/**
 * @file bsp_amakusa592.h
 * @author takemasa
 * @brief Amakusa BF592ボード用のリソース
 * @details
 * ここにはBSP専用のリソースを置く。実際にはボードの初期化子を置く。
 */
/**
 * @mainpage
 * Amakusa 592 ボードのBSP (Board Support Package)
 *
 * Uzumeを使う上のBSPは以下の構成になっている
 * @li uzume/bsp_amakusa592.cfg アプリケーションから読み込むべき
 * 静的コンフィギュレーション・ファイル
 * @li config/blackfin/bsp_amakusa592 BSPのシステム依存部
 * @li uzume_callback.c ユーザー用オーディオコールバックと初期化部の実装
 * @li uzume_app.c ユーザーアプリケーションが使うタスク。
 * @li uzume_app.cfg アプリケーション
 *
 * BSPを使う場合には、次のようにする
 * @li システム依存部から適切なBSPを選び、configure_projectの中で使用する。
 * @li kernel/uzumeの中からBSPに合わせた.cfgファイルを選び、uzume_app.cfgから
 * インクルードする
 * @li configure_projectを実行する
 *
 * これでプロジェクトがmake可能になる。
 *
 * 信号処理のアルゴリズムは uzume_callback.c のなかの process_audio() に記述する。
 * また、信号処理の前に初期以下が必要であれば init_audio() に初期化コードを記述する。
 */
#ifndef BSP_AMAKUSA592_H_
#define BSP_AMAKUSA592_H_

/**
 * \brief ボード・イニシャライザ
 * \param exinf 0を渡す。関数からは無視される。
 * \details
 * BSP用のイニシャライザである。アプリケーションに依存せず、uzumeが
 * 必要とする初期化処理をおここで行う。具体的にはI2S用のピンの割付を行う
 */
void board_initialize(VP_INT exinf);


#endif /* BSP_AMAKUSA592_H_ */
