// **************************************************
// Typenist.js 0.3.0 - Online VOCALOID Typing Game
// Copyright (c) 2008-2009 Typenist Project
// **************************************************

// initialize
$(document).ready(function(){
	var flashvars={};
	var params={};
	params.wmode="transparent";
	params.allowscriptaccess="always";
	var attributes={};
	swfobject.embedSWF("libs/flash/typecore.swf", "typeview", "800", "600", "8.0.0", false, flashvars, params, attributes);
});


// Define Global Variable
var ts=new Tsuikyo("roma", "flex");
var word=new Array();
var nowwordid=0;
var timeArray=new Array();
var lyricData;

// TypeView initializeComplete
function initializeComplete (str) {
	$.ajax({
		url: '../songdata/xml/anatanihanawo-watasiniutawo01.xml',
		type: 'GET',
		dataType: 'xml',
		timeout: 1000,
		error: function(){
			errorAlert(errorCode.L1);
		},
		success: function(xml){
			lyricData=$.xml2json(xml); 
			trace(lyricData);
			playReady();
		}
	});
}

function playReady () {
	nowwordid=0;
	var timeArray=new Array();
	var timeids=0;
	
	jQuery.each(lyricData.data, function () {
		timeArray[timeids]=this.time;
		timeids++;
	});

	timeArray.shift();
	callswf("typeview").songStart(timeArray);
}

function type(e) {
	var shift,ctrl;
		if(e!=null) { // Mozilla and Opera
		keycode=e.which;
		ctrl=typeof e.modifiers=='undefined' ? e.ctrlKey : e.modifiers & Event.CONTROL_MASK;
		shift=typeof e.modifiers=='undefined' ? e.shiftKey : e.modifiers & Event.SHIFT_MASK;
		e.preventDefault(); 
		e.stopPropagation();
		} else { // IE
		keycode=event.keyCode;
		ctrl=event.ctrlKey;
		shift=event.shiftKey;
		event.returnValue=false;
		event.cancelBubble=true;
		}
	
	var result=word.stroke(String.fromCharCode(keycode).toLowerCase());
	trace(result+":"+String.fromCharCode(keycode).toLowerCase());
	
	if(result){
		// 正打時処理
		if(result==4){
			// 打ち切り時処理
		}
	}else{
		// ミス時処理
	}
	
	keyview_refresh();
}

function timeTrigger () {
	nowwordid++;
	ts.clear();
		if(lyricData.data[nowwordid].lyric_type!="") {
		$(document).bind("keypress",type);
		word=ts.add(lyricData.data[nowwordid].lyric_type);
		hstr=word.getHiraganaString();
		kstr=word.getKeyString();
		} else {
		$(document).unbind("keypress",type);
		word=ts.add(" ");
		hstr="";
		kstr="";
		}
	callswf("typeview").newLine("",hstr,"",kstr);
}

function keyview_refresh () {
	hstr=word.getHiraganaString();
	kstr=word.getKeyString();
	hpos=word.getHiraganaPos();
	kpos=word.getKeyPos();
	missCount=word.getMissCount();
	callswf("typeview").newLine(hstr.substr(0, hpos),hstr.substr(hpos),kstr.substr(0, kpos),kstr.substr(kpos));
}

function callswf (names) {
	return document.all? window[names] : document[names];
}

function Clayer () {
	
}

function errorAlert (Eid) {
	$("#dialog").html(Eid+'<br><br>'+errorCode.A2);
		$("#dialog").dialog({
			bgiframe: true,
			show: 'drop',
			hide: 'puff',
			title: errorCode.A1,
			modal: true,
			buttons: {
				OK: function() {
					$(this).dialog('close');
				}
			}
		});
}

////////// デバッグ用関数
function trace (dat) {
	try {
	console.log(dat);
	} catch(e) {
	}
}
