/*
 *  TINET (TCP/IP Protocol Stack)
 * 
 *  Copyright (C) 2001-2009 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́C̏𖞂ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: in_rename.h,v 1.5 2009/12/24 05:47:21 abe Exp abe $
 */

#ifndef _IN_RENAME_H_
#define _IN_RENAME_H_

/*
 *  TCP/IP vgRX^bÑl[
 */

/* netinet/tcp_input.c */

#define tcp_input		_tinet_tcp_input
#define tcp_move_twcep		_tinet_tcp_move_twcep

/* netinet/tcp_output.c */

/* netinet/tcp_timer.c */

#define	tcp_cancel_timers	_tinet_tcp_cancel_timers
#define tcp_slow_timo		_tinet_tcp_slow_timo
#define tcp_fast_timo		_tinet_tcp_fast_timo
#define tcp_range_set		_tinet_tcp_range_set
#define tcp_set_persist_timer	_tinet_tcp_set_persist_timer

/* netinet/tcp_usrrq.c */

#define tcp_user_closed		_tinet_tcp_user_closed

/* netinet/tcp_subr.c */

#define tcp_iss			_tinet_tcp_iss
#define tcp_init		_tinet_tcp_init
#define tcp_init_iss		_tinet_tcp_init_iss
#define tcp_close		_tinet_tcp_close
#define tcp_drop		_tinet_tcp_drop
#define tcp_respond		_tinet_tcp_respond
#define tcp_set_header		_tinet_tcp_set_header
#define	tcp_get_segment		_tinet_tcp_get_segment
#define tcp_rexmt_val		_tinet_tcp_rexmt_val
#define tcp_init_cep		_tinet_tcp_init_cep
#define tcp_notify		_tinet_tcp_notify
#define tcp_find_cep		_tinet_tcp_find_cep
#define tcp_alloc_auto_port	_tinet_tcp_alloc_auto_port
#define tcp_alloc_port		_tinet_tcp_alloc_port
#define tcp_free_reassq		_tinet_tcp_free_reassq
#define tcp_move_ra2rw		_tinet_tcp_move_ra2rw
#define tcp_wait_rwbuf		_tinet_tcp_wait_rwbuf
#define tcp_write_raque		_tinet_tcp_write_raque
#define tcp_lock_cep		_tinet_tcp_lock_cep
#define tcp_can_send_more	_tinet_tcp_can_send_more
#define tcp_can_recv_more	_tinet_tcp_can_recv_more
#define tcp_output_trace	_tinet_tcp_output_trace
#define tcp_input_trace		_tinet_tcp_input_trace

/* netinet/tcp_subr_cs.c */

#define tcp_read_rwbuf		_tinet_tcp_read_rwbuf
#define tcp_write_rwbuf		_tinet_tcp_write_rwbuf
#define tcp_drop_rwbuf		_tinet_tcp_drop_rwbuf
#define tcp_free_rwbufq		_tinet_tcp_free_rwbufq
#define tcp_get_rwbuf_addr	_tinet_tcp_get_rwbuf_addr

#define tcp_free_rwbufq_cs	_tinet_tcp_free_rwbufq_cs
#define tcp_get_rwbuf_addr_cs	_tinet_tcp_get_rwbuf_addr_cs
#define tcp_read_rwbuf_cs	_tinet_tcp_read_rwbuf_cs
#define tcp_write_rwbuf_cs	_tinet_tcp_write_rwbuf_cs
#define tcp_drop_rwbuf_cs	_tinet_tcp_drop_rwbuf_cs

#define tcp_wait_swbuf		_tinet_tcp_wait_swbuf
#define tcp_init_swbuf		_tinet_tcp_init_swbuf
#define tcp_alloc_swbuf		_tinet_tcp_alloc_swbuf
#define tcp_is_swbuf_full	_tinet_tcp_is_swbuf_full
#define tcp_drop_swbuf		_tinet_tcp_drop_swbuf
#define tcp_free_swbufq		_tinet_tcp_free_swbufq
#define tcp_read_swbuf		_tinet_tcp_read_swbuf
#define tcp_write_swbuf		_tinet_tcp_write_swbuf
#define tcp_pull_res_nbuf	_tinet_tcp_pull_res_nbuf
#define tcp_push_res_nbuf	_tinet_tcp_push_res_nbuf
#define tcp_get_swbuf_addr	_tinet_tcp_get_swbuf_addr
#define tcp_send_swbuf		_tinet_tcp_send_swbuf

#define tcp_get_swbuf_addr_cs	_tinet_tcp_get_swbuf_addr_cs
#define tcp_wait_swbuf_cs	_tinet_tcp_wait_swbuf_cs
#define tcp_is_swbuf_full_cs	_tinet_tcp_is_swbuf_full_cs
#define tcp_alloc_swbuf_cs	_tinet_tcp_alloc_swbuf_cs
#define tcp_send_swbuf_cs	_tinet_tcp_send_swbuf_cs
#define tcp_free_swbufq_cs	_tinet_tcp_free_swbufq_cs
#define tcp_drop_swbuf_cs	_tinet_tcp_drop_swbuf_cs
#define tcp_write_swbuf_cs	_tinet_tcp_write_swbuf_cs

/* netinet/tcp_subr_ncs.c */

#define tcp_drop_rwbuf_ncs	_tinet_tcp_drop_rwbuf_ncs
#define tcp_read_rwbuf_ncs	_tinet_tcp_read_rwbuf_ncs
#define tcp_is_swbuf_full_ncs	_tinet_tcp_is_swbuf_full_ncs
#define tcp_drop_swbuf_ncs	_tinet_tcp_drop_swbuf_ncs
#define tcp_read_swbuf_ncs	_tinet_tcp_read_swbuf_ncs
#define tcp_wait_swbuf_ncs	_tinet_tcp_wait_swbuf_ncs
#define tcp_write_swbuf_ncs	_tinet_tcp_write_swbuf_ncs
#define tcp_write_rwbuf_ncs	_tinet_tcp_write_rwbuf_ncs
#define tcp_get_swbuf_addr_ncs	_tinet_tcp_get_swbuf_addr_ncs
#define tcp_send_swbuf_ncs	_tinet_tcp_send_swbuf_ncs
#define tcp_get_rwbuf_addr_ncs	_tinet_tcp_get_rwbuf_addr_ncs

/* tcp_cfg.c */

#define tcp_rep			_tinet_tcp_rep
#define tcp_cep			_tinet_tcp_cep
#define tcp_twcep		_tinet_tcp_twcep
#define tmax_tcp_repid		_tinet_tmax_tcp_repid
#define tmax_tcp_cepid		_tinet_tmax_tcp_cepid
#define tmax_tcp_crepid		_tinet_tmax_tcp_repid	/* TINET 1.3 Ƃ̌݊̂߂̒` */
#define tmax_tcp_ccepid		_tinet_tmax_tcp_cepid	/* TINET 1.3 Ƃ̌݊̂߂̒` */

/* netinet/udp_input.c */

#define udp_input		_tinet_udp_input

/* netinet/udp_subr.c */

#define udp_alloc_port		_tinet_udp_alloc_port
#define udp_alloc_auto_port	_tinet_udp_alloc_auto_port

/* netinet/udp_usrreq.c */

#define udp_send_data		_tinet_udp_send_data

/* netinet/udp_usrreq_nblk.c */

#define udp_can_rcv		_tinet_udp_can_rcv
#define udp_can_snd		_tinet_udp_can_snd

/* udp_cfg.c */

#define udp_cep			_tinet_udp_cep
#define tmax_udp_cepid		_tinet_tmax_udp_cepid
#define tmax_udp_ccepid		_tinet_tmax_udp_cepid	/* TINET 1.3 Ƃ̌݊̂߂̒` */

/* netinet/ip_icmp.c */

#define icmp_input		_tinet_icmp_input
#define icmp_error		_tinet_icmp_error
#define icmp_echo_reply		_tinet_icmp_echo_reply

/* netinet/ip_input.c */

#define ip_input		_tinet_ip_input
#define ip_init			_tinet_ip_init
#define ip_frag_timer		_tinet_ip_frag_timer
#define ip_get_frag_queue	_tinet_ip_get_frag_queue
#define ip_remove_options	_tinet_ip_remove_options

/* netinet/ip_output.c */

#define ip_output		_tinet_ip_output

/* netinet/in_subr.c */

#define in4_set_header		_tinet_in4_set_header
#define in4_get_datagram	_tinet_in4_get_datagram
#define in4_cksum		_tinet_in4_cksum
#define in4_rtalloc		_tinet_in4_rtalloc
#define in4_rtredirect		_tinet_in4_rtredirect
#define in4_init		_tinet_in4_init
#define in4_is_dstaddr_accept	_tinet_in4_is_dstaddr_accept
#define in4_ifawithifp		_tinet_in4_ifawithifp
#define in_cksum		_tinet_in_cksum
#define in_cksum_carry		_tinet_in_cksum_carry
#define in_cksum_sum		_tinet_in_cksum_sum
#define in_rtnewentry		_tinet_in_rtnewentry
#define in_rtinit		_tinet_in_rtinit
#define in_rttimer		_tinet_in_rttimer

/* netinet/if_ether.c */

#define arp_request		_tinet_arp_request
#define arp_input		_tinet_arp_input
#define arp_resolve		_tinet_arp_resolve
#define arp_init		_tinet_arp_init
#define arp_get_cache		_tinet_arp_get_cache

/* netinet6/icmp6.c */

#define icmp6_input		_tinet_icmp6_input

#endif	/* of #ifndef _IN_RENAME_H_ */
