/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2010 by Meika Sugimoto
 *
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 */

/*
 *  ^[QbgˑW[iTK_V850/JH3E+NETpj
 */

#include "kernel_impl.h"
#include <sil.h>
#include "tk_v850_jh3e.h"

/* oi[o͗p̃VA|[g */
static void target_fput_initialize(void);

/*
 *  ^[Qbgˑ̏
 */
void
target_initialize(void)
{
	uint16_t wr_mem_h;
	uint32_t wr_mem_w;
	
	/*
	 *	vZbTˑ̏
	 */
	prc_initialize();

	/*
	 * oi[o͗p̃VARg[̏
	 */
	target_fput_initialize();
	
	/*
	 *	LEDڑ|[g_
	 */
	clr_bit(LED1_BITPOS , LED1_ADDRESS);
	clr_bit(LED1_BITPOS , PCMT);
	
	/*
	 * UART0I/O|[g̐ݒ
	 *
	 * MP30CMP31C@\ݒ肪Kv(PMC3 , PFC3)
	 */
	wr_mem_h = (sil_reh_mem((uint16_t *)PMC3L) & 0xfffc) | 0x003;
	sil_wrh_mem((uint16_t *)PMC3L, wr_mem_h);
	wr_mem_w = (sil_reh_mem((uint16_t *)PFC3) & 0xfffc);
	sil_wrh_mem((uint16_t *)PFC3, wr_mem_w);
}

/*
 *  ^[Qbgˑ̏I
 */
void
target_exit(void)
{
	volatile uint_t i = 1;
	
	/*
	 *	vZbTˑ̏I
	 */
	prc_terminate();

	/*
	 *	ɂ͗Ȃ
	 *	
	 *	ϐivolatileĈ́AœKɂ
	 *	[v폜̂h߁B
	 */
	while(i)
		;
}

static void target_fput_initialize(void)
{
	/* ֎~ */
	clr_bit(7 , UA0CTL0);
	
	/* [hC{[[gݒ */
	sil_wrb_mem((uint8_t *)UA0CTL1 , TARGET_FPUTC_UAnCTL1_SETTING);
	sil_wrb_mem((uint8_t *)UA0CTL2 , TARGET_FPUTC_UAnCTL2_SETTING);
	
	/* M̂݋CLSBt@[XgCXgbvrbg1bitC8bitCpeBȂ */
	sil_wrb_mem((uint8_t *)UA0CTL0 , 0xD2);
}

/*
 *  VXeO̒჌xo͂̂߂̕o
 */
void
target_fput_log(char_t c)
{
	if (c == '\n') {
		while((sil_reb_mem((uint8_t *)TARGET_FPUTC_UAnSTR) & 0x80) != 0x00)
			;
		sil_wrb_mem((uint8_t *)TARGET_FPUTC_UAnTX , '\r');
	}
	while((sil_reb_mem((uint8_t *)TARGET_FPUTC_UAnSTR) & 0x80) != 0x00)
		;
	sil_wrb_mem((uint8_t *)TARGET_FPUTC_UAnTX , c);
}
