//------------------------------------------------------------------------------
//  TOPPERS/ASP Windows Debug Environment
//  Copyright (C) 2010-2013 Cores Co., Ltd. Japan
//------------------------------------------------------------------------------
// $Id: UnitSim.cs 115 2013-02-11 02:13:05Z nagasima $
#ifndef V850RegH
#define V850RegH

#ifdef __cplusplus
extern "C"{
#endif

#pragma pack(push, 1)

//------------------------------------------------------------------------------
// 荞ݐ䃌WX^
//------------------------------------------------------------------------------
struct TPIC
{
	unsigned char PPR : 3;				// D揇
	unsigned char : 3;
	unsigned char PMK : 1;				// 荞݃}XNEtO
	unsigned char PIF : 1;				// 荞ݗvtO
	unsigned char : 8;
};

//------------------------------------------------------------------------------
// UARTC䃌WX^0
//------------------------------------------------------------------------------
struct TUartCCTL0{
	unsigned char SL		: 1;		// Mf[^̃XgbvErbg
	unsigned char CL		: 1;		// Mf[^1t[̃LN^
	unsigned char PS		: 2;		// peBErbg
	unsigned char DIR		: 1;		// ][h(MSB/LSB)̎w
	unsigned char RXE		: 1;		// M
	unsigned char TXE		: 1;		// M
	unsigned char PWR		: 1;		// 쐧
};

//------------------------------------------------------------------------------
// UARTC䃌WX^1
//------------------------------------------------------------------------------
struct TUartCCTL1{
	unsigned char CKS		: 4;		// {NbNIWX^
	unsigned char : 4;
};

//------------------------------------------------------------------------------
// UARTC䃌WX^2
//------------------------------------------------------------------------------
struct TUartCCTL2{
	unsigned char BRS;					// 16rbgEJE^̕l
};

//------------------------------------------------------------------------------
// UARTCXe[^XWX^
//------------------------------------------------------------------------------
struct TUartCSTR{
	unsigned char OVE		: 1;		// I[o[G[tO
	unsigned char FE		: 1;		// t[~OG[tO
	unsigned char PE		: 1;		// peBG[tO
	unsigned char : 4;
	unsigned char TSF		: 1;		// ]ԃtO
};


//------------------------------------------------------------------------------
// UARTCIvV䃌WX^0
//------------------------------------------------------------------------------
struct TUartCOPT0{
	unsigned char OVE		: 1;		// SBFMtO
	unsigned char FE		: 1;		// SBFMgK
	unsigned char PE		: 1;		// SBFMgK
	unsigned char SLS		: 3;		// SBFMI
	unsigned char TDL		: 1;		// Mf[^ExErbg
	unsigned char RDL		: 1;		// Mf[^ExErbg
};

//------------------------------------------------------------------------------
//  UARTCIvV䃌WX^1
//------------------------------------------------------------------------------
struct TUartCOPT1{
	unsigned char EBE		: 1;		//grbg
	unsigned char : 7;
};

//------------------------------------------------------------------------------
// UARTC|[g
//------------------------------------------------------------------------------
struct TUartCPort{
	struct TUartCCTL0 CTL0;					// 䃌WX^0
	struct TUartCCTL1 CTL1;					// 䃌WX^1
	struct TUartCCTL2 CTL2;					// 䃌WX^2
	struct TUartCOPT0 OPT0;					// IvV䃌WX^0
	struct TUartCSTR STR;						// Xe[^XEWX^
	unsigned char SPACE_A05;
	unsigned char RX;					// Mobt@EWX^
	unsigned char SPACE_A07;
	unsigned char TX;					// Mobt@EWX^
	unsigned char SPACE_A09;
	struct TUartCOPT1 OPT1;					// IvV䃌WX^1
};


//------------------------------------------------------------------------------
// UARTB䃌WX^0
//------------------------------------------------------------------------------
struct TUartBCTL0{
	unsigned char SL: 1;				// Mf[^̃XgbvErbg̎w
	unsigned char CL : 1;				// Mf[^1t[̃f[^ELN^̎w
	unsigned char PS : 2;				// M̃peBI
	unsigned char DIR : 1;			// ][hiMSB/LSBj̎w
	unsigned char RXE : 1;			// M싖
	unsigned char TXE : 1;			// M싖
	unsigned char PWR : 1;			// UARTBnւ̓NbN̐
};

//------------------------------------------------------------------------------
// UARTB䃌WX^2
//------------------------------------------------------------------------------
struct TUartBCTL2{
	unsigned short BRS;				// 16rbgEJE^̕l
};

//------------------------------------------------------------------------------
// UARTBԃWX^
//------------------------------------------------------------------------------
struct TUartBSTR{
	unsigned char OVE: 1;				// I[oEG[EtO
	unsigned char FE: 1;				// t[~OEG[EtO
	unsigned char PE: 1;				// peBEG[EtO
	unsigned char OVF: 1;				// I[ot[EtO
	unsigned char : 3;
	unsigned char TSF: 1;				// ]ԃtO
};

//------------------------------------------------------------------------------
// UARTB FIFO䃌WX^0
//------------------------------------------------------------------------------
struct TUartBRXAP{
	unsigned char FEF : 1;			// t[~OEG[EtO
	unsigned char PEF : 1;			// peBEG[EtO
	unsigned char : 6;
};

//------------------------------------------------------------------------------
// UARTB FIFO䃌WX^0
//------------------------------------------------------------------------------
struct TUartBFIC0{
	unsigned char IRM : 1;			// FIFO[hINTUBnTIR荞ݔ^C~O̎w
	unsigned char ITM : 1;			// FIFO[hINTUBnTIT荞ݔ^C~O̎w
	unsigned char RFC : 1;			// MFIFOiUBnRXAPjNAEgKErbg
	unsigned char TFC : 1;			// MFIFONAEgKErbg
	unsigned char : 3;
	unsigned char MOD : 1;			// UARTBn̓샂[h̎w
};

//------------------------------------------------------------------------------
// UARTB FIFO䃌WX^1
//------------------------------------------------------------------------------
struct TUartBFIC1{
	unsigned char TC : 5;				// ^CAEgEJE^
	unsigned char : 2;
	unsigned char TCE : 1;			// ^CAEgEJE^@\̋֎~^̎w
};

//------------------------------------------------------------------------------
// UARTB FIFO䃌WX^2H
//------------------------------------------------------------------------------
struct TUartBFIC2H{
	unsigned char TT		: 4;		// MFIFOgKݒ
	unsigned char : 4;
};

//------------------------------------------------------------------------------
// UARTB FIFO䃌WX^2L
//------------------------------------------------------------------------------
struct TUartBFIC2L{
	unsigned char RT		: 4;		// MFIFOgKݒ
	unsigned char : 4;
};

//------------------------------------------------------------------------------
// UARTB FIFOԃWX^0
//------------------------------------------------------------------------------
struct TUartBFIS0{
	unsigned char RB		: 5;		// MFIFO|C^
	unsigned char : 3;
};

//------------------------------------------------------------------------------
// UARTB FIFOԃWX^1
//------------------------------------------------------------------------------
struct TUartBFIS1{
	unsigned char TB		: 5;		// MFIFO|C^
	unsigned char : 3;
};

//------------------------------------------------------------------------------
// UARTB|[g
//------------------------------------------------------------------------------
struct TUartBPort{
	struct TUartBCTL0 CTL0;					// 䃌WX^0
	unsigned char SPACE_B81;
	struct TUartBCTL2 CTL2;					// 䃌WX^2
	struct TUartBSTR STR;						// ԃWX^
	unsigned char SPACE_B85;
	unsigned char RX;					// Mf[^EWX^
	struct TUartBRXAP RXAP;					// Mf[^EWX^AP
	unsigned char TX;					// Mf[^EWX^
	unsigned char SPACE_B89;
	struct TUartBFIC0 FIC0;					// FIFO䃌WX^0
	struct TUartBFIC1 FIC1;					// FIFO䃌WX^1
	struct TUartBFIC2L FIC2L;					// FIFO䃌WX^2L
	struct TUartBFIC2H FIC2H;					// FIFO䃌WX^2H
	struct TUartBFIS0 FIS0;					// FIFOԃWX^0
	struct TUartBFIS1 FIS1;					// FIFOԃWX^1
};

//------------------------------------------------------------------------------
// ^C}lE䃌WX^
//------------------------------------------------------------------------------
struct TTMMCTL{
	unsigned char CKS : 3;				// JEgENbN
	unsigned char : 4;
	unsigned char CE : 1;				// NbN쐧
};

//------------------------------------------------------------------------------
// ^C}l|[g
//------------------------------------------------------------------------------
struct TTMMPort{
	struct TTMMCTL	CTL0;						// 䃌WX^
	unsigned char SPACE_A81[3];
	unsigned short CMP0;				// RyAEWX^
};

//------------------------------------------------------------------------------
// A^CEJE^
//------------------------------------------------------------------------------
struct TRCPort{
	unsigned short SUBC;				// TuEJEgEWX^
	unsigned char SEC;				// bJEgEWX^
	unsigned char MIN;				// JEgEWX^
	unsigned char HOUR;				// JEgEWX^
	unsigned char WEEK;				// jJEgEWX^
	unsigned char DAY;				// JEgEWX^
	unsigned char MONTH;				// JEgEWX^
	unsigned char YEAR;				// NJEgEWX^
	unsigned char SUBU;				// Ԍ덷␳WX^
	unsigned char ALM;				// A[ݒ背WX^
	unsigned char ALH;				// A[ݒ背WX^
	unsigned char ALW;				// A[jݒ背WX^
	unsigned char CC0;				// RTCRg[EWX^0
	unsigned char CC1;				// RTCRg[EWX^1
	unsigned char CC2;				// RTCRg[EWX^2
	unsigned char CC3;				// RTCRg[EWX^3
};

#define SPACE(end, size) unsigned char _SPACE_TO_##end[size];
#define FIELD_S(start, end, type, name) type name; SPACE(end, end + 1 - start - sizeof(type))
#define FIELD_0(start, end, type, name) type name;
#define ARRAY_S(start, end, type, name, count) type name[count]; SPACE(end, end + 1 - start - sizeof(type) * count)
#define ARRAY_0(start, end, type, name, count) type name[count];

//------------------------------------------------------------------------------
// CPUWX^
//------------------------------------------------------------------------------
struct TV850Reg
{
	SPACE(0xFFFFF003, 0xFFFFF004 - 0xFFFFF000)
	FIELD_0(0xFFFFF004, 0xFFFFF005, unsigned short, PDL)	// |[gDLWX^
	FIELD_S(0xFFFFF006, 0xFFFFF007, unsigned char, PDH)	// |[gDHWX^
	FIELD_S(0xFFFFF008, 0xFFFFF009, unsigned char, PCS)	// |[gCSWX^
	FIELD_S(0xFFFFF00A, 0xFFFFF00B, unsigned char, PCT)	// |[gCTWX^
	FIELD_S(0xFFFFF00C, 0xFFFFF023, unsigned char, PCM)	// |[gCMWX^
	FIELD_0(0xFFFFF024, 0xFFFFF025, unsigned short, PMDL)	// |[gDL[hEWX^
	FIELD_S(0xFFFFF026, 0xFFFFF027, unsigned char, PMDH)	// |[gDH[hEWX^
	FIELD_S(0xFFFFF028, 0xFFFFF029, unsigned char, PMCS)	// |[gCS[hEWX^
	FIELD_S(0xFFFFF02A, 0xFFFFF02B, unsigned char, PMCT)	// |[gCT[hEWX^
	FIELD_S(0xFFFFF02C, 0xFFFFF043, unsigned char, PMCM)	// |[gCM[hEWX^
	FIELD_0(0xFFFFF044, 0xFFFFF045, unsigned short, PMCDL)	// |[gDL[hERg[EWX^
	FIELD_S(0xFFFFF046, 0xFFFFF047, unsigned char, PMCDH)	// |[gDH[hERg[EWX^
	FIELD_S(0xFFFFF048, 0xFFFFF049, unsigned char, PMCCS)	// |[gCS[hERg[EWX^
	FIELD_S(0xFFFFF04A, 0xFFFFF04B, unsigned char, PMCCT)	// |[gCT[hERg[EWX^
	FIELD_S(0xFFFFF04C, 0xFFFFF055, unsigned char, PMCCM)	// |[gCM[hERg[EWX^
	FIELD_S(0xFFFFF056, 0xFFFFF063, unsigned char, PFCDH)	// |[gDHt@NVERg[EWX^
	FIELD_0(0xFFFFF064, 0xFFFFF065, unsigned short, BPC)	// I/ÖZNg䃌WX^
	FIELD_S(0xFFFFF066, 0xFFFFF06D, unsigned short, BSC)	// oXETCYERtBM[VEWX^
	FIELD_S(0xFFFFF06E, 0xFFFFF07F, unsigned char, VSWC)	// VXeEEGCgERg[EWX^
	FIELD_0(0xFFFFF080, 0xFFFFF081, unsigned short, DSA0L)	// DMA\[XEAhXEWX^0L
	FIELD_0(0xFFFFF082, 0xFFFFF083, unsigned short, DSA0H)	// DMA\[XEAhXEWX^0H
	FIELD_0(0xFFFFF084, 0xFFFFF085, unsigned short, DDA0L)	// DMAfXeBl[VEAhXEWX^0L
	FIELD_0(0xFFFFF086, 0xFFFFF087, unsigned short, DDA0H)	// DMAfXeBl[VEAhXEWX^0H
	FIELD_0(0xFFFFF088, 0xFFFFF089, unsigned short, DSA1L)	// DMA\[XEAhXEWX^1L
	FIELD_0(0xFFFFF08A, 0xFFFFF08B, unsigned short, DSA1H)	// DMA\[XEAhXEWX^1H
	FIELD_0(0xFFFFF08C, 0xFFFFF08D, unsigned short, DDA1L)	// DMAfXeBl[VEAhXEWX^1L
	FIELD_0(0xFFFFF08E, 0xFFFFF08F, unsigned short, DDA1H)	// DMAfXeBl[VEAhXEWX^1H
	FIELD_0(0xFFFFF090, 0xFFFFF091, unsigned short, DSA2L)	// DMA\[XEAhXEWX^2L
	FIELD_0(0xFFFFF092, 0xFFFFF093, unsigned short, DSA2H)	// DMA\[XEAhXEWX^2H
	FIELD_0(0xFFFFF094, 0xFFFFF095, unsigned short, DDA2L)	// DMAfXeBl[VEAhXEWX^2L
	FIELD_0(0xFFFFF096, 0xFFFFF097, unsigned short, DDA2H)	// DMAfXeBl[VEAhXEWX^2H
	FIELD_0(0xFFFFF098, 0xFFFFF099, unsigned short, DSA3L)	// DMA\[XEAhXEWX^3L
	FIELD_0(0xFFFFF09A, 0xFFFFF09B, unsigned short, DSA3H)	// DMA\[XEAhXEWX^3H
	FIELD_0(0xFFFFF09C, 0xFFFFF09D, unsigned short, DDA3L)	// DMAfXeBl[VEAhXEWX^3L
	FIELD_S(0xFFFFF09E, 0xFFFFF0BF, unsigned short, DDA3H)	// DMAfXeBl[VEAhXEWX^3H
	FIELD_0(0xFFFFF0C0, 0xFFFFF0C1, unsigned short, DBC0)	// DMA]JEgEWX^0
	FIELD_0(0xFFFFF0C2, 0xFFFFF0C3, unsigned short, DBC1)	// DMA]JEgEWX^1
	FIELD_0(0xFFFFF0C4, 0xFFFFF0C5, unsigned short, DBC2)	// DMA]JEgEWX^2
	FIELD_S(0xFFFFF0C6, 0xFFFFF0CF, unsigned short, DBC3)	// DMA]JEgEWX^3
	FIELD_0(0xFFFFF0D0, 0xFFFFF0D1, unsigned short, DADC0)	// DMAAhVOERg[EWX^0
	FIELD_0(0xFFFFF0D2, 0xFFFFF0D3, unsigned short, DADC1)	// DMAAhVOERg[EWX^1
	FIELD_0(0xFFFFF0D4, 0xFFFFF0D5, unsigned short, DADC2)	// DMAAhVOERg[EWX^2
	FIELD_S(0xFFFFF0D6, 0xFFFFF0DF, unsigned short, DADC3)	// DMAAhVOERg[EWX^3
	FIELD_S(0xFFFFF0E0, 0xFFFFF0E1, unsigned char, DCHC0)	// DMA`lERg[EWX^0
	FIELD_S(0xFFFFF0E2, 0xFFFFF0E3, unsigned char, DCHC1)	// DMA`lERg[EWX^1
	FIELD_S(0xFFFFF0E4, 0xFFFFF0E5, unsigned char, DCHC2)	// DMA`lERg[EWX^2
	FIELD_S(0xFFFFF0E6, 0xFFFFF0FF, unsigned char, DCHC3)	// DMA`lERg[EWX^3
	ARRAY_0(0xFFFFF100, 0xFFFFF10F, unsigned short, IMR, 8)	// 荞ݐ䃌WX^
	ARRAY_S(0xFFFFF110, 0xFFFFF1F9, struct TPIC, PIC, 114)	// 荞ݐ䃌WX^
	FIELD_S(0xFFFFF1FA, 0xFFFFF1FB, unsigned char, ISPR)	// CT[rXEvCIeBEWX^
	FIELD_S(0xFFFFF1FC, 0xFFFFF1FD, unsigned char, PRCMD)	// R}hEWX^
	FIELD_S(0xFFFFF1FE, 0xFFFFF1FF, unsigned char, PSC)	// p[EZ[uERg[EWX^
	FIELD_0(0xFFFFF200, 0xFFFFF200, unsigned char, ADA0M0)	// A/DRo[^E[hEWX^0
	FIELD_0(0xFFFFF201, 0xFFFFF201, unsigned char, ADA0M1)	// A/DRo[^E[hEWX^1
	FIELD_0(0xFFFFF202, 0xFFFFF202, unsigned char, ADA0S)	// A/DRo[^E`lw背WX^
	FIELD_0(0xFFFFF203, 0xFFFFF203, unsigned char, ADA0M2)	// A/DRo[^E[hEWX^2
	FIELD_0(0xFFFFF204, 0xFFFFF204, unsigned char, ADA0PFM)	// p[EtFCr[hEWX^
	FIELD_S(0xFFFFF205, 0xFFFFF20F, unsigned char, ADA0PFT)	// p[EtFCrlWX^
	ARRAY_S(0xFFFFF210, 0xFFFFF2FF, unsigned short, ADA0CR, 12)	// A/DϊʃWX^0-12
	FIELD_S(0xFFFFF300, 0xFFFFF307, unsigned char, KRM)	// L[E^[E[hEWX^
	FIELD_S(0xFFFFF308, 0xFFFFF30F, unsigned char, SELCNT0)	// ZN^쐧䃌WX^0
	FIELD_S(0xFFFFF310, 0xFFFFF311, unsigned char, CRCIN)	// CRCCvbgEWX^
	FIELD_S(0xFFFFF312, 0xFFFFF31F, unsigned char, CRCD)	// CRCf[^EWX^
	FIELD_0(0xFFFFF320, 0xFFFFF320, unsigned char, PRSM1)	// vXP[E[hEWX^1
	FIELD_S(0xFFFFF321, 0xFFFFF323, unsigned char, PRSCM1)	// vXP[ERyAEWX^1
	FIELD_0(0xFFFFF324, 0xFFFFF324, unsigned char, PRSM2)	// vXP[E[hEWX^2
	FIELD_S(0xFFFFF325, 0xFFFFF327, unsigned char, PRSCM2)	// vXP[ERyAEWX^2
	FIELD_0(0xFFFFF328, 0xFFFFF328, unsigned char, PRSM3)	// vXP[E[hEWX^3
	FIELD_S(0xFFFFF329, 0xFFFFF32B, unsigned char, PRSCM3)	// vXP[ERyAEWX^3
	FIELD_0(0xFFFFF32C, 0xFFFFF32C, unsigned char, PRSM4)	// vXP[E[hEWX^4
	FIELD_S(0xFFFFF32D, 0xFFFFF33F, unsigned char, PRSCM4)	// vXP[ERyAEWX^4
	FIELD_S(0xFFFFF340, 0xFFFFF343, unsigned char, OCKS0)	// IICNbNIWX^0
	FIELD_S(0xFFFFF344, 0xFFFFF347, unsigned char, OCKS1)	// IICNbNIWX^1
	FIELD_S(0xFFFFF348, 0xFFFFF3FF, unsigned char, OCKS2)	// IICNbNIWX^2
	FIELD_S(0xFFFFF400, 0xFFFFF403, unsigned char, P0)	// |[g0WX^
	FIELD_S(0xFFFFF404, 0xFFFFF405, unsigned char, P2)	// |[g2WX^
	FIELD_S(0xFFFFF406, 0xFFFFF407, unsigned char, P3)	// |[g3WX^
	FIELD_S(0xFFFFF408, 0xFFFFF409, unsigned char, P4)	// |[g4WX^
	FIELD_S(0xFFFFF40A, 0xFFFFF40D, unsigned char, P5)	// |[g5WX^
	FIELD_0(0xFFFFF40E, 0xFFFFF40E, unsigned char, P7L)	// |[g7LWX^
	FIELD_S(0xFFFFF40F, 0xFFFFF411, unsigned char, P7H)	// |[g7HWX^
	FIELD_0(0xFFFFF412, 0xFFFFF412, unsigned char, P9L)	// |[g9LWX^
	FIELD_S(0xFFFFF413, 0xFFFFF41F, unsigned char, P9H)	// |[g9HWX^
	FIELD_S(0xFFFFF420, 0xFFFFF423, unsigned char, PM0)	// |[g0[hEWX^
	FIELD_S(0xFFFFF424, 0xFFFFF425, unsigned char, PM2)	// |[g2[hEWX^
	FIELD_S(0xFFFFF426, 0xFFFFF427, unsigned char, PM3)	// |[g3[hEWX^
	FIELD_0(0xFFFFF428, 0xFFFFF428, unsigned char, PM4L)	// |[g4L[hEWX^
	FIELD_0(0xFFFFF429, 0xFFFFF429, unsigned char, PM4H)	// |[g4H[hEWX^
	FIELD_0(0xFFFFF42A, 0xFFFFF42A, unsigned char, PM5L)	// |[g5L[hEWX^
	FIELD_S(0xFFFFF42B, 0xFFFFF42D, unsigned char, PM5H)	// |[g5H[hEWX^
	FIELD_0(0xFFFFF42E, 0xFFFFF42E, unsigned char, PM7L)	// |[g7[hEWX^L
	FIELD_S(0xFFFFF42F, 0xFFFFF431, unsigned char, PM7H)	// |[g7[hEWX^H
	FIELD_0(0xFFFFF432, 0xFFFFF432, unsigned char, PM9L)	// |[g9L[hEWX^
	FIELD_S(0xFFFFF433, 0xFFFFF43F, unsigned char, PM9H)	// |[g9H[hEWX^
	FIELD_S(0xFFFFF440, 0xFFFFF443, unsigned char, PMC0)	// |[g0[hERg[EWX^
	FIELD_S(0xFFFFF444, 0xFFFFF445, unsigned char, PMC2)	// |[g2[hERg[EWX^
	FIELD_S(0xFFFFF446, 0xFFFFF447, unsigned char, PMC3)	// |[g3[hERg[EWX^
	FIELD_0(0xFFFFF448, 0xFFFFF448, unsigned char, PMC4L)	// |[g4L[hERg[EWX^
	FIELD_0(0xFFFFF449, 0xFFFFF449, unsigned char, PMC4H)	// |[g4H[hERg[EWX^
	FIELD_0(0xFFFFF44A, 0xFFFFF44A, unsigned char, PMC5L)	// |[g5L[hERg[EWX^
	FIELD_S(0xFFFFF44B, 0xFFFFF451, unsigned char, PMC5H)	// |[g5H[hERg[EWX^
	FIELD_0(0xFFFFF452, 0xFFFFF452, unsigned char, PMC9L)	// |[g9L[hERg[EWX^
	FIELD_S(0xFFFFF453, 0xFFFFF45F, unsigned char, PMC9H)	// |[g9H[hERg[EWX^
	FIELD_S(0xFFFFF460, 0xFFFFF463, unsigned char, PFC0)	// |[g0t@NVERg[EWX^
	FIELD_S(0xFFFFF464, 0xFFFFF465, unsigned char, PFC2)	// |[g2t@NVERg[EWX^
	FIELD_S(0xFFFFF466, 0xFFFFF467, unsigned char, PFC3)	// |[g3t@NVERg[EWX^
	FIELD_0(0xFFFFF468, 0xFFFFF468, unsigned char, PFC4L)	// |[g4Lt@NVERg[EWX^
	FIELD_0(0xFFFFF469, 0xFFFFF469, unsigned char, PFC4H)	// |[g4Ht@NVERg[EWX^
	FIELD_0(0xFFFFF46A, 0xFFFFF46A, unsigned char, PFC5L)	// |[g5Lt@NVERg[EWX^
	FIELD_S(0xFFFFF46B, 0xFFFFF471, unsigned char, PFC5H)	// |[g5Ht@NVERg[EWX^
	FIELD_0(0xFFFFF472, 0xFFFFF472, unsigned char, PFC9L)	// |[g9Lt@NVERg[EWX^
	FIELD_S(0xFFFFF473, 0xFFFFF483, unsigned char, PFC9H)	// |[g9Ht@NVERg[EWX^
	FIELD_S(0xFFFFF484, 0xFFFFF487, unsigned short, DWC0)	// f[^EEGCgERg[EWX^0
	FIELD_S(0xFFFFF488, 0xFFFFF489, unsigned char, AWC)	// AhXEEGCgERg[EWX^
	FIELD_S(0xFFFFF48A, 0xFFFFF53F, unsigned char, BCC)	// oXETCNERg[EWX^
	FIELD_0(0xFFFFF540, 0xFFFFF540, unsigned char, TAB0CTL0)	// TAB0䃌WX^0
	FIELD_0(0xFFFFF541, 0xFFFFF541, unsigned char, TAB0CTL1)	// TAB0䃌WX^1
	FIELD_0(0xFFFFF542, 0xFFFFF542, unsigned char, TAB0IOC0)	// TAB0I/O䃌WX^0
	FIELD_0(0xFFFFF543, 0xFFFFF543, unsigned char, TAB0IOC1)	// TAB0I/O䃌WX^1
	FIELD_0(0xFFFFF544, 0xFFFFF544, unsigned char, TAB0IOC2)	// TAB0I/O䃌WX^2
	FIELD_0(0xFFFFF545, 0xFFFFF545, unsigned char, TAB0OPT0)	// TAB0IvVEWX^0
	FIELD_S(0xFFFFF546, 0xFFFFF547, unsigned char, TAB0CCR0)	// TAB0Lv`^RyAEWX^0
	FIELD_S(0xFFFFF548, 0xFFFFF549, unsigned char, TAB0CCR1)	// TAB0Lv`^RyAEWX^1
	FIELD_S(0xFFFFF54A, 0xFFFFF54B, unsigned char, TAB0CCR2)	// TAB0Lv`^RyAEWX^2
	FIELD_S(0xFFFFF54C, 0xFFFFF54D, unsigned char, TAB0CCR3)	// TAB0Lv`^RyAEWX^3
	FIELD_S(0xFFFFF54E, 0xFFFFF54F, unsigned char, TAB0CNT)	// TAB0JE^E[hEobt@EWX^
	FIELD_S(0xFFFFF550, 0xFFFFF55F, unsigned char, TAB0IOC4)	// TAB0I/O䃌WX^4
	FIELD_0(0xFFFFF560, 0xFFFFF560, unsigned char, TAB1CTL0)	// TAB1䃌WX^0
	FIELD_0(0xFFFFF561, 0xFFFFF561, unsigned char, TAB1CTL1)	// TAB1䃌WX^1
	FIELD_0(0xFFFFF562, 0xFFFFF562, unsigned char, TAB1IOC0)	// TAB1I/O䃌WX^0
	FIELD_0(0xFFFFF563, 0xFFFFF563, unsigned char, TAB1IOC1)	// TAB1I/O䃌WX^1
	FIELD_0(0xFFFFF564, 0xFFFFF564, unsigned char, TAB1IOC2)	// TAB1I/O䃌WX^2
	FIELD_0(0xFFFFF565, 0xFFFFF565, unsigned char, TAB1OPT0)	// TAB1IvVEWX^0
	FIELD_S(0xFFFFF566, 0xFFFFF567, unsigned char, TAB1CCR0)	// TAB1Lv`^RyAEWX^0
	FIELD_S(0xFFFFF568, 0xFFFFF569, unsigned char, TAB1CCR1)	// TAB1Lv`^RyAEWX^1
	FIELD_S(0xFFFFF56A, 0xFFFFF56B, unsigned char, TAB1CCR2)	// TAB1Lv`^RyAEWX^2
	FIELD_S(0xFFFFF56C, 0xFFFFF56D, unsigned char, TAB1CCR3)	// TAB1Lv`^RyAEWX^3
	FIELD_S(0xFFFFF56E, 0xFFFFF56F, unsigned char, TAB1CNT)	// TAB1JE^E[hEobt@EWX^
	FIELD_S(0xFFFFF570, 0xFFFFF57F, unsigned char, TAB1IOC4)	// TAB1I/O䃌WX^4
	FIELD_0(0xFFFFF580, 0xFFFFF580, unsigned char, TAB1OPT1)	// TAB1IvVEWX^1
	FIELD_0(0xFFFFF581, 0xFFFFF581, unsigned char, TAB1OPT2)	// TAB1IvVEWX^2
	FIELD_S(0xFFFFF582, 0xFFFFF583, unsigned char, TAB1IOC3)	// TAB1I/O䃌WX^3
	FIELD_S(0xFFFFF584, 0xFFFFF58F, unsigned char, TAB1DTC)	// TAB1fbh^CERyAEWX^1
	FIELD_0(0xFFFFF590, 0xFFFFF590, unsigned char, HZA0CTL0)	// nCECs[_Xo͐䃌WX^0
	FIELD_S(0xFFFFF591, 0xFFFFF59F, unsigned char, HZA0CTL1)	// nCECs[_Xo͐䃌WX^1
	FIELD_S(0xFFFFF5A0, 0xFFFFF5A1, unsigned char, TANFC0)	// TAA0mCY䃌WX^
	FIELD_S(0xFFFFF5A2, 0xFFFFF5A3, unsigned char, TANFC1)	// TAA1mCY䃌WX^
	FIELD_S(0xFFFFF5A4, 0xFFFFF5A5, unsigned char, TANFC2)	// TAA2mCY䃌WX^
	FIELD_S(0xFFFFF5A6, 0xFFFFF5A7, unsigned char, TANFC3)	// TAA3mCY䃌WX^
	FIELD_S(0xFFFFF5A8, 0xFFFFF5A9, unsigned char, TANFC4)	// TAA4mCY䃌WX^
	FIELD_S(0xFFFFF5AA, 0xFFFFF5AB, unsigned char, TANFC5)	// TAA5mCY䃌WX^
	FIELD_S(0xFFFFF5AC, 0xFFFFF5AF, unsigned char, TTNFC)	// TMTmCY䃌WX^
	FIELD_S(0xFFFFF5B0, 0xFFFFF5FF, unsigned char, INTNFC)	// mCY䃌WX^
	FIELD_0(0xFFFFF600, 0xFFFFF600, unsigned char, TT0CTL0)	// TMT0䃌WX^0
	FIELD_0(0xFFFFF601, 0xFFFFF601, unsigned char, TT0CTL1)	// TMT0䃌WX^1
	FIELD_0(0xFFFFF602, 0xFFFFF602, unsigned char, TT0CTL2)	// TMT0䃌WX^2
	FIELD_0(0xFFFFF603, 0xFFFFF603, unsigned char, TT0IOC0)	// TMT0I/O䃌WX^0
	FIELD_0(0xFFFFF604, 0xFFFFF604, unsigned char, TT0IOC1)	// TMT0I/O䃌WX^1
	FIELD_0(0xFFFFF605, 0xFFFFF605, unsigned char, TT0IOC2)	// TMT0I/O䃌WX^2
	FIELD_0(0xFFFFF606, 0xFFFFF606, unsigned char, TT0IOC3)	// TMT0I/O䃌WX^3
	FIELD_0(0xFFFFF607, 0xFFFFF607, unsigned char, TT0OPT0)	// TMT0IvVEWX^0
	FIELD_S(0xFFFFF608, 0xFFFFF609, unsigned char, TT0OPT1)	// TMT0IvVEWX^1
	FIELD_S(0xFFFFF60A, 0xFFFFF60B, unsigned char, TT0CCR0)	// TMT0Lv`^RyAEWX^0
	FIELD_S(0xFFFFF60C, 0xFFFFF60D, unsigned char, TT0CCR1)	// TMT0Lv`^RyAEWX^1
	FIELD_S(0xFFFFF60E, 0xFFFFF60F, unsigned char, TT0CNT)	// TMT0JE^E[hEobt@EWX^
	FIELD_S(0xFFFFF610, 0xFFFFF62F, unsigned char, TT0TCW)	// TMT0JE^ECgEWX^
	FIELD_0(0xFFFFF630, 0xFFFFF630, unsigned char, TAA0CTL0)	// TAA0䃌WX^0
	FIELD_0(0xFFFFF631, 0xFFFFF631, unsigned char, TAA0CTL1)	// TAA0䃌WX^1
	FIELD_0(0xFFFFF632, 0xFFFFF632, unsigned char, TAA0IOC0)	// TAA0I/O䃌WX^0
	FIELD_0(0xFFFFF633, 0xFFFFF633, unsigned char, TAA0IOC1)	// TAA0I/O䃌WX^1
	FIELD_0(0xFFFFF634, 0xFFFFF634, unsigned char, TAA0IOC2)	// TAA0I/O䃌WX^2
	FIELD_0(0xFFFFF635, 0xFFFFF635, unsigned char, TAA0OPT0)	// TAA0IvVEWX^0
	FIELD_S(0xFFFFF636, 0xFFFFF637, unsigned char, TAA0CCR0)	// TAA0Lv`^RyAEWX^0
	FIELD_S(0xFFFFF638, 0xFFFFF639, unsigned char, TAA0CCR1)	// TAA0Lv`^RyAEWX^1
	FIELD_S(0xFFFFF63A, 0xFFFFF63B, unsigned char, TAA0CNT)	// TAA0JE^E[hEobt@EWX^
	FIELD_0(0xFFFFF63C, 0xFFFFF63C, unsigned char, TAA0IOC4)	// TAA0I/O䃌WX^4
	FIELD_S(0xFFFFF63D, 0xFFFFF63F, unsigned char, TAA0OPT1)	// TAA0IvVEWX^1
	FIELD_0(0xFFFFF640, 0xFFFFF640, unsigned char, TAA1CTL0)	// TAA1䃌WX^0
	FIELD_0(0xFFFFF641, 0xFFFFF641, unsigned char, TAA1CTL1)	// TAA1䃌WX^1
	FIELD_0(0xFFFFF642, 0xFFFFF642, unsigned char, TAA1IOC0)	// TAA1I/O䃌WX^0
	FIELD_0(0xFFFFF643, 0xFFFFF643, unsigned char, TAA1IOC1)	// TAA1I/O䃌WX^1
	FIELD_0(0xFFFFF644, 0xFFFFF644, unsigned char, TAA1IOC2)	// TAA1I/O䃌WX^2
	FIELD_0(0xFFFFF645, 0xFFFFF645, unsigned char, TAA1OPT0)	// TAA1IvVEWX^0
	FIELD_S(0xFFFFF646, 0xFFFFF647, unsigned char, TAA1CCR0)	// TAA1Lv`^RyAEWX^0
	FIELD_S(0xFFFFF648, 0xFFFFF649, unsigned char, TAA1CCR1)	// TAA1Lv`^RyAEWX^1
	FIELD_S(0xFFFFF64A, 0xFFFFF64B, unsigned char, TAA1CNT)	// TAA1JE^E[hEobt@EWX^
	FIELD_S(0xFFFFF64C, 0xFFFFF64F, unsigned char, TAA1IOC4)	// TAA1I/O䃌WX^4
	FIELD_0(0xFFFFF650, 0xFFFFF650, unsigned char, TAA2CTL0)	// TAA2䃌WX^0
	FIELD_0(0xFFFFF651, 0xFFFFF651, unsigned char, TAA2CTL1)	// TAA2䃌WX^1
	FIELD_0(0xFFFFF652, 0xFFFFF652, unsigned char, TAA2IOC0)	// TAA2I/O䃌WX^0
	FIELD_0(0xFFFFF653, 0xFFFFF653, unsigned char, TAA2IOC1)	// TAA2I/O䃌WX^1
	FIELD_0(0xFFFFF654, 0xFFFFF654, unsigned char, TAA2IOC2)	// TAA2I/O䃌WX^2
	FIELD_0(0xFFFFF655, 0xFFFFF655, unsigned char, TAA2OPT0)	// TAA2IvVEWX^0
	FIELD_S(0xFFFFF656, 0xFFFFF657, unsigned char, TAA2CCR0)	// TAA2Lv`^RyAEWX^0
	FIELD_S(0xFFFFF658, 0xFFFFF659, unsigned char, TAA2CCR1)	// TAA2Lv`^RyAEWX^1
	FIELD_S(0xFFFFF65A, 0xFFFFF65B, unsigned char, TAA2CNT)	// TAA2JE^E[hEobt@EWX^
	FIELD_0(0xFFFFF65C, 0xFFFFF65C, unsigned char, TAA2IOC4)	// TAA2I/O䃌WX^4
	FIELD_S(0xFFFFF65D, 0xFFFFF65F, unsigned char, TAA2OPT1)	// TAA2IvVEWX^1
	FIELD_0(0xFFFFF660, 0xFFFFF660, unsigned char, TAA3CTL0)	// TAA3䃌WX^0
	FIELD_0(0xFFFFF661, 0xFFFFF661, unsigned char, TAA3CTL1)	// TAA3䃌WX^1
	FIELD_0(0xFFFFF662, 0xFFFFF662, unsigned char, TAA3IOC0)	// TAA3I/O䃌WX^0
	FIELD_0(0xFFFFF663, 0xFFFFF663, unsigned char, TAA3IOC1)	// TAA3I/O䃌WX^1
	FIELD_0(0xFFFFF664, 0xFFFFF664, unsigned char, TAA3IOC2)	// TAA3I/O䃌WX^2
	FIELD_0(0xFFFFF665, 0xFFFFF665, unsigned char, TAA3OPT0)	// TAA3IvVEWX^0
	FIELD_S(0xFFFFF666, 0xFFFFF667, unsigned char, TAA3CCR0)	// TAA3Lv`^RyAEWX^0
	FIELD_S(0xFFFFF668, 0xFFFFF669, unsigned char, TAA3CCR1)	// TAA3Lv`^RyAEWX^1
	FIELD_S(0xFFFFF66A, 0xFFFFF66B, unsigned char, TAA3CNT)	// TAA3JE^E[hEobt@EWX^
	FIELD_S(0xFFFFF66C, 0xFFFFF66F, unsigned char, TAA3IOC4)	// TAA3I/O䃌WX^4
	FIELD_0(0xFFFFF670, 0xFFFFF670, unsigned char, TAA4CTL0)	// TAA4䃌WX^0
	FIELD_0(0xFFFFF671, 0xFFFFF671, unsigned char, TAA4CTL1)	// TAA4䃌WX^1
	FIELD_0(0xFFFFF672, 0xFFFFF672, unsigned char, TAA4IOC0)	// TAA4I/O䃌WX^0
	FIELD_0(0xFFFFF673, 0xFFFFF673, unsigned char, TAA4IOC1)	// TAA4I/O䃌WX^1
	FIELD_0(0xFFFFF674, 0xFFFFF674, unsigned char, TAA4IOC2)	// TAA4I/O䃌WX^2
	FIELD_0(0xFFFFF675, 0xFFFFF675, unsigned char, TAA4OPT0)	// TAA4IvVWX^0
	FIELD_S(0xFFFFF676, 0xFFFFF677, unsigned char, TAA4CCR0)	// TAA4Lv`^RyAEWX^0
	FIELD_S(0xFFFFF678, 0xFFFFF679, unsigned char, TAA4CCR1)	// TAA4Lv`^RyAEWX^1
	FIELD_S(0xFFFFF67A, 0xFFFFF67B, unsigned char, TAA4CNT)	// TAA4JE^E[hEobt@EWX^
	FIELD_S(0xFFFFF67C, 0xFFFFF67F, unsigned char, TAA4IOC4)	// TAA4I/O䃌WX^4 
	FIELD_0(0xFFFFF680, 0xFFFFF680, unsigned char, TAA5CTL0)	// TAA5䃌WX^0
	FIELD_0(0xFFFFF681, 0xFFFFF681, unsigned char, TAA5CTL1)	// TAA5䃌WX^1
	FIELD_0(0xFFFFF682, 0xFFFFF682, unsigned char, TAA5IOC0)	// TAA5I/O䃌WX^0
	FIELD_0(0xFFFFF683, 0xFFFFF683, unsigned char, TAA5IOC1)	// TAA5I/O䃌WX^1
	FIELD_0(0xFFFFF684, 0xFFFFF684, unsigned char, TAA5IOC2)	// TAA5I/O䃌WX^2
	FIELD_0(0xFFFFF685, 0xFFFFF685, unsigned char, TAA5OPT0)	// TAA5IvVEWX^0
	FIELD_S(0xFFFFF686, 0xFFFFF687, unsigned char, TAA5CCR0)	// TAA5Lv`^RyAEWX^0
	FIELD_S(0xFFFFF688, 0xFFFFF689, unsigned char, TAA5CCR1)	// TAA5Lv`^RyAEWX^1
	FIELD_S(0xFFFFF68A, 0xFFFFF68B, unsigned char, TAA5CNT)	// TAA5JE^E[hEobt@EWX^
	FIELD_S(0xFFFFF68C, 0xFFFFF6BF, unsigned char, TAA5IOC4)	// TAA5I/O䃌WX^4
	FIELD_0(0xFFFFF6C0, 0xFFFFF6C0, unsigned char, OSTS)	// U莞ԑIWX^
	FIELD_S(0xFFFFF6C1, 0xFFFFF6CF, unsigned char, PLLS)	// PLLbNAbvԎw背WX^
	FIELD_0(0xFFFFF6D0, 0xFFFFF6D0, unsigned char, WDTM2)	// EHb`hbOE^C}E[hEWX^2
	FIELD_S(0xFFFFF6D1, 0xFFFFF6DF, unsigned char, WDTE)	// EHb`hbOE^C}ECl[uEWX^ 
	FIELD_S(0xFFFFF6E0, 0xFFFFF6E1, unsigned char, RTBL0)	// A^Co̓obt@EWX^0k
	FIELD_S(0xFFFFF6E2, 0xFFFFF6E3, unsigned char, RTBH0)	// A^Co̓obt@EWX^0g
	FIELD_0(0xFFFFF6E4, 0xFFFFF6E4, unsigned char, RTPM0)	// A^Co̓|[gE[hEWX^0
	FIELD_S(0xFFFFF6E5, 0xFFFFF6FF, unsigned char, RTPC0)	// A^Co̓|[gERg[EWX^0
	FIELD_S(0xFFFFF700, 0xFFFFF703, unsigned char, PFCE0)	// |[g0t@NVERg[gWX^
	FIELD_S(0xFFFFF704, 0xFFFFF705, unsigned char, PFCE2)	// |[g2t@NVERg[gWX^
	FIELD_S(0xFFFFF706, 0xFFFFF707, unsigned char, PFCE3)	// |[g3t@NVERg[gWX^
	FIELD_S(0xFFFFF708, 0xFFFFF709, unsigned char, PFCE4L)	// |[g4t@NVERg[gWX^L
	FIELD_S(0xFFFFF70A, 0xFFFFF711, unsigned char, PFCE5L)	// |[g5t@NVERg[gWX^L
	FIELD_0(0xFFFFF712, 0xFFFFF712, unsigned char, PFCE9L)	// |[g9t@NVERg[gWX^L
	FIELD_S(0xFFFFF713, 0xFFFFF725, unsigned char, PFCE9H)	// |[g9t@NVERg[gWX^H
	FIELD_S(0xFFFFF726, 0xFFFFF801, unsigned char, PFCEDH)	// |[gDHt@NVRg[gWX^
	FIELD_S(0xFFFFF802, 0xFFFFF80B, unsigned char, SYS)	// VXeEXe[^XEWX^
	FIELD_S(0xFFFFF80C, 0xFFFFF80F, unsigned char, RCM)	// U[hEWX^
	FIELD_S(0xFFFFF810, 0xFFFFF811, unsigned char, DTFR0)	// DMAgKvWX^0
	FIELD_S(0xFFFFF812, 0xFFFFF813, unsigned char, DTFR1)	// DMAgKvWX^1
	FIELD_S(0xFFFFF814, 0xFFFFF815, unsigned char, DTFR2)	// DMAgKvWX^2
	FIELD_S(0xFFFFF816, 0xFFFFF81F, unsigned char, DTFR3)	// DMAgKvWX^3
	FIELD_S(0xFFFFF820, 0xFFFFF821, unsigned char, PSMR)	// p[EZ[uE[hEWX^
	FIELD_S(0xFFFFF822, 0xFFFFF823, unsigned char, CKC)	// NbNERg[EWX^
	FIELD_S(0xFFFFF824, 0xFFFFF827, unsigned char, LOCKR)	// bNEWX^
	FIELD_S(0xFFFFF828, 0xFFFFF82B, unsigned char, PCC)	// vZbTENbNERg[EWX^
	FIELD_S(0xFFFFF82C, 0xFFFFF82D, unsigned char, PLLCTL)	// PLLRg[EWX^
	FIELD_S(0xFFFFF82E, 0xFFFFF86F, unsigned char, CCLS)	// CPUNbNEXe[^XEWX^
	FIELD_S(0xFFFFF870, 0xFFFFF887, unsigned char, CLM)	// NbNEj^E[hEWX^
	FIELD_S(0xFFFFF888, 0xFFFFF88F, unsigned char, RESF)	// ZbgvtOEWX^
	FIELD_S(0xFFFFF890, 0xFFFFF891, unsigned char, LVIM)	// doWX^
	FIELD_S(0xFFFFF892, 0xFFFFF8AF, unsigned char, RAMS)	// RAMf[^EXe[^XEWX^
	FIELD_0(0xFFFFF8B0, 0xFFFFF8B0, unsigned char, PRSM0)	// vXP[E[hEWX^0
	FIELD_S(0xFFFFF8B1, 0xFFFFF9FB, unsigned char, PRSCM0)	// vXP[ERyAEWX^0
	FIELD_S(0xFFFFF9FC, 0xFFFFF9FF, unsigned char, OCDM)	// I`bvEfobOE[hEWX^
	FIELD_S(0xFFFFFA00, 0xFFFFFA0F, struct TUartCPort, UC0)	// UARTC0WX^
	FIELD_S(0xFFFFFA10, 0xFFFFFA1F, struct TUartCPort, UC1)	// UARTC1WX^
	FIELD_S(0xFFFFFA20, 0xFFFFFA2F, struct TUartCPort, UC2)	// UARTC2WX^
	FIELD_S(0xFFFFFA30, 0xFFFFFA3F, struct TUartCPort, UC3)	// UARTC3WX^
	FIELD_S(0xFFFFFA40, 0xFFFFFA4F, struct TUartCPort, UC4)	// UARTC4WX^
	FIELD_S(0xFFFFFA50, 0xFFFFFA5F, struct TUartCPort, UC5)	// UARTC5WX^
	FIELD_S(0xFFFFFA60, 0xFFFFFA6F, struct TUartCPort, UC6)	// UARTC6WX^
	FIELD_S(0xFFFFFA70, 0xFFFFFA7F, struct TUartCPort, UC7)	// UARTC7WX^
	FIELD_S(0xFFFFFA80, 0xFFFFFA8F, struct TTMMPort, TM0)	// TMM0WX^
	FIELD_S(0xFFFFFA90, 0xFFFFFA9F, struct TTMMPort, TM1)	// TMM1WX^
	FIELD_S(0xFFFFFAA0, 0xFFFFFAAF, struct TTMMPort, TM2)	// TMM2WX^
	FIELD_S(0xFFFFFAB0, 0xFFFFFACF, struct TTMMPort, TM3)	// TMM3WX^
	FIELD_S(0xFFFFFAD0, 0xFFFFFAFF, struct TRCPort, RC1)	// A^CEJE^
	FIELD_0(0xFFFFFB00, 0xFFFFFB00, unsigned char, CE0CTL0)	// CSIE0䃌WX^0
	FIELD_0(0xFFFFFB01, 0xFFFFFB01, unsigned char, CE0CTL1)	// CSIE0䃌WX^1
	FIELD_S(0xFFFFFB02, 0xFFFFFB05, unsigned char, CE0RX0)	// CSIE0Mf[^EWX^0
	FIELD_S(0xFFFFFB06, 0xFFFFFB07, unsigned char, CE0TX0)	// CSIE0Mf[^EWX^
	FIELD_0(0xFFFFFB08, 0xFFFFFB08, unsigned char, CE0STR)	// CSIE0ԃWX^
	FIELD_S(0xFFFFFB09, 0xFFFFFB0B, unsigned char, CE0CTL2)	// CSIE0䃌WX^2
	FIELD_S(0xFFFFFB0C, 0xFFFFFB3F, unsigned char, CE0CTL3)	// CSIE0䃌WX^3
	FIELD_0(0xFFFFFB40, 0xFFFFFB40, unsigned char, CE1CTL0)	// CSIE1䃌WX^0
	FIELD_0(0xFFFFFB41, 0xFFFFFB41, unsigned char, CE1CTL1)	// CSIE1䃌WX^1
	FIELD_S(0xFFFFFB42, 0xFFFFFB45, unsigned char, CE1RX0)	// CSIE1Mf[^EWX^
	FIELD_S(0xFFFFFB46, 0xFFFFFB47, unsigned char, CE1TX0)	// CSIE1Mf[^EWX^
	FIELD_0(0xFFFFFB48, 0xFFFFFB48, unsigned char, CE1STR)	// CSIE1ԃWX^
	FIELD_S(0xFFFFFB49, 0xFFFFFB4B, unsigned char, CE1CTL2)	// CSIE1䃌WX^2
	FIELD_S(0xFFFFFB4C, 0xFFFFFB7F, unsigned char, CE1CTL3)	// CSIE1䃌WX^3
	FIELD_S(0xFFFFFB80, 0xFFFFFB9F, struct TUartBPort, UB0)	// UARTB0WX^
	FIELD_S(0xFFFFFBA0, 0xFFFFFBBF, struct TUartBPort, UB1)	// UARTB1WX^0
	FIELD_S(0xFFFFFBC0, 0xFFFFFBC1, unsigned char, IIC4)	// IICVtgEWX^4
	FIELD_0(0xFFFFFBC2, 0xFFFFFBC2, unsigned char, IICC4)	// IICRg[EWX^4
	FIELD_0(0xFFFFFBC3, 0xFFFFFBC3, unsigned char, SVA4)	// X[uAhXWX^4
	FIELD_0(0xFFFFFBC4, 0xFFFFFBC4, unsigned char, IICCL4)	// IICNbNIWX^4
	FIELD_0(0xFFFFFBC5, 0xFFFFFBC5, unsigned char, IICX4)	// IIC@\gWX^4
	FIELD_S(0xFFFFFBC6, 0xFFFFFBC9, unsigned char, IICS4)	// IICԃWX^4 
	FIELD_S(0xFFFFFBCA, 0xFFFFFBDF, unsigned char, IICF4)	// IICtOEWX^4
	FIELD_S(0xFFFFFBE0, 0xFFFFFBFF, unsigned char, MIICTL)	// C[TlbgERg[EWX^
	FIELD_S(0xFFFFFC00, 0xFFFFFC03, unsigned char, INTF0)	// O荞ݗGbWw背WX^0
	FIELD_S(0xFFFFFC04, 0xFFFFFC05, unsigned char, INTF2)	// O荞ݗGbWw背WX^2
	FIELD_S(0xFFFFFC06, 0xFFFFFC08, unsigned char, INTF3)	// O荞ݗGbWw背WX^3
	FIELD_0(0xFFFFFC09, 0xFFFFFC09, unsigned char, INTF4)	// O荞ݗGbWw背WX^4
	FIELD_S(0xFFFFFC0A, 0xFFFFFC11, unsigned short, INTF5)	// O荞ݗGbWw背WX^5
	FIELD_S(0xFFFFFC12, 0xFFFFFC1F, unsigned short, INTF9)	// O荞ݗGbWw背WX^9
	FIELD_S(0xFFFFFC20, 0xFFFFFC23, unsigned char, INTR0)	// O荞ݗオGbWw背WX^0
	FIELD_S(0xFFFFFC24, 0xFFFFFC25, unsigned char, INTR2)	// O荞ݗオGbWw背WX^2
	FIELD_S(0xFFFFFC26, 0xFFFFFC28, unsigned char, INTR3)	// O荞ݗオGbWw背WX^3
	FIELD_0(0xFFFFFC29, 0xFFFFFC29, unsigned char, INTR4)	// O荞ݗオGbWw背WX^4
	FIELD_S(0xFFFFFC2A, 0xFFFFFC31, unsigned short, INTR5)	// O荞ݗオGbWw背WX^5
	FIELD_S(0xFFFFFC32, 0xFFFFFC5F, unsigned short, INTR9)	// O荞ݗオGbWw背WX^9
	FIELD_S(0xFFFFFC60, 0xFFFFFC63, unsigned char, PF0)	// |[g0t@NVEWX^
	FIELD_S(0xFFFFFC64, 0xFFFFFC65, unsigned char, PF2)	// |[g2t@NVEWX^
	FIELD_S(0xFFFFFC66, 0xFFFFFC67, unsigned char, PF3)	// |[g3t@NVEWX^
	FIELD_S(0xFFFFFC68, 0xFFFFFC69, unsigned char, PF4)	// |[g4t@NVEWX^
	FIELD_S(0xFFFFFC6A, 0xFFFFFC71, unsigned char, PF5)	// |[g5t@NVEWX^
	FIELD_S(0xFFFFFC72, 0xFFFFFCFF, unsigned char, PF9)	// |[g9t@NVEWX^
	FIELD_0(0xFFFFFD00, 0xFFFFFD00, unsigned char, CF0CTL0)	// CSIF0䃌WX^0
	FIELD_0(0xFFFFFD01, 0xFFFFFD01, unsigned char, CF0CTL1)	// CSIF0䃌WX^1
	FIELD_0(0xFFFFFD02, 0xFFFFFD02, unsigned char, CF0CTL2)	// CSIF0䃌WX^2
	FIELD_0(0xFFFFFD03, 0xFFFFFD03, unsigned char, CF0STR)	// CSIF0ԃWX^
	FIELD_S(0xFFFFFD04, 0xFFFFFD05, unsigned char, CF0RX)	// CSIF0Mf[^EWX^
	FIELD_S(0xFFFFFD06, 0xFFFFFD0F, unsigned char, CF0TX)	// CSIF0Mf[^EWX^
	FIELD_0(0xFFFFFD10, 0xFFFFFD10, unsigned char, CF1CTL0)	// CSIF1䃌WX^0
	FIELD_0(0xFFFFFD11, 0xFFFFFD11, unsigned char, CF1CTL1)	// CSIF1䃌WX^1
	FIELD_0(0xFFFFFD12, 0xFFFFFD12, unsigned char, CF1CTL2)	// CSIF1䃌WX^2
	FIELD_0(0xFFFFFD13, 0xFFFFFD13, unsigned char, CF1STR)	// CSIF1ԃWX^
	FIELD_0(0xFFFFFD14, 0xFFFFFD15, unsigned char, CF1RX)	// CSIF1Mf[^EWX^
	FIELD_S(0xFFFFFD16, 0xFFFFFD1F, unsigned char, CF1TX)	// CSIF1Mf[^EWX^
	FIELD_0(0xFFFFFD20, 0xFFFFFD20, unsigned char, CF2CTL0)	// CSIF2䃌WX^0
	FIELD_0(0xFFFFFD21, 0xFFFFFD21, unsigned char, CF2CTL1)	// CSIF2䃌WX^1
	FIELD_0(0xFFFFFD22, 0xFFFFFD22, unsigned char, CF2CTL2)	// CSIF2䃌WX^2
	FIELD_0(0xFFFFFD23, 0xFFFFFD23, unsigned char, CF2STR)	// CSIF2ԃWX^
	FIELD_S(0xFFFFFD24, 0xFFFFFD25, unsigned char, CF2RX)	// CSIF2Mf[^EWX^
	FIELD_S(0xFFFFFD26, 0xFFFFFD2F, unsigned char, CF2TX)	// CSIF2Mf[^EWX^
	FIELD_0(0xFFFFFD30, 0xFFFFFD30, unsigned char, CF3CTL0)	// CSIF3䃌WX^0
	FIELD_0(0xFFFFFD31, 0xFFFFFD31, unsigned char, CF3CTL1)	// CSIF3䃌WX^1
	FIELD_0(0xFFFFFD32, 0xFFFFFD32, unsigned char, CF3CTL2)	// CSIF3䃌WX^2
	FIELD_0(0xFFFFFD33, 0xFFFFFD33, unsigned char, CF3STR)	// CSIF3ԃWX^
	FIELD_S(0xFFFFFD34, 0xFFFFFD35, unsigned char, CF3RX)	// CSIF3Mf[^EWX^
	FIELD_S(0xFFFFFD36, 0xFFFFFD3F, unsigned char, CF3TX)	// CSIF3Mf[^EWX^
	FIELD_0(0xFFFFFD40, 0xFFFFFD40, unsigned char, CF4CTL0)	// CSIF4䃌WX^0
	FIELD_0(0xFFFFFD41, 0xFFFFFD41, unsigned char, CF4CTL1)	// CSIF4䃌WX^1
	FIELD_0(0xFFFFFD42, 0xFFFFFD42, unsigned char, CF4CTL2)	// CSIF4䃌WX^2
	FIELD_0(0xFFFFFD43, 0xFFFFFD43, unsigned char, CF4STR)	// CSIF4ԃWX^
	FIELD_S(0xFFFFFD44, 0xFFFFFD45, unsigned char, CF4RX)	// CSIF4Mf[^EWX^
	FIELD_S(0xFFFFFD46, 0xFFFFFD4F, unsigned char, CF4TX)	// CSIF4Mf[^EWX^
	FIELD_0(0xFFFFFD50, 0xFFFFFD50, unsigned char, CF5CTL0)	// CSIF5䃌WX^0
	FIELD_0(0xFFFFFD51, 0xFFFFFD51, unsigned char, CF5CTL1)	// CSIF5䃌WX^1
	FIELD_0(0xFFFFFD52, 0xFFFFFD52, unsigned char, CF5CTL2)	// CSIF5䃌WX^2
	FIELD_0(0xFFFFFD53, 0xFFFFFD53, unsigned char, CF5STR)	// CSIF5ԃWX^
	FIELD_S(0xFFFFFD54, 0xFFFFFD55, unsigned char, CF5RX)	// CSIF5Mf[^EWX^
	FIELD_S(0xFFFFFD56, 0xFFFFFD5F, unsigned char, CF5TX)	// CSIF5Mf[^EWX^
	FIELD_0(0xFFFFFD60, 0xFFFFFD60, unsigned char, CF6CTL0)	// CSIF6䃌WX^0
	FIELD_0(0xFFFFFD61, 0xFFFFFD61, unsigned char, CF6CTL1)	// CSIF6䃌WX^1
	FIELD_0(0xFFFFFD62, 0xFFFFFD62, unsigned char, CF6CTL2)	// CSIF6䃌WX^2
	FIELD_0(0xFFFFFD63, 0xFFFFFD63, unsigned char, CF6STR)	// CSIF6ԃWX^
	FIELD_S(0xFFFFFD64, 0xFFFFFD65, unsigned char, CF6RX)	// CSIF6Mf[^EWX^
	FIELD_S(0xFFFFFD66, 0xFFFFFD7F, unsigned char, CF6TX)	// CSIF6Mf[^EWX^
	FIELD_S(0xFFFFFD80, 0xFFFFFD81, unsigned char, IIC0)	// IICVtgEWX^0
	FIELD_0(0xFFFFFD82, 0xFFFFFD82, unsigned char, IICC0)	// IICRg[EWX^0
	FIELD_0(0xFFFFFD83, 0xFFFFFD83, unsigned char, SVA0)	// X[uEAhXEWX^0
	FIELD_0(0xFFFFFD84, 0xFFFFFD84, unsigned char, IICCL0)	// IICNbNIWX^0
	FIELD_0(0xFFFFFD85, 0xFFFFFD85, unsigned char, IICX0)	// IIC@\gWX^0
	FIELD_S(0xFFFFFD86, 0xFFFFFD89, unsigned char, IICS0)	// IICԃWX^0 
	FIELD_S(0xFFFFFD8A, 0xFFFFFD8F, unsigned char, IICF0)	// IICtOEWX^0
	FIELD_S(0xFFFFFD90, 0xFFFFFD91, unsigned char, IIC1)	// IICVtgEWX^1
	FIELD_0(0xFFFFFD92, 0xFFFFFD92, unsigned char, IICC1)	// IICRg[EWX^1
	FIELD_0(0xFFFFFD93, 0xFFFFFD93, unsigned char, SVA1)	// X[uEAhXEWX^1
	FIELD_0(0xFFFFFD94, 0xFFFFFD94, unsigned char, IICCL1)	// IICNbNIWX^1
	FIELD_0(0xFFFFFD95, 0xFFFFFD95, unsigned char, IICX1)	// IIC@\gWX^1
	FIELD_S(0xFFFFFD96, 0xFFFFFD99, unsigned char, IICS1)	// IICԃWX^1 
	FIELD_S(0xFFFFFD9A, 0xFFFFFD9F, unsigned char, IICF1)	// IICtOEWX^1
	FIELD_S(0xFFFFFDA0, 0xFFFFFDA1, unsigned char, IIC2)	// IICVtgEWX^2
	FIELD_0(0xFFFFFDA2, 0xFFFFFDA2, unsigned char, IICC2)	// IICRg[EWX^2
	FIELD_0(0xFFFFFDA3, 0xFFFFFDA3, unsigned char, SVA2)	// X[uEAhXEWX^2
	FIELD_0(0xFFFFFDA4, 0xFFFFFDA4, unsigned char, IICCL2)	// IICNbNIWX^2
	FIELD_0(0xFFFFFDA5, 0xFFFFFDA5, unsigned char, IICX2)	// IIC@\gWX^2
	FIELD_S(0xFFFFFDA6, 0xFFFFFDA9, unsigned char, IICS2)	// IICԃWX^2 
	FIELD_S(0xFFFFFDAA, 0xFFFFFDAF, unsigned char, IICF2)	// IICtOEWX^2
	FIELD_S(0xFFFFFDB0, 0xFFFFFDB1, unsigned char, IIC3)	// IICVtgEWX^3
	FIELD_0(0xFFFFFDB2, 0xFFFFFDB2, unsigned char, IICC3)	// IICRg[EWX^3
	FIELD_0(0xFFFFFDB3, 0xFFFFFDB3, unsigned char, SVA3)	// X[uAhXWX^3
	FIELD_0(0xFFFFFDB4, 0xFFFFFDB4, unsigned char, IICCL3)	// IICNbNIWX^3
	FIELD_0(0xFFFFFDB5, 0xFFFFFDB5, unsigned char, IICX3)	// IIC@\gWX^3
	FIELD_S(0xFFFFFDB6, 0xFFFFFDB9, unsigned char, IICS3)	// IICԃWX^3 
	FIELD_S(0xFFFFFDBA, 0xFFFFFF3F, unsigned char, IICF3)	// IICtOEWX^3
	FIELD_0(0xFFFFFF40, 0xFFFFFF40, unsigned char, UCKSEL)	// USBNbNIWX^
	FIELD_S(0xFFFFFF41, 0xFFFFFF5F, unsigned char, UFCKMSK)	// USBt@NV䃌WX^
	FIELD_0(0xFFFFFF60, 0xFFFFFF60, unsigned char, EXDRQEN)	// ODMANGXgECl[uEWX^
};

//------------------------------------------------------------------------------
// őpPbgWX^ R/W 00000600H
//------------------------------------------------------------------------------
struct TEtherLMAXReg
{
	unsigned int MAXF : 16;		// őpPbgioCgj
	unsigned int : 16;
};

//------------------------------------------------------------------------------
// MIIRtBM|VEWX^ R/W 00000000H
//------------------------------------------------------------------------------
struct TEtherMIICReg
{
	unsigned int : 1;
	unsigned int PHYSEL : 1;			// MDC̏o͐ݒ
	unsigned int CLKS : 3;				// MDC̕ݒ
	unsigned int : 10;
	unsigned int MIRST : 1;			// VAE}lWgEC^tF[XEubNE\tgEGAEZbg
	unsigned int : 16;
};

//------------------------------------------------------------------------------
// MIIAhXEWX^ R/W 00000000H
//------------------------------------------------------------------------------
struct TEtherMADRReg
{
	unsigned int RGAD : 5;				// PHYWX^EAhX
	unsigned int : 3;
	unsigned int FIAD : 5;				// PHYAhX
	unsigned int : 19;
};

//------------------------------------------------------------------------------
// MIICgEf[^EWX^ R/W 00000000H
//------------------------------------------------------------------------------
struct TEtherMWTDReg
{
	unsigned int CTLD : 16;			// MIICgEf[^
	unsigned int : 16;
};

//------------------------------------------------------------------------------
// MII[hEf[^EWX^ R/W 00000000H
//------------------------------------------------------------------------------
struct TEtherMRDDReg
{
	unsigned int PRSD : 16;			// MII[hEf[^
	unsigned int : 16;
};

//------------------------------------------------------------------------------
// MIICWP[^EWX^ R 00000000H
//------------------------------------------------------------------------------
struct TEtherMINDReg
{
	unsigned int BUSY : 1;				// BUSY
	unsigned int SCANA : 1;			// SCANR}hEANeBu
	unsigned int NVALID : 1;			// SCANR}hJnXe[^X
	unsigned int : 29;
};

//------------------------------------------------------------------------------
// AhXEtB^EWX^ R/W 00000000H
//------------------------------------------------------------------------------
struct TEtherAFRReg
{
	unsigned int ABC : 1;				// u[hLXgM
	unsigned int AMC : 1;				// t}`LXgM
	unsigned int PRM : 1;				// }`LXgM
	unsigned int PRO : 1;				// v~XJXE[h
	unsigned int : 24;
};

//------------------------------------------------------------------------------
// \tgEZbg䃌WX^ R/W 00000000H
//------------------------------------------------------------------------------
struct TEtherRSTCNTReg
{
	unsigned int SFTRST : 1;			// \tgEGAEZbg
	unsigned int : 7;
	unsigned int TFFLSH : 1;			// MFIFONAitbVj
	unsigned int : 7;
	unsigned int RFFLSH : 1;			// MFIFONAitbVj
	unsigned int : 15;
};

//------------------------------------------------------------------------------
// \tgEGAEZbg䃌WX^ R/W 00000000H
//------------------------------------------------------------------------------
struct TEtherSFTRSTReg
{
	unsigned int SFTRST : 1;			// \tgEGAEZbg
	unsigned int : 31;
};

//------------------------------------------------------------------------------
// RAEt@NV䃌WX^ R/W 00000000H
//------------------------------------------------------------------------------
struct TEtherETHMODEReg
{
	unsigned int : 17;
	unsigned int TXS : 1;			// Mrbg
	unsigned int RXS : 1;			// Mrbg
	unsigned int : 13;
};

//------------------------------------------------------------------------------
// MXe[^X荞݃WX^ R 00000000H
//------------------------------------------------------------------------------
struct TEtherTXSTATUSReg
{
	unsigned int TCRCE : 1;		// CRCG[
	unsigned int TFLER : 1;		// OXEtB[hf[^EtB[hƕsv
	unsigned int TFLOR : 1;		// OXEtB[h1500傫
	unsigned int TDFR : 1;			// Mx
	unsigned int TEDFR : 1;		// ߏ著MxoiTABvj
	unsigned int ECOL : 1;			// őՓˉ񐔂zՓ˂iTABvj
	unsigned int LCOL : 1;			// CgERWoiTABvj
	unsigned int TGNT : 1;			// LMAXz钷̃pPbg𑗐MiTABvj
	unsigned int : 8;
	unsigned int TAB : 1;			// MA{[g
	unsigned int : 15;
};

//------------------------------------------------------------------------------
// MXe[^X荞݃WX^ R 00000000H
//------------------------------------------------------------------------------
struct TEtherRXSTATUSReg
{
	unsigned int DVCF : 1;			// MpPbgL
	unsigned int TXRX : 1;			// dM̃RW
	unsigned int PAIG : 1;			// 
	unsigned int REPS : 1;			// 
	unsigned int CEPS : 1;			// False Carriero
	unsigned int RXER : 1;			// RXERo
	unsigned int RCRCE : 1;		// MCRCG[
	unsigned int RLER : 1;			// OXEtB[hCf[^EtB[hƕsv
	unsigned int RLOR : 1;			// OXEtB[hC1500zpPbg̎M
	unsigned int DBNB : 1;			// huEju܂ރpPbg̎M
	unsigned int RCFR : 1;			// Rg[EpPbgM
	unsigned int RPCF : 1;			// |[YERg[EpPbgM
	unsigned int USOP : 1;			// `IyR[hERg[EpPbgM
	unsigned int VLAN : 1;			// VLANpPbgM
	unsigned int RLENE : 1;		// MpPbgEOXEG[
	unsigned int : 17;
};

//------------------------------------------------------------------------------
// 荞ݐ䃌WX^ R/W 07000700H
//------------------------------------------------------------------------------
struct TEtherINTMSReg
{
	unsigned int TXI : 1;				// pPbgMiDMAj̊荞
	unsigned int TECI : 1;				// MiDMAjGhEIuE`FC荞݂łB[hENA܂B
	unsigned int TBEI : 1;				// Mf[^Eobt@EANZXEG[荞
	unsigned int : 5;
	unsigned int TXMSK : 1;			// rbg0TXI荞݃}XN
	unsigned int TECMSK : 1;			// rbg1TECI荞݃}XN
	unsigned int TBEMSK : 1;			// rbg2TBEI荞݃}XN
	unsigned int : 5;
	unsigned int RXI : 1;				// pPbgMiDMAj̊荞
	unsigned int RECI : 1;				// MiDMAjGhEIuE`FC荞
	unsigned int RBEI : 1;				// Mf[^Eobt@EANZXEG[荞
	unsigned int : 5;
	unsigned int RXMSK : 1;			// rbg16RXI荞݃}XN
	unsigned int RECMSK : 1;			// rbg17RECI荞݃}XN
	unsigned int RBEMSK : 1;			// rbg18RBEI荞݃}XN
	unsigned int : 5;
};

//------------------------------------------------------------------------------
// ]䃌WX^ R/W 00030000H
//------------------------------------------------------------------------------
struct TEtherTRANSCTLReg
{
	unsigned int RXCHKSMEN : 1;		// M`FbNTt@\̃I^It
	unsigned int : 15;
	unsigned int TXEN : 1;				// MCl[uݒrbg
	unsigned int RXEN : 1;				// MCl[uݒrbg
	unsigned int : 6;
	unsigned int TXEN_STA : 1;			// MXe[^XErbg
	unsigned int RXEN_STA : 1;			// MXe[^XErbg
	unsigned int : 6;
};

//------------------------------------------------------------------------------
// obt@EfBXNv^
//------------------------------------------------------------------------------
struct TEtherDescriper{
	unsigned short Size;			// obt@Ef[^̃TCYioCgPʁj
	unsigned short Status : 10;	// MStatus 
	unsigned short O : 1;			// M̃I[ot[
	unsigned short S : 1;			// MXe[^XL
	unsigned short D : 1;			// f[^Eobt@̃ANZXEG[
	unsigned short U : 1;			// [YhErbg
	unsigned short E : 1;			// XgEobt@EtO
	unsigned short T : 1;			// fBXNv^E^Cv
	void *Pointer;					// f[^Eobt@̃X^[gEAhX
};

//------------------------------------------------------------------------------
// obt@EfBXNv^MXe[^X
//------------------------------------------------------------------------------
struct TEtherDescriperStatus{
	unsigned short CEPS : 1;
	unsigned short RCV : 1;
	unsigned short RCRCE : 1;
	unsigned short RLOR : 1;
	unsigned short DBNB : 1;
	unsigned short RXOK : 1;
	unsigned short FTYP : 3;			// 000FRBRO
										// 001FRMUL
										// 010FUSOP
										// 011FVLAN
										// 100FRPCF
										// 101FRCFR
										// 110FgNormalh
										// 111FgReservedh
};

//------------------------------------------------------------------------------
// EthernetWX^
//------------------------------------------------------------------------------
struct TEtherReg
{
	FIELD_0(0x002E0000, 0x002E0003, unsigned int, MACC1)	// MACݒ背WX^1 R/W 00000000H
	FIELD_0(0x002E0004, 0x002E0007, unsigned int, MACC2)	// MACݒ背WX^2 R/W 00000000H
	FIELD_0(0x002E0008, 0x002E000B, unsigned int, IPGT)	// Back-to-Back IPGWX^ R/W 00000013H
	FIELD_0(0x002E000C, 0x002E000F, unsigned int, IPGR)	// NON Back-to-Back IPGWX^ R/W 00000E13H
	FIELD_0(0x002E0010, 0x002E0013, unsigned int, CLRT)	// RWEWX^ R/W 0000380FH
	FIELD_S(0x002E0014, 0x002E0053, struct TEtherLMAXReg, LMAX)	// őpPbgWX^ R/W 00000600H
	FIELD_0(0x002E0054, 0x002E0057, unsigned int, LSA1)	// Xe[VEAhXEWX^1 R/W 00000000H
	FIELD_0(0x002E0058, 0x002E005B, unsigned int, LSA2)	// Xe[VEAhXEWX^2 R/W 00000000H
	FIELD_S(0x002E005C, 0x002E0063, unsigned int, PTVR)	// |[YE^C}l[hEWX^ R 00000000H
	FIELD_S(0x002E0064, 0x002E007F, unsigned int, VLTP)	// VLAN^CvEWX^ R/W 00000000H
	FIELD_S(0x002E0080, 0x002E0093, struct TEtherMIICReg, MIIC)	// MIIRtBM|VEWX^ R/W 00000000H
	FIELD_0(0x002E0094, 0x002E0097, unsigned int, MCMD)	// MIIR}hEWX^ W 00000000H
	FIELD_0(0x002E0098, 0x002E009B, struct TEtherMADRReg, MADR)	// MIIAhXEWX^ R/W 00000000H
	FIELD_0(0x002E009C, 0x002E009F, struct TEtherMWTDReg, MWTD)	// MIICgEf[^EWX^ R/W 00000000H
	FIELD_0(0x002E00A0, 0x002E00A3, struct TEtherMRDDReg, MRDD)	// MII[hEf[^EWX^ R/W 00000000H
	FIELD_S(0x002E00A4, 0x002E00C7, struct TEtherMINDReg, MIND)	// MIICWP[^EWX^ R 00000000H
	FIELD_0(0x002E00C8, 0x002E00CB, struct TEtherAFRReg, AFR)	// AhXEtB^EWX^ R/W 00000000H
	FIELD_0(0x002E00CC, 0x002E00CF, unsigned int, HT1)	// HASHe[uEWX^1 R/W 00000000H
	FIELD_S(0x002E00D0, 0x002E00DB, unsigned int, HT2)	// HASHe[uEWX^2 R/W 00000000H
	FIELD_0(0x002E00DC, 0x002E00DF, unsigned int, CAR1)	// L[EWX^1 R/W 00000000H
	FIELD_S(0x002E00E0, 0x002E012F, unsigned int, CAR2)	// L[EWX^2 R/W 00000000H
	FIELD_0(0x002E0130, 0x002E0133, unsigned int, CAM1)	// L[E}XNEWX^1 R/W 00000000H
	FIELD_S(0x002E0134, 0x002E013F, unsigned int, CAM2)	// L[E}XNEWX^2 R/W 00000000H
	FIELD_0(0x002E0140, 0x002E0143, unsigned int, RBYT)	// MoCgEJE^ R/W 00000000H
	FIELD_0(0x002E0144, 0x002E0147, unsigned int, RPKT)	// MpPbgEJE^ R/W 00000000H
	FIELD_0(0x002E0148, 0x002E014B, unsigned int, RFCS)	// MFCSG[Et[EJE^ R/W 00000000H
	FIELD_0(0x002E014C, 0x002E014F, unsigned int, RMCA)	// M}`LXgEpPbgEJE^ R/W 00000000H
	FIELD_0(0x002E0150, 0x002E0153, unsigned int, RBCA)	// Mu[hLXgEpPbgEJE^ R/W 00000000H
	FIELD_0(0x002E0154, 0x002E0157, unsigned int, RXCF)	// MRg[Et[EpPbgEJE^ R/W 00000000H
	FIELD_0(0x002E0158, 0x002E015B, unsigned int, RXPF)	// M|[YEt[EpPbgEJE^ R/W 00000000H
	FIELD_0(0x002E015C, 0x002E015F, unsigned int, RXUO)	// M`Rg[EpPbgEJE^ R/W 00000000H
	FIELD_0(0x002E0160, 0x002E0163, unsigned int, RALN)	// MACgEG[EJE^ R/W 00000000H
	FIELD_0(0x002E0164, 0x002E0167, unsigned int, RFLR)	// Mt[G[EJE^ R/W 00000000H
	FIELD_0(0x002E0168, 0x002E016B, unsigned int, RCDE)	// MR[hEG[EJE^ R/W 00000000H
	FIELD_0(0x002E016C, 0x002E016F, unsigned int, RFCR)	// MFalse Carrier JE^ R/W 00000000H
	FIELD_0(0x002E0170, 0x002E0173, unsigned int, RUND)	// MA_TCYEpPbgEJE^ R/W 00000000H
	FIELD_0(0x002E0174, 0x002E0177, unsigned int, ROVR)	// MI[oTCYEpPbgEJE^ R/W 00000000H
	FIELD_0(0x002E0178, 0x002E017B, unsigned int, RFRG)	// MtOgEJE^ R/W 00000000H
	FIELD_0(0x002E017C, 0x002E017F, unsigned int, RJBR)	// MWo[EJE^ R/W 00000000H
	FIELD_0(0x002E0180, 0x002E0183, unsigned int, R64)	// M64oCgEt[EJE^ R/W 00000000H
	FIELD_0(0x002E0184, 0x002E0187, unsigned int, R127)	// M65-127oCgEt[EJE^ R/W 00000000H
	FIELD_0(0x002E0188, 0x002E018B, unsigned int, R255)	// M128-255oCgEt[EJE^ R/W 00000000H
	FIELD_0(0x002E018C, 0x002E018F, unsigned int, R511)	// M256-511oCgEt[EJE^ R/W 00000000H
	FIELD_0(0x002E0190, 0x002E0193, unsigned int, R1K)	// M512-1023oCgEt[EJE^ R/W 00000000H
	FIELD_0(0x002E0194, 0x002E0197, unsigned int, RMAX)	// M1024-RMAXoCgEt[EJE^ R/W 00000000H
	FIELD_S(0x002E0198, 0x002E01BF, unsigned int, RVBT)	// MLoCgEJE^ R/W 00000000H
	FIELD_0(0x002E01C0, 0x002E01C3, unsigned int, TBYT)	// MoCgEJE^ R/W 00000000H
	FIELD_0(0x002E01C4, 0x002E01C7, unsigned int, TPKT)	// MpPbgEJE^ R/W 00000000H
	FIELD_0(0x002E01C8, 0x002E01CB, unsigned int, TFCS)	// MFCSG[Et[EJE^ R/W 00000000H
	FIELD_0(0x002E01CC, 0x002E01CF, unsigned int, TMCA)	// M}`LXgEpPbgEJE^ R/W 00000000H
	FIELD_0(0x002E01D0, 0x002E01D3, unsigned int, TBCA)	// Mu[hLXgEpPbgEJE^ R/W 00000000H
	FIELD_0(0x002E01D4, 0x002E01D7, unsigned int, TUCA)	// MjLXgEpPbgEJE^ R/W 00000000H
	FIELD_0(0x002E01D8, 0x002E01DB, unsigned int, TXPF)	// M|[YERg[Et[EJE^ R/W 00000000H
	FIELD_0(0x002E01DC, 0x002E01DF, unsigned int, TDFR)	// MxpPbgEJE^ R/W 00000000H
	FIELD_0(0x002E01E0, 0x002E01E3, unsigned int, TXDF)	// MߏxpPbgEJE^ R/W 00000000H
	FIELD_0(0x002E01E4, 0x002E01E7, unsigned int, TSCL)	// MVOERWEpPbgEJE^ R/W 00000000H
	FIELD_0(0x002E01E8, 0x002E01EB, unsigned int, TMCL)	// M}`vERWEpPbgEJE^ R/W 00000000H
	FIELD_0(0x002E01EC, 0x002E01EF, unsigned int, TLCL)	// MCgERWEpPbgEJE^ R/W 00000000H
	FIELD_0(0x002E01F0, 0x002E01F3, unsigned int, TXCL)	// MߏRWEpPbgEJE^ R/W 00000000H
	FIELD_0(0x002E01F4, 0x002E01F7, unsigned int, TNCL)	// Mg[^ERWEJE^ R/W 00000000H
	FIELD_0(0x002E01F8, 0x002E01FB, unsigned int, TCSE)	// MLAEZXEG[EJE^ R/W 00000000H
	FIELD_0(0x002E01FC, 0x002E01FF, unsigned int, TIME)	// MACG[EJE^ R/W 00000000H
	FIELD_0(0x002E0200, 0x002E0203, unsigned int, MFFCONT)	// FIFORg[ERg[EWX^ R/W 00000000H
	FIELD_S(0x002E0204, 0x002E0217, struct TEtherRSTCNTReg, RSTCNT)	// \tgEZbg䃌WX^ R/W 00000000H
	FIELD_0(0x002E0218, 0x002E021B, unsigned int, FLOWTHRESH)	// t[臒lWX^ R/W 06000200H
	FIELD_0(0x002E021C, 0x002E021F, unsigned int, PAUSETM)	// |[YE^C}lWX^ R/W 7FFFFFFFH
	FIELD_S(0x002E0220, 0x002E022F, unsigned int, RXERSEL)	// MG[IWX^ R/W 00000001H
	FIELD_0(0x002E0230, 0x002E0233, unsigned int, TXSTMONI1)	// MXe[^XEj^1WX^ R 00000000H
	FIELD_0(0x002E0234, 0x002E0237, unsigned int, TXSTMONI2)	// MXe[^XEj^2WX^ R 00000000H
	FIELD_0(0x002E0238, 0x002E023B, unsigned int, TXFINF1)	// MXe[^X1WX^ R 00000800H
	FIELD_0(0x002E023C, 0x002E023F, unsigned int, TXFINF2)	// MXe[^X2WX^ R 00000001H
	FIELD_0(0x002E0240, 0x002E0243, unsigned int, RXSTMONI)	// MXe[^XEj^EWX^ R 00000000H
	FIELD_0(0x002E0244, 0x002E0247, unsigned int, RXFINF1)	// MXe[^X1WX^ R 00000000H
	FIELD_0(0x002E0248, 0x002E024B, unsigned int, RXFINF2)	// MXe[^X2WX^ R 00000800H
	FIELD_0(0x002E024C, 0x002E024F, unsigned int, RXFINF3)	// MXe[^X3WX^ R 00000001H
	FIELD_0(0x002E0250, 0x002E0253, unsigned int, FSTATUS)	// FIFOXe[^X荞݃WX^ R 00000000H
	FIELD_0(0x002E0254, 0x002E0257, unsigned int, FSTATUS_MASK)	// FIFOXe[^X荞݃}XNEWX^ R/W 01011FFFH
	FIELD_0(0x002E0258, 0x002E025B, struct TEtherTXSTATUSReg, TXSTATUS)	// MXe[^X荞݃WX^ R 00000000H
	FIELD_0(0x002E025C, 0x002E025F, unsigned int, TXSTATUS_MASK)	// Me[^X荞݃}XNEWX^ R/W 000101FFH
	FIELD_0(0x002E0260, 0x002E0263, struct TEtherRXSTATUSReg, RXSTATUS)	// MXe[^X荞݃WX^ R 00000000H
	FIELD_S(0x002E0264, 0x002E026F, unsigned int, RXSTATUS_MASK)	// MXe[^X荞݃}XNEWX^ R/W 00007FFFH
	FIELD_0(0x002E0270, 0x002E0273, unsigned int, TXABTCNT)	// MA{[gEJE^ R/W 00000000H
	FIELD_S(0x002E0274, 0x002E02FF, unsigned int, RXABTCNT)	// MA{[gEJE^ R/W 00000000H
	FIELD_0(0x002E0300, 0x002E0303, struct TEtherETHMODEReg, ETHMODE)	// RAEt@NV䃌WX^ R/W 00000000H
	FIELD_0(0x002E0304, 0x002E0307, struct TEtherINTMSReg, INTMS)	// 荞ݐ䃌WX^ R/W 07000700H
	FIELD_0(0x002E0308, 0x002E030B, struct TEtherTRANSCTLReg, TRANSCTL)	// ]䃌WX^ R/W 00030000H
	FIELD_0(0x002E030C, 0x002E030F, struct TEtherSFTRSTReg, SFTRST)	// \tgEGAEZbg䃌WX^ R/W 00000000H
	FIELD_S(0x002E0310, 0x002E031F, unsigned int, DMACM)	// DMAC[h䃌WX^ R/W 00000010H
	FIELD_0(0x002E0320, 0x002E0323, struct TEtherDescriper *, RXDP)	// MfBXNv^E|C^EWX^ R/W FFFFFFFCH
	FIELD_0(0x002E0324, 0x002E0327, struct TEtherDescriper *, LSTRXDP)	// ŏIMfBXNv^E|C^EWX^ R FFFFFFFCH
	FIELD_0(0x002E0328, 0x002E032B, struct TEtherDescriper *, TXDP)	// MfBXNv^E|C^EWX^ R/W FFFFFFFCH
	FIELD_0(0x002E032C, 0x002E032F, struct TEtherDescriper *, LSTTXDP)	// ŏIMfBXNv^E|C^EWX^ R FFFFFFFCH
};

//------------------------------------------------------------------------------
// USBWX^
//------------------------------------------------------------------------------
struct TUsbReg
{
	FIELD_S(0x00200000, 0x00200001, unsigned char, UF0E0N)	// UF0_EP0NAKWX^
	FIELD_S(0x00200002, 0x00200003, unsigned char, UF0E0NA)	// UF0_EP0NAKALLWX^
	FIELD_S(0x00200004, 0x00200005, unsigned char, UF0EN)	// UF0_EPNAKWX^
	FIELD_S(0x00200006, 0x00200007, unsigned char, UF0ENM)	// UF0_EPNAK}XNEWX^
	FIELD_S(0x00200008, 0x00200009, unsigned char, UF0SDS)	// UF0_SNDSIEWX^
	FIELD_S(0x0020000A, 0x0020000B, unsigned char, UF0CLR)	// UF0_CLRNGXgEWX^
	FIELD_S(0x0020000C, 0x0020000D, unsigned char, UF0SET)	// UF0_SETNGXgEWX^
	FIELD_S(0x0020000E, 0x0020000F, unsigned char, UF0EPS0)	// UF0_EPXe[^X0WX^
	FIELD_S(0x00200010, 0x00200011, unsigned char, UF0EPS1)	// UF0_EPXe[^X1WX^
	FIELD_S(0x00200012, 0x0020001F, unsigned char, UF0EPS2)	// UF0_EPXe[^X2WX^
	FIELD_S(0x00200020, 0x00200021, unsigned char, UF0IS0)	// UF0_INTXe[^X0WX^
	FIELD_S(0x00200022, 0x00200023, unsigned char, UF0IS1)	// UF0_INTXe[^X1WX^
	FIELD_S(0x00200024, 0x00200025, unsigned char, UF0IS2)	// UF0_INTXe[^X2WX^
	FIELD_S(0x00200026, 0x00200027, unsigned char, UF0IS3)	// UF0_INTXe[^X3WX^
	FIELD_S(0x00200028, 0x0020002D, unsigned char, UF0IS4)	// UF0_INTXe[^X4WX^
	FIELD_S(0x0020002E, 0x0020002F, unsigned char, UF0IM0)	// UF0_INT}XN0WX^
	FIELD_S(0x00200030, 0x00200031, unsigned char, UF0IM1)	// UF0_INT}XN1WX^
	FIELD_S(0x00200032, 0x00200033, unsigned char, UF0IM2)	// UF0_INT}XN2WX^
	FIELD_S(0x00200034, 0x00200035, unsigned char, UF0IM3)	// UF0_INT}XN3WX^
	FIELD_S(0x00200036, 0x0020003B, unsigned char, UF0IM4)	// UF0_INT}XN4WX^
	FIELD_S(0x0020003C, 0x0020003D, unsigned char, UF0IC0)	// UF0_INTNA0WX^
	FIELD_S(0x0020003E, 0x0020003F, unsigned char, UF0IC1)	// UF0_INTNA1WX^
	FIELD_S(0x00200040, 0x00200041, unsigned char, UF0IC2)	// UF0_INTNA2WX^
	FIELD_S(0x00200042, 0x00200043, unsigned char, UF0IC3)	// UF0_INTNA3WX^
	FIELD_S(0x00200044, 0x0020004B, unsigned char, UF0IC4)	// UF0_INTNA4WX^
	FIELD_S(0x0020004C, 0x0020004D, unsigned char, UF0IDR)	// UF0_INTDMARQWX^
	FIELD_S(0x0020004E, 0x0020004F, unsigned char, UF0DMS0)	// UF0_DMAXe[^X0WX^
	FIELD_S(0x00200050, 0x0020005F, unsigned char, UF0DMS1)	// UF0_DMAXe[^X1WX^
	FIELD_S(0x00200060, 0x00200061, unsigned char, UF0FIC0)	// UF0_FIFONA0WX^
	FIELD_S(0x00200062, 0x00200069, unsigned char, UF0FIC1)	// UF0_FIFONA1WX^
	FIELD_S(0x0020006A, 0x0020006D, unsigned char, UF0DEND)	// UF0f[^EGhEWX^
	FIELD_S(0x0020006E, 0x00200073, unsigned char, UF0GPR)	// UF0_GPRWX^
	FIELD_S(0x00200074, 0x00200077, unsigned char, UF0MODC)	// UF0[hERg[EWX^
	FIELD_S(0x00200078, 0x0020007F, unsigned char, UF0MODS)	// UF0[hEXe[^XEWX^
	FIELD_S(0x00200080, 0x00200081, unsigned char, UF0AIFN)	// UF0ANeBuEC^tF[XEio[EWX^
	FIELD_S(0x00200082, 0x00200083, unsigned char, UF0AAS)	// UF0ANeBuEI^ieBuEZbeBOEWX^
	FIELD_S(0x00200084, 0x00200085, unsigned char, UF0ASS)	// UF0I^ieBuEZbeBOEXe[^XEWX^
	FIELD_S(0x00200086, 0x00200087, unsigned char, UF0E1IM)	// UF0Gh|Cg1C^tF[XE}bsOEWX^
	FIELD_S(0x00200088, 0x00200089, unsigned char, UF0E2IM)	// UF0Gh|Cg2C^tF[XE}bsOEWX^
	FIELD_S(0x0020008A, 0x0020008B, unsigned char, UF0E3IM)	// UF0Gh|Cg3C^tF[XE}bsOEWX^
	FIELD_S(0x0020008C, 0x00200091, unsigned char, UF0E4IM)	// UF0Gh|Cg4C^tF[XE}bsOEWX^
	FIELD_S(0x00200092, 0x002000FF, unsigned char, UF0E7IM)	// UF0Gh|Cg7C^tF[XE}bsOEWX^
	FIELD_S(0x00200100, 0x00200101, unsigned char, UF0E0RR)	// UF0_EP0[hEWX^
	FIELD_S(0x00200102, 0x00200103, unsigned char, UF0E0L)	// UF0_EP0OXEWX^
	FIELD_S(0x00200104, 0x00200105, unsigned char, UF0E0ST)	// UF0_EP0ZbgAbvEWX^
	FIELD_S(0x00200106, 0x00200107, unsigned char, UF0E0W)	// UF0_EP0CgEWX^
	FIELD_S(0x00200108, 0x00200109, unsigned char, UF0BO1)	// UF0oNEAEg1WX^
	FIELD_S(0x0020010A, 0x0020010B, unsigned char, UF0BO1L)	// UF0oNEAEg1OXEWX^
	FIELD_S(0x0020010C, 0x0020010D, unsigned char, UF0BO2)	// UF0oNEAEg2WX^
	FIELD_S(0x0020010E, 0x0020010F, unsigned char, UF0BO2L)	// UF0oNEAEg2OXEWX^
	FIELD_S(0x00200110, 0x00200111, unsigned char, UF0BI1)	// UF0oNEC1WX^
	FIELD_S(0x00200112, 0x00200113, unsigned char, UF0BI2)	// UF0oNEC2WX^
	FIELD_S(0x00200114, 0x00200143, unsigned char, UF0INT1)	// UF0C^vg1WX^
	FIELD_S(0x00200144, 0x0020014B, unsigned char, UF0DSTL)	// UF0foCXEXe[^XEWX^L
	FIELD_S(0x0020014C, 0x0020014F, unsigned char, UF0E0SL)	// UF0_EP0Xe[^XEWX^L
	FIELD_S(0x00200150, 0x00200153, unsigned char, UF0E1SL)	// UF0_EP1Xe[^XEWX^L
	FIELD_S(0x00200154, 0x00200157, unsigned char, UF0E2SL)	// UF0_EP2Xe[^XEWX^L
	FIELD_S(0x00200158, 0x0020015B, unsigned char, UF0E3SL)	// UF0_EP3Xe[^XEWX^L
	FIELD_S(0x0020015C, 0x00200167, unsigned char, UF0E4SL)	// UF0_EP4Xe[^XEWX^L
	FIELD_S(0x00200168, 0x0020017F, unsigned char, UF0E7SL)	// UF0_EP7Xe[^XEWX^L
	FIELD_S(0x00200180, 0x00200181, unsigned char, UF0ADRS)	// UF0AhXEWX^
	FIELD_S(0x00200182, 0x00200183, unsigned char, UF0CNF)	// UF0RtBM[VEWX^
	FIELD_S(0x00200184, 0x00200185, unsigned char, UF0IF0)	// UF0C^tF[X0WX^
	FIELD_S(0x00200186, 0x00200187, unsigned char, UF0IF1)	// UF0C^tF[X1WX^
	FIELD_S(0x00200188, 0x00200189, unsigned char, UF0IF2)	// UF0C^tF[X2WX^
	FIELD_S(0x0020018A, 0x0020018B, unsigned char, UF0IF3)	// UF0C^tF[X3WX^
	FIELD_S(0x0020018C, 0x0020019F, unsigned char, UF0IF4)	// UF0C^tF[X4WX^
	FIELD_S(0x002001A0, 0x002001A1, unsigned char, UF0DSCL)	// UF0fBXNv^EOXEWX^
	ARRAY_0(0x002001A2, 0x002001C5, unsigned short, UF0DD, 18)	// UF0foCXEfBXNv^EWX^0-17
	ARRAY_0(0x002001C6, 0x002003C5, unsigned short, UF0CIE, 256)	// UF0RtBM[V^C^tF[X^Gh|CgEfBXNv^EWX^0-255
};

#define PIC_NO_INTLVI		0		// do POCLVI 00000080H LVIIC
#define PIC_NO_INTP00		1		// O荞ݒ[q GbWoiINTP00j[q 00000090H PIC00
#define PIC_NO_INTP01		2		// O荞ݒ[q GbWoiINTP01j[q 000000A0H PIC01
#define PIC_NO_INTP02		3		// O荞ݒ[q GbWoiINTP02j[q 000000B0H PIC02
#define PIC_NO_INTP03		4		// O荞ݒ[q GbWoiINTP03j[q 000000C0H PIC03
#define PIC_NO_INTP04		5		// O荞ݒ[q GbWoiINTP04j[q 000000D0H PIC04
#define PIC_NO_INTP05		6		// O荞ݒ[q GbWoiINTP05j[q 000000E0H PIC05
#define PIC_NO_INTP06		7		// O荞ݒ[q GbWoiINTP06j[q 000000F0H PIC06
#define PIC_NO_INTP07		8		// O荞ݒ[q GbWoiINTP07j[q 00000100H PIC07
#define PIC_NO_INTP08		9		// O荞ݒ[q GbWoiINTP08j[q 00000110H PIC08
#define PIC_NO_INTP09		10		// O荞ݒ[q GbWoiINTP09j[q 00000120H PIC09
#define PIC_NO_INTP10		11		// O荞ݒ[q GbWoiINTP10j[q 00000130H PIC10
#define PIC_NO_INTP11		12		// O荞ݒ[q GbWoiINTP11j[q 00000140H PIC11
#define PIC_NO_INTP12		13		// O荞ݒ[q GbWoiINTP12j[q 00000150H PIC12
#define PIC_NO_INTP13		14		// O荞ݒ[q GbWoiINTP16j[q 00000160H PIC13
#define PIC_NO_INTP14		15		// O荞ݒ[q GbWoiINTP14j[q 00000170H PIC14
#define PIC_NO_INTP15		16		// O荞ݒ[q GbWoiINTP15j[q 00000180H PIC15
#define PIC_NO_INTP16		17		// O荞ݒ[q GbWoiINTP16j[q 00000190H PIC16
#define PIC_NO_INTP17		18		// O荞ݒ[q GbWoiINTP17j[q 000001A0H PIC17
#define PIC_NO_INTP18		19		// O荞ݒ[q GbWoiINTP18j[q 000001B0H PIC18
#define PIC_NO_INTP19		20		// O荞ݒ[q GbWoiINTP19j[q 000001C0H PIC19
#define PIC_NO_INTP20		21		// O荞ݒ[q GbWoiINTP20j[q 000001D0H PIC20
#define PIC_NO_INTP21		22		// O荞ݒ[q GbWoiINTP21j[q 000001E0H PIC21
#define PIC_NO_INTP22		23		// O荞ݒ[q GbWoiINTP22j[q 000001F0H PIC22
#define PIC_NO_INTP23		24		// O荞ݒ[q GbWoiINTP23j[q 00000200H PIC23
#define PIC_NO_INTP24		25		// O荞ݒ[q GbWoiINTP24j[q 00000210H PIC24
#define PIC_NO_INTP25		26		// O荞ݒ[q GbWoiINTP25j[q 00000220H PIC25
#define PIC_NO_INTTAB0OV	27		// TAB0I[ot[ TAB0 00000230H TAB0OVIC
#define PIC_NO_INTTAB0CC0	28		// TAB0Lv`0^RyA0v TAB0 00000240H TAB0CCIC0
#define PIC_NO_INTTAB0CC1	29		// TAB0Lv`1^RyA1v TAB0 00000250H TAB0CCIC1
#define PIC_NO_INTTAB0CC2	30		// TAB0Lv`2^RyA2v TAB0 00000260H TAB0CCIC2
#define PIC_NO_INTTAB0CC3	31		// TAB0Lv`3^RyA3v TAB0 00000270H TAB0CCIC3
#define PIC_NO_INTTAB1OV	32		// TAB1I[ot[ TAB1 00000280H TAB1OVIC
#define PIC_NO_INTTAB1CC0	33		// TAB1Lv`0^RyA0v TAB1 00000290H TAB1CCIC0
#define PIC_NO_INTTAB1CC1	34		// TAB1Lv`1^RyA1v TAB1 000002A0H TAB1CCIC1
#define PIC_NO_INTTAB1CC2	35		// TAB1Lv`2^RyA2v TAB1 000002B0H TAB1CCIC2
#define PIC_NO_INTTAB1CC3	36		// TAB1Lv`3^RyA3v TAB1 000002C0H TAB1CCIC3
#define PIC_NO_INTTT0OV		37		// TMT0I[ot[ TMT0 000002D0H TT0OVIC
#define PIC_NO_INTTT0CC0	38		// TMT0Lv`0^RyA0v TMT0 000002E0H TT0CCIC0
#define PIC_NO_INTTT0CC1	39		// TMT0Lv`1^RyA1v TMT0 000002F0H TT0CCIC1
#define PIC_NO_INTTT0EC		40		// TMT0GR[_ TMT0 00000300H TT0ECIC
#define PIC_NO_INTTAA0OV	41		// TAA0I[ot[ TAA0 00000310H TAA0OVIC
#define PIC_NO_INTTAA0CC0	42		// TAA0Lv`0^RyA0v TAA0 00000320H TAA0CCIC0
#define PIC_NO_INTTAA0CC1	43		// TAA0Lv`1^RyA1v TAA0 00000330H TAA0CCIC1
#define PIC_NO_INTTAA1OV	44		// TAA1I[ot[ TAA1 00000340H TAA1OVIC
#define PIC_NO_INTTAA1CC0	45		// TAA1Lv`0^RyA0v TAA1 00000350H TAA1CCIC0
#define PIC_NO_INTTAA1CC1	46		// TAA1Lv`1^RyA1v TAA1 00000360H TAA1CCIC1
#define PIC_NO_INTTAA2OV	47		// TAA2I[ot[ TAA2 00000370H TAA2OVIC
#define PIC_NO_INTTAA2CC0	48		// TAA2Lv`0^RyA0v TAA2 00000380H TAA2CCIC0
#define PIC_NO_INTTAA2CC1	49		// TAA2Lv`1^RyA1v TAA2 00000390H TAA2CCIC1
#define PIC_NO_INTTAA3OV	50		// TAA3I[ot[ TAA3 000003A0H TAA3OVIC
#define PIC_NO_INTTAA3CC0	51		// TAA3Lv`0^RyA0v TAA3 000003B0H TAA3CCIC0
#define PIC_NO_INTTAA3CC1	52		// TAA3Lv`1^RyA1v TAA3 000003C0H TAA3CCIC1
#define PIC_NO_INTTAA4OV	53		// TAA4I[ot[ TAA4 000003D0H TAA4OVIC
#define PIC_NO_INTTAA4CC0	54		// TAA4Lv`0^RyA0v TAA4 000003E0H TAA4CCIC0
#define PIC_NO_INTTAA4CC1	55		// TAA4Lv`1^RyA1v TAA4 000003F0H TAA4CCIC1
#define PIC_NO_INTTAA5OV	56		// TAA5I[ot[ TAA5 00000400H TAA5OVIC
#define PIC_NO_INTTAA5CC0	57		// TAA5Lv`0^RyA0v TAA5 00000410H TAA5CCIC0
#define PIC_NO_INTTAA5CC1	58		// TAA5Lv`1^RyA1v TAA5 00000420H TAA5CCIC1
#define PIC_NO_INTTM0EQ0	59		// TMM0RyAv TMM0 00000430H TM0EQIC0
#define PIC_NO_INTTM1EQ0	60		// TMM1RyAv TMM1 00000440H TM1EQIC0
#define PIC_NO_INTTM2EQ0	61		// TMM2RyAv TMM2 00000450H TM2EQIC0
#define PIC_NO_INTTM3EQ0	62		// TMM3RyAv TMM3 00000460H TM3EQIC0
#define PIC_NO_INTCE0T		63		// CSIE0̓]I CSIE0 00000470H CE0TIC
#define PIC_NO_INTUC4R		63		// UARTC4̎MG[ UARTC4 00000470H UC4RIC
#define PIC_NO_INTCE0TIOF	64		// CSIE0̃obt@EI[ot[ CSIE0 00000480H CE0TIOFIC
#define PIC_NO_INTUC4T		64		// UARTC4̘AM݋ UARTC4 00000480H UC4TIC
#define PIC_NO_INTCE1T		65		// CSIE1̓]I CSIE1 00000490H CE1TIC
#define PIC_NO_INTUC5R		65		// UARTC5̎MG[ UARTC5 00000490H UC5RIC
#define PIC_NO_INTIIC3		65		// IIC2]I IIC3 00000490H IICIC3
#define PIC_NO_INTCE1TIOF	66		// CSIE1̃obt@EI[ot[ CSIE1 000004A0H CE1TIOFIC
#define PIC_NO_INTUC5T		66		// UARTC5̘AM݋ UARTC5 000004A0H UC5TIC
#define PIC_NO_INTCF0R		67		// CSIF0̓]I CSIF0 000004B0H CE0RIC
#define PIC_NO_INTUC3R		67		// UARTC3̎MI^UARTC3̎MG[ UARTC3 000004B0H UC3RIC
#define PIC_NO_INTIIC1		67		// IIC1]I IIC1 000004B0H IICIC1
#define PIC_NO_INTCF0T		68		// CSIF0AM݋ CSIF0 000004C0H CF0TIC
#define PIC_NO_INTUC3T		68		// UARTC3AM݋ UARTC3 000004C0H UC3TIC
#define PIC_NO_INTCF1R		69		// CSIF1MI^CSIF1MG[ CSIF1 000004D0H CF1RIC
#define PIC_NO_INTUC1R		69		// UARTC1MI^UARTC1MG[ UARTC1 000004D0H UC1RIC
#define PIC_NO_INTIIC0		69		// IIC0]I IIC0 000004D0H IICIC0
#define PIC_NO_INTCF1T		70		// CSIF1AM݋ CSIF1 000004E0H CF1TIC
#define PIC_NO_INTUC1T		70		// UARTC1AM݋ UARTC1 000004E0H UC1TIC
#define PIC_NO_INTCF2R		71		// CSIF2MI^CSIF2MG[ CSIF2 000004F0H CF2RIC
#define PIC_NO_INTUC0R		71		// UARTC0MI^UARTC0MG[ UARTC0 000004F0H UC0RIC
#define PIC_NO_INTCF2T		72		// CSIF2AM݋ CSIF2 00000500H CF2TIC
#define PIC_NO_INTUC0T		72		// UARTC0AM݋ UARTC0 00000500H UC0TIC
#define PIC_NO_INTCF3R		73		// CSIF3MI^CSIF3MG[ CSIF3 00000510H CF3RIC
#define PIC_NO_INTUB1TIR	73		// UARTB1MI UARTB1 00000510H UB1TIRIC
#define PIC_NO_INTCF3T		74		// CSIF3AM݋ CSIF3 00000520H CF3TIC
#define PIC_NO_INTUB1TIT	74		// UARTB1MI UARTB1 00000520H UB1TITIC
#define PIC_NO_INTUB1TIF	75		// UARTB1 FIFOMI UARTB1 00000530H UB1TIFIC
#define PIC_NO_INTUB1TIRE	76		// UARTB1MG[ UARTB1 00000540H UB1TIREIC
#define PIC_NO_INTUB1TITO	77		// UARTB1M^CAEg UARTB1 00000550H UB1TITOIC
#define PIC_NO_INTCF4R		78		// CSIF4MI^CSIF4MG[ CSIF4 00000560H CF4RIC
#define PIC_NO_INTUB0TIR	78		// UARTB0MI UARTB0 00000560H UB0TIRIC
#define PIC_NO_INTCF4T		79		// CSIF4AM݋ CSIF4 00000570H CF4TIC
#define PIC_NO_INTUB0TIT	79		// UARTB0MI UARTB0 00000570H UB0TITIC
#define PIC_NO_INTUB0TIF	80		// UARTB0 FIFOMI UARTB0 00000580H UB0TIFIC
#define PIC_NO_INTUB0TIRE	81		// UARTB0MG[ UARTB0 00000590H UB0TIREIC
#define PIC_NO_INTUB0TITO	82		// UARTB0M^CAEg UARTB0 000005A0H UB0TITOIC
#define PIC_NO_INTCF5R		83		// CSIF5MI^CSIF5MG[ CSIF5 000005B0H CF5RIC
#define PIC_NO_INTUC6R		83		// UARTC6MI^UARTC6MG[ UARTC6 000005B0H UC6RIC
#define PIC_NO_INTCF5T		84		// CSIF5AM݋ CSIF5 000005C0H CF5TIC
#define PIC_NO_INTUC6T		84		// UARTC6AM݋ UARTC6 000005C0H UC6TIC
#define PIC_NO_INTCF6R		85		// CSIF6MI^CSIF6MG[ CSIF6 000005D0H CF6RIC
#define PIC_NO_INTUC7R		85		// UARTC7MI^UARTC7MG[ UARTC7 000005D0H UC7RIC
#define PIC_NO_INTCF6T		86		// CSIF6AM݋ CSIF6 000005E0H CF6TIC
#define PIC_NO_INTUC7T		86		// UARTC7AM݋ UARTC7 000005E0H UC7TIC
#define PIC_NO_INTUC2R		87		// UARTC2MI^UARTC2MG[ UARTC2 000005F0H UC2RIC
#define PIC_NO_INTIIC2		87		// IIC2]I IIC2 000005F0H IICIC2
#define PIC_NO_INTUC2T		88		// UARTC2AM݋ UARTC2 00000600H UC2TIC
#define PIC_NO_INTIIC4		89		// IIC4]I IIC4 00000610H IICIC4
#define PIC_NO_INTAD		90		// A/DϊI A/D 00000620H ADIC
#define PIC_NO_INTDMA0		91		// DMA0]I DMA 00000630H DMAIC0
#define PIC_NO_INTDMA1		92		// DMA1]I DMA 00000640H DMAIC1
#define PIC_NO_INTDMA2		93		// DMA2]I DMA 00000650H DMAIC2
#define PIC_NO_INTDMA3		94		// DMA3]I DMA 00000660H DMAIC3
#define PIC_NO_INTKR		95		// L[E^[荞 KR 00000670H KRIC
#define PIC_NO_INTRTC0		96		// RTCM RTC 00000680H RTC0IC
#define PIC_NO_INTRTC1		97		// RTCA[v RTC 00000690H RTC1IC
#define PIC_NO_INTRTC2		98		// RTCC^[oM RTC 000006A0H RTC2IC
#define PIC_NO_INTUSBF0		99		// USBF荞 USBF 000006B0H UFIC0
#define PIC_NO_INTUSBF1		100		// USBF Resume荞 USBF 000006C0H UFIC1
#define PIC_NO_INTETMRX		101		// pPbgM Ethernet 000006D0H ETMRXIC
#define PIC_NO_INTETMTX		102		// pPbgM Ethernet 000006E0H ETMTXIC
#define PIC_NO_INTETMRQ		103		// MpPbgǂݏov Ethernet 000006F0H ETMRQIC
#define PIC_NO_INTETMFS		104		// FIFOXe[^X Ethernet 00000700H ETMFSIC
#define PIC_NO_INTETMTS		105		// MXe[^X Ethernet 00000710H ETMTSIC
#define PIC_NO_INTETMRS		106		// MXe[^X Ethernet 00000720H ETMRSIC
#define PIC_NO_INTETMOV		107		// vJE^I[ot[ Ethernet 00000730H ETMOVIC
#define PIC_NO_INTETBER		108		// G[荞 Ethernet 00000740H ETBERIC
#define PIC_NO_INTC0ERR		110		// CAN0G[ CAN0 00000760H ERRIC0
#define PIC_NO_INTC0WUP1	111		// CAN0EGCNEAbv CAN0 00000770H WUPIC0
#define PIC_NO_INTC0REC		112		// CAN0M CAN0 00000780H RECIC0
#define PIC_NO_INTC0TRX		113		// CAN0M CAN0 00000790H TRXIC0

#define LVIIC		((struct TPIC *)&PIC[(0xFFFFF110 - 0xFFFFF110) / 2])
#define PIC00		((struct TPIC *)&PIC[(0xFFFFF112 - 0xFFFFF110) / 2])
#define PIC01		((struct TPIC *)&PIC[(0xFFFFF114 - 0xFFFFF110) / 2])
#define PIC02		((struct TPIC *)&PIC[(0xFFFFF116 - 0xFFFFF110) / 2])
#define PIC03		((struct TPIC *)&PIC[(0xFFFFF118 - 0xFFFFF110) / 2])
#define PIC04		((struct TPIC *)&PIC[(0xFFFFF11A - 0xFFFFF110) / 2])
#define PIC05		((struct TPIC *)&PIC[(0xFFFFF11C - 0xFFFFF110) / 2])
#define PIC06		((struct TPIC *)&PIC[(0xFFFFF11E - 0xFFFFF110) / 2])
#define PIC07		((struct TPIC *)&PIC[(0xFFFFF120 - 0xFFFFF110) / 2])
#define PIC08		((struct TPIC *)&PIC[(0xFFFFF122 - 0xFFFFF110) / 2])
#define PIC09		((struct TPIC *)&PIC[(0xFFFFF124 - 0xFFFFF110) / 2])
#define PIC10		((struct TPIC *)&PIC[(0xFFFFF126 - 0xFFFFF110) / 2])
#define PIC11		((struct TPIC *)&PIC[(0xFFFFF128 - 0xFFFFF110) / 2])
#define PIC12		((struct TPIC *)&PIC[(0xFFFFF12A - 0xFFFFF110) / 2])
#define PIC13		((struct TPIC *)&PIC[(0xFFFFF12C - 0xFFFFF110) / 2])
#define PIC14		((struct TPIC *)&PIC[(0xFFFFF12E - 0xFFFFF110) / 2])
#define PIC15		((struct TPIC *)&PIC[(0xFFFFF130 - 0xFFFFF110) / 2])
#define PIC16		((struct TPIC *)&PIC[(0xFFFFF132 - 0xFFFFF110) / 2])
#define PIC17		((struct TPIC *)&PIC[(0xFFFFF134 - 0xFFFFF110) / 2])
#define PIC18		((struct TPIC *)&PIC[(0xFFFFF136 - 0xFFFFF110) / 2])
#define PIC19		((struct TPIC *)&PIC[(0xFFFFF138 - 0xFFFFF110) / 2])
#define PIC20		((struct TPIC *)&PIC[(0xFFFFF13A - 0xFFFFF110) / 2])
#define PIC21		((struct TPIC *)&PIC[(0xFFFFF13C - 0xFFFFF110) / 2])
#define PIC22		((struct TPIC *)&PIC[(0xFFFFF13E - 0xFFFFF110) / 2])
#define PIC23		((struct TPIC *)&PIC[(0xFFFFF140 - 0xFFFFF110) / 2])
#define PIC24		((struct TPIC *)&PIC[(0xFFFFF142 - 0xFFFFF110) / 2])
#define PIC25		((struct TPIC *)&PIC[(0xFFFFF144 - 0xFFFFF110) / 2])
#define TAB0OVIC	((struct TPIC *)&PIC[(0xFFFFF146 - 0xFFFFF110) / 2])
#define TAB0CCIC0	((struct TPIC *)&PIC[(0xFFFFF148 - 0xFFFFF110) / 2])
#define TAB0CCIC1	((struct TPIC *)&PIC[(0xFFFFF14A - 0xFFFFF110) / 2])
#define TAB0CCIC2	((struct TPIC *)&PIC[(0xFFFFF14C - 0xFFFFF110) / 2])
#define TAB0CCIC3	((struct TPIC *)&PIC[(0xFFFFF14E - 0xFFFFF110) / 2])
#define TAB1OVIC	((struct TPIC *)&PIC[(0xFFFFF150 - 0xFFFFF110) / 2])
#define TAB1CCIC0	((struct TPIC *)&PIC[(0xFFFFF152 - 0xFFFFF110) / 2])
#define TAB1CCIC1	((struct TPIC *)&PIC[(0xFFFFF154 - 0xFFFFF110) / 2])
#define TAB1CCIC2	((struct TPIC *)&PIC[(0xFFFFF156 - 0xFFFFF110) / 2])
#define TAB1CCIC3	((struct TPIC *)&PIC[(0xFFFFF158 - 0xFFFFF110) / 2])
#define TT0OVIC		((struct TPIC *)&PIC[(0xFFFFF15A - 0xFFFFF110) / 2])
#define TT0CCIC0	((struct TPIC *)&PIC[(0xFFFFF15C - 0xFFFFF110) / 2])
#define TT0CCIC1	((struct TPIC *)&PIC[(0xFFFFF15E - 0xFFFFF110) / 2])
#define TT0IECIC	((struct TPIC *)&PIC[(0xFFFFF160 - 0xFFFFF110) / 2])
#define TAA0OVIC	((struct TPIC *)&PIC[(0xFFFFF162 - 0xFFFFF110) / 2])
#define TAA0CCIC0	((struct TPIC *)&PIC[(0xFFFFF164 - 0xFFFFF110) / 2])
#define TAA0CCIC1	((struct TPIC *)&PIC[(0xFFFFF166 - 0xFFFFF110) / 2])
#define TAA1OVIC	((struct TPIC *)&PIC[(0xFFFFF168 - 0xFFFFF110) / 2])
#define TAA1CCIC0	((struct TPIC *)&PIC[(0xFFFFF16A - 0xFFFFF110) / 2])
#define TAA1CCIC1	((struct TPIC *)&PIC[(0xFFFFF16C - 0xFFFFF110) / 2])
#define TAA2OVIC	((struct TPIC *)&PIC[(0xFFFFF16E - 0xFFFFF110) / 2])
#define TAA2CCIC0	((struct TPIC *)&PIC[(0xFFFFF170 - 0xFFFFF110) / 2])
#define TAA2CCIC1	((struct TPIC *)&PIC[(0xFFFFF172 - 0xFFFFF110) / 2])
#define TAA3OVIC	((struct TPIC *)&PIC[(0xFFFFF174 - 0xFFFFF110) / 2])
#define TAA3CCIC0	((struct TPIC *)&PIC[(0xFFFFF176 - 0xFFFFF110) / 2])
#define TAA3CCIC1	((struct TPIC *)&PIC[(0xFFFFF178 - 0xFFFFF110) / 2])
#define TAA4OVIC	((struct TPIC *)&PIC[(0xFFFFF17A - 0xFFFFF110) / 2])
#define TAA4CCIC0	((struct TPIC *)&PIC[(0xFFFFF17C - 0xFFFFF110) / 2])
#define TAA4CCIC1	((struct TPIC *)&PIC[(0xFFFFF17E - 0xFFFFF110) / 2])
#define TAA5OVIC	((struct TPIC *)&PIC[(0xFFFFF180 - 0xFFFFF110) / 2])
#define TAA5CCIC0	((struct TPIC *)&PIC[(0xFFFFF182 - 0xFFFFF110) / 2])
#define TAA5CCIC1	((struct TPIC *)&PIC[(0xFFFFF184 - 0xFFFFF110) / 2])
#define TM0EQIC0	((struct TPIC *)&PIC[(0xFFFFF186 - 0xFFFFF110) / 2])
#define TM1EQIC0	((struct TPIC *)&PIC[(0xFFFFF188 - 0xFFFFF110) / 2])
#define TM2EQIC0	((struct TPIC *)&PIC[(0xFFFFF18A - 0xFFFFF110) / 2])
#define TM3EQIC0	((struct TPIC *)&PIC[(0xFFFFF18C - 0xFFFFF110) / 2])
#define CE0TIC		((struct TPIC *)&PIC[(0xFFFFF18E - 0xFFFFF110) / 2])
#define UC4RIC		((struct TPIC *)&PIC[(0xFFFFF18E - 0xFFFFF110) / 2])
#define CE0TIOFIC	((struct TPIC *)&PIC[(0xFFFFF190 - 0xFFFFF110) / 2])
#define UC4TIC		((struct TPIC *)&PIC[(0xFFFFF190 - 0xFFFFF110) / 2])
#define CE1TIC		((struct TPIC *)&PIC[(0xFFFFF192 - 0xFFFFF110) / 2])
#define UC5RIC		((struct TPIC *)&PIC[(0xFFFFF192 - 0xFFFFF110) / 2])
#define IICIC3		((struct TPIC *)&PIC[(0xFFFFF192 - 0xFFFFF110) / 2])
#define CE1TIOFIC	((struct TPIC *)&PIC[(0xFFFFF194 - 0xFFFFF110) / 2])
#define UC5TIC		((struct TPIC *)&PIC[(0xFFFFF194 - 0xFFFFF110) / 2])
#define CF0RIC		((struct TPIC *)&PIC[(0xFFFFF196 - 0xFFFFF110) / 2])
#define UC3RIC		((struct TPIC *)&PIC[(0xFFFFF196 - 0xFFFFF110) / 2])
#define IICIC1		((struct TPIC *)&PIC[(0xFFFFF196 - 0xFFFFF110) / 2])
#define CF0TIC		((struct TPIC *)&PIC[(0xFFFFF198 - 0xFFFFF110) / 2])
#define UC3TIC		((struct TPIC *)&PIC[(0xFFFFF198 - 0xFFFFF110) / 2])
#define CF1RIC		((struct TPIC *)&PIC[(0xFFFFF19A - 0xFFFFF110) / 2])
#define UC1RIC		((struct TPIC *)&PIC[(0xFFFFF19A - 0xFFFFF110) / 2])
#define IICIC0		((struct TPIC *)&PIC[(0xFFFFF19A - 0xFFFFF110) / 2])
#define CF1TIC		((struct TPIC *)&PIC[(0xFFFFF19C - 0xFFFFF110) / 2])
#define UC1TIC		((struct TPIC *)&PIC[(0xFFFFF19C - 0xFFFFF110) / 2])
#define CF2RIC		((struct TPIC *)&PIC[(0xFFFFF19E - 0xFFFFF110) / 2])
#define UC0RIC		((struct TPIC *)&PIC[(0xFFFFF19E - 0xFFFFF110) / 2])
#define CF2TIC		((struct TPIC *)&PIC[(0xFFFFF1A0 - 0xFFFFF110) / 2])
#define UC0TIC		((struct TPIC *)&PIC[(0xFFFFF1A0 - 0xFFFFF110) / 2])
#define CF3RIC		((struct TPIC *)&PIC[(0xFFFFF1A2 - 0xFFFFF110) / 2])
#define UB1TIRIC	((struct TPIC *)&PIC[(0xFFFFF1A2 - 0xFFFFF110) / 2])
#define CF3TIC		((struct TPIC *)&PIC[(0xFFFFF1A4 - 0xFFFFF110) / 2])
#define UB1TITIC	((struct TPIC *)&PIC[(0xFFFFF1A4 - 0xFFFFF110) / 2])
#define UB1TIFIC	((struct TPIC *)&PIC[(0xFFFFF1A6 - 0xFFFFF110) / 2])
#define UB1TIREIC	((struct TPIC *)&PIC[(0xFFFFF1A8 - 0xFFFFF110) / 2])
#define UB1TITOIC	((struct TPIC *)&PIC[(0xFFFFF1AA - 0xFFFFF110) / 2])
#define CF4RIC		((struct TPIC *)&PIC[(0xFFFFF1AC - 0xFFFFF110) / 2])
#define UB0TIRIC	((struct TPIC *)&PIC[(0xFFFFF1AC - 0xFFFFF110) / 2])
#define CF4TIC		((struct TPIC *)&PIC[(0xFFFFF1AE - 0xFFFFF110) / 2])
#define UB0TITIC	((struct TPIC *)&PIC[(0xFFFFF1AE - 0xFFFFF110) / 2])
#define UB0TIFIC	((struct TPIC *)&PIC[(0xFFFFF1B0 - 0xFFFFF110) / 2])
#define UB0TIREIC	((struct TPIC *)&PIC[(0xFFFFF1B2 - 0xFFFFF110) / 2])
#define UB0TITOIC	((struct TPIC *)&PIC[(0xFFFFF1B4 - 0xFFFFF110) / 2])
#define CF5RIC		((struct TPIC *)&PIC[(0xFFFFF1B6 - 0xFFFFF110) / 2])
#define UC6RIC		((struct TPIC *)&PIC[(0xFFFFF1B6 - 0xFFFFF110) / 2])
#define CF5TIC		((struct TPIC *)&PIC[(0xFFFFF1B8 - 0xFFFFF110) / 2])
#define UC6TIC		((struct TPIC *)&PIC[(0xFFFFF1B8 - 0xFFFFF110) / 2])
#define CF6RIC		((struct TPIC *)&PIC[(0xFFFFF1BA - 0xFFFFF110) / 2])
#define UC7RIC		((struct TPIC *)&PIC[(0xFFFFF1BA - 0xFFFFF110) / 2])
#define CF6TIC		((struct TPIC *)&PIC[(0xFFFFF1BC - 0xFFFFF110) / 2])
#define UC7TIC		((struct TPIC *)&PIC[(0xFFFFF1BC - 0xFFFFF110) / 2])
#define UC2RIC		((struct TPIC *)&PIC[(0xFFFFF1BE - 0xFFFFF110) / 2])
#define IICIC2		((struct TPIC *)&PIC[(0xFFFFF1BE - 0xFFFFF110) / 2])
#define UC2TIC		((struct TPIC *)&PIC[(0xFFFFF1C0 - 0xFFFFF110) / 2])
#define IICIC4		((struct TPIC *)&PIC[(0xFFFFF1C2 - 0xFFFFF110) / 2])
#define ADIC		((struct TPIC *)&PIC[(0xFFFFF1C4 - 0xFFFFF110) / 2])
#define DMAIC0		((struct TPIC *)&PIC[(0xFFFFF1C6 - 0xFFFFF110) / 2])
#define DMAIC1		((struct TPIC *)&PIC[(0xFFFFF1C8 - 0xFFFFF110) / 2])
#define DMAIC2		((struct TPIC *)&PIC[(0xFFFFF1CA - 0xFFFFF110) / 2])
#define DMAIC3		((struct TPIC *)&PIC[(0xFFFFF1CC - 0xFFFFF110) / 2])
#define KRIC		((struct TPIC *)&PIC[(0xFFFFF1CE - 0xFFFFF110) / 2])
#define RTC0IC		((struct TPIC *)&PIC[(0xFFFFF1D0 - 0xFFFFF110) / 2])
#define RTC1IC		((struct TPIC *)&PIC[(0xFFFFF1D2 - 0xFFFFF110) / 2])
#define RTC2IC		((struct TPIC *)&PIC[(0xFFFFF1D4 - 0xFFFFF110) / 2])
#define UFIC0		((struct TPIC *)&PIC[(0xFFFFF1D6 - 0xFFFFF110) / 2])
#define UFIC1		((struct TPIC *)&PIC[(0xFFFFF1D8 - 0xFFFFF110) / 2])
#define ETMRXIC		((struct TPIC *)&PIC[(0xFFFFF1DA - 0xFFFFF110) / 2])
#define ETMTXIC		((struct TPIC *)&PIC[(0xFFFFF1DC - 0xFFFFF110) / 2])
#define ETMRQIC		((struct TPIC *)&PIC[(0xFFFFF1DE - 0xFFFFF110) / 2])
#define ETMFSIC		((struct TPIC *)&PIC[(0xFFFFF1E0 - 0xFFFFF110) / 2])
#define ETMTSIC		((struct TPIC *)&PIC[(0xFFFFF1E2 - 0xFFFFF110) / 2])
#define ETMRSIC		((struct TPIC *)&PIC[(0xFFFFF1E4 - 0xFFFFF110) / 2])
#define ETMOVIC		((struct TPIC *)&PIC[(0xFFFFF1E6 - 0xFFFFF110) / 2])
#define ETBERIC		((struct TPIC *)&PIC[(0xFFFFF1E8 - 0xFFFFF110) / 2])
#define ERRIC0		((struct TPIC *)&PIC[(0xFFFFF1EC - 0xFFFFF110) / 2])
#define WUPIC0		((struct TPIC *)&PIC[(0xFFFFF1EE - 0xFFFFF110) / 2])
#define RECIC0		((struct TPIC *)&PIC[(0xFFFFF1F0 - 0xFFFFF110) / 2])
#define TRXIC0		((struct TPIC *)&PIC[(0xFFFFF1F2 - 0xFFFFF110) / 2])
 
#define ETMFSIF						(ETMFSIC)
#define ETMFSMK						(ETMFSIC)
#define ETMOVIF						(ETMOVIC)
#define ETMOVMK						(ETMOVIC)
#define ETMRQIF						(ETMRQIC)
#define ETMRQMK						(ETMRQIC)
#define ETMRSIF						(ETMRSIC)
#define ETMRSMK						(ETMRSIC)
#define ETMRXIF						(ETMRXIC)
#define ETMRXMK						(ETMRXIC)
#define ETMTSIF						(ETMTSIC)
#define ETMTSMK						(ETMTSIC)
#define ETMTXIF						(ETMTXIC)
#define ETMTXMK						(ETMTXIC)

#pragma pack(pop)

#ifdef __cplusplus
}
#endif

#endif V850RegH
