//------------------------------------------------------------------------------
//  TOPPERS/ASP Windows Debug Environment
//  Copyright (C) 2010-2013 Cores Co., Ltd. Japan
//------------------------------------------------------------------------------
// $Id: UnitSim.cs 115 2013-02-11 02:13:05Z nagasima $
#ifndef SifV850ESJX3EH
#define SifV850ESJX3EH

//---------------------------------------------------------------------------
#include "Kernel.h"
#include "V850ESJX3EReg.h"
#include "SifUARTC.h"
#include "SifUARTB.h"

enum TTimerTerm
{
	ttInterrupt,
	ttWait,
};

//------------------------------------------------------------------------------
//  PBXXbh NX
//  TvF
//   PBXXbh NX
//------------------------------------------------------------------------------
class CSifV850ESJX3E : public ISifCPU, public ISystemIF, public ISysTimerSync
{
public:
	CSifV850ESJX3E(TV850Reg *V850Reg);
	virtual ~CSifV850ESJX3E();
private:
	TV850Reg *m_CPUReg;
	LONG m_Lock;
	TTimerTerm m_Term;
	__int64 m_Timer;
	unsigned char GetByte2(uintptr_t Addr);
	void SetByte2(uintptr_t Addr, unsigned char Value);
protected:
	void SpinLock(){ while(InterlockedCompareExchange(&m_Lock, 1, 0) == 1) SwitchToThread(); }
	void SpinUnlock(){ InterlockedExchange(&m_Lock, 0); }
public:
	bool InterruptEnabled(int IntNo);
	void ClearInterrupt(int IntNo);
	void SetInterrupt(int IntNo);
	unsigned int InterruptPriority(int IntNo);
	void ChangeInterruptControlRegister(int IntNo, uint8_t icrcmd);
public:	// ISystemIF
	virtual unsigned char GetByte(uintptr_t Addr);
	virtual void SetByte(uintptr_t Addr, unsigned char Value);
	virtual unsigned short GetUInt16(uintptr_t Addr);
	virtual void SetUInt16(uintptr_t Addr, unsigned short Value);
	virtual unsigned int GetUInt32(uintptr_t Addr);
	virtual void SetUInt32(uintptr_t Addr, unsigned int Value);
public:	// ISysTimerSync
	__int64 GetTimer();
	void Progress(__int64 Timer);
	void CallTimeOut(__int64 Frequency);
public:
	void OnTerminate();
public:
	CSifUARTC UARTC0;
	CSifUARTC UARTC1;
	CSifUARTC UARTC2;
	CSifUARTC UARTC3;
	CSifUARTC UARTC4;
	CSifUARTC UARTC5;
	CSifUARTC UARTC6;
	CSifUARTC UARTC7;
	CSifUARTB UARTB0;
	CSifUARTB UARTB1;
};

//---------------------------------------------------------------------------
#endif // SifV850ESJX3EH
