/*
 *  TLV - Trace Log Visualizer
 *
 *  Copyright (C) 2008-2010 by Nagoya Univ., JAPAN
 *
 *  上記著作権者は，以下の(1)〜(4)の条件を満たす場合に限り，本ソフトウェ
 *  ア（本ソフトウェアを改変したものを含む．以下同じ）を使用・複製・改
 *  変・再配布（以下，利用と呼ぶ）することを無償で許諾する．
 *  (1) 本ソフトウェアをソースコードの形で利用する場合には，上記の著作
 *      権表示，この利用条件および下記の無保証規定が，そのままの形でソー
 *      スコード中に含まれていること．
 *  (2) 本ソフトウェアを，ライブラリ形式など，他のソフトウェア開発に使
 *      用できる形で再配布する場合には，再配布に伴うドキュメント（利用
 *      者マニュアルなど）に，上記の著作権表示，この利用条件および下記
 *      の無保証規定を掲載すること．
 *  (3) 本ソフトウェアを，機器に組み込むなど，他のソフトウェア開発に使
 *      用できない形で再配布する場合には，次のいずれかの条件を満たすこ
 *      と．
 *    (a) 再配布に伴うドキュメント（利用者マニュアルなど）に，上記の著
 *        作権表示，この利用条件および下記の無保証規定を掲載すること．
 *    (b) 再配布の形態を，別に定める方法によって，TOPPERSプロジェクトに
 *        報告すること．
 *  (4) 本ソフトウェアの利用により直接的または間接的に生じるいかなる損
 *      害からも，上記著作権者およびTOPPERSプロジェクトを免責すること．
 *      また，本ソフトウェアのユーザまたはエンドユーザからのいかなる理
 *      由に基づく請求からも，上記著作権者およびTOPPERSプロジェクトを
 *      免責すること．
 *
 *  本ソフトウェアは，無保証で提供されているものである．上記著作権者お
 *  よびTOPPERSプロジェクトは，本ソフトウェアに関して，特定の使用目的
 *  に対する適合性も含めて，いかなる保証も行わない．また，本ソフトウェ
 *  アの利用により直接的または間接的に生じたいかなる損害に関しても，そ
 *  の責任を負わない．
 *
 *  @(#) $Id$
 */
using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Text;
using System.IO;
using NU.OJL.MPRTOS.TLV.Base;
using System.Drawing;

namespace NU.OJL.MPRTOS.TLV.Core
{
	public class ResourceType : IJsonable<ResourceType>, INamed
	{
		private string _name = string.Empty;
		private string _DisplayName;
		private GeneralNamedCollection<AttributeType> _Attributes;
		private GeneralNamedCollection<BehaviorType> _Behaviors;
		private Color? _Color;

		public string Name
		{
			get { return _name; }
			set
			{
				_name = value;
				if (DisplayName == null)
					DisplayName = value;
			}
		}

		/// <summary>
		/// 表示名
		/// </summary>
		public string DisplayName { get { return _DisplayName; } set { _DisplayName = value; } }
		/// <summary>
		/// 属性リスト
		/// </summary>
		public GeneralNamedCollection<AttributeType> Attributes { get { return _Attributes; } set { _Attributes = value; } }
		/// <summary>
		/// 振る舞いリスト
		/// </summary>
		public GeneralNamedCollection<BehaviorType> Behaviors { get { return _Behaviors; } set { _Behaviors = value; } }
		/// <summary>
		/// 色
		/// </summary>
		public Color? Color { get { return _Color; } set { _Color = value; } }

		/// <summary>
		/// <c>Resource</c>のインスタンスを生成する
		/// </summary>
		public ResourceType()
		{
			DisplayName = string.Empty;
			Color = ApplicationFactory.ColorFactory.RamdomColor();
		}

		public string ToJson()
		{
			return ApplicationFactory.JsonSerializer.Serialize(this);
		}

		public ResourceType Parse(string data)
		{
			return ApplicationFactory.JsonSerializer.Deserialize<ResourceType>(data);
		}
	}
}
