/*
 *  TLV - Trace Log Visualizer
 *
 *  Copyright (C) 2008-2010 by Nagoya Univ., JAPAN
 *
 *  上記著作権者は，以下の(1)〜(4)の条件を満たす場合に限り，本ソフトウェ
 *  ア（本ソフトウェアを改変したものを含む．以下同じ）を使用・複製・改
 *  変・再配布（以下，利用と呼ぶ）することを無償で許諾する．
 *  (1) 本ソフトウェアをソースコードの形で利用する場合には，上記の著作
 *      権表示，この利用条件および下記の無保証規定が，そのままの形でソー
 *      スコード中に含まれていること．
 *  (2) 本ソフトウェアを，ライブラリ形式など，他のソフトウェア開発に使
 *      用できる形で再配布する場合には，再配布に伴うドキュメント（利用
 *      者マニュアルなど）に，上記の著作権表示，この利用条件および下記
 *      の無保証規定を掲載すること．
 *  (3) 本ソフトウェアを，機器に組み込むなど，他のソフトウェア開発に使
 *      用できない形で再配布する場合には，次のいずれかの条件を満たすこ
 *      と．
 *    (a) 再配布に伴うドキュメント（利用者マニュアルなど）に，上記の著
 *        作権表示，この利用条件および下記の無保証規定を掲載すること．
 *    (b) 再配布の形態を，別に定める方法によって，TOPPERSプロジェクトに
 *        報告すること．
 *  (4) 本ソフトウェアの利用により直接的または間接的に生じるいかなる損
 *      害からも，上記著作権者およびTOPPERSプロジェクトを免責すること．
 *      また，本ソフトウェアのユーザまたはエンドユーザからのいかなる理
 *      由に基づく請求からも，上記著作権者およびTOPPERSプロジェクトを
 *      免責すること．
 *
 *  本ソフトウェアは，無保証で提供されているものである．上記著作権者お
 *  よびTOPPERSプロジェクトは，本ソフトウェアに関して，特定の使用目的
 *  に対する適合性も含めて，いかなる保証も行わない．また，本ソフトウェ
 *  アの利用により直接的または間接的に生じたいかなる損害に関しても，そ
 *  の責任を負わない．
 *
 *  @(#) $Id$
 */
using System;
using System.Collections.Generic;
using System.Text;

namespace NU.OJL.MPRTOS.TLV.Base
{
	public class Json : IEnumerable<Json>
	{
		private object _Value;

		public static Json Empty { get { return new Json(); } }
		public bool IsEmpty { get { return Value == null; } }

		public static Json Object { get { return new Json(new Dictionary<string, Json>()); } }
		public static Json Array { get { return new Json(new List<Json>()); } }

		public object Value { get { return _Value; } set { _Value = value; } }
		public Json this[int i]
		{
			get { return Value is List<Json> ? ((List<Json>)Value)[i] : null; }
			set
			{
				if (Value is List<Json>)
				{
					((List<Json>)Value)[i] = value;
				}
			}
		}
		public Json this[string name]
		{
			get { return Value is Dictionary<string, Json> ? ((Dictionary<string, Json>)Value)[name] : null; }
			set
			{
				if (Value is Dictionary<string, Json>)
				{
					((Dictionary<string, Json>)Value)[name] = value;
				}
			}
		}

		public Json()
		{
			Value = null;
		}

		public Json(object value)
		{
			Value = value;
		}

		public bool ContainsKey(string name)
		{
			return Value is Dictionary<string, Json> ? ((Dictionary<string, Json>)Value).ContainsKey(name) : false;
		}
		public bool ContainsKey(int index)
		{
			return Value is List<Json> ? ((List<Json>)Value).Contains(this[index]) : false;
		}

		public int IndexOf(Json value)
		{
			if (Value is List<Json>)
			{
				return ((List<Json>)Value).IndexOf(value);
			}
			else
			{
				return -1;
			}
		}
		public int Count
		{
			get
			{
				if (Value is List<Json>)
				{
					return ((List<Json>)Value).Count;
				}
				else
				{
					return 0;
				}
			}
		}

		public bool IsArray { get { return Value is List<Json>; } }
		public bool IsObject { get { return Value is Dictionary<string, Json>; } }

		public void AddArray(string name)
		{
			if (Value is Dictionary<string, Json>)
			{
				((Dictionary<string, Json>)Value).Add(name, new Json(new List<Json>()));
			}
		}

		public void AddObject(string name)
		{
			if (Value is Dictionary<string, Json>)
			{
				((Dictionary<string, Json>)Value).Add(name, new Json(new Dictionary<string, Json>()));
			}
		}

		public void Add(string name, object value)
		{
			if (Value is Dictionary<string, Json>)
			{
				((Dictionary<string, Json>)Value).Add(name, new Json(value));
			}
		}

		public void Add(object value)
		{
			if (Value is List<Json>)
			{
				((List<Json>)Value).Add(new Json(value));
			}
		}

		public IEnumerator<Json> GetEnumerator()
		{
			if (Value is IEnumerable<Json>)
				return ((IEnumerable<Json>)Value).GetEnumerator();
			else
				return null;
		}

		public IEnumerable<KeyValuePair<string, Json>> GetKeyValuePairEnumerator()
		{
			if (Value is IEnumerable<KeyValuePair<string, Json>>)
				return (IEnumerable<KeyValuePair<string, Json>>)Value;
			else
				return null;
		}

		System.Collections.IEnumerator System.Collections.IEnumerable.GetEnumerator()
		{
			if (Value is IEnumerable<Json>)
				return ((IEnumerable<Json>)Value).GetEnumerator();
			else if (Value is IEnumerable<KeyValuePair<string, Json>>)
				return ((IEnumerable<KeyValuePair<string, Json>>)Value).GetEnumerator();
			else
				return null;
		}

		public static implicit operator string(Json jsonValue)
		{
			return jsonValue.ToString();
		}
		public static implicit operator bool(Json jsonValue)
		{
			return (bool)jsonValue.Value;
		}
		public static implicit operator decimal(Json jsonValue)
		{
			return (decimal)jsonValue.Value;
		}
		public static implicit operator List<Json>(Json jsonValue)
		{
			return (List<Json>)jsonValue.Value;
		}
		public static implicit operator Dictionary<string, Json>(Json jsonValue)
		{
			return (Dictionary<string, Json>)jsonValue.Value;
		}

		public override string ToString()
		{
			if (Value == null)
				return "null";

			return Value.ToString();
		}

	}
}
