import com.we_lab_doc.spacecard.model.*
import com.we_lab_doc.spacecard.utils.*

class WorkCardTests extends SpaceCardModelTestCase {
	/*    	
    void testPermission() {
		def sv = User.getActiveUserByAccount(spaceCardModelProperties.supervisorAccount)
		assertNotNull sv
		def svc = Organization.getSupervisorCommunity()
		assertNotNull svc
		def p1 = Project.create(
				[
				 title:"hoge1",
				 creator:sv
				]
				,svc)
		def p2 = Project.create(
				[
				 title:"hoge2",
				 creator:sv
				]
				,svc)
		assertTrue "0", ModelUtils.flush([p1,p2])
		def au = p1.assign(sv, PartType.LEADER)
//		assertTrue "1", accessControlService.checkPermission(sv, p1)
//		assertFalse "2", accessControlService.checkPermission(sv, p2)
    }

    void testDate() {
		def sv = User.getActiveUserByAccount(spaceCardModelProperties.supervisorAccount)
		assertNotNull sv
		def svc = Organization.getSupervisorCommunity()
		assertNotNull svc
		def p1 = Project.create(
				[
				 title:"hoge1",
				 creator:sv
				]
				,svc)

		assertTrue ModelUtils.flush(p1)
		assertNotNull "1-1", p1
		assertEquals "1-2", p1.creator, sv
		assertNotNull "2", p1.createdDate
		assertNull "3", p1.updatedDate
		//assertNotNull p1.updatedDate 
		assertNull "4", p1.closedDate
		
		p1.title = "hoge"
		assertTrue "6", ModelUtils.flush(p1)
		assertNotNull "7", p1.createdDate
		assertNotNull "8", p1.updatedDate
		assertNull "9", p1.closedDate
		assertEquals "10-1:${p1.updater}, ${sv}", p1.updater, sv
		assertNull "10-3", p1.closer
		
		assertTrue "11", p1.close()
		assertTrue "12", ModelUtils.flush(p1)
		assertNotNull "13", p1.createdDate
		assertNotNull "14", p1.updatedDate
		assertNotNull "15", p1.closedDate
		assertEquals "16-1", p1.updater, sv
		assertEquals "16-3", p1.closer, sv
		
		assertTrue "17", p1.remove()
    }
    
    void testGetProjects() {
		def sv = User.getActiveUserByAccount(spaceCardModelProperties.supervisorAccount)
		assertNotNull sv
		def svc = Organization.getSupervisorCommunity()
		assertNotNull svc
		
		def projParams = [
		                  [title:"hoge1",creator:sv],
		                  [title:"hoge2",creator:sv],
		                  [title:"hoge3",creator:sv],
		                  [title:"hoge4",creator:sv],
		                  [title:"hoge5",creator:sv],
		                  [title:"hoge6",creator:sv],
		                  [title:"hoge7",creator:sv],
		                  [title:"hoge8",creator:sv],
		                  [title:"hoge9",creator:sv],			                  
		                 ]
		def projs = []
		for (projParam in projParams) {
			def p = Project.create(projParam,svc)
			projs << p
		}
		assertTrue "0", ModelUtils.flush(projs)
		assertTrue "1", projs[2].close()
		assertTrue "2", projs[3].close()
		assertTrue "3", projs[4].close()
		assertTrue "3-1", ModelUtils.flush([projs[2], projs[3], projs[4]])
		assertTrue "4", projs[5].remove()
		assertTrue "5", projs[6].remove()
		assertTrue "6", projs[7].remove()
		assertTrue "7", projs[8].remove()
		
		assertTrue "9", svc.getOpenProjects(null).size() == 2
		assertTrue "9-1", svc.countOfOpenProjects() == 2
		assertTrue "10", svc.getClosedProjects(null).size() == 3
		assertTrue "10-1", svc.countOfClosedProjects() == 3
    }
    
    void testGetMissions() {
		def sv = User.getActiveUserByAccount(spaceCardModelProperties.supervisorAccount)
		assertNotNull sv
		def svc = Organization.getSupervisorCommunity()
		assertNotNull svc
		
		def prj = Project.create(
				[title:"hoge0",creator:sv],svc)
		assertTrue "0", ModelUtils.flush(prj)

		def missionParams = [
		                  [title:"hoge1",creator:sv],
		                  [title:"hoge2",creator:sv],
		                  [title:"hoge3",creator:sv],
		                  [title:"hoge4",creator:sv],
		                  [title:"hoge5",creator:sv],
		                  [title:"hoge6",creator:sv],
		                  [title:"hoge7",creator:sv],
		                  [title:"hoge8",creator:sv],
		                  [title:"hoge9",creator:sv],			                  
		                 ]
		def missions = []
		for (missionParam in missionParams) {
			def m = Mission.create(
					missionParam, prj)
			missions << m
		}
		assertTrue "0", ModelUtils.flush(missions)
		assertTrue "1", missions[2].close()
		assertTrue "2", missions[3].close()
		assertTrue "3", missions[4].close()
		assertTrue "8", ModelUtils.flush([missions[2],missions[3],missions[4]])
		assertTrue "4", missions[5].remove()
		assertTrue "5", missions[6].remove()
		assertTrue "6", missions[7].remove()			
		assertTrue "7", missions[8].remove()
		
		assertTrue "9", prj.getOpenMissions(null).size() == 2
		assertTrue "9-1", prj.countOfOpenMissions() == 2
		assertTrue "10", prj.getClosedMissions(null).size() == 3
		assertTrue "10-1", prj.countOfClosedMissions() == 3		
    }
    
    void testGetTasks() {
		def sv = User.getActiveUserByAccount(spaceCardModelProperties.supervisorAccount)
		assertNotNull sv
		def svc = Organization.getSupervisorCommunity()
		assertNotNull svc
		
		def prj = Project.create(
				[title:"hoge0-1",creator:sv],svc)
		assertTrue "0-1", ModelUtils.flush(prj)
		
		def msn = Mission.create(
				[title:"hoge0-2",creator:sv],prj)
		assertTrue "0-2", ModelUtils.flush(msn)

		def taskParams = [
		                  [title:"hoge1",creator:sv],
		                  [title:"hoge2",creator:sv],
		                  [title:"hoge3",creator:sv],
		                  [title:"hoge4",creator:sv],
		                  [title:"hoge5",creator:sv],
		                  [title:"hoge6",creator:sv],
		                  [title:"hoge7",creator:sv],
		                  [title:"hoge8",creator:sv],
		                  [title:"hoge9",creator:sv],			                  
		                 ]
		def tasks = []
		for (taskParam in taskParams) {
			def t = Task.create(
					taskParam, msn)
			tasks << t
		}
		assertTrue "0", ModelUtils.flush(tasks)
		assertTrue "1", tasks[2].close()
		assertTrue "2", tasks[3].close()
		assertTrue "3", tasks[4].close()
		assertTrue "8", ModelUtils.flush([tasks[2],tasks[3],tasks[4]])					
		assertTrue "4", tasks[5].remove()
		assertTrue "5", tasks[6].remove()
		assertTrue "6", tasks[7].remove()			
		assertTrue "7", tasks[8].remove()
		
		assertTrue "9", msn.getOpenTasks(null).size() == 2
		assertTrue "9-1", msn.countOfOpenTasks() == 2
		assertTrue "10", msn.getClosedTasks(null).size() == 3
		assertTrue "10-1", msn.countOfClosedTasks() == 3
    }    
    
    void testGetUsers() {
		def sv = User.getActiveUserByAccount(spaceCardModelProperties.supervisorAccount)
		assertNotNull sv
		def svc = Organization.getSupervisorCommunity()
		assertNotNull svc
		
		def prj = Project.create(
				[title:"hoge0-1",creator:sv],svc)
		assertTrue "0-1", ModelUtils.flush(prj)
		
		def role = svc.getUserRole()
		def userParams = [
		                  [account:"account_1", lastName:"lastName_1", firstName:"firstName_1", 
		                        lastNameKana:"lastNameKana_1", password:"password_1", 
		                   		email:"email_1@hoge", visibleEmail:true, description:null, role:role],
		                  [account:"account_2", lastName:"lastName_2", firstName:"firstName_2", 
		                   		lastNameKana:"lastNameKana_2", password:"password_2", 
			                   	email:"email_2@hoge", visibleEmail:true, description:null, role:role],
		                  [account:"account_3", lastName:"lastName_3", firstName:"firstName_3", 
		                   		lastNameKana:"lastNameKana_3", password:"password_3", 
			                   	email:"email_3@hoge", visibleEmail:true, description:null, role:role],				                   	
		                  ]
		
		def users = []
		userParams.each { userParam ->
			def user = User.create(userParam.account, userParam.lastName, userParam.firstName, userParam.lastNameKana,	
					userParam.password, userParam.email, userParam.visibleEmail, userParam.description, userParam.role)
			users << user
		}
		assertTrue "0-2", ModelUtils.flush(users)
		
		def i = 0
		users.each { user ->
			assertTrue "1-${i++}", prj.assign(user, PartType.LEADER) != false
		}
		
		assertTrue "2-1", prj.getUsers(true, null).size() == 3
		assertTrue "2-1-1", prj.countOfUsers(true) == 3		
		assertTrue "2-2", prj.getUsers(false, null).size() == 3
		assertTrue "2-2-1", prj.countOfUsers(false) == 3
		
		assertTrue "2-3", prj.getLeaders(true, null).size() == 3
		assertTrue "2-3-1", prj.countOfLeaders(true) == 3
		assertTrue "2-4", prj.getLeaders(false, null).size() == 3			
		assertTrue "2-4-1", prj.countOfLeaders(false) == 3
		
		assertNotNull "3-1", users[0].deactivate()
		assertNotNull "3-2", users[2].deactivate()
		assertTrue "3-3", ModelUtils.flush([users[0], users[2]])
		
		assertTrue "4-1", prj.getUsers(true, null).size() == 3
		assertTrue "4-1-1", prj.countOfUsers(true) == 3		
		assertTrue "4-2", prj.getUsers(false, null).size() == 1
		assertTrue "4-2-1", prj.countOfUsers(false) == 1		
		assertTrue "4-3", prj.getLeaders(true, null).size() == 3
		assertTrue "4-3-1", prj.countOfLeaders(true) == 3		
		assertTrue "4-4", prj.getLeaders(false, null).size() == 1
		assertTrue "4-4-1", prj.countOfLeaders(false) == 1		
		def aus = users[0].getAssigns()
		assertTrue "5-1: ${aus.size()}", aus.size() == 1
		assertTrue "5-1-1", users[0].countOfAssigns() == 1
		def prjs2 = users[0].getAssignedProjects(null)
		assertTrue "5-3", prjs2.size() == 1
		assertTrue "5-3-1", users[0].countOfAssignedProjects() == 1
		def prjs5 = users[0].getAssignedWorkCards(null)
		assertTrue "5-6", prjs5.size() == 1
		assertTrue "5-6-1", users[0].countOfAssignedWorkCards() == 1
    }
*/    
}
