/* Copyright 2008 we-lab-doc! (http://www.we-lab-doc.com/)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.we_lab_doc.spacecard.model

import com.we_lab_doc.spacecard.model.abstracts.*

/**
 * @author Shigeru GOUGI
 * @since 0.1
 *        <p/>
 *        Created: March 24, 2008
 */ 
final class WorkCardExternalURL extends ExternalURL {
	boolean remove() {
		this.workCard?.removeFromUrls(this)
		return super.remove()
	}
	/////////////////////////////////////////////
	static ExternalURL create(String url) {
		assert url != null && url.length() > 0		
		return create([url:url])
	}
	static ExternalURL create(String url, String description) {
		assert url != null && url.length() > 0
		return create([url:url, description:description])
	}
	static ExternalURL create(params) {
		assert params != null
		if(!params.creator) {
			def acs = SpaceCardModel.accessControlService
			params.creator = acs.getLoggedInUser()
		}
		return new WorkCardExternalURL(params)
	}
	/////////////////////////////////////////////
	static belongsTo   = [workCard:WorkCard]
	static constraints = {
		workCard(nullable:false)
		url(url:true, blank:false)		
	}
	/////////////////////////////////////////////
}
