/* Copyright 2008 we-lab-doc! (http://www.we-lab-doc.com/)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.we_lab_doc.spacecard.model


import com.we_lab_doc.spacecard.model.abstracts.*

/**
 * @author Shigeru GOUGI
 * @since 0.1
 *        <p/>
 *        Created: February 13, 2008
 */ 
final class OneDirectionLink extends CrossLink {
	SpaceCard getTarget() {
		for(t in targets) if(t != null) return t
		return null
	}
	SpaceCard getOwner() {
		for(o in owners) if(o != null) return o
		return null
	}	
	////
	Link bind(SpaceCard owner, SpaceCard card) {
		assert targets == null || targets.size() == 0
		assert card != null
		addToTargets(card)
		owner.addToLinks(this)
		return this
	}
	////		
	protected boolean constraintsTargets() {
		return targets?.size() == 1
	}
	////
	static Link create() {
		return create(null, null)
	}
	static Link create(String name) {
		return create(name, null)
	}	
	static Link create(String name, String description) {
		return create([name:name, description:description]) 
	}
	static Link create(params) {
		assert params != null
		if(!params.creator) {
			def accessControlService = SpaceCardModel.accessControlService
			params.creator = accessControlService.getLoggedInUser()
		}
		return new OneDirectionLink(params)
	}		
	/////////////////////////////////////////////
	static transients = ['target','owner']
	/////////////////////////////////////////////
}
