/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.inlineformatting.infontformatting;

import com.adobe.agl.lang.UScript;
import com.adobe.fontengine.font.FontData;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.inlineformatting.AttributedRun;
import com.adobe.fontengine.inlineformatting.ElementAttribute;
import com.adobe.fontengine.inlineformatting.infontformatting.ArabicFormatter;
import com.adobe.fontengine.inlineformatting.infontformatting.BaseFormatter;
import com.adobe.fontengine.inlineformatting.infontformatting.BengaliFormatter;
import com.adobe.fontengine.inlineformatting.infontformatting.DevanagariFormatter;
import com.adobe.fontengine.inlineformatting.infontformatting.GenericFormatter;
import com.adobe.fontengine.inlineformatting.infontformatting.GlyphFormatter;
import com.adobe.fontengine.inlineformatting.infontformatting.GujaratiFormatter;
import com.adobe.fontengine.inlineformatting.infontformatting.GurmukhiFormatter;
import com.adobe.fontengine.inlineformatting.infontformatting.HanKanaFormatter;
import com.adobe.fontengine.inlineformatting.infontformatting.HangulFormatter;
import com.adobe.fontengine.inlineformatting.infontformatting.KannadaFormatter;
import com.adobe.fontengine.inlineformatting.infontformatting.LaoFormatter;
import com.adobe.fontengine.inlineformatting.infontformatting.OriyaFormatter;
import com.adobe.fontengine.inlineformatting.infontformatting.TamilFormatter;
import com.adobe.fontengine.inlineformatting.infontformatting.TeluguFormatter;
import com.adobe.fontengine.inlineformatting.infontformatting.ThaiFormatter;
import com.adobe.fontengine.inlineformatting.infontformatting.TibetanFormatter;
import java.util.HashSet;
import java.util.Set;

public final class InFontFormatter {
    private static final BaseFormatter[] scriptFormatters = new BaseFormatter[55];
    private static final BaseFormatter glyphFormatter = new GlyphFormatter();
    public static final ElementAttribute scriptAttribute;
    protected static final Set typographicSystem;
    protected static final Set fontAtts;

    private InFontFormatter() {
    }

    static void resolveScript(AttributedRun attributedRun, int n, int n2) {
        int n3;
        int n4 = 0;
        Integer n5 = null;
        int n6 = n - 1;
        for (n3 = n; n3 < n2; ++n3) {
            if (attributedRun.getElementStyle(n3, ElementAttribute.isGlyph) == Boolean.TRUE) continue;
            int n7 = UScript.getScript((int)attributedRun.elementAt(n3));
            if (n7 == 0 || n7 == 1) {
                if (n5 != null) {
                    attributedRun.setElementStyle(n3, scriptAttribute, n5);
                    continue;
                }
                n6 = n3;
                continue;
            }
            if (n7 != n4) {
                n4 = n7;
                n5 = new Integer(n7);
                if (n6 != n - 1) {
                    for (int i = n; i <= n6; ++i) {
                        attributedRun.setElementStyle(i, scriptAttribute, n5);
                    }
                    n6 = n - 1;
                }
            }
            attributedRun.setElementStyle(n3, scriptAttribute, n5);
        }
        if (n6 != n - 1) {
            for (n3 = n; n3 <= n6; ++n3) {
                attributedRun.setElementStyle(n3, scriptAttribute, new Integer(25));
            }
        }
    }

    public static int preFormat(AttributedRun attributedRun, int n, int n2) {
        while (n < n2) {
            int n3 = attributedRun.getSubrunLimit(n, n2, ElementAttribute.isGlyph);
            boolean bl = (Boolean)attributedRun.getElementStyle(n, ElementAttribute.isGlyph);
            if (bl) {
                n = n3;
                continue;
            }
            InFontFormatter.resolveScript(attributedRun, n, n3);
            n = n3;
        }
        return n2;
    }

    public static int firstPass(AttributedRun attributedRun, int n, int n2) {
        while (n < n2) {
            int n3 = attributedRun.getSubrunLimit(n, n2, ElementAttribute.isGlyph);
            boolean bl = (Boolean)attributedRun.getElementStyle(n, ElementAttribute.isGlyph);
            if (bl) {
                n = n3;
                continue;
            }
            while (n < n3) {
                int n4;
                int n5 = attributedRun.getSubrunLimit(n, n3, scriptAttribute);
                int n6 = (Integer)attributedRun.getElementStyle(n, scriptAttribute);
                n = n4 = scriptFormatters[n6].firstPass(attributedRun, n, n5);
                n3 += n4 - n5;
                n2 += n4 - n5;
            }
        }
        return n2;
    }

    public static int canRenderWithFont(FontData fontData, AttributedRun attributedRun, int n, int n2) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        int n3 = (Integer)attributedRun.getElementStyle(n, scriptAttribute);
        return scriptFormatters[n3].canRenderWithFont(fontData, attributedRun, n, n2);
    }

    public static int canRenderWithNotdef(AttributedRun attributedRun, int n, int n2) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        int n3 = (Integer)attributedRun.getElementStyle(n, scriptAttribute);
        return scriptFormatters[n3].canRenderWithNotdef(attributedRun, n, n2);
    }

    public static int format(AttributedRun attributedRun, int n, int n2, boolean bl) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        while (n < n2) {
            int n3;
            int n4 = attributedRun.getSubrunLimit(n, n2, typographicSystem);
            boolean bl2 = (Boolean)attributedRun.getElementStyle(n, ElementAttribute.isGlyph);
            if (bl2) {
                n3 = glyphFormatter.format(attributedRun, n, n4, bl);
            } else {
                int n5 = (Integer)attributedRun.getElementStyle(n, scriptAttribute);
                n3 = scriptFormatters[n5].format(attributedRun, n, n4, bl);
            }
            n = n3;
            n2 += n3 - n4;
        }
        return n2;
    }

    static {
        GenericFormatter genericFormatter = new GenericFormatter();
        for (int i = 0; i < scriptFormatters.length; ++i) {
            InFontFormatter.scriptFormatters[i] = genericFormatter;
        }
        InFontFormatter.scriptFormatters[2] = new ArabicFormatter();
        InFontFormatter.scriptFormatters[4] = new BengaliFormatter();
        InFontFormatter.scriptFormatters[10] = new DevanagariFormatter();
        InFontFormatter.scriptFormatters[15] = new GujaratiFormatter();
        InFontFormatter.scriptFormatters[16] = new GurmukhiFormatter();
        InFontFormatter.scriptFormatters[18] = new HangulFormatter();
        InFontFormatter.scriptFormatters[21] = new KannadaFormatter();
        InFontFormatter.scriptFormatters[24] = new LaoFormatter();
        InFontFormatter.scriptFormatters[31] = new OriyaFormatter();
        InFontFormatter.scriptFormatters[35] = new TamilFormatter();
        InFontFormatter.scriptFormatters[36] = new TeluguFormatter();
        InFontFormatter.scriptFormatters[38] = new ThaiFormatter();
        InFontFormatter.scriptFormatters[39] = new TibetanFormatter();
        HanKanaFormatter hanKanaFormatter = new HanKanaFormatter();
        InFontFormatter.scriptFormatters[20] = hanKanaFormatter;
        InFontFormatter.scriptFormatters[22] = hanKanaFormatter;
        InFontFormatter.scriptFormatters[54] = hanKanaFormatter;
        InFontFormatter.scriptFormatters[17] = hanKanaFormatter;
        scriptAttribute = new ElementAttribute("script");
        typographicSystem = new HashSet();
        typographicSystem.add(scriptAttribute);
        typographicSystem.add(ElementAttribute.locale);
        typographicSystem.add(ElementAttribute.isGlyph);
        fontAtts = new HashSet();
        fontAtts.add(ElementAttribute.font);
    }
}

