/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.parser;

import java.util.Iterator;
import macromedia.asc.parser.AttributeListNode;
import macromedia.asc.parser.Evaluator;
import macromedia.asc.parser.ExpressionStatementNode;
import macromedia.asc.parser.LoadRegisterNode;
import macromedia.asc.parser.Node;
import macromedia.asc.semantics.ObjectValue;
import macromedia.asc.semantics.Value;
import macromedia.asc.util.BitSet;
import macromedia.asc.util.Context;
import macromedia.asc.util.ObjectList;

public class StatementListNode
extends Node {
    public ObjectList<Node> items = new ObjectList(5);
    public boolean dominates_program_endpoint = false;
    public boolean was_empty = false;
    public boolean is_loop = false;
    public ObjectValue default_namespace;
    public AttributeListNode config_attrs;

    public StatementListNode(Node node) {
        if (node != null) {
            this.items.add(node);
        }
    }

    public Value evaluate(Context context, Evaluator evaluator) {
        if (evaluator.checkFeature(context, this)) {
            return evaluator.evaluate(context, this);
        }
        return null;
    }

    public Node first() {
        return this.items.isEmpty() ? null : this.items.first();
    }

    public int countVars() {
        int n = 0;
        Iterator iterator = this.items.iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            if (node == null) continue;
            n += node.countVars();
        }
        return n;
    }

    public Node last() {
        return this.items.isEmpty() ? null : this.items.last();
    }

    public BitSet getGenBits() {
        BitSet bitSet = null;
        Iterator iterator = this.items.iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            bitSet = BitSet.reset_set(bitSet, node.getKillBits(), node.getGenBits());
        }
        return bitSet;
    }

    public BitSet getKillBits() {
        BitSet bitSet = null;
        Iterator iterator = this.items.iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            bitSet = BitSet.reset_set(bitSet, node.getGenBits(), node.getKillBits());
        }
        return bitSet;
    }

    public boolean isStatementList() {
        return true;
    }

    public String toString() {
        return this.items.last().toString();
    }

    public boolean definesCV() {
        Iterator iterator = this.items.iterator();
        while (iterator.hasNext()) {
            ExpressionStatementNode expressionStatementNode;
            Node node = (Node)iterator.next();
            if (!node.isExpressionStatement() || (expressionStatementNode = (ExpressionStatementNode)node).isVarStatement()) continue;
            return true;
        }
        return false;
    }

    public void voidResult() {
        Iterator iterator = this.items.iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            node.voidResult();
        }
        if (this.items.last() instanceof LoadRegisterNode) {
            ((LoadRegisterNode)this.items.last()).void_result = true;
        }
    }
}

