/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;

public class SetUtils {
    public static final Set EMPTY_SET = Collections.EMPTY_SET;
    public static final SortedSet EMPTY_SORTED_SET = Collections.unmodifiableSortedSet(new TreeSet());

    public static Set synchronizedSet(Set set) {
        return Collections.synchronizedSet(set);
    }

    public static Set unmodifiableSet(Set set) {
        return Collections.unmodifiableSet(set);
    }

    public static Set predicatedSet(Set set, Predicate predicate) {
        return new PredicatedSet(set, predicate);
    }

    public static SortedSet synchronizedSortedSet(SortedSet set) {
        return Collections.synchronizedSortedSet(set);
    }

    public static SortedSet unmodifiableSortedSet(SortedSet set) {
        return Collections.unmodifiableSortedSet(set);
    }

    public static SortedSet predicatedSortedSet(SortedSet set, Predicate predicate) {
        return new PredicatedSortedSet(set, predicate);
    }

    static class PredicatedSortedSet
    extends PredicatedSet
    implements SortedSet {
        public PredicatedSortedSet(SortedSet set, Predicate predicate) {
            super(set, predicate);
        }

        public SortedSet subSet(Object o1, Object o2) {
            SortedSet<Object> sub = this.getSortedSet().subSet(o1, o2);
            return new PredicatedSortedSet(sub, this.predicate);
        }

        public SortedSet headSet(Object o1) {
            SortedSet<Object> sub = this.getSortedSet().headSet(o1);
            return new PredicatedSortedSet(sub, this.predicate);
        }

        public SortedSet tailSet(Object o1) {
            SortedSet<Object> sub = this.getSortedSet().tailSet(o1);
            return new PredicatedSortedSet(sub, this.predicate);
        }

        public Object first() {
            return this.getSortedSet().first();
        }

        public Object last() {
            return this.getSortedSet().last();
        }

        public Comparator comparator() {
            return this.getSortedSet().comparator();
        }

        private SortedSet getSortedSet() {
            return (SortedSet)this.collection;
        }
    }

    static class PredicatedSet
    extends CollectionUtils.PredicatedCollection
    implements Set {
        public PredicatedSet(Set set, Predicate predicate) {
            super(set, predicate);
        }
    }
}

