/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.transcoder.image;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.RenderedImage;
import java.awt.image.SinglePixelPackedSampleModel;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.batik.ext.awt.image.codec.PNGEncodeParam;
import org.apache.batik.ext.awt.image.codec.PNGImageEncoder;
import org.apache.batik.ext.awt.image.rendered.IndexImage;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.TranscodingHints;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.transcoder.image.resources.Messages;
import org.apache.batik.transcoder.keys.FloatKey;
import org.apache.batik.transcoder.keys.IntegerKey;

public class PNGTranscoder
extends ImageTranscoder {
    public static final TranscodingHints.Key KEY_GAMMA = new FloatKey();
    public static final float[] DEFAULT_CHROMA = new float[]{0.3127f, 0.329f, 0.64f, 0.33f, 0.3f, 0.6f, 0.15f, 0.06f};
    public static final TranscodingHints.Key KEY_INDEXED = new IntegerKey();

    public PNGTranscoder() {
        this.hints.put(KEY_FORCE_TRANSPARENT_WHITE, Boolean.FALSE);
    }

    public BufferedImage createImage(int width, int height) {
        return new BufferedImage(width, height, 2);
    }

    public void writeImage(BufferedImage img, TranscoderOutput output) throws TranscoderException {
        PNGEncodeParam params;
        OutputStream ostream = output.getOutputStream();
        if (ostream == null) {
            throw new TranscoderException(Messages.formatMessage("png.badoutput", null));
        }
        boolean forceTransparentWhite = false;
        if (this.hints.containsKey(KEY_FORCE_TRANSPARENT_WHITE)) {
            forceTransparentWhite = (Boolean)this.hints.get(KEY_FORCE_TRANSPARENT_WHITE);
        }
        if (forceTransparentWhite) {
            int w = img.getWidth();
            int h = img.getHeight();
            DataBufferInt biDB = (DataBufferInt)img.getRaster().getDataBuffer();
            int scanStride = ((SinglePixelPackedSampleModel)img.getSampleModel()).getScanlineStride();
            int dbOffset = biDB.getOffset();
            int[] pixels = biDB.getBankData()[0];
            int p = dbOffset;
            int adjust = scanStride - w;
            int a = 0;
            int r = 0;
            int g = 0;
            int b = 0;
            int pel = 0;
            for (int i = 0; i < h; ++i) {
                for (int j = 0; j < w; ++j) {
                    pel = pixels[p];
                    a = pel >> 24 & 0xFF;
                    r = pel >> 16 & 0xFF;
                    g = pel >> 8 & 0xFF;
                    b = pel & 0xFF;
                    r = (255 * (255 - a) + a * r) / 255;
                    g = (255 * (255 - a) + a * g) / 255;
                    b = (255 * (255 - a) + a * b) / 255;
                    pixels[p++] = a << 24 & 0xFF000000 | r << 16 & 0xFF0000 | g << 8 & 0xFF00 | b & 0xFF;
                }
                p += adjust;
            }
        }
        int n = -1;
        if (this.hints.containsKey(KEY_INDEXED) && ((n = ((Integer)this.hints.get(KEY_INDEXED)).intValue()) == 1 || n == 2 || n == 4 || n == 8)) {
            img = IndexImage.getIndexedImage((BufferedImage)img, (int)(1 << n));
        }
        if ((params = PNGEncodeParam.getDefaultEncodeParam((RenderedImage)img)) instanceof PNGEncodeParam.RGB) {
            ((PNGEncodeParam.RGB)params).setBackgroundRGB(new int[]{255, 255, 255});
        }
        if (this.hints.containsKey(KEY_GAMMA)) {
            float gamma = ((Float)this.hints.get(KEY_GAMMA)).floatValue();
            if (gamma > 0.0f) {
                params.setGamma(gamma);
            }
            params.setChromaticity(DEFAULT_CHROMA);
        } else {
            params.setSRGBIntent(0);
        }
        float PixSzMM = this.userAgent.getPixelUnitToMillimeter();
        int numPix = (int)((double)(1000.0f / PixSzMM) + 0.5);
        params.setPhysicalDimension(numPix, numPix, 1);
        try {
            PNGImageEncoder pngEncoder = new PNGImageEncoder(ostream, params);
            pngEncoder.encode((RenderedImage)img);
            ostream.flush();
        }
        catch (IOException ex) {
            throw new TranscoderException(ex);
        }
    }
}

