/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.io;

import com.adobe.internal.io.ByteWriter;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;

public class ByteBufferByteWriter
implements ByteWriter {
    private ByteBuffer buffer;

    public ByteBufferByteWriter(ByteBuffer buffer) throws IOException {
        this.buffer = buffer;
    }

    public ByteBufferByteWriter(byte[] b) throws IOException {
        this(ByteBuffer.wrap(b));
    }

    public void write(long position, byte[] b, int offset, int length) throws IOException {
        try {
            if (position > Integer.MAX_VALUE) {
                throw new IndexOutOfBoundsException("Attempt to position beyond the buffer size.");
            }
            this.buffer.position((int)position);
            this.buffer.put(b, offset, length);
        }
        catch (BufferOverflowException e) {
            IOException exception = new IOException();
            exception.initCause(e);
            throw exception;
        }
        catch (IndexOutOfBoundsException e) {
            IOException exception = new IOException();
            exception.initCause(e);
            throw exception;
        }
        catch (ReadOnlyBufferException e) {
            IOException exception = new IOException();
            exception.initCause(e);
            throw exception;
        }
    }

    public void write(long position, int b) throws IOException {
        try {
            if (position > Integer.MAX_VALUE) {
                throw new IndexOutOfBoundsException("Attempt to position beyond the buffer size.");
            }
            this.buffer.put((int)position, (byte)b);
        }
        catch (BufferOverflowException e) {
            IOException exception = new IOException();
            exception.initCause(e);
            throw exception;
        }
        catch (IndexOutOfBoundsException e) {
            IOException exception = new IOException();
            exception.initCause(e);
            throw exception;
        }
        catch (ReadOnlyBufferException e) {
            IOException exception = new IOException();
            exception.initCause(e);
            throw exception;
        }
    }

    public long length() throws IOException {
        return this.buffer.limit();
    }

    public void flush() throws IOException {
    }

    public void close() throws IOException {
        this.buffer = null;
    }

    public String toString() {
        return this.buffer.toString();
    }

    public int read(long position) throws IOException {
        if (position < 0L || position >= (long)this.buffer.limit()) {
            return -1;
        }
        return this.buffer.get((int)position) & 0xFF;
    }

    public int read(long position, byte[] b, int offset, int length) throws IOException {
        if (position < 0L || position >= (long)this.buffer.limit()) {
            return -1;
        }
        this.buffer.position((int)position);
        length = (int)Math.min((long)length, (long)this.buffer.limit() - position);
        this.buffer.get(b, offset, length);
        return length;
    }
}

