/*
 * Decompiled with CFR 0.152.
 */
package flex.webtier.server.j2ee;

import flash.localization.ILocalizer;
import flash.localization.LocalizationManager;
import flash.localization.ResourceBundleLocalizer;
import flash.localization.XLRLocalizer;
import flex.webtier.server.j2ee.BaseCompileFilter;
import flex.webtier.server.j2ee.CompileAgentServlet;
import flex.webtier.server.j2ee.CompileFilter;
import flex.webtier.server.j2ee.DetectionSettingsFactory;
import flex.webtier.server.j2ee.HistorySettingsFactory;
import flex.webtier.server.j2ee.HttpCache;
import flex.webtier.server.j2ee.IncrementalCompileFilter;
import flex.webtier.server.j2ee.MxmlContext;
import flex.webtier.server.j2ee.MxmlFilter;
import flex.webtier.server.j2ee.PathExistsFilter;
import flex.webtier.server.j2ee.RecompileFilter;
import flex.webtier.server.j2ee.RenderFilter;
import flex.webtier.server.j2ee.ServletPathResolver;
import flex.webtier.services.ServiceFactory;
import flex.webtier.services.VersionInfo;
import flex.webtier.services.extensions.ExtensionManager;
import flex.webtier.services.license.LicenseService;
import flex.webtier.util.PathResolver;
import flex.webtier.util.ServiceUtil;
import flex.webtier.util.ServletUtils;
import flex2.compiler.common.LocalFilePathResolver;
import flex2.compiler.common.SinglePathResolver;
import flex2.compiler.util.ThreadLocalToolkit;
import flex2.compiler.util.URLPathResolver;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.LogFactory;

public class MxmlServlet
extends CompileAgentServlet {
    static final long serialVersionUID = -714667980223685920L;
    private ServiceFactory serviceImpl;
    private MxmlFilter filterChain;
    private MxmlFilter objectFilterChain;
    private String swfExt;
    private boolean logCompilerErrors;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.serviceImpl = ServiceUtil.setupFlexService(this.getServletContext(), servletConfig);
        LicenseService license = ServiceFactory.getLicenseService();
        if (license.isBetaExpired()) {
            this.log(license.expiredMessage());
            throw new ServletException(license.expiredMessage());
        }
        String message = "Starting Adobe Flex Web Tier Compiler";
        if (license.getBetaRemainingMessage() != null) {
            message = message + license.getBetaRemainingMessage();
        }
        this.log(message);
        this.log(VersionInfo.buildMessage());
        this.initializeExtensions();
        this.filterChain = this.createFilterChain();
        this.objectFilterChain = this.createObjectFilterChain();
        this.logCompilerErrors = ServiceFactory.getConfigurator().getServerConfiguration().getDebuggingConfiguration().logCompilerErrors();
    }

    public void destroy() {
        LogFactory.releaseAll();
        if (this.serviceImpl != null) {
            this.serviceImpl.stop();
        }
        super.destroy();
    }

    private void initializeExtensions() {
        ExtensionManager extensionManager = ServiceFactory.getExtensionManager();
        this.swfExt = extensionManager.getSwfExt();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            request.setCharacterEncoding("UTF-8");
            MxmlContext context = new MxmlContext();
            context.setRequest(request);
            context.setResponse(response);
            context.setServletContext(this.getServletContext());
            context.setPageTitle(request.getServletPath());
            this.setupMxmlContextKeys(this.getServletContext(), context, request);
            context.setDetectionSettings(DetectionSettingsFactory.getInstance(request.getContextPath()));
            context.setHistorySettings(HistorySettingsFactory.getInstance(request.getContextPath()));
            ServiceFactory.setThreadLocalLicense((String)request.getAttribute("flexbuilder3"));
            if (!ServiceFactory.getLicenseService().isMxmlCompileEnabled()) {
                response.sendError(481, "The current license does not support this feature.");
                ServiceFactory.getLogger().logError("The current license does not support this feature. request=" + request.getServletPath());
                return;
            }
            if (this.isObjectRequest(request)) {
                if (request.getParameter("w") != null) {
                    context.setWidth(request.getParameter("w"));
                } else {
                    context.setWidth("100%");
                }
                if (request.getParameter("h") != null) {
                    context.setHeight(request.getParameter("h"));
                } else {
                    context.setHeight("100%");
                }
                this.objectFilterChain.invoke(context);
            } else {
                PathResolver.setThreadLocalPathResolver(new flex.webtier.util.ServletPathResolver(this.getServletContext()));
                flex2.compiler.common.PathResolver resolver = new flex2.compiler.common.PathResolver();
                resolver.addSinglePathResolver((SinglePathResolver)new ServletPathResolver(this.getServletContext()));
                resolver.addSinglePathResolver((SinglePathResolver)LocalFilePathResolver.getSingleton());
                resolver.addSinglePathResolver((SinglePathResolver)URLPathResolver.getSingleton());
                ThreadLocalToolkit.setPathResolver((flex2.compiler.common.PathResolver)resolver);
                LocalizationManager localizationManager = new LocalizationManager();
                localizationManager.addLocalizer((ILocalizer)new XLRLocalizer());
                localizationManager.addLocalizer((ILocalizer)new ResourceBundleLocalizer());
                ThreadLocalToolkit.setLocalizationManager((LocalizationManager)localizationManager);
                this.setupCompileEventLogger(context, request);
                this.setupSourceCodeLoader(context);
                this.filterChain.invoke(context);
            }
        }
        catch (FileNotFoundException fnfe) {
            HttpCache.setCacheHeaders(false, 0L, -1L, response);
            response.sendError(404, fnfe.getMessage());
            if (this.logCompilerErrors) {
                ServiceFactory.getLogger().logError(fnfe.getMessage(), fnfe);
            }
        }
        catch (Throwable t) {
            ServiceFactory.getLogger().logError("Unknown error " + request.getServletPath() + ": " + t.getMessage(), t);
            throw new ServletException(t);
        }
        finally {
            ServletUtils.clearThreadLocals();
        }
    }

    private boolean isObjectRequest(HttpServletRequest request) {
        return request.getParameter("objectWrapperJs") != null;
    }

    private MxmlFilter createFilterChain() {
        PathExistsFilter pathExistsFilter = new PathExistsFilter();
        RecompileFilter recompileFilter = new RecompileFilter();
        BaseCompileFilter compileFilter = ServiceFactory.getConfigurator().getServerConfiguration().isIncrementalCompile() ? new IncrementalCompileFilter(this.swfExt) : new CompileFilter(this.swfExt);
        RenderFilter renderFilter = new RenderFilter();
        pathExistsFilter.setNext(recompileFilter);
        recompileFilter.setNext(compileFilter);
        compileFilter.setNext(renderFilter);
        return pathExistsFilter;
    }

    private MxmlFilter createObjectFilterChain() {
        RenderFilter renderFilter = new RenderFilter();
        return renderFilter;
    }
}

