/*
 * Decompiled with CFR 0.152.
 */
package flex.webtier.server.j2ee;

import flash.swf.Movie;
import flex.webtier.server.j2ee.MxmlContext;
import flex.webtier.server.j2ee.MxmlFilter;
import flex.webtier.server.j2ee.SWFInfo;
import flex.webtier.server.j2ee.cache.CacheHelper;
import flex.webtier.server.j2ee.events.CompileEvent;
import flex.webtier.services.config.ServerConfiguration;
import flex.webtier.util.Trace;
import flex2.compiler.AssetInfo;
import flex2.compiler.CompilationUnit;
import flex2.compiler.CompilerException;
import flex2.compiler.io.FileUtil;
import flex2.compiler.io.InMemoryFile;
import flex2.compiler.io.VirtualFile;
import flex2.linker.LinkerException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class BaseCompileFilter
extends MxmlFilter {
    protected String swfExt;
    static final /* synthetic */ boolean $assertionsDisabled;

    public BaseCompileFilter(String swfExt) {
        this.swfExt = swfExt;
    }

    public void invoke(MxmlContext context) throws Throwable {
        if (!context.hasErrors()) {
            try {
                byte[] swfBuffer = this.mxmlToSwf(context.getSourceFileName(), context);
                if (swfBuffer.length > 0) {
                    context.setSwfBuffer(swfBuffer);
                }
            }
            catch (LinkerException le) {
                if (!context.hasErrors()) {
                    context.addEvent(new CompileEvent(le));
                }
            }
            catch (CompilerException ce) {
                if (!context.hasErrors()) {
                    context.addEvent(new CompileEvent(ce));
                }
            }
            catch (Throwable t) {
                context.addEvent(new CompileEvent(t));
            }
        }
        if (this.next != null) {
            this.next.invoke(context);
        }
    }

    protected abstract SWFInfo compileMxml(SWFInfo var1, String var2, MxmlContext var3, HashMap var4) throws Exception;

    private boolean isJspFile(String name) {
        boolean isJspFile = false;
        String path = name.replace('\\', '/');
        try {
            String base = path.substring(path.lastIndexOf(47) + 1);
            int idx = base.indexOf(46);
            if (idx >= 3 && (base = base.substring(3, idx)).length() == 32) {
                isJspFile = true;
                for (int i = 0; i < 32 && isJspFile; ++i) {
                    if (Character.isDigit(base.charAt(i)) || base.charAt(i) == 'A' || base.charAt(i) == 'B' || base.charAt(i) == 'C' || base.charAt(i) == 'D' || base.charAt(i) == 'E' || base.charAt(i) == 'F') continue;
                    isJspFile = false;
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return isJspFile;
    }

    protected void getDependenciesFromCompilationUnits(List units, HashMap dependencies) {
        int size = units.size();
        for (int i = 0; i < size; ++i) {
            CompilationUnit u = (CompilationUnit)units.get(i);
            String name = u.getSource().getRawLocation();
            long lastmod = u.getSource().getRawLastModified();
            if (lastmod != -1L) {
                if (!this.isJspFile(name)) {
                    lastmod -= lastmod % 1000L;
                    dependencies.put(name, new Long(lastmod));
                    if (Trace.cache) {
                        Trace.trace((String)("[cache] name = " + name + "; lastmod = " + lastmod));
                    }
                } else if (Trace.cache) {
                    Trace.trace((String)("[cache] skipping jsp file " + name));
                }
            } else if (Trace.cache) {
                Trace.trace((String)("[cache] skipping file " + name));
            }
            Iterator iter = u.getSource().getFileIncludes();
            while (iter.hasNext()) {
                try {
                    VirtualFile includeVirtual = (VirtualFile)iter.next();
                    String includeName = new URL(includeVirtual.getURL()).getFile();
                    if (includeVirtual instanceof InMemoryFile) {
                        if (!Trace.cache) continue;
                        Trace.trace((String)("[cache] skipping include file " + includeName));
                        continue;
                    }
                    if (includeName.equals("")) continue;
                    long includeMod = includeVirtual.getLastModified();
                    includeMod -= includeMod % 1000L;
                    dependencies.put(includeVirtual.getName(), new Long(includeMod));
                    if (!Trace.cache) continue;
                    Trace.trace((String)("[cache] includes = " + includeVirtual.getName() + "; lastmod = " + includeMod));
                }
                catch (MalformedURLException mue) {}
            }
            iter = u.getAssets().iterator();
            while (iter.hasNext()) {
                try {
                    Map.Entry asset = (Map.Entry)iter.next();
                    AssetInfo assetInfo = (AssetInfo)asset.getValue();
                    VirtualFile assetVirtual = assetInfo.getPath();
                    String assetName = new URL(assetVirtual.getURL()).getFile();
                    if (assetVirtual instanceof InMemoryFile) {
                        if (!Trace.cache) continue;
                        Trace.trace((String)("[cache] skipping asset file " + assetName));
                        continue;
                    }
                    if (assetName.equals("")) continue;
                    long includeMod = assetVirtual.getLastModified();
                    includeMod -= includeMod % 1000L;
                    dependencies.put(assetVirtual.getName(), new Long(includeMod));
                    if (!Trace.cache) continue;
                    Trace.trace((String)("[cache] assets = " + assetVirtual.getName() + "; lastmod = " + includeMod));
                }
                catch (MalformedURLException mue) {}
            }
        }
    }

    protected void getDependenciesFromConfiguration(ServerConfiguration configuration, HashMap dependencies) {
        Map configs = configuration.getFlexConfigConfiguration().getCompilerConfiguration().getServicesDependencies().getConfigPaths();
        Iterator iter = configs.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            long modified = (Long)entry.getValue();
            modified -= modified % 1000L;
            dependencies.put(entry.getKey(), new Long(modified));
            if (!Trace.cache) continue;
            Trace.trace((String)("[cache] name = " + entry.getKey() + "; lastmod = " + modified));
        }
    }

    protected void keepGenerated(ByteArrayOutputStream swf, File parentPath, File appPath) {
        block7: {
            if (!$assertionsDisabled && parentPath == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && appPath == null) {
                throw new AssertionError();
            }
            String name = appPath.getName();
            name = name.substring(0, name.lastIndexOf(46));
            if (swf != null) {
                FileOutputStream fos = null;
                try {
                    fos = new FileOutputStream(FileUtil.openFile((File)parentPath, (String)(name + this.swfExt)));
                    swf.writeTo(fos);
                }
                catch (IOException ioe) {
                    if (fos == null) break block7;
                    try {
                        fos.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        }
    }

    protected byte[] mxmlToSwf(String filename, MxmlContext context) throws Throwable {
        CacheHelper ch = CacheHelper.getInstance(context.getServletContext());
        String cacheKey = context.getCacheKey();
        ch.lockCache();
        try {
            SWFInfo swfInfo = ch.getFromCache(cacheKey);
            if (swfInfo != null) {
                this.copySwfInfoToContext(context, swfInfo);
                if (Trace.cache) {
                    Trace.trace((String)("[cache] swfinfo in content cache up-to-date; cache key = " + cacheKey));
                }
            }
            if (swfInfo == null) {
                if (Trace.cache) {
                    Trace.trace((String)("[cache] recompile swf; cache key = " + cacheKey));
                }
                context.setLogSwfEvents(true);
                swfInfo = new SWFInfo(context.getDependencyKey(), context.getServletContext(), context.getRequest());
                HashMap dependencies = new HashMap();
                this.compileMxml(swfInfo, filename, context, dependencies);
                this.copyContextToSwfInfo(context, swfInfo);
                ch.addToCache(cacheKey, swfInfo, dependencies);
            }
            context.setLastModifiedTime(swfInfo.getLastModified());
            return swfInfo.getSwfBuffer();
        }
        catch (Throwable t) {
            ch.unlockCache(cacheKey);
            ch.removeFromCache(cacheKey);
            throw t;
        }
    }

    protected void setHtmlWrapperAttributes(Movie movie, MxmlContext context) {
        if (movie.userSpecifiedHeight) {
            context.setHeight(new Integer(movie.height).toString());
        } else if (movie.heightPercent != null) {
            context.setHeight(movie.heightPercent);
        } else {
            context.setHeight("100%");
        }
        if (movie.userSpecifiedWidth) {
            context.setWidth(new Integer(movie.width).toString());
        } else if (movie.widthPercent != null) {
            context.setWidth(movie.widthPercent);
        } else {
            context.setWidth("100%");
        }
        if (movie.pageTitle != null) {
            context.setPageTitle(movie.pageTitle);
        }
        if (movie.bgcolor != null) {
            context.setBackgroundColor(movie.bgcolor.color);
        }
    }

    protected void copyContextToSwfInfo(MxmlContext context, SWFInfo swfInfo) {
        swfInfo.setPageTitle(context.getPageTitle());
        swfInfo.setWidth(context.getWidth());
        swfInfo.setHeight(context.getHeight());
        swfInfo.setBackgroundColor(context.getBackgroundColor());
        swfInfo.setCompileEvents(context.getEvents());
    }

    protected void copySwfInfoToContext(MxmlContext context, SWFInfo swfInfo) {
        context.setPageTitle(swfInfo.getPageTitle());
        context.setWidth(swfInfo.getWidth());
        context.setHeight(swfInfo.getHeight());
        context.setBackgroundColor(swfInfo.getBackgroundColor());
        context.setEvents(swfInfo.getCompileEvents());
    }

    static {
        $assertionsDisabled = !BaseCompileFilter.class.desiredAssertionStatus();
    }
}

