/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.db;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.transaction.Synchronization;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.LockMode;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.jbpm.JbpmException;
import org.jbpm.graph.def.Action;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.job.Job;
import org.jbpm.job.Timer;

public class JobSession {
    private Session session;
    private static Log log = LogFactory.getLog((Class)JobSession.class);

    public JobSession(Session session) {
        this.session = session;
    }

    public Job getFirstAcquirableJob(String lockOwner) {
        Job job = null;
        try {
            Query query = this.session.getNamedQuery("JobSession.getFirstAcquirableJob");
            query.setString("lockOwner", lockOwner);
            query.setTimestamp("now", new Date());
            query.setMaxResults(1);
            job = (Job)query.uniqueResult();
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new JbpmException("couldn't get acquirable jobs", e);
        }
        return job;
    }

    public List findExclusiveJobs(String lockOwner, ProcessInstance processInstance) {
        List jobs = null;
        try {
            Query query = this.session.getNamedQuery("JobSession.findExclusiveJobs");
            query.setString("lockOwner", lockOwner);
            query.setTimestamp("now", new Date());
            query.setParameter("processInstance", (Object)processInstance);
            jobs = query.list();
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new JbpmException("couldn't find exclusive jobs for thread '" + lockOwner + "' and process instance '" + processInstance + "'", e);
        }
        return jobs;
    }

    public Job getFirstDueJob(String lockOwner, Collection jobIdsToIgnore) {
        Job job = null;
        try {
            Query query = null;
            if (jobIdsToIgnore == null || jobIdsToIgnore.isEmpty()) {
                query = this.session.getNamedQuery("JobSession.getFirstDueJob");
                query.setString("lockOwner", lockOwner);
            } else {
                query = this.session.getNamedQuery("JobSession.getFirstDueJobExlcMonitoredJobs");
                query.setString("lockOwner", lockOwner);
                query.setParameterList("jobIdsToIgnore", jobIdsToIgnore);
            }
            query.setMaxResults(1);
            job = (Job)query.uniqueResult();
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new JbpmException("couldn't get acquirable jobs", e);
        }
        return job;
    }

    public void saveJob(Job job) {
        Timer timer;
        Action action;
        this.session.saveOrUpdate((Object)job);
        if (job instanceof Timer && (action = (timer = (Timer)job).getAction()) != null && !this.session.contains((Object)action)) {
            log.debug((Object)"cascading timer save to timer action");
            this.session.save((Object)action);
        }
    }

    public void reattachUnmodifiedJob(Job job) {
        this.session.lock((Object)job, LockMode.NONE);
    }

    public void deleteJob(Job job) {
        log.debug((Object)("deleting " + job));
        this.session.delete((Object)job);
    }

    public Job loadJob(long jobId) {
        try {
            return (Job)this.session.load(Job.class, (Serializable)new Long(jobId));
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new JbpmException("couldn't load job '" + jobId + "'", e);
        }
    }

    public Job getJob(long jobId) {
        try {
            return (Job)this.session.get(Job.class, (Serializable)new Long(jobId));
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new JbpmException("couldn't get job '" + jobId + "'", e);
        }
    }

    public void suspendJobs(Token token) {
        try {
            Query query = this.session.getNamedQuery("JobSession.suspendJobs");
            query.setParameter("token", (Object)token);
            query.executeUpdate();
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new JbpmException("couldn't suspend jobs for " + token, e);
        }
    }

    public void resumeJobs(Token token) {
        try {
            Query query = this.session.getNamedQuery("JobSession.resumeJobs");
            query.setParameter("token", (Object)token);
            query.executeUpdate();
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new JbpmException("couldn't resume jobs for " + token, e);
        }
    }

    public void cancelTimersByName(String name, Token token) {
        try {
            Query query = this.session.getNamedQuery("JobSession.getTimersByName");
            query.setString("name", name);
            query.setParameter("token", (Object)token);
            List results = query.list();
            if (results != null) {
                Iterator iter = results.iterator();
                while (iter.hasNext()) {
                    Timer timer = (Timer)iter.next();
                    log.debug((Object)("deleting timer " + timer + " by name " + name));
                    this.session.delete((Object)timer);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new JbpmException("couldn't cancel timers '" + name + "' for '" + token + "'", e);
        }
    }

    public void deleteJobsForProcessInstance(ProcessInstance processInstance) {
        try {
            Transaction transaction = this.session.getTransaction();
            transaction.registerSynchronization((Synchronization)new DeleteJobsSynchronization(processInstance));
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new JbpmException("couldn't delete jobs for '" + processInstance + "'", e);
        }
    }

    public List findJobsWithOverdueLockTime(Date treshold) {
        Query query = this.session.getNamedQuery("JobSession.findJobsWithOverdueLockTime");
        query.setDate("now", treshold);
        return query.list();
    }

    private class DeleteJobsSynchronization
    implements Synchronization,
    Serializable {
        private static final long serialVersionUID = 1L;
        ProcessInstance processInstance;

        public DeleteJobsSynchronization(ProcessInstance processInstance) {
            this.processInstance = processInstance;
        }

        public void beforeCompletion() {
            log.debug((Object)("deleting timers for process instance " + this.processInstance));
            Query query = JobSession.this.session.getNamedQuery("JobSession.deleteTimersForProcessInstance");
            query.setParameter("processInstance", (Object)this.processInstance);
            int result = query.executeUpdate();
            log.debug((Object)(Integer.toString(result) + " remaining timers for '" + this.processInstance + "' are deleted"));
            log.debug((Object)("deleting execute-node-jobs for process instance " + this.processInstance));
            query = JobSession.this.session.getNamedQuery("JobSession.deleteExecuteNodeJobsForProcessInstance");
            query.setParameter("processInstance", (Object)this.processInstance);
            result = query.executeUpdate();
            log.debug((Object)(Integer.toString(result) + " remaining execute-node-jobs for '" + this.processInstance + "' are deleted"));
        }

        public void afterCompletion(int arg0) {
        }
    }
}

