/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.util;

import com.adobe.internal.util.ByteSequence;
import com.adobe.internal.util.ByteString;
import java.io.Serializable;

public class ByteStringBuffer
implements ByteSequence,
Comparable,
Serializable {
    private byte[] value;
    private int length;
    private static final long serialVersionUID = -5059151845327279132L;

    public ByteStringBuffer() {
        this(16);
    }

    public ByteStringBuffer(int length) {
        this.value = new byte[length];
    }

    public byte byteAt(int index) {
        if (index < 0 || index >= this.length) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return this.value[index];
    }

    public int length() {
        return this.length;
    }

    public ByteSequence subSequence(int start, int end) {
        return null;
    }

    public ByteString substring(int begin, int end) {
        if (begin < 0) {
            throw new StringIndexOutOfBoundsException(begin);
        }
        if (end > this.length) {
            throw new StringIndexOutOfBoundsException(end);
        }
        if (begin > end) {
            throw new StringIndexOutOfBoundsException(end - begin);
        }
        return new ByteString(this.value, begin, end - begin);
    }

    public void getBytes(int srcBegin, int srcEnd, byte[] dst, int dstBegin) {
        try {
            System.arraycopy(this.value, srcBegin, dst, dstBegin, srcEnd - srcBegin);
        }
        catch (IndexOutOfBoundsException e) {
            StringIndexOutOfBoundsException newException = new StringIndexOutOfBoundsException();
            newException.initCause(e);
            throw newException;
        }
    }

    public byte[] getBytes() {
        byte[] array = new byte[this.length];
        System.arraycopy(this.value, 0, array, 0, this.length);
        return array;
    }

    public void setByteAt(int index, byte b) {
        if (index < 0 || index >= this.length) {
            throw new StringIndexOutOfBoundsException(index);
        }
        this.value[index] = b;
    }

    public ByteStringBuffer append(byte b) {
        int newLength = this.length + 1;
        if (newLength > this.value.length) {
            this.expandCapacity(newLength);
        }
        this.value[this.length++] = b;
        return this;
    }

    public ByteStringBuffer append(byte[] b) {
        return this.append(b, 0, b.length);
    }

    public ByteStringBuffer append(byte[] b, int offset, int length) {
        if (offset < 0 || length < 0 || offset + length > b.length) {
            throw new IndexOutOfBoundsException("Byte array index out of bounds.");
        }
        int newLength = this.length + length;
        if (newLength > this.value.length) {
            this.expandCapacity(newLength);
        }
        System.arraycopy(this.value, this.length, b, offset, length);
        this.length += length;
        return this;
    }

    public void ensureCapacity(int minimumCapacity) {
        if (minimumCapacity > this.value.length) {
            this.expandCapacity(minimumCapacity);
        }
    }

    private void expandCapacity(int minimumCapacity) {
        int newCapacity = (this.value.length + 1) * 2;
        if (newCapacity < 0) {
            newCapacity = Integer.MAX_VALUE;
        } else if (minimumCapacity > newCapacity) {
            newCapacity = minimumCapacity;
        }
        byte[] newValue = new byte[newCapacity];
        System.arraycopy(this.value, 0, newValue, 0, this.length);
        this.value = newValue;
    }

    public int compareTo(Object otherObject) {
        return this.compareTo((ByteStringBuffer)otherObject);
    }

    public int compareTo(ByteStringBuffer otherByteString) {
        int count = Math.min(this.length, otherByteString.length);
        for (int i = 0; i < count; ++i) {
            byte b1 = this.value[i];
            byte b2 = otherByteString.value[i];
            if (b1 == b2) continue;
            return b1 - b2;
        }
        return this.length - otherByteString.length;
    }

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject instanceof ByteStringBuffer) {
            return this.compareTo(otherObject) == 0;
        }
        return false;
    }
}

