/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.inlineformatting.css20;

import com.adobe.agl.util.ULocale;
import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontData;
import com.adobe.fontengine.font.FontException;
import com.adobe.fontengine.font.FontImpl;
import com.adobe.fontengine.inlineformatting.AttributedRun;
import com.adobe.fontengine.inlineformatting.ElementAttribute;
import com.adobe.fontengine.inlineformatting.FallbackFontSet;
import com.adobe.fontengine.inlineformatting.FontStyle;
import com.adobe.fontengine.inlineformatting.FormattingException;
import com.adobe.fontengine.inlineformatting.NoSuitableFontException;
import com.adobe.fontengine.inlineformatting.TypographicCase;
import com.adobe.fontengine.inlineformatting.css20.CSS20Attribute;
import com.adobe.fontengine.inlineformatting.css20.CSS20FontDatabase;
import com.adobe.fontengine.inlineformatting.css20.CSS20FontSet;
import com.adobe.fontengine.inlineformatting.infontformatting.InFontFormatter;
import java.util.List;

public final class CSS20FontSelector {
    private final CSS20FontDatabase fontDB;

    public CSS20FontSelector(CSS20FontSet cSS20FontSet) {
        this.fontDB = (CSS20FontDatabase)cSS20FontSet;
    }

    public int format(AttributedRun attributedRun, int n, int n2) throws FormattingException {
        Font font = null;
        FontData fontData = null;
        while (n < n2) {
            int n3;
            CSS20Attribute cSS20Attribute = (CSS20Attribute)attributedRun.getElementStyle(n, ElementAttribute.CSS20Attribute);
            SelectedFont selectedFont = null;
            try {
                selectedFont = this.selectFont(cSS20Attribute, attributedRun, n, n2, font, fontData);
            }
            catch (FontException fontException) {
                throw new FormattingException("Font problem found during formatting", (Throwable)fontException, n, n2);
            }
            int n4 = n3 = selectedFont.count == 0 ? 1 : selectedFont.count;
            if (selectedFont.font == null) {
                throw new NoSuitableFontException("Unable to select font for character U+" + Integer.toHexString(attributedRun.elementAt(n)) + " '" + (char)attributedRun.elementAt(n) + "'", n, n + n3);
            }
            font = selectedFont.font;
            fontData = selectedFont.fontData;
            attributedRun.setElementStyle(n, n + n3, ElementAttribute.font, selectedFont.font);
            attributedRun.setElementStyle(n, n + n3, ElementAttribute.pointSize, new Double(cSS20Attribute.getPointSize()));
            CSS20Attribute.CSSStyleValue cSSStyleValue = cSS20Attribute.getStyle();
            attributedRun.setElementStyle(n, n + n3, ElementAttribute.fontStyle, cSSStyleValue == CSS20Attribute.CSSStyleValue.ITALIC ? FontStyle.ITALIC : (cSSStyleValue == CSS20Attribute.CSSStyleValue.OBLIQUE ? FontStyle.OBLIQUE : FontStyle.NORMAL));
            attributedRun.setElementStyle(n, n + n3, ElementAttribute.typographicCase, cSS20Attribute.getVariant() == CSS20Attribute.CSSVariantValue.SMALL_CAPS ? TypographicCase.SMALLCAPS : TypographicCase.TEXT);
            n += n3;
        }
        return n2;
    }

    private SelectedFont selectFont(CSS20Attribute cSS20Attribute, AttributedRun attributedRun, int n, int n2, Font font, FontData fontData) throws FontException {
        int n3;
        FontData fontData2;
        Object object;
        Object object2;
        List list = cSS20Attribute.getFamilyNamesList();
        this.fontDB.replaceGenericFontFamily(list);
        for (int i = 0; i < list.size(); ++i) {
            object2 = (String)list.get(i);
            object = this.fontDB.findFont((String)object2, cSS20Attribute);
            if (object == null) continue;
            for (int j = 0; j < ((Object)object).length; ++j) {
                try {
                    fontData2 = object[j] == font ? fontData : ((FontImpl)object[j]).getFontData();
                    n3 = InFontFormatter.canRenderWithFont(fontData2, attributedRun, n, n2);
                    if (n3 == 0) continue;
                    return new SelectedFont((Font)object[j], n3, fontData2);
                }
                catch (FontException fontException) {
                    fontException.initFont((Font)object[j]);
                    throw fontException;
                }
            }
        }
        ULocale uLocale = (ULocale)attributedRun.getElementStyle(n, ElementAttribute.locale);
        object2 = this.fontDB.getFallbackFontSet();
        object = ((FallbackFontSet)object2).getFallbackFonts(uLocale);
        while (object.hasNext()) {
            Font font2 = (Font)object.next();
            fontData2 = font2 == font ? fontData : ((FontImpl)font2).getFontData();
            try {
                n3 = InFontFormatter.canRenderWithFont(fontData2, attributedRun, n, n2);
            }
            catch (FontException fontException) {
                fontException.initFont(font2);
                throw fontException;
            }
            if (n3 != 0) {
                return new SelectedFont(font2, n3, fontData2);
            }
            if (object.hasNext()) continue;
            return new SelectedFont(font2, InFontFormatter.canRenderWithNotdef(attributedRun, n, n2), fontData2);
        }
        return new SelectedFont(null, 0, null);
    }

    private static final class SelectedFont {
        final Font font;
        final int count;
        final FontData fontData;

        public SelectedFont(Font font, int n, FontData fontData) {
            this.font = font;
            this.count = n;
            this.fontData = fontData;
        }
    }
}

