/*
 * Decompiled with CFR 0.152.
 */
package flex.webtier.server.j2ee;

import flash.util.StringUtils;
import flex.webtier.compiler.ConfigConstants;
import flex.webtier.server.j2ee.filemanager.DetectionFileManager;
import flex.webtier.server.j2ee.html.DetectionSettings;
import flex.webtier.services.ServiceFactory;
import flex.webtier.services.config.FlashPlayerConfiguration;
import flex.webtier.services.config.ServerConfiguration;

public class DetectionSettingsFactory
implements ConfigConstants {
    private static DetectionSettings ds;

    public static DetectionSettings getInstance(String contextRoot) {
        if (ds == null) {
            ds = DetectionSettingsFactory.setupDefaultDetectionSettings(contextRoot);
        }
        return ds;
    }

    protected static DetectionSettings setupDefaultDetectionSettings(String contextRoot) {
        String secureAlternateContentPage;
        DetectionSettings defaultDetectionSettings = new DetectionSettings();
        String jsUri = StringUtils.substitute((String)(DetectionFileManager.DETECTION_URI + "?action=" + DetectionFileManager.DETECTION_ACTION_JS), (String)"{context.root}", (String)contextRoot);
        defaultDetectionSettings.setTagsJavascript(jsUri);
        String swfUri = StringUtils.substitute((String)(DetectionFileManager.DETECTION_URI + "?action=" + DetectionFileManager.DETECTION_ACTION_SWF), (String)"{context.root}", (String)contextRoot);
        defaultDetectionSettings.setSwfUri(swfUri);
        ServerConfiguration configurator = ServiceFactory.getConfigurator().getServerConfiguration();
        FlashPlayerConfiguration config = configurator.getFlashPlayerConfiguration();
        defaultDetectionSettings.setEnabled(config.usePlayerDetection());
        defaultDetectionSettings.setUseExpressInstall(config.useExpressInstall());
        defaultDetectionSettings.setMajorVersion(config.requiredMajorVersion());
        defaultDetectionSettings.setMinorVersion(config.requiredMinorVersion());
        defaultDetectionSettings.setVersionRevision(config.requiredVersionRevision());
        String alternateContentPage = config.alternateContentPage();
        if (alternateContentPage != null) {
            alternateContentPage = StringUtils.substitute((String)alternateContentPage, (String)"{context.root}", (String)contextRoot);
        }
        if ((secureAlternateContentPage = config.secureAlternateContentPage()) != null) {
            secureAlternateContentPage = StringUtils.substitute((String)secureAlternateContentPage, (String)"{context.root}", (String)contextRoot);
        }
        defaultDetectionSettings.setAlternateContentPage(alternateContentPage);
        defaultDetectionSettings.setSecureAlternateContentPage(secureAlternateContentPage);
        defaultDetectionSettings.setAlternateContentInclude(config.alternateContentInclude());
        defaultDetectionSettings.setSecureAlternateContentInclude(config.secureAlternateContentInclude());
        return defaultDetectionSettings;
    }
}

