/* Copyright 2008 we-lab-doc! (http://www.we-lab-doc.com/)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.we_lab_doc.spacecard.utils

import org.springframework.web.context.request.RequestContextHolder as RCH
import org.springframework.web.context.WebApplicationContext
import org.springframework.web.context.support.WebApplicationContextUtils
import org.codehaus.groovy.grails.web.context.ServletContextHolder

/**
 * @author Shigeru GOUGI
 * @since 0.1
 *        <p/>
 *        Created: February 19, 2008
 */ 
class BeanUtils {
	private BeanUtils(){}
	
	static def getApplicationContext() {
		def webRequest = RCH.currentRequestAttributes()
		def appCtx = webRequest.attributes.applicationContext
		return appCtx
	}
	static def getBean(name) {
        if(name == null) return null
        def appCtx = getApplicationContext()
		return appCtx.getBean(name)
	}
	static def getBeanFromWebAppCtxIfExists(name) {
		def servletCtx = ServletContextHolder.getServletContext()
		if(servletCtx == null) {
			return getBean(name)
		}
		def webAppCtx = 
			WebApplicationContextUtils.getWebApplicationContext(
					servletCtx
	          )
	    return webAppCtx.getBean(name)		
	}
}