/* Copyright 2008 we-lab-doc! (http://www.we-lab-doc.com/)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import com.we_lab_doc.spacecard.ac.*
import com.we_lab_doc.spacecard.model.*
import com.we_lab_doc.spacecard.utils.*

/**
 * @author Shigeru GOUGI
 * @since 0.1
 *        <p/>
 *        Created: February 20, 2008
 */ 
class AccessControlService   {
	boolean transactional = false
	private User _loggedInUserForTesting = null
	
	// utils /////////////////////////////////////////////////////////////
	User getLoggedInUser() {
		if(_loggedInUserForTesting) return _loggedInUserForTesting
		User user = (User)accessControlManager.getLoggedInAuthUser()
		return user
	}
	String getAccountOfLoggedInUser() {
		return getLoggedInUser()?.account
	}
	def setLoggedInUserForTesting(User user){
		_loggedInUserForTesting = user
	}
	/// authentication ///////////////////////////////////////////////////
	boolean authenticate(String account, String password) {
		return accessControlManager.authenticate(account, password)
	}
	def unauthenticate() {
		accessControlManager.unauthenticate()
	}
	/// check ////////////////////////////////////////////////////////////
	boolean isLoggedIn() {
		return accessControlManager.isLoggedIn()
	}
	boolean isNotLoggedIn(){
		return !isLoggedIn()
	}
	boolean isLoggedInAsSupervisor() {
		def user = getLoggedInUser()
		return user.isSupervisor()
	}
	boolean isLoggedInAsAdmin(Organization org) {
		assert org != null
		def user = getLoggedInUser()
		return user.isAdmin(org)		
	}
	boolean isLoggedInAsUser(Organization org) {
		assert org != null
		def user = getLoggedInUser()
		return user.isUser(org)		
	}	
	/// permission //////////////////////////////////////////////////////
	def authorize(modelOrModels) {
		def user = getLoggedInUser()
		return authorize(user, modelOrModels)		
	}
	def authorize(User user, modelOrModels) {
		assert user != null
		if(modelOrModels == null) return null
		if(modelOrModels instanceof Collection) {
			def rtModels = []
			modelOrModels.each {
				if (it instanceof AccessControllable) {
					def ac = (AccessControllable)it
					if(accessControlManager.checkPermission(user, ac)){
						rtModels.add(it)
					}
				} else {
					rtModels.add(it)
				}
			}
			return rtModels
		} else {
			if (modelOrModels instanceof AccessControllable) {
				def ac = (AccessControllable)modelOrModels
				return accessControlManager.checkPermission(user, ac) ? modelOrModels : null   
			} else {
				return modelOrModels
			}
		}		
	}
	boolean checkPermission(User user, model) {
		assert user != null
		assert model != null
		if (model instanceof AccessControllable) {
			def ac = (AccessControllable)model
			return accessControlManager.checkPermission(user, ac)
		} else {
			return true
		}
	}
	boolean checkPermission(model) {
		def user = getLoggedInUser()
		return checkPermission(user, model)
	}
	///////////////////////////////////////////////////
	private getAccessControlManager(){
		return BeanUtils.getBean("accessControlManager")
	}
}





