/* Copyright 2008 we-lab-doc! (http://www.we-lab-doc.com/)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import org.apache.log4j.Logger
import com.we_lab_doc.spacecard.service.MailServiceExceptionReporter
import com.we_lab_doc.spacecard.bean.annotation.SpaceCardCustomBean
/**
 * @author Shigeru GOUGI
 * @since 0.1
 *        <p/>
 *        Created: February 24, 2008
 */ 
@SpaceCardCustomBean
class DefaultMailServiceExceptionReporter implements MailServiceExceptionReporter {
	static log = Logger.getLogger("com.we_lab_doc.spacecard.service.${DefaultMailServiceExceptionReporter.class.getSimpleName()}")
	void report(Map params, Exception e) {
		StringBuffer sb = new StringBuffer()
		sb.append("\n###### Error : MailService#send : " + new Date()).append("\n")
		sb.append(e).append("\n")
		sb.append("fromPerson : " + params.fromPerson).append("\n")
		sb.append("from: " + params.from).append("\n")
		sb.append("tos: " + params.tos).append("\n")
		sb.append("ccs: " + params.ccs).append("\n")
		sb.append("bccs: " + params.bccs).append("\n")
		sb.append("subject: " + params.subject).append("\n")
		sb.append("bodyText:\n" + params.bodyText).append("\n")
		sb.append("#########################\n")
		log.error(sb.toString())		
	}
}
