/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.CSSStyleSheetNode;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.svg.AttributeInitializer;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.svg.SVGOMElement;
import org.apache.batik.dom.svg.XMLBaseSupport;
import org.apache.batik.dom.util.XMLSupport;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.stylesheets.LinkStyle;
import org.w3c.dom.stylesheets.StyleSheet;
import org.w3c.dom.svg.SVGStyleElement;

public class SVGOMStyleElement
extends SVGOMElement
implements CSSStyleSheetNode,
SVGStyleElement,
LinkStyle {
    protected static final AttributeInitializer attributeInitializer = new AttributeInitializer(1);
    protected transient StyleSheet sheet;
    protected transient org.apache.batik.css.engine.StyleSheet styleSheet;
    protected transient EventListener domCharacterDataModifiedListener = new DOMCharacterDataModifiedListener();

    protected SVGOMStyleElement() {
    }

    public SVGOMStyleElement(String prefix, AbstractDocument owner) {
        super(prefix, owner);
    }

    public String getLocalName() {
        return "style";
    }

    public org.apache.batik.css.engine.StyleSheet getCSSStyleSheet() {
        if (this.styleSheet == null && this.getType().equals("text/css")) {
            SVGOMDocument doc = (SVGOMDocument)((Object)this.getOwnerDocument());
            CSSEngine e = doc.getCSSEngine();
            String text = "";
            Node n = this.getFirstChild();
            if (n != null) {
                StringBuffer sb = new StringBuffer();
                while (n != null) {
                    if (n.getNodeType() == 4 || n.getNodeType() == 3) {
                        sb.append(n.getNodeValue());
                    }
                    n = n.getNextSibling();
                }
                text = sb.toString();
            }
            URL burl = null;
            try {
                String bu = XMLBaseSupport.getCascadedXMLBase((Element)((Object)this));
                if (bu != null) {
                    burl = new URL(bu);
                }
            }
            catch (MalformedURLException ex) {
                ex.printStackTrace();
                throw new InternalError();
            }
            String media = this.getAttributeNS(null, "media");
            this.styleSheet = e.parseStyleSheet(text, burl, media);
            this.addEventListener("DOMCharacterDataModified", this.domCharacterDataModifiedListener, false);
        }
        return this.styleSheet;
    }

    public StyleSheet getSheet() {
        throw new RuntimeException(" !!! Not implemented.");
    }

    public String getXMLspace() {
        return XMLSupport.getXMLSpace((Element)((Object)this));
    }

    public void setXMLspace(String space) throws DOMException {
        this.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:space", space);
    }

    public String getType() {
        return this.getAttributeNS(null, "type");
    }

    public void setType(String type) throws DOMException {
        this.setAttributeNS(null, "type", type);
    }

    public String getMedia() {
        return this.getAttribute("media");
    }

    public void setMedia(String media) throws DOMException {
        this.setAttribute("media", media);
    }

    public String getTitle() {
        return this.getAttribute("title");
    }

    public void setTitle(String title) throws DOMException {
        this.setAttribute("title", title);
    }

    protected AttributeInitializer getAttributeInitializer() {
        return attributeInitializer;
    }

    protected Node newNode() {
        return new SVGOMStyleElement();
    }

    static {
        attributeInitializer.addAttribute("http://www.w3.org/XML/1998/namespace", "xml", "space", "preserve");
    }

    protected class DOMCharacterDataModifiedListener
    implements EventListener {
        protected DOMCharacterDataModifiedListener() {
        }

        public void handleEvent(Event evt) {
            SVGOMStyleElement.this.styleSheet = null;
        }
    }
}

