/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.mxml.builder;

import flex2.compiler.CompilationUnit;
import flex2.compiler.mxml.Configuration;
import flex2.compiler.mxml.builder.Builder;
import flex2.compiler.mxml.builder.XMLBuilder;
import flex2.compiler.mxml.dom.CDATANode;
import flex2.compiler.mxml.dom.Node;
import flex2.compiler.mxml.dom.XMLListNode;
import flex2.compiler.mxml.lang.TextParser;
import flex2.compiler.mxml.reflect.TypeTable;
import flex2.compiler.mxml.rep.AtResource;
import flex2.compiler.mxml.rep.BindingExpression;
import flex2.compiler.mxml.rep.Model;
import flex2.compiler.mxml.rep.MxmlDocument;
import flex2.compiler.mxml.rep.XMLList;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.IntegerPool;
import flex2.compiler.util.QName;
import flex2.compiler.util.QNameMap;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;

public class XMLListBuilder
extends Builder {
    private String id;
    private Set temp;
    private Model parent;
    private boolean allowTopLevelBinding;
    XMLList xmlList;

    XMLListBuilder(CompilationUnit unit, TypeTable typeTable, Configuration configuration, MxmlDocument document) {
        this(unit, typeTable, configuration, document, null);
        this.allowTopLevelBinding = true;
    }

    XMLListBuilder(CompilationUnit unit, TypeTable typeTable, Configuration configuration, MxmlDocument document, Model parent) {
        super(unit, typeTable, configuration, document);
        this.parent = parent;
        this.allowTopLevelBinding = false;
        this.temp = new HashSet();
    }

    public void analyze(XMLListNode node) {
        this.id = (String)node.getAttribute("id");
        this.xmlList = new XMLList(this.document, this.typeTable.xmlListType, this.parent, node.beginLine);
        if (this.id != null) {
            this.xmlList.setId(this.id, false);
        }
        if (!this.checkFormat(node)) {
            this.xmlList.setLiteralXML("null");
            return;
        }
        StringWriter writer = new StringWriter();
        if (node.getChildCount() == 1 && node.getChildAt(0) instanceof CDATANode) {
            CDATANode cdata = (CDATANode)node.getChildAt(0);
            if (cdata.image.length() > 0) {
                String bindingExprString = TextParser.getBindingExpressionFromString(cdata.image.trim());
                if (bindingExprString == null) {
                    writer.write(TextParser.cleanupBindingEscapes(cdata.image));
                } else if (this.allowTopLevelBinding) {
                    BindingExpression be = new BindingExpression(bindingExprString, cdata.beginLine, this.document);
                    be.setDestination(this.xmlList);
                } else {
                    this.log(cdata, (CompilerMessage)new Builder.BindingNotAllowed());
                }
            }
        } else {
            this.processChildren(node, writer, null, new Stack(), new Stack());
        }
        this.xmlList.setLiteralXML(writer.toString());
    }

    private boolean checkFormat(XMLListNode node) {
        if (node.getChildAt(0) instanceof CDATANode) {
            this.log(node, (CompilerMessage)new RequireXMLContent());
            return false;
        }
        return true;
    }

    private void pushNodeNamespace(Node node, Stack namespaces) {
        this.temp.clear();
        String uri = node.getNamespace();
        int size = namespaces.size();
        for (int i = 0; i < size; ++i) {
            PrefixMapping pm = (PrefixMapping)namespaces.get(i);
            this.temp.add(pm);
            if (!pm.uri.equals(uri)) continue;
            namespaces.push(pm);
            return;
        }
        namespaces.push(new PrefixMapping(this.temp.size() + 1, uri));
    }

    private int getNamespaceId(String nsUri, Stack namespaces) {
        this.temp.clear();
        int size = namespaces.size();
        for (int i = 0; i < size; ++i) {
            PrefixMapping pm = (PrefixMapping)namespaces.get(i);
            this.temp.add(pm);
            if (!pm.uri.equals(nsUri)) continue;
            return pm.ns;
        }
        return this.temp.size() + 1;
    }

    private void popNodeNamespace(Stack namespaces) {
        namespaces.pop();
    }

    private void pushNamespaces(BindingExpression be, Stack namespaces) {
        this.temp.clear();
        int count = namespaces.size();
        for (int i = 0; i < count; ++i) {
            PrefixMapping pm = (PrefixMapping)namespaces.get(i);
            this.temp.add(pm);
        }
        Iterator j = this.temp.iterator();
        while (j.hasNext()) {
            PrefixMapping pm = (PrefixMapping)j.next();
            be.addNamespace(pm.uri, pm.ns);
        }
    }

    private void processNode(Node node, StringWriter serializer, String e4xElementsByLocalName, Stack destinationPropertyStack, Stack namespaces) {
        QNameMap attributeBindings = this.processBindingAttributes(node);
        this.processResourceAttributes(node);
        if (attributeBindings != null) {
            String destinationProperty = this.createExpression(destinationPropertyStack);
            Iterator i = attributeBindings.keySet().iterator();
            while (i.hasNext()) {
                String attrExpr;
                QName attrName = (QName)i.next();
                String nsUri = attrName.getNamespace();
                int nsId = 0;
                if (nsUri.length() > 0) {
                    nsId = this.getNamespaceId(nsUri, namespaces);
                    attrExpr = e4xElementsByLocalName + ".@ns" + nsId + "::" + attrName.getLocalPart();
                } else {
                    attrExpr = e4xElementsByLocalName + ".@" + attrName.getLocalPart();
                }
                BindingExpression be = new BindingExpression((String)attributeBindings.get(attrName), node.beginLine, this.document);
                be.setDestinationXMLAttribute(true);
                be.setDestinationLValue(attrExpr);
                be.setDestinationProperty(destinationProperty + "[" + node.getIndex() + "]");
                be.setDestination(this.xmlList);
                this.xmlList.setHasBindings(true);
                this.pushNamespaces(be, namespaces);
                if (nsUri.length() <= 0) continue;
                be.addNamespace(nsUri, nsId);
            }
        }
        node.toStartElement(serializer);
        if (node.getChildCount() == 1 && node.getChildAt(0) instanceof CDATANode) {
            CDATANode cdata = (CDATANode)node.getChildAt(0);
            if (cdata.image.length() > 0) {
                String bindingExprString = TextParser.getBindingExpressionFromString(cdata.image);
                if (bindingExprString != null) {
                    String destinationProperty = this.createExpression(destinationPropertyStack);
                    BindingExpression be = new BindingExpression(bindingExprString, cdata.beginLine, this.document);
                    be.setDestinationLValue(e4xElementsByLocalName);
                    be.setDestinationProperty(destinationProperty + "[" + node.getIndex() + "]");
                    be.setDestination(this.xmlList);
                    be.setDestinationXMLNode(true);
                    be.setDestinationE4X(true);
                    this.xmlList.setHasBindings(true);
                    this.pushNamespaces(be, namespaces);
                } else {
                    serializer.write(TextParser.cleanupBindingEscapes(cdata.image));
                }
            }
        } else {
            this.processChildren(node, serializer, e4xElementsByLocalName, destinationPropertyStack, namespaces);
        }
        node.toEndElement(serializer);
    }

    private void processChildren(Node node, StringWriter serializer, String e4xElementsByLocalName, Stack destinationProperty, Stack namespaces) {
        this.assignIndices(node);
        int count = node.getChildCount();
        for (int i = 0; i < count; ++i) {
            StringBuffer e4xbuffer;
            Node child = (Node)node.getChildAt(i);
            if (child instanceof CDATANode) {
                CDATANode cdata = (CDATANode)child;
                if (cdata.image.trim().length() > 0) {
                    this.log(child, (CompilerMessage)new XMLBuilder.MixedContent(child.image));
                    continue;
                }
                serializer.write(cdata.image);
                continue;
            }
            this.pushNodeNamespace(child, namespaces);
            if (e4xElementsByLocalName != null) {
                e4xbuffer = new StringBuffer(e4xElementsByLocalName);
                String destProp = child.getLocalPart();
                if (child.getNamespace().length() > 0) {
                    PrefixMapping pm = (PrefixMapping)namespaces.peek();
                    destProp = "ns" + pm.ns + "::" + destProp;
                }
                e4xbuffer.append(".").append(destProp).append("[").append(child.getIndex()).append("]");
                destinationProperty.push(destProp);
                this.processNode(child, serializer, e4xbuffer.toString(), destinationProperty, namespaces);
                destinationProperty.pop();
            } else {
                e4xbuffer = new StringBuffer(this.xmlList.getId());
                e4xbuffer.append("[").append(i).append("]");
                destinationProperty.push(child.getLocalPart());
                this.processNode(child, serializer, e4xbuffer.toString(), destinationProperty, namespaces);
                destinationProperty.pop();
            }
            this.popNodeNamespace(namespaces);
        }
    }

    private QNameMap processBindingAttributes(Node node) {
        QNameMap attributeBindings = null;
        Iterator i = node.getAttributeNames();
        while (i != null && i.hasNext()) {
            QName qname = (QName)i.next();
            String value = (String)node.getAttribute(qname);
            String bindingExprString = TextParser.getBindingExpressionFromString(value);
            if (bindingExprString == null) continue;
            if (attributeBindings == null) {
                attributeBindings = new QNameMap();
            }
            attributeBindings.put(qname, bindingExprString);
            i.remove();
        }
        return attributeBindings;
    }

    private void processResourceAttributes(Node node) {
        QName qname;
        QNameMap attributeResources = new QNameMap();
        Iterator i = node.getAttributeNames();
        while (i != null && i.hasNext()) {
            qname = (QName)i.next();
            String text = (String)node.getAttribute(qname);
            String atFunction = TextParser.getAtFunctionName(text);
            if ("Resource".equals(atFunction)) {
                AtResource atResource = (AtResource)this.textParser.resource(text, this.typeTable.stringType);
                if (atResource == null) continue;
                attributeResources.put(qname, atResource);
                continue;
            }
            if (atFunction == null) continue;
            this.textParser.desc = atFunction;
            this.textParser.line = node.beginLine;
            this.textParser.error(7, null, null, null);
        }
        Iterator iter = attributeResources.keySet().iterator();
        while (iter.hasNext()) {
            qname = (QName)iter.next();
            AtResource atResource = (AtResource)attributeResources.get(qname);
            node.addAttribute(qname.getNamespace(), qname.getLocalPart(), atResource, node.beginLine);
        }
    }

    private void assignIndices(Node parent) {
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        Integer zero = IntegerPool.getNumber(0);
        int count = parent.getChildCount();
        for (int i = 0; i < count; ++i) {
            Node child = (Node)parent.getChildAt(i);
            if (child instanceof CDATANode) continue;
            if (!counts.containsKey(child.image)) {
                counts.put(child.image, zero);
                child.setIndex(0);
                continue;
            }
            int num = (Integer)counts.get(child.image) + 1;
            counts.put(child.image, IntegerPool.getNumber(num));
            child.setIndex(num);
        }
    }

    private String createExpression(Stack stack) {
        StringBuffer buffer = new StringBuffer();
        int count = stack.size();
        for (int i = 0; i < count; ++i) {
            buffer.append(stack.get(i));
            if (i >= count - 1) continue;
            buffer.append(".");
        }
        return buffer.toString();
    }

    public static class RequireXMLContent
    extends CompilerMessage.CompilerError {
    }

    class PrefixMapping {
        int ns;
        String uri;

        PrefixMapping(int ns, String uri) {
            this.ns = ns;
            this.uri = uri;
        }

        public boolean equals(Object obj) {
            return this.uri.equals(obj);
        }

        public int hashCode() {
            return this.uri.hashCode();
        }
    }
}

