/*
 * Decompiled with CFR 0.152.
 */
package flex2.tools.oem.internal;

import flash.swf.Frame;
import flex2.compiler.AssetInfo;
import flex2.compiler.CompilationUnit;
import flex2.compiler.Source;
import flex2.compiler.common.Configuration;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.swc.SwcScript;
import flex2.compiler.util.MultiNameSet;
import flex2.compiler.util.QName;
import flex2.compiler.util.QNameList;
import flex2.linker.SimpleMovie;
import flex2.tools.VersionInfo;
import flex2.tools.oem.Message;
import flex2.tools.oem.Report;
import flex2.tools.oem.internal.GenericMessage;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class OEMReport
implements Report {
    private String[] compiler_SourceNames;
    private String[] compiler_AssetNames;
    private String[] compiler_LibraryNames;
    private String[] linker_SourceNames;
    private String[] linker_AssetNames;
    private String[] linker_LibraryNames;
    private String[] resourceBundleNames;
    private Map data;
    private Map locations;
    private Map timestamps;
    private int frameCount;
    private int bgColor;
    private int defaultWidth;
    private int defaultHeight;
    private int width;
    private int height;
    private String pageTitle;
    private double widthPercent;
    private double heightPercent;
    private String linkReport;
    private String configurationReport;
    private Message[] messages;
    private String[][] assetNames;
    private String[][] definitionNames;

    public OEMReport(List sources, SimpleMovie movie, Configuration configuration, String configurationReport, List messages) {
        this.init(sources, movie == null ? null : movie.getExportedUnits(), configuration == null ? null : configuration.getResourceBundles());
        this.processFrames(movie);
        this.processMessages(messages);
        this.frameCount = movie == null ? 0 : movie.frames.size();
        this.configurationReport = configurationReport;
        this.defaultWidth = configuration != null ? configuration.defaultWidth() : 0;
        int n = this.defaultHeight = configuration != null ? configuration.defaultHeight() : 0;
        if (movie != null) {
            String percent;
            this.linkReport = movie.getLinkReport();
            this.bgColor = movie.bgcolor.color;
            this.pageTitle = movie.pageTitle;
            if (movie.userSpecifiedWidth) {
                this.width = movie.width;
                this.widthPercent = 0.0;
            } else {
                this.width = 0;
                percent = configuration == null ? null : configuration.widthPercent();
                percent = percent == null ? "0%" : percent.trim();
                percent = percent.substring(0, percent.length() - 1);
                try {
                    this.widthPercent = Double.parseDouble(percent) / 100.0;
                }
                catch (NumberFormatException ex) {
                    this.widthPercent = 0.0;
                }
            }
            if (movie.userSpecifiedHeight) {
                this.height = movie.height;
                this.heightPercent = 0.0;
            } else {
                this.height = 0;
                percent = configuration == null ? null : configuration.heightPercent();
                percent = percent == null ? "0%" : percent.trim();
                percent = percent.substring(0, percent.length() - 1);
                try {
                    this.heightPercent = Double.parseDouble(percent) / 100.0;
                }
                catch (NumberFormatException ex) {
                    this.heightPercent = 0.0;
                }
            }
        } else {
            this.linkReport = null;
            this.bgColor = 0;
            this.width = 0;
            this.height = 0;
            this.pageTitle = null;
            this.widthPercent = 0.0;
            this.heightPercent = 0.0;
        }
    }

    private void init(List sourceList, List exportedUnits, Set resourceBundles) {
        TreeSet sources = new TreeSet();
        TreeSet assets = new TreeSet();
        TreeSet libraries = new TreeSet();
        this.data = new HashMap();
        this.locations = new HashMap();
        this.processSources(sourceList, sources, assets, libraries, this.data, this.locations);
        this.compiler_SourceNames = this.toArray(sources);
        this.compiler_AssetNames = this.toArray(assets);
        this.compiler_LibraryNames = this.toArray(libraries);
        this.resourceBundleNames = this.toArray(resourceBundles);
        sources.clear();
        assets.clear();
        libraries.clear();
        this.processCompilationUnits(exportedUnits, sources, assets, libraries);
        this.linker_SourceNames = this.toArray(sources);
        this.linker_AssetNames = this.toArray(assets);
        this.linker_LibraryNames = this.toArray(libraries);
        this.timestamps = new HashMap();
        this.storeTimestamps(this.linker_SourceNames);
        this.storeTimestamps(this.linker_AssetNames);
        this.storeTimestamps(this.linker_LibraryNames);
    }

    private void storeTimestamps(String[] a) {
        int len;
        int n = len = a == null ? 0 : a.length;
        for (int i = 0; i < len; ++i) {
            if (this.timestamps.containsKey(a[i])) continue;
            this.timestamps.put(a[i], new Long(new File(a[i]).lastModified()));
        }
    }

    public boolean contentUpdated() {
        Iterator i = this.timestamps.keySet().iterator();
        while (i.hasNext()) {
            String path = (String)i.next();
            Long ts = (Long)this.timestamps.get(path);
            File f = new File(path);
            if (f.exists() && f.lastModified() == ts.longValue()) continue;
            return true;
        }
        return false;
    }

    public String[] getSourceNames(Object report) {
        return COMPILER.equals(report) ? this.compiler_SourceNames : (LINKER.equals(report) ? this.linker_SourceNames : null);
    }

    public String[] getAssetNames(int frame) {
        return this.assetNames[frame - 1];
    }

    public String[] getAssetNames(Object report) {
        return COMPILER.equals(report) ? this.compiler_AssetNames : (LINKER.equals(report) ? this.linker_AssetNames : null);
    }

    public String[] getLibraryNames(Object report) {
        return COMPILER.equals(report) ? this.compiler_LibraryNames : (LINKER.equals(report) ? this.linker_LibraryNames : null);
    }

    public String[] getResourceBundleNames() {
        return this.resourceBundleNames;
    }

    public String[] getDefinitionNames(int frame) {
        return this.definitionNames[frame - 1];
    }

    public String[] getDefinitionNames(String sourceName) {
        Data d = (Data)this.data.get(sourceName);
        return d == null ? null : d.definitions;
    }

    public String getLocation(String definition) {
        return (String)this.locations.get(definition);
    }

    public String[] getDependencies(String definition) {
        String location = this.getLocation(definition);
        if (location != null) {
            Data d = (Data)this.data.get(location);
            return d == null ? null : d.dependencies;
        }
        return null;
    }

    public String[] getPrerequisites(String definition) {
        String location = this.getLocation(definition);
        if (location != null) {
            Data d = (Data)this.data.get(location);
            return d == null ? null : d.prerequisites;
        }
        return null;
    }

    public long writeLinkReport(Writer out) throws IOException {
        long size = 0L;
        if (this.linkReport != null) {
            out.write(this.linkReport);
            out.flush();
            size = this.linkReport.length();
        }
        return size;
    }

    public long writeConfigurationReport(Writer out) throws IOException {
        long size = 0L;
        if (this.configurationReport != null) {
            out.write(this.configurationReport);
            out.flush();
            size = this.configurationReport.length();
        }
        return size;
    }

    public int getBackgroundColor() {
        return this.bgColor;
    }

    public String getPageTitle() {
        return this.pageTitle;
    }

    public int getDefaultWidth() {
        return this.defaultWidth;
    }

    public int getDefaultHeight() {
        return this.defaultHeight;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public double getWidthPercent() {
        return this.widthPercent;
    }

    public double getHeightPercent() {
        return this.heightPercent;
    }

    public String getCompilerVersion() {
        return VersionInfo.buildMessage();
    }

    public Message[] getMessages() {
        return this.messages;
    }

    public int getFrameCount() {
        return this.frameCount;
    }

    private void processCompilationUnits(List units, TreeSet sources, TreeSet assets, TreeSet libraries) {
        int length;
        int n = length = units == null ? 0 : units.size();
        for (int i = 0; i < length; ++i) {
            Source s;
            CompilationUnit u = (CompilationUnit)units.get(i);
            Source source = s = u == null ? null : u.getSource();
            if (s == null) continue;
            if (s.isFileSpecOwner() || s.isSourceListOwner() || s.isSourcePathOwner() || s.isResourceBundlePathOwner()) {
                sources.add(s.getName());
                Iterator j = s.getFileIncludes();
                while (j.hasNext()) {
                    VirtualFile f = (VirtualFile)j.next();
                    sources.add(f.getName());
                }
                j = u.getAssets().iterator();
                while (j.hasNext()) {
                    Map.Entry e = (Map.Entry)j.next();
                    AssetInfo assetInfo = (AssetInfo)e.getValue();
                    VirtualFile path = assetInfo.getPath();
                    if (path == null) continue;
                    assets.add(path.getName());
                }
                continue;
            }
            if (!s.isSwcScriptOwner()) continue;
            String location = ((SwcScript)s.getOwner()).getLibrary().getSwcLocation();
            libraries.add(location);
        }
    }

    private void processSources(List sourceList, TreeSet sources, TreeSet assets, TreeSet libraries, Map data, Map locations) {
        CompilationUnit u;
        Source s;
        int i;
        int length;
        int n = length = sourceList == null ? 0 : sourceList.size();
        for (i = 0; i < length; ++i) {
            s = (Source)sourceList.get(i);
            CompilationUnit compilationUnit = u = s == null ? null : s.getCompilationUnit();
            if (s == null) continue;
            if (s.isFileSpecOwner() || s.isSourceListOwner() || s.isSourcePathOwner() || s.isResourceBundlePathOwner()) {
                sources.add(s.getName());
                Iterator j = s.getFileIncludes();
                while (j.hasNext()) {
                    VirtualFile f = (VirtualFile)j.next();
                    sources.add(f.getName());
                }
                j = u.getAssets().iterator();
                while (j.hasNext()) {
                    Map.Entry e = (Map.Entry)j.next();
                    AssetInfo assetInfo = (AssetInfo)e.getValue();
                    VirtualFile path = assetInfo.getPath();
                    if (path == null) continue;
                    assets.add(assetInfo.getPath().getName());
                }
                if (locations == null) continue;
                int size = u.topLevelDefinitions.size();
                for (int j2 = 0; j2 < size; ++j2) {
                    locations.put(u.topLevelDefinitions.get(j2).toString(), s.getName());
                }
                continue;
            }
            if (!s.isSwcScriptOwner()) continue;
            String location = ((SwcScript)s.getOwner()).getLibrary().getSwcLocation();
            libraries.add(location);
            if (locations == null) continue;
            int size = u.topLevelDefinitions.size();
            for (int j = 0; j < size; ++j) {
                locations.put(u.topLevelDefinitions.get(j).toString(), location);
            }
        }
        int n2 = length = sourceList == null ? 0 : sourceList.size();
        for (i = 0; i < length; ++i) {
            s = (Source)sourceList.get(i);
            CompilationUnit compilationUnit = u = s == null ? null : s.getCompilationUnit();
            if (s == null || !s.isFileSpecOwner() && !s.isSourceListOwner() && !s.isSourcePathOwner() && !s.isResourceBundlePathOwner()) continue;
            Data d = new Data();
            d.definitions = this.toArray(u.topLevelDefinitions);
            d.prerequisites = this.toArray(new MultiNameSet[]{u.inheritance}, null, locations);
            d.dependencies = this.toArray(new MultiNameSet[]{u.namespaces, u.types, u.expressions}, new Set[]{u.extraClasses, u.resourceBundleHistory}, locations);
            data.put(s.getName(), d);
        }
    }

    private void processFrames(SimpleMovie movie) {
        int count = movie == null ? 0 : movie.frames.size();
        this.assetNames = new String[count][];
        this.definitionNames = new String[count][];
        for (int i = 0; i < count; ++i) {
            int size;
            Frame f = (Frame)movie.frames.get(i);
            List units = movie.getExportedUnitsByFrame(f);
            ArrayList<String> aList = new ArrayList<String>();
            ArrayList<String> dList = new ArrayList<String>();
            int n = size = units == null ? 0 : units.size();
            for (int j = 0; j < size; ++j) {
                CompilationUnit u = (CompilationUnit)units.get(j);
                Source s = u.getSource();
                Iterator k = u.getAssets().iterator();
                while (k.hasNext()) {
                    String assetName;
                    Map.Entry e = (Map.Entry)k.next();
                    AssetInfo assetInfo = (AssetInfo)e.getValue();
                    VirtualFile path = assetInfo.getPath();
                    if (path == null || aList.contains(assetName = path.getName())) continue;
                    aList.add(assetName);
                }
                if (!s.isFileSpecOwner() && !s.isResourceBundlePathOwner() && !s.isSourceListOwner() && !s.isSourcePathOwner() && !s.isSwcScriptOwner()) continue;
                k = u.topLevelDefinitions.iterator();
                while (k.hasNext()) {
                    String definitionName = k.next().toString();
                    dList.add(definitionName);
                }
            }
            if (aList.size() > 0) {
                this.assetNames[i] = new String[aList.size()];
                aList.toArray(this.assetNames[i]);
            }
            if (dList.size() <= 0) continue;
            this.definitionNames[i] = new String[dList.size()];
            dList.toArray(this.definitionNames[i]);
        }
    }

    private void processMessages(List messages) {
        if (messages != null && messages.size() > 0) {
            ArrayList<Message> filtered = new ArrayList<Message>();
            int length = messages.size();
            for (int i = 0; i < length; ++i) {
                Message m = (Message)messages.get(i);
                if (m == null || "info".equals(m.getLevel())) continue;
                filtered.add(m);
            }
            messages = filtered;
        }
        if (messages != null && messages.size() > 0) {
            this.messages = new Message[messages.size()];
            int length = this.messages.length;
            for (int i = 0; i < length; ++i) {
                this.messages[i] = new GenericMessage((Message)messages.get(i));
            }
        } else {
            this.messages = null;
        }
    }

    private String[] toArray(Set set) {
        String[] a = new String[set == null ? 0 : set.size()];
        int j = 0;
        if (set != null) {
            Iterator i = set.iterator();
            while (i.hasNext()) {
                a[j] = (String)i.next();
                ++j;
            }
        }
        return a.length == 0 ? null : a;
    }

    private String[] toArray(QNameList definitions) {
        String[] a = new String[definitions == null ? 0 : definitions.size()];
        for (int i = 0; i < a.length; ++i) {
            a[i] = definitions.get(i).toString();
        }
        return a.length == 0 ? null : a;
    }

    private String[] toArray(MultiNameSet[] mnSets, Set[] sets, Map locations) {
        Object obj;
        Iterator j;
        int i;
        int length;
        TreeSet<String> set = new TreeSet<String>();
        int n = length = mnSets == null ? 0 : mnSets.length;
        for (i = 0; i < length; ++i) {
            if (mnSets[i] == null) continue;
            j = mnSets[i].iterator();
            while (j.hasNext()) {
                obj = j.next();
                String qName = null;
                if (!(obj instanceof QName) || locations != null && !locations.containsKey(qName = obj.toString())) continue;
                set.add(qName);
            }
        }
        int n2 = length = sets == null ? 0 : sets.length;
        for (i = 0; i < length; ++i) {
            if (sets[i] == null) continue;
            j = sets[i].iterator();
            while (j.hasNext()) {
                obj = j.next();
                if (!(obj instanceof String) || locations != null && !locations.containsKey(obj)) continue;
                set.add((String)obj);
            }
        }
        return this.toArray(set);
    }

    static class Data {
        String[] definitions;
        String[] prerequisites;
        String[] dependencies;

        Data() {
        }
    }
}

