/*
 * Decompiled with CFR 0.152.
 */
package flex2.tools.oem.internal;

import flash.localization.ILocalizer;
import flash.localization.LocalizationManager;
import flash.localization.ResourceBundleLocalizer;
import flex2.compiler.common.Configuration;
import flex2.compiler.common.DefaultsConfigurator;
import flex2.compiler.config.ConfigurationBuffer;
import flex2.compiler.config.ConfigurationException;
import flex2.compiler.io.FileUtil;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.swc.SwcException;
import flex2.compiler.util.ThreadLocalToolkit;
import flex2.linker.FlexMovie;
import flex2.tools.API;
import flex2.tools.CompcConfiguration;
import flex2.tools.Compiler;
import flex2.tools.oem.Library;
import flex2.tools.oem.Report;
import flex2.tools.oem.internal.OEMConfiguration;
import flex2.tools.oem.internal.OEMConsole;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class LibraryCompiler {
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        OEMConsole console = new OEMConsole();
        try {
            LibraryCompiler.init();
            LibraryCompiler.run(console, args);
        }
        catch (ConfigurationException ex) {
            Compiler.processConfigurationException(ex, "compc");
        }
        catch (SwcException ex) {
            if (!$assertionsDisabled && ThreadLocalToolkit.errorCount() <= 0) {
                throw new AssertionError();
            }
        }
        catch (Throwable t) {
            ThreadLocalToolkit.logError(t.getMessage());
            t.printStackTrace();
        }
        finally {
            LibraryCompiler.clean();
        }
        System.exit(console.errorCount());
    }

    public static void run(OEMConsole console, String[] args) throws ConfigurationException, IOException, URISyntaxException {
        ThreadLocalToolkit.setLogger(console);
        Library lib = new Library();
        lib.setLogger(console);
        OEMConfiguration c1 = (OEMConfiguration)lib.getDefaultConfiguration();
        CompcConfiguration c2 = LibraryCompiler.getCompcConfiguration(args);
        OEMConfiguration c3 = new OEMConfiguration(null, c2);
        c1.importDefaults(c3);
        lib.setConfiguration(c1);
        c1.enableDigestComputation(c2.getComputeDigest());
        Iterator i = c2.getClasses().iterator();
        while (i.hasNext()) {
            lib.addComponent((String)i.next());
        }
        List fileList = flex2.compiler.API.getVirtualFileList(c2.getIncludeSources(), new HashSet<String>(Arrays.asList(API.getSourcePathMimeTypes())));
        Iterator i2 = fileList.iterator();
        while (i2.hasNext()) {
            lib.addComponent(new File(((VirtualFile)i2.next()).getName()));
        }
        Map ss = c2.getStylesheets();
        Iterator<Object> i3 = ss.keySet().iterator();
        while (i3.hasNext()) {
            String key = (String)i3.next();
            lib.addStyleSheet(key, new File(((VirtualFile)ss.get(key)).getName()));
        }
        i3 = c2.getIncludeResourceBundles().iterator();
        while (i3.hasNext()) {
            lib.addResourceBundle((String)i3.next());
        }
        i3 = c2.getNamespaces().iterator();
        while (i3.hasNext()) {
            lib.addComponent(new URI((String)i3.next()));
        }
        Map m = c2.getFiles();
        Iterator i4 = m.keySet().iterator();
        while (i4.hasNext()) {
            String key = (String)i4.next();
            lib.addArchiveFile(key, new File(((VirtualFile)m.get(key)).getName()));
        }
        try {
            lib.load(new BufferedInputStream(new FileInputStream(new File(c2.getOutput() + ".incr"))));
            ThreadLocalToolkit.setLogger(console);
        }
        catch (IOException ex) {
            // empty catch block
        }
        long size = 0L;
        size = lib.build(new BufferedOutputStream(new FileOutputStream(new File(c2.getOutput()))), true);
        if (size == 0L) {
            ThreadLocalToolkit.logError("Build unsuccessful.");
        } else {
            System.out.println(c2.getOutput() + " (" + size + " bytes)");
            if (c2.generateRBList() && c2.getRBListFileName() != null) {
                int l;
                Report r = lib.getReport();
                String[] rbNames = r.getResourceBundleNames();
                HashSet<String> set = new HashSet<String>();
                int n = l = rbNames == null ? 0 : rbNames.length;
                for (int i5 = 0; i5 < l; ++i5) {
                    set.add(rbNames[i5]);
                }
                String list = FlexMovie.dumpRBList(set);
                FileUtil.writeFile(c2.getRBListFileName(), list);
            }
        }
        lib.save(new BufferedOutputStream(new FileOutputStream(new File(c2.getOutput() + ".incr"))));
        lib.clean();
    }

    private static CompcConfiguration getCompcConfiguration(String[] args) throws ConfigurationException, IOException {
        ConfigurationBuffer cfgbuf = new ConfigurationBuffer(CompcConfiguration.class, CompcConfiguration.getAliases());
        cfgbuf.setDefaultVar("include-classes");
        DefaultsConfigurator.loadCompcDefaults(cfgbuf);
        Configuration obj = Compiler.processConfiguration(ThreadLocalToolkit.getLocalizationManager(), "compc", args, cfgbuf, CompcConfiguration.class, "include-classes");
        return (CompcConfiguration)obj;
    }

    static final void init() {
        flex2.compiler.API.useAS3();
        flex2.compiler.API.usePathResolver();
        LibraryCompiler.setupLocalizationManager();
    }

    static final void clean() {
        flex2.compiler.API.removePathResolver();
        ThreadLocalToolkit.setLogger(null);
        ThreadLocalToolkit.setLocalizationManager(null);
    }

    static final LocalizationManager setupLocalizationManager() {
        LocalizationManager l10n = new LocalizationManager();
        l10n.addLocalizer((ILocalizer)new ResourceBundleLocalizer());
        ThreadLocalToolkit.setLocalizationManager(l10n);
        return l10n;
    }

    static {
        $assertionsDisabled = !LibraryCompiler.class.desiredAssertionStatus();
    }
}

