/*
 * Decompiled with CFR 0.152.
 */
package flex.webtier.server.j2ee;

import flex.webtier.compiler.WrongCaseException;
import flex.webtier.server.j2ee.FileNameGenerator;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;

public class PathValidator {
    private static boolean isWindows = File.separatorChar == '\\';

    public static void checkFileExists(String mxmlFileName, HttpServletRequest request) throws FileNotFoundException {
        File mxmlFile = new File(mxmlFileName);
        if (!mxmlFile.isFile() || !mxmlFile.exists()) {
            throw new FileNotFoundException("File not found: " + mxmlFileName);
        }
        if (isWindows) {
            String filename = mxmlFile.getName().toUpperCase();
            if (mxmlFile.getName().lastIndexOf(46) != -1) {
                filename = filename.substring(0, filename.lastIndexOf(46)).toUpperCase();
            }
            if (filename.endsWith("NUL") || filename.endsWith("PRN") || filename.endsWith("LPT1") || filename.endsWith("LPT2") || filename.endsWith("COM2") || filename.endsWith("AUX") || filename.endsWith("CON") || filename.endsWith("COM1") || filename.endsWith("COM3")) {
                throw new FileNotFoundException("File not found: " + mxmlFileName);
            }
        }
        try {
            String sourceFileName = FileNameGenerator.sourceFileName(request.getServletPath());
            PathValidator.checkServletPath(sourceFileName, mxmlFileName);
        }
        catch (WrongCaseException wrongCaseException) {
            throw new FileNotFoundException(wrongCaseException.getMessage());
        }
    }

    private static void checkServletPath(String servletPath, String realPath) throws WrongCaseException {
        String newPath;
        try {
            newPath = new File(realPath).getCanonicalPath();
        }
        catch (IOException ioe) {
            newPath = realPath;
        }
        if (File.separatorChar == '\\') {
            String fileElement;
            String servletPathElement;
            String fileRev = PathValidator.reversePathElements(newPath.replace('\\', '/'));
            String servletPathRev = PathValidator.reversePathElements(servletPath);
            StringTokenizer fileStringTokenizer = new StringTokenizer(fileRev, "/");
            StringTokenizer servletPathStringTokenizer = new StringTokenizer(servletPathRev, "/");
            while (fileStringTokenizer.hasMoreTokens() && servletPathStringTokenizer.hasMoreTokens() && (servletPathElement = servletPathStringTokenizer.nextToken()).equalsIgnoreCase(fileElement = fileStringTokenizer.nextToken())) {
                if (servletPathElement.equals(fileElement)) continue;
                throw new WrongCaseException("The request path, " + servletPath + ", had the wrong case.  Use: " + fileElement);
            }
        }
    }

    private static String reversePathElements(String path) {
        StringTokenizer stringTokenizer = new StringTokenizer(path, "/");
        StringBuffer results = new StringBuffer(path.length());
        while (stringTokenizer.hasMoreElements()) {
            results.insert(0, stringTokenizer.nextToken());
            results.insert(0, '/');
        }
        return results.toString();
    }
}

