/*
 * Decompiled with CFR 0.152.
 */
package flash.fonts.flashtype;

import flash.fonts.flashtype.ADF;
import flash.fonts.flashtype.ADFAlgnZones;
import flash.fonts.flashtype.ADFMathUtils;
import flash.fonts.flashtype.ADFTypeSystem;
import flash.fonts.flashtype.FlexADFData;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class ADFTest {
    public static void main(String[] args) throws Exception {
        ADFTest.testADFMathUtils();
        ADFTest.testADF();
        ADFTest.generateADFAlgnZones();
    }

    private static void testADFMathUtils() {
        ADFMathUtils.FloatingPointValue val = new ADFMathUtils.FloatingPointValue(0.0);
        ADFMathUtils.frexp(val);
        System.out.println("frexp: " + val.mantissa + " : " + val.exp);
        val = new ADFMathUtils.FloatingPointValue(1.0);
        ADFMathUtils.frexp(val);
        System.out.println("frexp: " + val.mantissa + " : " + val.exp);
        val = new ADFMathUtils.FloatingPointValue(-5.555);
        ADFMathUtils.frexp(val);
        System.out.println("frexp: " + val.mantissa + " : " + val.exp);
        ADFMathUtils.ADFPackF32Result result = ADFMathUtils.ADFPackF32(5.555f);
        System.out.println("ADFPackF32: " + result.packedValue);
        float unpack = ADFMathUtils.ADFUnpackF32(result.packedValue);
        System.out.println("ADFUnpackF32: " + unpack);
        result = ADFMathUtils.ADFPackF32(1234.5679f);
        System.out.println("ADFPackF32: " + result.packedValue);
        unpack = ADFMathUtils.ADFUnpackF32(result.packedValue);
        System.out.println("ADFUnpackF32: " + unpack);
        ADFMathUtils.RootValue root = ADFMathUtils.ADFGetRealQuadraticRoots(new double[]{1.0, 0.0, -1.0});
        System.out.println("ADFGetRealQuadraticRoots: " + root.num);
        System.out.println("");
    }

    private static void testADF() {
        ADF.ADFGlyph adf = new ADF.ADFGlyph();
        adf.xAlgnCoord = 20.0f;
        adf.xRange = 30.0f;
        adf.yAlgnCoord = 40.0f;
        adf.yRange = 50.0f;
        adf.algnZonesMask = 92345678;
        ADFTypeSystem.ADFPath path = new ADFTypeSystem.ADFPath();
        ADF.ADFPackAlgnZones(adf, path);
        System.out.println("algnZones: " + path.algnZones[0] + " : " + path.algnZones[1]);
        System.out.println("algnZonesMask: " + path.algnZonesMask);
        ADF.ADFUnpackAlgnZones(path, adf);
        System.out.println("adf.xAlgnCoord = " + adf.xAlgnCoord + " : " + "adf.yAlgnCoord = " + adf.yAlgnCoord);
        System.out.println("adf.xRange = " + adf.xRange + " : adf.yRange = " + adf.yRange);
        System.out.println("adf.algnZonesMask = " + adf.algnZonesMask);
        System.out.println("");
    }

    private static void createInternPath() throws Exception {
        int i;
        Object mpLibInst = new Object();
        Method method = ADFTest.getFontOutlinesMethod();
        ADFTypeSystem.ADFGenAttrs genAttrs = new ADFTypeSystem.ADFGenAttrs();
        genAttrs.maxLevel = 5L;
        genAttrs.maxError = 2.0E-4f;
        genAttrs.distEps = 0.0f;
        ADFTypeSystem.ADFPath path = (ADFTypeSystem.ADFPath)method.invoke(null, mpLibInst, new FlexADFData(), new Character('Z'));
        ADF.InternPath inPath = ADF.CreateInternPath(path, genAttrs);
        System.out.println("*** InternPath ***");
        System.out.println("ADFUnitsPerEM: " + inPath.ADFUnitsPerEM + ", FUToADFScale: " + inPath.FUToADFScale);
        System.out.println("glyphOffsetX: " + inPath.glyphOffsetX + ", glyphOffsetY: " + inPath.glyphOffsetY);
        System.out.println("maxGridLines: " + inPath.maxGridLines + ", numPathElements: " + inPath.numPathElements);
        for (i = 0; i < inPath.numPathElements; ++i) {
            ADF.InternCorner corner = inPath.corners[i];
            if (corner == null) continue;
            System.out.println("corner num: " + i + ", type: " + corner.type + ", sec1ID: " + corner.sec1ID + ", sec2ID: " + corner.sec2ID);
            System.out.println("corner p: " + ADFTest.getFloatArrayString(corner.p));
            System.out.println("corner t1: " + ADFTest.getFloatArrayString(corner.t1) + " t2: " + ADFTest.getFloatArrayString(corner.t2));
        }
        System.out.println("contours: " + ADFTest.getIntArrayString(inPath.contours));
        System.out.println("crossings: " + ADFTest.getFloatArrayString(inPath.crossings));
        for (i = 0; i < inPath.numPathElements; ++i) {
            ADF.InternPathElm elm = inPath.elms[i];
            System.out.println("elm c/featureID: " + elm.c1 + " : " + elm.c2 + " : " + elm.c3 + " : " + elm.featureID);
            System.out.println("elm e_ID: " + elm.e0_ID + " : " + elm.e1_ID);
            System.out.println("elm e0: " + ADFTest.getFloatArrayString(elm.e0));
            System.out.println("elm e1: " + ADFTest.getFloatArrayString(elm.e1));
        }
        for (i = 0; i < inPath.numPathElements; ++i) {
            ADF.CTNode node = inPath.clusterTreeRoot[i];
            System.out.println("CTNode minDistSqr: " + node.minDistSqr + ", " + node.xMin + " : " + node.xMax + " : " + node.yMin + " : " + node.yMax);
        }
        System.out.println("*** end InternPath ***");
    }

    private static void createADF() throws Exception {
        Object mpLibInst = new Object();
        Method method = ADFTest.getFontOutlinesMethod();
        ADFTypeSystem.ADFGenAttrs genAttrs = new ADFTypeSystem.ADFGenAttrs();
        genAttrs.maxLevel = 5L;
        genAttrs.maxError = 2.0E-4f;
        genAttrs.distEps = 0.0f;
        ADFTypeSystem.ADFPath path = (ADFTypeSystem.ADFPath)method.invoke(null, mpLibInst, new FlexADFData(), new Character('Z'));
        ADF.ADFGlyph adf = (ADF.ADFGlyph)ADF.ADFGenerateADF(mpLibInst, path, genAttrs);
        System.out.println("int[] cellArr = new int[" + adf.cellsAndDists.length + "];");
        for (int i = 0; i < adf.cellsAndDists.length; ++i) {
            System.out.println("cellArr[" + i + "] = " + adf.cellsAndDists[i] + ";");
        }
    }

    private static Method getFontOutlinesMethod() {
        Method method = null;
        Method[] methodArr = ADFTest.class.getMethods();
        for (int i = 0; i < methodArr.length; ++i) {
            if (!methodArr[i].getName().equals("GetFontOutlinesCB")) continue;
            method = methodArr[i];
            break;
        }
        return method;
    }

    static String getFloatArrayString(float[] f) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < f.length; ++i) {
            sb.append(f[i]);
            sb.append(", ");
        }
        return sb.toString();
    }

    private static String getIntArrayString(int[] n) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < n.length; ++i) {
            sb.append(n[i]);
            sb.append(", ");
        }
        return sb.toString();
    }

    private static void generateADFAlgnZones() throws Exception {
        Method method = ADFTest.getFontOutlinesMethod();
        ADFAlgnZones.AlgnZoneState mpZoneInst = (ADFAlgnZones.AlgnZoneState)ADFAlgnZones.ADFInitAlgnZoneDetection(null, new FlexADFData(), null, method, null);
        ADFTest.generateADF(mpZoneInst, 'A');
        ADFTest.generateADF(mpZoneInst, 'B');
        ADFTest.generateADF(mpZoneInst, 'H');
        ADFTest.generateADF(mpZoneInst, 'L');
        ADFTest.generateADF(mpZoneInst, 'Z');
        ADFTest.generateADF(mpZoneInst, 'l');
        ADFTest.generateADF(mpZoneInst, 'z');
    }

    private static void generateADF(ADFAlgnZones.AlgnZoneState mpZoneInst, char inCharCode) {
        FlexADFData data = new FlexADFData();
        ADFTypeSystem.ADFPath pOnePath = ADFTest.GetFontOutlinesCB(null, data, inCharCode);
        ADFAlgnZones.ADFDetectAlgnZones(null, mpZoneInst, pOnePath);
        ADF.ADFGlyph adf = new ADF.ADFGlyph();
        ADF.ADFUnpackAlgnZones(pOnePath, adf);
        System.out.println("ADF align zones for " + inCharCode + ": ");
        System.out.println("Generated:       " + pOnePath.algnZones[0] + " : " + pOnePath.algnZones[1] + " : " + adf.xAlgnCoord + " : " + adf.yAlgnCoord + " : " + adf.xRange + " : " + adf.yRange);
        ADFTypeSystem.ADFPath path = new ADFTypeSystem.ADFPath();
        path.algnZonesMask = 3;
        switch (inCharCode) {
            case 'A': {
                path.algnZones = new long[]{13915L, 1121845248L};
                break;
            }
            case 'B': {
                path.algnZones = new long[]{13924L, 1121861447L};
                break;
            }
            case 'H': {
                path.algnZones = new long[]{13954L, 1121861568L};
                break;
            }
            case 'L': {
                path.algnZones = new long[]{13915L, 1121845248L};
                break;
            }
            case 'Z': {
                path.algnZones = new long[]{13915L, 1121845248L};
                break;
            }
            case 'l': {
                path.algnZones = new long[]{13309L, 1108606976L};
                break;
            }
            case 'z': {
                path.algnZones = new long[]{13309L, 1108606976L};
            }
        }
        if (path.algnZones != null) {
            ADF.ADFUnpackAlgnZones(path, adf);
            System.out.println("Flash Authoring: " + path.algnZones[0] + " : " + path.algnZones[1] + " : " + adf.xAlgnCoord + " : " + adf.yAlgnCoord + " : " + adf.xRange + " : " + adf.yRange);
        }
        System.out.println("");
    }

    public static ADFTypeSystem.ADFPath GetFontOutlinesCB(Object libInst, Object fontID, char charCode) {
        ADFTypeSystem.ADFPenCmd penCmd14;
        ADFTypeSystem.ADFPenCmd penCmd13;
        ADFTypeSystem.ADFPenCmd penCmd12;
        ADFTypeSystem.ADFPenCmd penCmd11;
        ADFTypeSystem.ADFPenCmd penCmd10;
        ADFTypeSystem.ADFPenCmd penCmd9;
        ADFTypeSystem.ADFPenCmd penCmd8;
        ADFTypeSystem.ADFPenCmd penCmd7;
        ADFTypeSystem.ADFPenCmd penCmd6;
        ADFTypeSystem.ADFPenCmd penCmd5;
        ADFTypeSystem.ADFPenCmd penCmd4;
        ADFTypeSystem.ADFPenCmd penCmd3;
        ADFTypeSystem.ADFPenCmd penCmd2;
        ADFTypeSystem.ADFPenCmd penCmd1;
        ADFTypeSystem.ADFPenCmd penCmd0;
        FlexADFData data = (FlexADFData)fontID;
        if (charCode == 'A') {
            data.mPath.fontUnitsPerEM = 20480.0f;
            data.mPath.charCode = (char)65;
            penCmd0 = new ADFTypeSystem.ADFPenCmd();
            penCmd0.opCode = 0L;
            penCmd0.x = -30.0f;
            penCmd0.y = 0.0f;
            penCmd1 = new ADFTypeSystem.ADFPenCmd();
            penCmd1.opCode = 1L;
            penCmd1.x = 5600.0f;
            penCmd1.y = 14660.0f;
            penCmd2 = new ADFTypeSystem.ADFPenCmd();
            penCmd2.opCode = 1L;
            penCmd2.x = 7690.0f;
            penCmd2.y = 14660.0f;
            penCmd3 = new ADFTypeSystem.ADFPenCmd();
            penCmd3.opCode = 1L;
            penCmd3.x = 13690.0f;
            penCmd3.y = 0.0f;
            penCmd4 = new ADFTypeSystem.ADFPenCmd();
            penCmd4.opCode = 1L;
            penCmd4.x = 11480.0f;
            penCmd4.y = 0.0f;
            penCmd5 = new ADFTypeSystem.ADFPenCmd();
            penCmd5.opCode = 1L;
            penCmd5.x = 9770.0f;
            penCmd5.y = 4440.0f;
            penCmd6 = new ADFTypeSystem.ADFPenCmd();
            penCmd6.opCode = 1L;
            penCmd6.x = 3640.0f;
            penCmd6.y = 4440.0f;
            penCmd7 = new ADFTypeSystem.ADFPenCmd();
            penCmd7.opCode = 1L;
            penCmd7.x = 2030.0f;
            penCmd7.y = 0.0f;
            penCmd8 = new ADFTypeSystem.ADFPenCmd();
            penCmd8.opCode = 1L;
            penCmd8.x = -30.0f;
            penCmd8.y = 0.0f;
            penCmd9 = new ADFTypeSystem.ADFPenCmd();
            penCmd9.opCode = 0L;
            penCmd9.x = 4200.0f;
            penCmd9.y = 6020.0f;
            penCmd10 = new ADFTypeSystem.ADFPenCmd();
            penCmd10.opCode = 1L;
            penCmd10.x = 9170.0f;
            penCmd10.y = 6020.0f;
            penCmd11 = new ADFTypeSystem.ADFPenCmd();
            penCmd11.opCode = 1L;
            penCmd11.x = 7640.0f;
            penCmd11.y = 10080.0f;
            penCmd12 = new ADFTypeSystem.ADFPenCmd();
            penCmd12.opCode = 2L;
            penCmd12.x = 6600.0f;
            penCmd12.y = 13120.0f;
            penCmd12.cx = 6940.0f;
            penCmd12.cy = 11930.0f;
            penCmd13 = new ADFTypeSystem.ADFPenCmd();
            penCmd13.opCode = 2L;
            penCmd13.x = 5810.0f;
            penCmd13.y = 10320.0f;
            penCmd13.cx = 6320.0f;
            penCmd13.cy = 11710.0f;
            penCmd14 = new ADFTypeSystem.ADFPenCmd();
            penCmd14.opCode = 1L;
            penCmd14.x = 4200.0f;
            penCmd14.y = 6020.0f;
            data.mPath.penCmds = new ArrayList(15);
            data.mPath.penCmds.add(0, penCmd0);
            data.mPath.penCmds.add(1, penCmd1);
            data.mPath.penCmds.add(2, penCmd2);
            data.mPath.penCmds.add(3, penCmd3);
            data.mPath.penCmds.add(4, penCmd4);
            data.mPath.penCmds.add(5, penCmd5);
            data.mPath.penCmds.add(6, penCmd6);
            data.mPath.penCmds.add(7, penCmd7);
            data.mPath.penCmds.add(8, penCmd8);
            data.mPath.penCmds.add(9, penCmd9);
            data.mPath.penCmds.add(10, penCmd10);
            data.mPath.penCmds.add(11, penCmd11);
            data.mPath.penCmds.add(12, penCmd12);
            data.mPath.penCmds.add(13, penCmd13);
            data.mPath.penCmds.add(14, penCmd14);
            data.mPath.glyphMinX = -30.0f;
            data.mPath.glyphMinY = -0.0f;
            data.mPath.glyphMaxX = 13690.0f;
            data.mPath.glyphMaxY = 14660.0f;
            data.mPath.numContours = 2;
            data.mPath.numPenCmds = 15L;
        }
        if (charCode == 'B') {
            data.mPath.fontUnitsPerEM = 20480.0f;
            data.mPath.charCode = (char)66;
            penCmd0 = new ADFTypeSystem.ADFPenCmd();
            penCmd0.opCode = 0L;
            penCmd0.x = 1500.0f;
            penCmd0.y = 0.0f;
            penCmd1 = new ADFTypeSystem.ADFPenCmd();
            penCmd1.opCode = 1L;
            penCmd1.x = 1500.0f;
            penCmd1.y = 14660.0f;
            penCmd2 = new ADFTypeSystem.ADFPenCmd();
            penCmd2.opCode = 1L;
            penCmd2.x = 7000.0f;
            penCmd2.y = 14660.0f;
            penCmd3 = new ADFTypeSystem.ADFPenCmd();
            penCmd3.opCode = 2L;
            penCmd3.x = 9695.0f;
            penCmd3.y = 14215.0f;
            penCmd3.cx = 8680.0f;
            penCmd3.cy = 14660.0f;
            penCmd4 = new ADFTypeSystem.ADFPenCmd();
            penCmd4.opCode = 2L;
            penCmd4.x = 11285.0f;
            penCmd4.y = 12845.0f;
            penCmd4.cx = 10710.0f;
            penCmd4.cy = 13770.0f;
            penCmd5 = new ADFTypeSystem.ADFPenCmd();
            penCmd5.opCode = 2L;
            penCmd5.x = 11860.0f;
            penCmd5.y = 10910.0f;
            penCmd5.cx = 11860.0f;
            penCmd5.cy = 11920.0f;
            penCmd6 = new ADFTypeSystem.ADFPenCmd();
            penCmd6.opCode = 2L;
            penCmd6.x = 11350.0f;
            penCmd6.y = 9140.0f;
            penCmd6.cx = 11860.0f;
            penCmd6.cy = 9970.0f;
            penCmd7 = new ADFTypeSystem.ADFPenCmd();
            penCmd7.opCode = 2L;
            penCmd7.x = 9810.0f;
            penCmd7.y = 7800.0f;
            penCmd7.cx = 10840.0f;
            penCmd7.cy = 8310.0f;
            penCmd8 = new ADFTypeSystem.ADFPenCmd();
            penCmd8.opCode = 2L;
            penCmd8.x = 11855.0f;
            penCmd8.y = 6470.0f;
            penCmd8.cx = 11140.0f;
            penCmd8.cy = 7410.0f;
            penCmd9 = new ADFTypeSystem.ADFPenCmd();
            penCmd9.opCode = 2L;
            penCmd9.x = 12570.0f;
            penCmd9.y = 4250.0f;
            penCmd9.cx = 12570.0f;
            penCmd9.cy = 5530.0f;
            penCmd10 = new ADFTypeSystem.ADFPenCmd();
            penCmd10.opCode = 2L;
            penCmd10.x = 12135.0f;
            penCmd10.y = 2335.0f;
            penCmd10.cx = 12570.0f;
            penCmd10.cy = 3220.0f;
            penCmd11 = new ADFTypeSystem.ADFPenCmd();
            penCmd11.opCode = 2L;
            penCmd11.x = 11060.0f;
            penCmd11.y = 970.0f;
            penCmd11.cx = 11700.0f;
            penCmd11.cy = 1450.0f;
            penCmd12 = new ADFTypeSystem.ADFPenCmd();
            penCmd12.opCode = 2L;
            penCmd12.x = 9455.0f;
            penCmd12.y = 245.0f;
            penCmd12.cx = 10420.0f;
            penCmd12.cy = 490.0f;
            penCmd13 = new ADFTypeSystem.ADFPenCmd();
            penCmd13.opCode = 2L;
            penCmd13.x = 7090.0f;
            penCmd13.y = 0.0f;
            penCmd13.cx = 8490.0f;
            penCmd13.cy = 0.0f;
            penCmd14 = new ADFTypeSystem.ADFPenCmd();
            penCmd14.opCode = 1L;
            penCmd14.x = 1500.0f;
            penCmd14.y = 0.0f;
            ADFTypeSystem.ADFPenCmd penCmd15 = new ADFTypeSystem.ADFPenCmd();
            penCmd15.opCode = 0L;
            penCmd15.x = 3440.0f;
            penCmd15.y = 8500.0f;
            ADFTypeSystem.ADFPenCmd penCmd16 = new ADFTypeSystem.ADFPenCmd();
            penCmd16.opCode = 1L;
            penCmd16.x = 6610.0f;
            penCmd16.y = 8500.0f;
            ADFTypeSystem.ADFPenCmd penCmd17 = new ADFTypeSystem.ADFPenCmd();
            penCmd17.opCode = 2L;
            penCmd17.x = 8460.0f;
            penCmd17.y = 8670.0f;
            penCmd17.cx = 7900.0f;
            penCmd17.cy = 8500.0f;
            ADFTypeSystem.ADFPenCmd penCmd18 = new ADFTypeSystem.ADFPenCmd();
            penCmd18.opCode = 2L;
            penCmd18.x = 9575.0f;
            penCmd18.y = 9400.0f;
            penCmd18.cx = 9200.0f;
            penCmd18.cy = 8890.0f;
            ADFTypeSystem.ADFPenCmd penCmd19 = new ADFTypeSystem.ADFPenCmd();
            penCmd19.opCode = 2L;
            penCmd19.x = 9950.0f;
            penCmd19.y = 10680.0f;
            penCmd19.cx = 9950.0f;
            penCmd19.cy = 9910.0f;
            ADFTypeSystem.ADFPenCmd penCmd20 = new ADFTypeSystem.ADFPenCmd();
            penCmd20.opCode = 2L;
            penCmd20.x = 9600.0f;
            penCmd20.y = 11965.0f;
            penCmd20.cx = 9950.0f;
            penCmd20.cy = 11410.0f;
            ADFTypeSystem.ADFPenCmd penCmd21 = new ADFTypeSystem.ADFPenCmd();
            penCmd21.opCode = 2L;
            penCmd21.x = 8600.0f;
            penCmd21.y = 12725.0f;
            penCmd21.cx = 9250.0f;
            penCmd21.cy = 12520.0f;
            ADFTypeSystem.ADFPenCmd penCmd22 = new ADFTypeSystem.ADFPenCmd();
            penCmd22.opCode = 2L;
            penCmd22.x = 6370.0f;
            penCmd22.y = 12930.0f;
            penCmd22.cx = 7950.0f;
            penCmd22.cy = 12930.0f;
            ADFTypeSystem.ADFPenCmd penCmd23 = new ADFTypeSystem.ADFPenCmd();
            penCmd23.opCode = 1L;
            penCmd23.x = 3440.0f;
            penCmd23.y = 12930.0f;
            ADFTypeSystem.ADFPenCmd penCmd24 = new ADFTypeSystem.ADFPenCmd();
            penCmd24.opCode = 1L;
            penCmd24.x = 3440.0f;
            penCmd24.y = 8500.0f;
            ADFTypeSystem.ADFPenCmd penCmd25 = new ADFTypeSystem.ADFPenCmd();
            penCmd25.opCode = 0L;
            penCmd25.x = 3440.0f;
            penCmd25.y = 1730.0f;
            ADFTypeSystem.ADFPenCmd penCmd26 = new ADFTypeSystem.ADFPenCmd();
            penCmd26.opCode = 1L;
            penCmd26.x = 7090.0f;
            penCmd26.y = 1730.0f;
            ADFTypeSystem.ADFPenCmd penCmd27 = new ADFTypeSystem.ADFPenCmd();
            penCmd27.opCode = 2L;
            penCmd27.x = 8410.0f;
            penCmd27.y = 1800.0f;
            penCmd27.cx = 8030.0f;
            penCmd27.cy = 1730.0f;
            ADFTypeSystem.ADFPenCmd penCmd28 = new ADFTypeSystem.ADFPenCmd();
            penCmd28.opCode = 2L;
            penCmd28.x = 9530.0f;
            penCmd28.y = 2200.0f;
            penCmd28.cx = 9080.0f;
            penCmd28.cy = 1920.0f;
            ADFTypeSystem.ADFPenCmd penCmd29 = new ADFTypeSystem.ADFPenCmd();
            penCmd29.opCode = 2L;
            penCmd29.x = 10270.0f;
            penCmd29.y = 3015.0f;
            penCmd29.cx = 9980.0f;
            penCmd29.cy = 2480.0f;
            ADFTypeSystem.ADFPenCmd penCmd30 = new ADFTypeSystem.ADFPenCmd();
            penCmd30.opCode = 2L;
            penCmd30.x = 10560.0f;
            penCmd30.y = 4250.0f;
            penCmd30.cx = 10560.0f;
            penCmd30.cy = 3550.0f;
            ADFTypeSystem.ADFPenCmd penCmd31 = new ADFTypeSystem.ADFPenCmd();
            penCmd31.opCode = 2L;
            penCmd31.x = 10140.0f;
            penCmd31.y = 5675.0f;
            penCmd31.cx = 10560.0f;
            penCmd31.cy = 5070.0f;
            ADFTypeSystem.ADFPenCmd penCmd32 = new ADFTypeSystem.ADFPenCmd();
            penCmd32.opCode = 2L;
            penCmd32.x = 8975.0f;
            penCmd32.y = 6525.0f;
            penCmd32.cx = 9720.0f;
            penCmd32.cy = 6280.0f;
            ADFTypeSystem.ADFPenCmd penCmd33 = new ADFTypeSystem.ADFPenCmd();
            penCmd33.opCode = 2L;
            penCmd33.x = 6830.0f;
            penCmd33.y = 6770.0f;
            penCmd33.cx = 8230.0f;
            penCmd33.cy = 6770.0f;
            ADFTypeSystem.ADFPenCmd penCmd34 = new ADFTypeSystem.ADFPenCmd();
            penCmd34.opCode = 1L;
            penCmd34.x = 3440.0f;
            penCmd34.y = 6770.0f;
            ADFTypeSystem.ADFPenCmd penCmd35 = new ADFTypeSystem.ADFPenCmd();
            penCmd35.opCode = 1L;
            penCmd35.x = 3440.0f;
            penCmd35.y = 1730.0f;
            data.mPath.penCmds = new ArrayList(36);
            data.mPath.penCmds.add(0, penCmd0);
            data.mPath.penCmds.add(1, penCmd1);
            data.mPath.penCmds.add(2, penCmd2);
            data.mPath.penCmds.add(3, penCmd3);
            data.mPath.penCmds.add(4, penCmd4);
            data.mPath.penCmds.add(5, penCmd5);
            data.mPath.penCmds.add(6, penCmd6);
            data.mPath.penCmds.add(7, penCmd7);
            data.mPath.penCmds.add(8, penCmd8);
            data.mPath.penCmds.add(9, penCmd9);
            data.mPath.penCmds.add(10, penCmd10);
            data.mPath.penCmds.add(11, penCmd11);
            data.mPath.penCmds.add(12, penCmd12);
            data.mPath.penCmds.add(13, penCmd13);
            data.mPath.penCmds.add(14, penCmd14);
            data.mPath.penCmds.add(15, penCmd15);
            data.mPath.penCmds.add(16, penCmd16);
            data.mPath.penCmds.add(17, penCmd17);
            data.mPath.penCmds.add(18, penCmd18);
            data.mPath.penCmds.add(19, penCmd19);
            data.mPath.penCmds.add(20, penCmd20);
            data.mPath.penCmds.add(21, penCmd21);
            data.mPath.penCmds.add(22, penCmd22);
            data.mPath.penCmds.add(23, penCmd23);
            data.mPath.penCmds.add(24, penCmd24);
            data.mPath.penCmds.add(25, penCmd25);
            data.mPath.penCmds.add(26, penCmd26);
            data.mPath.penCmds.add(27, penCmd27);
            data.mPath.penCmds.add(28, penCmd28);
            data.mPath.penCmds.add(29, penCmd29);
            data.mPath.penCmds.add(30, penCmd30);
            data.mPath.penCmds.add(31, penCmd31);
            data.mPath.penCmds.add(32, penCmd32);
            data.mPath.penCmds.add(33, penCmd33);
            data.mPath.penCmds.add(34, penCmd34);
            data.mPath.penCmds.add(35, penCmd35);
            data.mPath.glyphMinX = 1500.0f;
            data.mPath.glyphMinY = -0.0f;
            data.mPath.glyphMaxX = 12570.0f;
            data.mPath.glyphMaxY = 14660.0f;
            data.mPath.numContours = 3;
            data.mPath.numPenCmds = 36L;
        }
        if (charCode == 'Z') {
            data.mPath.fontUnitsPerEM = 20480.0f;
            data.mPath.charCode = (char)90;
            penCmd0 = new ADFTypeSystem.ADFPenCmd();
            penCmd0.opCode = 0L;
            penCmd0.x = 410.0f;
            penCmd0.y = 0.0f;
            penCmd1 = new ADFTypeSystem.ADFPenCmd();
            penCmd1.opCode = 1L;
            penCmd1.x = 410.0f;
            penCmd1.y = 1800.0f;
            penCmd2 = new ADFTypeSystem.ADFPenCmd();
            penCmd2.opCode = 1L;
            penCmd2.x = 7920.0f;
            penCmd2.y = 11190.0f;
            penCmd3 = new ADFTypeSystem.ADFPenCmd();
            penCmd3.opCode = 2L;
            penCmd3.x = 9440.0f;
            penCmd3.y = 12930.0f;
            penCmd3.cx = 8720.0f;
            penCmd3.cy = 12190.0f;
            penCmd4 = new ADFTypeSystem.ADFPenCmd();
            penCmd4.opCode = 1L;
            penCmd4.x = 1260.0f;
            penCmd4.y = 12930.0f;
            penCmd5 = new ADFTypeSystem.ADFPenCmd();
            penCmd5.opCode = 1L;
            penCmd5.x = 1260.0f;
            penCmd5.y = 14660.0f;
            penCmd6 = new ADFTypeSystem.ADFPenCmd();
            penCmd6.opCode = 1L;
            penCmd6.x = 11760.0f;
            penCmd6.y = 14660.0f;
            penCmd7 = new ADFTypeSystem.ADFPenCmd();
            penCmd7.opCode = 1L;
            penCmd7.x = 11760.0f;
            penCmd7.y = 12930.0f;
            penCmd8 = new ADFTypeSystem.ADFPenCmd();
            penCmd8.opCode = 1L;
            penCmd8.x = 3530.0f;
            penCmd8.y = 2760.0f;
            penCmd9 = new ADFTypeSystem.ADFPenCmd();
            penCmd9.opCode = 1L;
            penCmd9.x = 2640.0f;
            penCmd9.y = 1730.0f;
            penCmd10 = new ADFTypeSystem.ADFPenCmd();
            penCmd10.opCode = 1L;
            penCmd10.x = 12000.0f;
            penCmd10.y = 1730.0f;
            penCmd11 = new ADFTypeSystem.ADFPenCmd();
            penCmd11.opCode = 1L;
            penCmd11.x = 12000.0f;
            penCmd11.y = 0.0f;
            penCmd12 = new ADFTypeSystem.ADFPenCmd();
            penCmd12.opCode = 1L;
            penCmd12.x = 410.0f;
            penCmd12.y = 0.0f;
            data.mPath.penCmds = new ArrayList(13);
            data.mPath.penCmds.add(0, penCmd0);
            data.mPath.penCmds.add(1, penCmd1);
            data.mPath.penCmds.add(2, penCmd2);
            data.mPath.penCmds.add(3, penCmd3);
            data.mPath.penCmds.add(4, penCmd4);
            data.mPath.penCmds.add(5, penCmd5);
            data.mPath.penCmds.add(6, penCmd6);
            data.mPath.penCmds.add(7, penCmd7);
            data.mPath.penCmds.add(8, penCmd8);
            data.mPath.penCmds.add(9, penCmd9);
            data.mPath.penCmds.add(10, penCmd10);
            data.mPath.penCmds.add(11, penCmd11);
            data.mPath.penCmds.add(12, penCmd12);
            data.mPath.glyphMinX = 410.0f;
            data.mPath.glyphMinY = -0.0f;
            data.mPath.glyphMaxX = 12000.0f;
            data.mPath.glyphMaxY = 14660.0f;
            data.mPath.numContours = 1;
            data.mPath.numPenCmds = 13L;
        }
        if (charCode == 'z') {
            data.mPath.fontUnitsPerEM = 20480.0f;
            data.mPath.charCode = (char)122;
            penCmd0 = new ADFTypeSystem.ADFPenCmd();
            penCmd0.opCode = 0L;
            penCmd0.x = 400.0f;
            penCmd0.y = 0.0f;
            penCmd1 = new ADFTypeSystem.ADFPenCmd();
            penCmd1.opCode = 1L;
            penCmd1.x = 400.0f;
            penCmd1.y = 1460.0f;
            penCmd2 = new ADFTypeSystem.ADFPenCmd();
            penCmd2.opCode = 1L;
            penCmd2.x = 7160.0f;
            penCmd2.y = 9220.0f;
            penCmd3 = new ADFTypeSystem.ADFPenCmd();
            penCmd3.opCode = 2L;
            penCmd3.x = 5130.0f;
            penCmd3.y = 9160.0f;
            penCmd3.cx = 6010.0f;
            penCmd3.cy = 9160.0f;
            penCmd4 = new ADFTypeSystem.ADFPenCmd();
            penCmd4.opCode = 1L;
            penCmd4.x = 800.0f;
            penCmd4.y = 9160.0f;
            penCmd5 = new ADFTypeSystem.ADFPenCmd();
            penCmd5.opCode = 1L;
            penCmd5.x = 800.0f;
            penCmd5.y = 10620.0f;
            penCmd6 = new ADFTypeSystem.ADFPenCmd();
            penCmd6.opCode = 1L;
            penCmd6.x = 9480.0f;
            penCmd6.y = 10620.0f;
            penCmd7 = new ADFTypeSystem.ADFPenCmd();
            penCmd7.opCode = 1L;
            penCmd7.x = 9480.0f;
            penCmd7.y = 9430.0f;
            penCmd8 = new ADFTypeSystem.ADFPenCmd();
            penCmd8.opCode = 1L;
            penCmd8.x = 3730.0f;
            penCmd8.y = 2690.0f;
            penCmd9 = new ADFTypeSystem.ADFPenCmd();
            penCmd9.opCode = 1L;
            penCmd9.x = 2620.0f;
            penCmd9.y = 1460.0f;
            penCmd10 = new ADFTypeSystem.ADFPenCmd();
            penCmd10.opCode = 2L;
            penCmd10.x = 4890.0f;
            penCmd10.y = 1550.0f;
            penCmd10.cx = 3830.0f;
            penCmd10.cy = 1550.0f;
            penCmd11 = new ADFTypeSystem.ADFPenCmd();
            penCmd11.opCode = 1L;
            penCmd11.x = 9800.0f;
            penCmd11.y = 1550.0f;
            penCmd12 = new ADFTypeSystem.ADFPenCmd();
            penCmd12.opCode = 1L;
            penCmd12.x = 9800.0f;
            penCmd12.y = 0.0f;
            penCmd13 = new ADFTypeSystem.ADFPenCmd();
            penCmd13.opCode = 1L;
            penCmd13.x = 400.0f;
            penCmd13.y = 0.0f;
            data.mPath.penCmds = new ArrayList(14);
            data.mPath.penCmds.add(0, penCmd0);
            data.mPath.penCmds.add(1, penCmd1);
            data.mPath.penCmds.add(2, penCmd2);
            data.mPath.penCmds.add(3, penCmd3);
            data.mPath.penCmds.add(4, penCmd4);
            data.mPath.penCmds.add(5, penCmd5);
            data.mPath.penCmds.add(6, penCmd6);
            data.mPath.penCmds.add(7, penCmd7);
            data.mPath.penCmds.add(8, penCmd8);
            data.mPath.penCmds.add(9, penCmd9);
            data.mPath.penCmds.add(10, penCmd10);
            data.mPath.penCmds.add(11, penCmd11);
            data.mPath.penCmds.add(12, penCmd12);
            data.mPath.penCmds.add(13, penCmd13);
            data.mPath.glyphMinX = 400.0f;
            data.mPath.glyphMinY = -0.0f;
            data.mPath.glyphMaxX = 9800.0f;
            data.mPath.glyphMaxY = 10620.0f;
            data.mPath.numContours = 1;
            data.mPath.numPenCmds = 14L;
        }
        if (charCode == 'L') {
            data.mPath.fontUnitsPerEM = 20480.0f;
            data.mPath.charCode = (char)76;
            penCmd0 = new ADFTypeSystem.ADFPenCmd();
            penCmd0.opCode = 0L;
            penCmd0.x = 1500.0f;
            penCmd0.y = 0.0f;
            penCmd1 = new ADFTypeSystem.ADFPenCmd();
            penCmd1.opCode = 1L;
            penCmd1.x = 1500.0f;
            penCmd1.y = 14660.0f;
            penCmd2 = new ADFTypeSystem.ADFPenCmd();
            penCmd2.opCode = 1L;
            penCmd2.x = 3440.0f;
            penCmd2.y = 14660.0f;
            penCmd3 = new ADFTypeSystem.ADFPenCmd();
            penCmd3.opCode = 1L;
            penCmd3.x = 3440.0f;
            penCmd3.y = 1730.0f;
            penCmd4 = new ADFTypeSystem.ADFPenCmd();
            penCmd4.opCode = 1L;
            penCmd4.x = 10660.0f;
            penCmd4.y = 1730.0f;
            penCmd5 = new ADFTypeSystem.ADFPenCmd();
            penCmd5.opCode = 1L;
            penCmd5.x = 10660.0f;
            penCmd5.y = 0.0f;
            penCmd6 = new ADFTypeSystem.ADFPenCmd();
            penCmd6.opCode = 1L;
            penCmd6.x = 1500.0f;
            penCmd6.y = 0.0f;
            data.mPath.penCmds = new ArrayList(7);
            data.mPath.penCmds.add(0, penCmd0);
            data.mPath.penCmds.add(1, penCmd1);
            data.mPath.penCmds.add(2, penCmd2);
            data.mPath.penCmds.add(3, penCmd3);
            data.mPath.penCmds.add(4, penCmd4);
            data.mPath.penCmds.add(5, penCmd5);
            data.mPath.penCmds.add(6, penCmd6);
            data.mPath.glyphMinX = 1500.0f;
            data.mPath.glyphMinY = -0.0f;
            data.mPath.glyphMaxX = 10660.0f;
            data.mPath.glyphMaxY = 14660.0f;
            data.mPath.numContours = 1;
            data.mPath.numPenCmds = 7L;
        }
        if (charCode == 'l') {
            data.mPath.fontUnitsPerEM = 20480.0f;
            data.mPath.charCode = (char)108;
            penCmd0 = new ADFTypeSystem.ADFPenCmd();
            penCmd0.opCode = 0L;
            penCmd0.x = 1310.0f;
            penCmd0.y = 0.0f;
            penCmd1 = new ADFTypeSystem.ADFPenCmd();
            penCmd1.opCode = 1L;
            penCmd1.x = 1310.0f;
            penCmd1.y = 14660.0f;
            penCmd2 = new ADFTypeSystem.ADFPenCmd();
            penCmd2.opCode = 1L;
            penCmd2.x = 3110.0f;
            penCmd2.y = 14660.0f;
            penCmd3 = new ADFTypeSystem.ADFPenCmd();
            penCmd3.opCode = 1L;
            penCmd3.x = 3110.0f;
            penCmd3.y = 0.0f;
            penCmd4 = new ADFTypeSystem.ADFPenCmd();
            penCmd4.opCode = 1L;
            penCmd4.x = 1310.0f;
            penCmd4.y = 0.0f;
            data.mPath.penCmds = new ArrayList(5);
            data.mPath.penCmds.add(0, penCmd0);
            data.mPath.penCmds.add(1, penCmd1);
            data.mPath.penCmds.add(2, penCmd2);
            data.mPath.penCmds.add(3, penCmd3);
            data.mPath.penCmds.add(4, penCmd4);
            data.mPath.glyphMinX = 1310.0f;
            data.mPath.glyphMinY = -0.0f;
            data.mPath.glyphMaxX = 3110.0f;
            data.mPath.glyphMaxY = 14660.0f;
            data.mPath.numContours = 1;
            data.mPath.numPenCmds = 5L;
        }
        if (charCode == 'H') {
            data.mPath.fontUnitsPerEM = 20480.0f;
            data.mPath.charCode = (char)72;
            penCmd0 = new ADFTypeSystem.ADFPenCmd();
            penCmd0.opCode = 0L;
            penCmd0.x = 1640.0f;
            penCmd0.y = 0.0f;
            penCmd1 = new ADFTypeSystem.ADFPenCmd();
            penCmd1.opCode = 1L;
            penCmd1.x = 1640.0f;
            penCmd1.y = 14660.0f;
            penCmd2 = new ADFTypeSystem.ADFPenCmd();
            penCmd2.opCode = 1L;
            penCmd2.x = 3580.0f;
            penCmd2.y = 14660.0f;
            penCmd3 = new ADFTypeSystem.ADFPenCmd();
            penCmd3.opCode = 1L;
            penCmd3.x = 3580.0f;
            penCmd3.y = 8640.0f;
            penCmd4 = new ADFTypeSystem.ADFPenCmd();
            penCmd4.opCode = 1L;
            penCmd4.x = 11200.0f;
            penCmd4.y = 8640.0f;
            penCmd5 = new ADFTypeSystem.ADFPenCmd();
            penCmd5.opCode = 1L;
            penCmd5.x = 11200.0f;
            penCmd5.y = 14660.0f;
            penCmd6 = new ADFTypeSystem.ADFPenCmd();
            penCmd6.opCode = 1L;
            penCmd6.x = 13140.0f;
            penCmd6.y = 14660.0f;
            penCmd7 = new ADFTypeSystem.ADFPenCmd();
            penCmd7.opCode = 1L;
            penCmd7.x = 13140.0f;
            penCmd7.y = 0.0f;
            penCmd8 = new ADFTypeSystem.ADFPenCmd();
            penCmd8.opCode = 1L;
            penCmd8.x = 11200.0f;
            penCmd8.y = 0.0f;
            penCmd9 = new ADFTypeSystem.ADFPenCmd();
            penCmd9.opCode = 1L;
            penCmd9.x = 11200.0f;
            penCmd9.y = 6910.0f;
            penCmd10 = new ADFTypeSystem.ADFPenCmd();
            penCmd10.opCode = 1L;
            penCmd10.x = 3580.0f;
            penCmd10.y = 6910.0f;
            penCmd11 = new ADFTypeSystem.ADFPenCmd();
            penCmd11.opCode = 1L;
            penCmd11.x = 3580.0f;
            penCmd11.y = 0.0f;
            penCmd12 = new ADFTypeSystem.ADFPenCmd();
            penCmd12.opCode = 1L;
            penCmd12.x = 1640.0f;
            penCmd12.y = 0.0f;
            data.mPath.penCmds = new ArrayList(13);
            data.mPath.penCmds.add(0, penCmd0);
            data.mPath.penCmds.add(1, penCmd1);
            data.mPath.penCmds.add(2, penCmd2);
            data.mPath.penCmds.add(3, penCmd3);
            data.mPath.penCmds.add(4, penCmd4);
            data.mPath.penCmds.add(5, penCmd5);
            data.mPath.penCmds.add(6, penCmd6);
            data.mPath.penCmds.add(7, penCmd7);
            data.mPath.penCmds.add(8, penCmd8);
            data.mPath.penCmds.add(9, penCmd9);
            data.mPath.penCmds.add(10, penCmd10);
            data.mPath.penCmds.add(11, penCmd11);
            data.mPath.penCmds.add(12, penCmd12);
            data.mPath.glyphMinX = 1640.0f;
            data.mPath.glyphMinY = -0.0f;
            data.mPath.glyphMaxX = 13140.0f;
            data.mPath.glyphMaxY = 14660.0f;
            data.mPath.numContours = 1;
            data.mPath.numPenCmds = 13L;
        }
        return data.mPath;
    }
}

