/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.agl.charset;

import com.adobe.agl.common.ErrorCode;
import com.adobe.agl.converters.NativeConverter;
import com.adobe.agl.converters.UConverter;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;

public final class CharsetEncoderICU
extends CharsetEncoder {
    private int[] data = new int[3];
    private static final int INPUT_CONSUMED = 0;
    private static final int OUTPUT_WRITTEN = 1;
    private static final int INVALID_CHARS = 2;
    private final UConverter converterHandle;
    private char[] input = null;
    private byte[] output = null;
    private int inEnd;
    private int outEnd;
    private int save;
    private int ec;
    private int icuAction;

    public CharsetEncoderICU(Charset cs, UConverter cHandle) {
        super(cs, NativeConverter.getAveBytesPerChar(cHandle), NativeConverter.getMaxBytesPerChar(cHandle), NativeConverter.getSubstitutionBytes(cHandle));
        this.ec = NativeConverter.setCallbackEncode(cHandle, 0, false);
        this.converterHandle = cHandle;
        if (ErrorCode.isFailure(this.ec)) {
            throw ErrorCode.getException(this.ec);
        }
    }

    protected void implReplaceWith(byte[] newReplacement) {
        if (this.converterHandle != null) {
            if (newReplacement.length > NativeConverter.getMaxBytesPerChar(this.converterHandle)) {
                System.out.println(this.converterHandle);
                throw new IllegalArgumentException("Number of replacement Bytes are greater than max bytes per char");
            }
            this.ec = NativeConverter.setSubstitutionBytes(this.converterHandle, newReplacement, newReplacement.length);
            if (ErrorCode.isFailure(this.ec)) {
                throw ErrorCode.getException(this.ec);
            }
        }
    }

    protected void implOnMalformedInput(CodingErrorAction newAction) {
        this.icuAction = 0;
        if (newAction.equals(CodingErrorAction.IGNORE)) {
            this.icuAction = 1;
        } else if (newAction.equals(CodingErrorAction.REPLACE)) {
            this.icuAction = 3;
        }
        this.ec = NativeConverter.setCallbackEncode(this.converterHandle, this.icuAction, false);
        if (ErrorCode.isFailure(this.ec)) {
            throw ErrorCode.getException(this.ec);
        }
    }

    protected void implOnUnmappableCharacter(CodingErrorAction newAction) {
        this.icuAction = 0;
        if (newAction.equals(CodingErrorAction.IGNORE)) {
            this.icuAction = 1;
        } else if (newAction.equals(CodingErrorAction.REPLACE)) {
            this.icuAction = 3;
        }
        this.ec = NativeConverter.setCallbackEncode(this.converterHandle, this.icuAction, true);
        if (ErrorCode.isFailure(this.ec)) {
            throw ErrorCode.getException(this.ec);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CoderResult implFlush(ByteBuffer out) {
        try {
            this.getArray(out);
            this.ec = NativeConverter.flushCharToByte(this.converterHandle, this.output, this.outEnd, this.data);
            if (ErrorCode.isFailure(this.ec)) {
                if (this.ec == 15) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                ErrorCode.getException(this.ec);
            }
            this.implReset();
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            this.setPosition(out);
        }
    }

    protected void implReset() {
        NativeConverter.resetCharToByte(this.converterHandle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CoderResult encodeLoop(CharBuffer in, ByteBuffer out) {
        if (!in.hasRemaining()) {
            return CoderResult.UNDERFLOW;
        }
        this.getArray(in);
        this.getArray(out);
        try {
            this.ec = NativeConverter.encode(this.converterHandle, this.input, this.inEnd, this.output, this.outEnd, this.data, false);
            if (ErrorCode.isFailure(this.ec)) {
                if (this.ec == 15) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                if (this.ec == 10) {
                    CoderResult coderResult = CoderResult.unmappableForLength(this.data[2]);
                    return coderResult;
                }
                if (this.ec == 12) {
                    CoderResult coderResult = CoderResult.malformedForLength(this.data[2]);
                    return coderResult;
                }
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            this.setPosition(in);
            this.setPosition(out);
        }
    }

    public boolean canEncode(char c) {
        return this.canEncode((int)c);
    }

    public boolean canEncode(int codepoint) {
        return NativeConverter.canEncode(this.converterHandle, codepoint);
    }

    public boolean isLegalReplacement(byte[] repl) {
        return NativeConverter.isValidSubstitutionBytes(this.charset().name(), repl);
    }

    protected void finalize() throws Throwable {
        NativeConverter.closeConverter(this.converterHandle);
        super.finalize();
    }

    private final void getArray(ByteBuffer out) {
        if (out.hasArray()) {
            this.output = out.array();
            this.outEnd = out.arrayOffset() + out.limit();
            this.data[1] = out.arrayOffset() + out.position();
        } else {
            this.outEnd = out.remaining();
            if (this.output == null || this.outEnd > this.output.length) {
                this.output = new byte[this.outEnd];
            }
            this.data[1] = 0;
        }
    }

    private final void getArray(CharBuffer in) {
        if (in.hasArray()) {
            this.input = in.array();
            this.inEnd = in.arrayOffset() + in.limit();
            this.data[0] = in.arrayOffset() + in.position();
        } else {
            this.inEnd = in.remaining();
            if (this.input == null || this.inEnd > this.input.length) {
                this.input = new char[this.inEnd];
            }
            int pos = in.position();
            in.get(this.input, 0, this.inEnd);
            in.position(pos);
            this.data[0] = 0;
        }
    }

    private final void setPosition(ByteBuffer out) {
        if (out.hasArray()) {
            out.position(out.position() + this.data[1] - out.arrayOffset());
        } else {
            out.put(this.output, 0, this.data[1]);
        }
    }

    private final void setPosition(CharBuffer in) {
        if (in.hasArray()) {
            in.position(in.position() + this.data[0] - in.arrayOffset());
        } else {
            in.position(in.position() + this.data[0]);
        }
    }
}

