/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.mxml;

import flash.localization.LocalizationManager;
import flex2.compiler.ILocalizableMessage;
import flex2.compiler.Logger;
import flex2.compiler.util.LineNumberMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class LogAdapter
implements Logger {
    private Logger original;
    private LineNumberMap map;
    private List extras;
    private Map renamedVariableMap;
    private Map messages;
    static final /* synthetic */ boolean $assertionsDisabled;

    public LogAdapter(Logger original, LineNumberMap map) {
        this.original = original;
        this.map = map;
    }

    public void setRenamedVariableMap(Map renamedVariableMap) {
        this.renamedVariableMap = renamedVariableMap;
    }

    public int errorCount() {
        return this.original.errorCount();
    }

    public int warningCount() {
        return this.original.warningCount();
    }

    public void addLineNumberMap(LineNumberMap map) {
        if (this.extras == null) {
            this.extras = new ArrayList(5);
        }
        this.extras.add(map);
    }

    public void addLineNumberMaps(Collection c) {
        if (c != null && this.extras == null) {
            this.extras = new ArrayList(5);
        }
        if (c != null) {
            this.extras.addAll(c);
        }
    }

    public void logInfo(String info) {
        this.original.logInfo(info);
    }

    public void logDebug(String debug) {
        this.original.logDebug(debug);
    }

    public void logWarning(String warning) {
        this.original.logWarning(warning);
    }

    public void logError(String error) {
        this.original.logError(error);
    }

    public void logInfo(String path, String info) {
        LineNumberMap map = null;
        map = this.matchPath(path);
        if (map != null) {
            this.original.logInfo(map.getOldName(), info);
        } else {
            this.original.logInfo(path, info);
        }
    }

    public void logDebug(String path, String debug) {
        LineNumberMap map = null;
        map = this.matchPath(path);
        if (map != null) {
            this.original.logDebug(map.getOldName(), debug);
        } else {
            this.original.logDebug(path, debug);
        }
    }

    public void logWarning(String path, String warning) {
        LineNumberMap map = null;
        map = this.matchPath(path);
        if (map != null) {
            this.original.logWarning(map.getOldName(), warning);
        } else {
            this.original.logWarning(path, warning);
        }
    }

    public void logWarning(String path, String warning, int errorCode) {
        LineNumberMap map = null;
        map = this.matchPath(path);
        if (map != null) {
            this.original.logWarning(map.getOldName(), warning, errorCode);
        } else {
            this.original.logWarning(path, warning, errorCode);
        }
    }

    public void logError(String path, String error) {
        LineNumberMap map = null;
        map = this.matchPath(path);
        if (map != null) {
            this.original.logError(map.getOldName(), error);
        } else {
            this.original.logError(path, error);
        }
    }

    public void logError(String path, String error, int errorCode) {
        LineNumberMap map = null;
        map = this.matchPath(path);
        if (map != null) {
            this.original.logError(map.getOldName(), error, errorCode);
        } else {
            this.original.logError(path, error, errorCode);
        }
    }

    public void logInfo(String path, int line, String info) {
        LineNumberMap map = null;
        map = this.matchPath(path);
        if (map != null) {
            if (this.isUserDefined(map, line)) {
                this.original.logInfo(map.getOldName(), map.get(line), info);
            } else {
                this.original.logInfo(path, line, info);
            }
        } else {
            this.original.logInfo(path, line, info);
        }
    }

    public void logDebug(String path, int line, String debug) {
        LineNumberMap map = null;
        map = this.matchPath(path);
        if (map != null) {
            if (this.isUserDefined(map, line)) {
                this.original.logDebug(map.getOldName(), map.get(line), debug);
            } else {
                this.original.logDebug(path, line, debug);
            }
        } else {
            this.original.logDebug(path, line, debug);
        }
    }

    public void logWarning(String path, int line, String warning) {
        LineNumberMap map = null;
        map = this.matchPath(path);
        if (map != null) {
            if (this.isUserDefined(map, line)) {
                this.original.logWarning(map.getOldName(), map.get(line), warning);
            } else {
                this.original.logWarning(path, line, warning);
            }
        } else {
            this.original.logWarning(path, line, warning);
        }
    }

    public void logWarning(String path, int line, String warning, int errorCode) {
        LineNumberMap map = null;
        map = this.matchPath(path);
        if (map != null) {
            if (this.isUserDefined(map, line)) {
                this.original.logWarning(map.getOldName(), map.get(line), warning, errorCode);
            } else {
                this.original.logWarning(path, line, warning, errorCode);
            }
        } else {
            this.original.logWarning(path, line, warning, errorCode);
        }
    }

    public void logError(String path, int line, String error) {
        LineNumberMap map = null;
        map = this.matchPath(path);
        if (map != null) {
            if (this.isUserDefined(map, line)) {
                this.original.logError(map.getOldName(), map.get(line), error);
            } else {
                this.original.logError(path, line, error);
            }
        } else {
            this.original.logError(path, line, error);
        }
    }

    public void logError(String path, int line, String error, int errorCode) {
        LineNumberMap map = null;
        map = this.matchPath(path);
        if (map != null) {
            if (this.isUserDefined(map, line)) {
                this.original.logError(map.getOldName(), map.get(line), error, errorCode);
            } else {
                this.original.logError(path, line, error, errorCode);
            }
        } else {
            this.original.logError(path, line, error, errorCode);
        }
    }

    public void logInfo(String path, int line, int col, String info) {
        LineNumberMap map = null;
        map = this.matchPath(path);
        if (map != null) {
            if (this.isUserDefined(map, line)) {
                this.original.logInfo(map.getOldName(), map.get(line), info);
            } else {
                this.original.logInfo(path, line, col, info);
            }
        } else {
            this.original.logInfo(path, line, col, info);
        }
    }

    public void logDebug(String path, int line, int col, String debug) {
        LineNumberMap map = null;
        map = this.matchPath(path);
        if (map != null) {
            if (this.isUserDefined(map, line)) {
                this.original.logDebug(map.getOldName(), map.get(line), debug);
            } else {
                this.original.logDebug(path, line, col, debug);
            }
        } else {
            this.original.logDebug(path, line, col, debug);
        }
    }

    public void logWarning(String path, int line, int col, String warning) {
        LineNumberMap map = null;
        map = this.matchPath(path);
        if (map != null) {
            if (this.isUserDefined(map, line)) {
                this.original.logWarning(map.getOldName(), map.get(line), warning);
            } else {
                this.original.logWarning(path, line, col, warning);
            }
        } else {
            this.original.logWarning(path, line, col, warning);
        }
    }

    public void logError(String path, int line, int col, String error) {
        LineNumberMap map = null;
        map = this.matchPath(path);
        if (map != null) {
            if (this.isUserDefined(map, line)) {
                this.original.logError(map.getOldName(), map.get(line), error);
            } else {
                this.original.logError(path, line, col, error);
            }
        } else {
            this.original.logError(path, line, col, error);
        }
    }

    public void logWarning(String path, int line, int col, String warning, String source) {
        warning = this.mapRenamedVariables(warning);
        LineNumberMap map = null;
        map = this.matchPath(path);
        if (map != null) {
            if (this.isUserDefined(map, line)) {
                String key;
                if (this.messages == null) {
                    this.messages = new HashMap();
                }
                if (!warning.equals((String)this.messages.get(key = map.getOldName() + map.get(line)))) {
                    this.original.logWarning(map.getOldName(), map.get(line), warning);
                    this.messages.put(key, warning);
                }
            } else {
                this.original.logWarning(path, line, col, warning, source);
            }
        } else {
            this.original.logWarning(path, line, col, warning, source);
        }
    }

    public void logWarning(String path, int line, int col, String warning, String source, int errorCode) {
        warning = this.mapRenamedVariables(warning);
        LineNumberMap map = null;
        map = this.matchPath(path);
        if (map != null) {
            if (this.isUserDefined(map, line)) {
                String key;
                if (this.messages == null) {
                    this.messages = new HashMap();
                }
                if (!warning.equals((String)this.messages.get(key = map.getOldName() + map.get(line)))) {
                    this.original.logWarning(map.getOldName(), map.get(line), warning, errorCode);
                    this.messages.put(key, warning);
                }
            } else {
                this.original.logWarning(path, line, col, warning, source, errorCode);
            }
        } else {
            this.original.logWarning(path, line, col, warning, source, errorCode);
        }
    }

    public void logError(String path, int line, int col, String error, String source) {
        LineNumberMap map = null;
        map = this.matchPath(path);
        if (map != null) {
            if (this.isUserDefined(map, line)) {
                String key;
                if (this.messages == null) {
                    this.messages = new HashMap();
                }
                if (!error.equals((String)this.messages.get(key = map.getOldName() + map.get(line)))) {
                    this.original.logError(map.getOldName(), map.get(line), error);
                    this.messages.put(key, error);
                }
            } else {
                this.original.logError(path, line, col, error, source);
            }
        } else {
            this.original.logError(path, line, col, error, source);
        }
    }

    public void logError(String path, int line, int col, String error, String source, int errorCode) {
        LineNumberMap map = null;
        map = this.matchPath(path);
        if (map != null) {
            if (this.isUserDefined(map, line)) {
                String key;
                if (this.messages == null) {
                    this.messages = new HashMap();
                }
                if (!error.equals((String)this.messages.get(key = map.getOldName() + map.get(line)))) {
                    this.original.logError(map.getOldName(), map.get(line), error, errorCode);
                    this.messages.put(key, error);
                }
            } else {
                this.original.logError(path, line, col, error, source, errorCode);
            }
        } else {
            this.original.logError(path, line, col, error, source, errorCode);
        }
    }

    public void log(ILocalizableMessage m) {
        this.log(m, null);
    }

    public void log(ILocalizableMessage m, String source) {
        LineNumberMap map = null;
        map = this.matchPath(m.getPath());
        if (map != null) {
            if (this.isUserDefined(map, m.getLine())) {
                m.setPath(map.getOldName());
                m.setLine(map.get(m.getLine()));
                m.setColumn(-1);
                source = null;
            } else if (!$assertionsDisabled) {
                throw new AssertionError((Object)"codegen-specific error...");
            }
        }
        if (source == null) {
            this.original.log(m);
        } else {
            this.original.log(m, source);
        }
    }

    public void needsCompilation(String path, String reason) {
        this.original.needsCompilation(path, reason);
    }

    public void includedFileUpdated(String path) {
        this.original.includedFileUpdated(path);
    }

    public void includedFileAffected(String path) {
        this.original.includedFileAffected(path);
    }

    public void setLocalizationManager(LocalizationManager mgr) {
    }

    private LineNumberMap matchPath(String path) {
        int size;
        if (this.map != null && this.map.getNewName().equals(path)) {
            return this.map;
        }
        int n = size = this.extras == null ? 0 : this.extras.size();
        for (int i = 0; i < size; ++i) {
            LineNumberMap m = (LineNumberMap)this.extras.get(i);
            if (!m.getNewName().equals(path)) continue;
            return m;
        }
        return null;
    }

    private boolean isUserDefined(LineNumberMap map, int line) {
        return map.get(line) > 0;
    }

    private String mapRenamedVariables(String message) {
        if (this.renamedVariableMap != null) {
            Iterator iterator = this.renamedVariableMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String newVariableName = (String)entry.getKey();
                String oldVariableName = (String)entry.getValue();
                message = message.replaceAll("'" + newVariableName + "'", "'" + oldVariableName + "'");
            }
        }
        return message;
    }

    static {
        $assertionsDisabled = !LogAdapter.class.desiredAssertionStatus();
    }
}

