/*
 * Decompiled with CFR 0.152.
 */
package flash.fonts;

import org.apache.batik.svggen.font.Font;
import org.apache.batik.svggen.font.table.Os2Table;

public class FSType {
    public int fsType;
    public String description;
    public boolean installable;
    public boolean editable;
    public boolean previewAndPrint;
    public boolean noEmbedding;
    public boolean usableByFlex;

    public FSType(int fsType, String description, boolean installable, boolean editable, boolean previewAndPrint, boolean noEmbedding) {
        this.fsType = fsType;
        this.description = description;
        this.installable = installable;
        this.editable = editable;
        this.previewAndPrint = previewAndPrint;
        this.noEmbedding = noEmbedding;
        this.usableByFlex = true;
    }

    public static FSType getFSType(Font font) {
        Os2Table table = font.getOS2Table();
        return FSType.getFSType(table.getLicenseType());
    }

    public static FSType getFSType(int lt) {
        String description;
        boolean editableBit;
        boolean installable = false;
        boolean editable = false;
        boolean previewAndPrint = false;
        boolean noEmbedding = false;
        boolean noEmbeddingBit = (lt & 2) == 2;
        boolean previewAndPrintBit = (lt & 4) == 4;
        boolean bl = editableBit = (lt & 8) == 8;
        if (editableBit) {
            editable = true;
            description = "Editable embedding";
        } else if (previewAndPrintBit) {
            previewAndPrint = true;
            description = "Preview and Print embedding";
        } else if (noEmbeddingBit) {
            noEmbedding = true;
            description = "No embedding allowed";
        } else {
            installable = true;
            description = "Installable embedding";
        }
        return new FSType(lt, description, installable, editable, previewAndPrint, noEmbedding);
    }
}

