/*
 * Decompiled with CFR 0.152.
 */
package flex.webtier.server.j2ee.cache;

import flex.webtier.server.j2ee.FileNameGenerator;
import flex.webtier.server.j2ee.URLHelper;
import flex.webtier.services.ServiceFactory;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class CacheKeyUtils {
    private static String asExt;
    private static String asSwfExt;
    private static String mxmlExt;
    private static String mxmlSwdExt;
    private static String mxmlSwfExt;

    public static String generateGenericCacheKey(HttpServletRequest request, UrlData data) {
        StringBuffer key = new StringBuffer("//");
        String uri = CacheKeyUtils.getRequestURL(request);
        uri = CacheKeyUtils.parseUri(uri, data);
        key.append(uri);
        return key.toString();
    }

    public static String generateSwfCacheKey(HttpServletRequest request, UrlData data) {
        String base;
        int lastSlashIndex;
        StringBuffer key = new StringBuffer("//");
        String uri = CacheKeyUtils.getRequestURL(request);
        uri = CacheKeyUtils.parseUri(uri, data);
        if (!ServiceFactory.isMxmlSwfExtension() && (lastSlashIndex = uri.lastIndexOf(47)) != -1 && (base = uri.substring(lastSlashIndex + 1)).length() >= 32 && base.startsWith("jsp")) {
            uri = uri.replaceFirst(base, base.substring(3));
        }
        key.append(FileNameGenerator.swfFileName(uri));
        CacheKeyUtils.appendCompilerDirectives(key, request.getQueryString());
        return key.toString();
    }

    public static String generateJspCacheKey(HttpServletRequest request, String sourceKey) {
        if (mxmlSwfExt == null) {
            mxmlSwfExt = ServiceFactory.isMxmlSwfExtension() ? ServiceFactory.getExtensionManager().getMxmlSwfExt() : ServiceFactory.getExtensionManager().getSwfExt();
        }
        String requestUrl = CacheKeyUtils.getRequestURL(request);
        StringBuffer key = new StringBuffer("//");
        key.append(requestUrl.substring(0, requestUrl.lastIndexOf(47) + 1));
        key.append(sourceKey);
        key.append(mxmlSwfExt);
        CacheKeyUtils.appendCompilerDirectives(key, request.getQueryString());
        return key.toString();
    }

    public static String generateJspExternalCacheKey(HttpServletRequest request, String sourceKey, String queryString) {
        if (mxmlSwfExt == null) {
            mxmlSwfExt = ServiceFactory.isMxmlSwfExtension() ? ServiceFactory.getExtensionManager().getMxmlSwfExt() : ServiceFactory.getExtensionManager().getSwfExt();
        }
        String requestUrl = CacheKeyUtils.getRequestURL(request);
        StringBuffer key = new StringBuffer("//");
        int contextPathEnd = requestUrl.indexOf(request.getContextPath()) + request.getContextPath().length();
        key.append(requestUrl.substring(0, contextPathEnd));
        key.append(sourceKey);
        key.append(mxmlSwfExt);
        CacheKeyUtils.appendCompilerDirectives(key, queryString);
        return key.toString();
    }

    public static StringBuffer appendCompilerDirectives(StringBuffer url, String queryString) {
        if (queryString != null) {
            Map params = URLHelper.getParameterMap(queryString);
            Set entries = params.entrySet();
            Iterator iter = entries.iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                if (CacheKeyUtils.isCompilerDirective((String)entry.getKey())) continue;
                iter.remove();
            }
            String query = URLHelper.encode(params);
            if (query != null) {
                if (url.indexOf("?") == -1) {
                    url.append("?");
                } else {
                    url.append("&");
                }
                url.append(query);
            }
        }
        return url;
    }

    private static String parseUri(String uri, UrlData data) {
        String newUri = uri;
        String sessionPathMatch = ";JSESSIONID=";
        int index = uri.indexOf(sessionPathMatch);
        if (index == -1) {
            sessionPathMatch = ";jsessionid=";
            index = uri.indexOf(sessionPathMatch);
        }
        if (index != -1) {
            String id = uri.substring(index + sessionPathMatch.length());
            newUri = uri.substring(0, index);
            index = id.indexOf(59);
            if (index < 0) {
                index = id.length();
            }
            if (data != null) {
                data.sessionId = id.substring(0, index);
            }
        }
        return newUri;
    }

    public static UrlData getUrlData(HttpServletRequest request) {
        if (mxmlSwdExt == null) {
            mxmlSwdExt = ServiceFactory.getExtensionManager().getMxmlSwdExt();
        }
        if (mxmlSwfExt == null) {
            mxmlSwfExt = ServiceFactory.isMxmlSwfExtension() ? ServiceFactory.getExtensionManager().getMxmlSwfExt() : ServiceFactory.getExtensionManager().getSwfExt();
        }
        if (mxmlExt == null) {
            mxmlExt = ServiceFactory.getExtensionManager().getMxmlExt();
        }
        if (asExt == null) {
            asExt = ServiceFactory.getExtensionManager().getAsExt();
        }
        if (asSwfExt == null) {
            asSwfExt = ServiceFactory.getExtensionManager().getAsSwfExt();
        }
        UrlData data = new UrlData();
        String url = CacheKeyUtils.getRequestURL(request);
        boolean bl = data.isSwd = url.indexOf(mxmlSwdExt) != -1;
        data.cacheKey = url.indexOf(mxmlSwfExt) != -1 || url.indexOf(asSwfExt) != -1 || data.isSwd ? CacheKeyUtils.generateSwfCacheKey(request, data) : (url.indexOf(mxmlExt) != -1 || url.indexOf(asExt) != -1 ? CacheKeyUtils.generateSwfCacheKey(request, data) : CacheKeyUtils.generateGenericCacheKey(request, data));
        return data;
    }

    public static boolean isCompilerDirective(String key) {
        boolean directive = false;
        if (key != null && (key.equals("accessible") || key.equals("debug") || key.equals("asprofile") || key.equals("verboseStacktraces") || key.equals("networkCapturePort"))) {
            directive = true;
        }
        return directive;
    }

    private static String getRequestURL(HttpServletRequest request) {
        StringBuffer requestURL = request.getRequestURL();
        if (requestURL == null) {
            requestURL = new StringBuffer(request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getRequestURI());
        }
        return requestURL != null ? requestURL.toString() : null;
    }

    public static class UrlData {
        public String cacheKey;
        public String sessionId;
        public boolean isSwd = false;
    }
}

