/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.agl.converters;

import com.adobe.agl.common.ErrorCode;
import com.adobe.agl.converters.NativeConverter;
import com.adobe.agl.converters.UConverter;
import java.io.UnsupportedEncodingException;
import sun.io.ByteToCharConverter;
import sun.io.ConversionBufferFullException;
import sun.io.MalformedInputException;
import sun.io.UnknownCharacterException;

public class ByteToCharConverterICU
extends ByteToCharConverter {
    private int[] data = new int[2];
    private final UConverter converterHandle;
    private final String encoding;

    public ByteToCharConverterICU(String enc) throws UnsupportedEncodingException {
        this.encoding = enc;
        this.data[0] = 0;
        this.data[1] = 0;
        UConverter[] converterHandleArr = new UConverter[1];
        if (!ErrorCode.LIBRARY_LOADED) {
            ErrorCode.LIBRARY_LOADED = true;
        }
        if (NativeConverter.openConverter(converterHandleArr, enc) > 0) {
            throw new UnsupportedEncodingException();
        }
        this.converterHandle = converterHandleArr[0];
    }

    private ByteToCharConverterICU(UConverter convHandle, String enc) {
        this.converterHandle = convHandle;
        this.encoding = enc;
    }

    public int convert(byte[] input, int inOff, int inEnd, char[] output, int outOff, int outEnd) throws ConversionBufferFullException, UnknownCharacterException, MalformedInputException, IllegalArgumentException {
        if (input == null || output == null) {
            throw new IllegalArgumentException();
        }
        this.data[0] = inOff;
        this.data[1] = outOff;
        int err = NativeConverter.convertByteToChar(this.converterHandle, input, inEnd, output, outEnd, this.data, false);
        this.byteOff += this.data[0];
        this.charOff += this.data[1];
        if (err == 15) {
            throw new ConversionBufferFullException();
        }
        if (err > 0) {
            throw new MalformedInputException();
        }
        if (this.data[0] != inEnd && !this.subMode) {
            throw new UnknownCharacterException();
        }
        return this.data[1];
    }

    public final String getCharacterEncoding() {
        return this.encoding;
    }

    public final int flush(char[] output, int outStart, int outEnd) throws IllegalArgumentException, ConversionBufferFullException, MalformedInputException {
        if (output == null) {
            throw new IllegalArgumentException();
        }
        this.data[0] = 0;
        this.data[1] = outStart;
        int err = NativeConverter.flushByteToChar(this.converterHandle, output, outEnd, this.data);
        this.byteOff = this.data[0];
        this.charOff = this.data[1];
        if (err == 15) {
            throw new ConversionBufferFullException();
        }
        if (err == 11) {
            throw new MalformedInputException();
        }
        this.reset();
        return this.data[1];
    }

    public final void setSubstitutionChars(char[] c) throws IllegalArgumentException {
        if (c.length > this.getMaxCharsPerByte()) {
            throw new IllegalArgumentException();
        }
        this.subChars = c;
        if (NativeConverter.setSubstitutionChars(this.converterHandle, this.subChars, this.subChars.length) > 0) {
            throw new IllegalArgumentException();
        }
    }

    public final void reset() {
        this.charOff = 0;
        this.byteOff = 0;
        NativeConverter.resetByteToChar(this.converterHandle);
    }

    public final int getMaxCharsPerByte() {
        return 2;
    }

    public final void setSubstitutionMode(boolean doSub) {
        if (doSub) {
            NativeConverter.setSubstitutionChars(this.converterHandle, this.subChars, this.subChars.length);
        } else {
            NativeConverter.setSubstitutionChars(this.converterHandle, null, 0);
        }
    }

    public final int getBadInputLength() {
        int[] length = new int[1];
        NativeConverter.countInvalidBytes(this.converterHandle, length);
        return length[0];
    }

    public final char[] getSubChars() {
        return this.subChars;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            NativeConverter.closeConverter(this.converterHandle);
        }
        finally {
            super.finalize();
        }
    }

    public static final ByteToCharConverter createConverter(String enc) throws UnsupportedEncodingException {
        return new ByteToCharConverterICU(enc);
    }

    public Object clone() {
        ByteToCharConverterICU result = null;
        UConverter[] handleArr = new UConverter[1];
        int ec = NativeConverter.safeClone(this.converterHandle, handleArr);
        if (ec > 0) {
            throw new RuntimeException("Cloning failed" + ErrorCode.getErrorName(ec));
        }
        result = new ByteToCharConverterICU(handleArr[0], this.encoding);
        return result;
    }
}

