/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.semantics;

import java.util.HashSet;
import macromedia.asc.embedding.ErrorConstants;
import macromedia.asc.parser.ArgumentListNode;
import macromedia.asc.parser.AttributeListNode;
import macromedia.asc.parser.BinaryClassDefNode;
import macromedia.asc.parser.BinaryExpressionNode;
import macromedia.asc.parser.BinaryFunctionDefinitionNode;
import macromedia.asc.parser.BinaryInterfaceDefinitionNode;
import macromedia.asc.parser.BinaryProgramNode;
import macromedia.asc.parser.BoxNode;
import macromedia.asc.parser.BreakStatementNode;
import macromedia.asc.parser.CallExpressionNode;
import macromedia.asc.parser.CaseLabelNode;
import macromedia.asc.parser.CatchClauseNode;
import macromedia.asc.parser.ClassDefinitionNode;
import macromedia.asc.parser.ClassNameNode;
import macromedia.asc.parser.CoerceNode;
import macromedia.asc.parser.ConditionalExpressionNode;
import macromedia.asc.parser.ConfigNamespaceDefinitionNode;
import macromedia.asc.parser.ContinueStatementNode;
import macromedia.asc.parser.DefaultXMLNamespaceNode;
import macromedia.asc.parser.DefinitionNode;
import macromedia.asc.parser.DeleteExpressionNode;
import macromedia.asc.parser.DoStatementNode;
import macromedia.asc.parser.DocCommentNode;
import macromedia.asc.parser.EmptyElementNode;
import macromedia.asc.parser.EmptyStatementNode;
import macromedia.asc.parser.ErrorNode;
import macromedia.asc.parser.Evaluator;
import macromedia.asc.parser.ExpressionStatementNode;
import macromedia.asc.parser.FinallyClauseNode;
import macromedia.asc.parser.ForStatementNode;
import macromedia.asc.parser.FunctionCommonNode;
import macromedia.asc.parser.FunctionDefinitionNode;
import macromedia.asc.parser.FunctionNameNode;
import macromedia.asc.parser.FunctionSignatureNode;
import macromedia.asc.parser.GetExpressionNode;
import macromedia.asc.parser.HasNextNode;
import macromedia.asc.parser.IdentifierNode;
import macromedia.asc.parser.IfStatementNode;
import macromedia.asc.parser.ImportDirectiveNode;
import macromedia.asc.parser.ImportNode;
import macromedia.asc.parser.IncludeDirectiveNode;
import macromedia.asc.parser.IncrementNode;
import macromedia.asc.parser.InheritanceNode;
import macromedia.asc.parser.InterfaceDefinitionNode;
import macromedia.asc.parser.InvokeNode;
import macromedia.asc.parser.LabeledStatementNode;
import macromedia.asc.parser.ListNode;
import macromedia.asc.parser.LiteralArrayNode;
import macromedia.asc.parser.LiteralBooleanNode;
import macromedia.asc.parser.LiteralFieldNode;
import macromedia.asc.parser.LiteralNullNode;
import macromedia.asc.parser.LiteralNumberNode;
import macromedia.asc.parser.LiteralObjectNode;
import macromedia.asc.parser.LiteralRegExpNode;
import macromedia.asc.parser.LiteralStringNode;
import macromedia.asc.parser.LiteralXMLNode;
import macromedia.asc.parser.LoadRegisterNode;
import macromedia.asc.parser.MemberExpressionNode;
import macromedia.asc.parser.MetaDataNode;
import macromedia.asc.parser.NamespaceDefinitionNode;
import macromedia.asc.parser.Node;
import macromedia.asc.parser.NodeFactory;
import macromedia.asc.parser.PackageDefinitionNode;
import macromedia.asc.parser.PackageIdentifiersNode;
import macromedia.asc.parser.PackageNameNode;
import macromedia.asc.parser.ParameterListNode;
import macromedia.asc.parser.ParameterNode;
import macromedia.asc.parser.ParenExpressionNode;
import macromedia.asc.parser.ParenListExpressionNode;
import macromedia.asc.parser.PragmaExpressionNode;
import macromedia.asc.parser.PragmaNode;
import macromedia.asc.parser.ProgramNode;
import macromedia.asc.parser.QualifiedExpressionNode;
import macromedia.asc.parser.QualifiedIdentifierNode;
import macromedia.asc.parser.RegisterNode;
import macromedia.asc.parser.RestExpressionNode;
import macromedia.asc.parser.RestParameterNode;
import macromedia.asc.parser.ReturnStatementNode;
import macromedia.asc.parser.SetExpressionNode;
import macromedia.asc.parser.StatementListNode;
import macromedia.asc.parser.StoreRegisterNode;
import macromedia.asc.parser.SuperExpressionNode;
import macromedia.asc.parser.SuperStatementNode;
import macromedia.asc.parser.SwitchStatementNode;
import macromedia.asc.parser.ThisExpressionNode;
import macromedia.asc.parser.ThrowStatementNode;
import macromedia.asc.parser.ToObjectNode;
import macromedia.asc.parser.TryStatementNode;
import macromedia.asc.parser.TypeExpressionNode;
import macromedia.asc.parser.TypedIdentifierNode;
import macromedia.asc.parser.UnaryExpressionNode;
import macromedia.asc.parser.UntypedVariableBindingNode;
import macromedia.asc.parser.UseDirectiveNode;
import macromedia.asc.parser.VariableBindingNode;
import macromedia.asc.parser.VariableDefinitionNode;
import macromedia.asc.parser.WhileStatementNode;
import macromedia.asc.parser.WithStatementNode;
import macromedia.asc.semantics.Builder;
import macromedia.asc.semantics.ConfigurationBuilder;
import macromedia.asc.semantics.NamespaceValue;
import macromedia.asc.semantics.ObjectValue;
import macromedia.asc.semantics.ReferenceValue;
import macromedia.asc.semantics.Slot;
import macromedia.asc.semantics.TypeInfo;
import macromedia.asc.semantics.TypeValue;
import macromedia.asc.semantics.Value;
import macromedia.asc.util.Boxing;
import macromedia.asc.util.Context;
import macromedia.asc.util.IntegerPool;
import macromedia.asc.util.Namespaces;
import macromedia.asc.util.ObjectList;

public class ConfigurationEvaluator
implements Evaluator,
ErrorConstants {
    private boolean fold_expressions = false;
    private ObjectValue true_ov;
    private ObjectValue false_ov;
    private boolean top_level = false;
    private HashSet<String> config_namespaces = new HashSet();
    static final String UNDEFINED = "undefined";
    static final String TRUE = "true";
    static final String FALSE = "false";

    private ObjectValue getBooleanObjectValue(Context context, boolean bl) {
        if (bl) {
            if (this.true_ov == null) {
                this.true_ov = new ObjectValue(TRUE, context.booleanType());
            }
            return this.true_ov;
        }
        if (this.false_ov == null) {
            this.false_ov = new ObjectValue(FALSE, context.booleanType());
        }
        return this.false_ov;
    }

    public boolean checkFeature(Context context, Node node) {
        return true;
    }

    public Value evaluate(Context context, Node node) {
        return null;
    }

    public Value evaluate(Context context, IncrementNode incrementNode) {
        incrementNode.expr = this.evalAndFold(context, incrementNode.expr);
        return null;
    }

    public Value evaluate(Context context, DeleteExpressionNode deleteExpressionNode) {
        deleteExpressionNode.expr = this.evalAndFold(context, deleteExpressionNode.expr);
        return null;
    }

    public Value evaluate(Context context, IdentifierNode identifierNode) {
        return new ReferenceValue(context, null, identifierNode.name, context.publicNamespace());
    }

    public Value evaluate(Context context, InvokeNode invokeNode) {
        invokeNode.args.evaluate(context, this);
        invokeNode.expr = this.evalAndFold(context, invokeNode.expr);
        return null;
    }

    public Value evaluate(Context context, ThisExpressionNode thisExpressionNode) {
        return null;
    }

    public Value evaluate(Context context, QualifiedIdentifierNode qualifiedIdentifierNode) {
        ReferenceValue referenceValue;
        Slot slot;
        AttributeListNode attributeListNode;
        ReferenceValue referenceValue2 = null;
        Value value = qualifiedIdentifierNode.qualifier != null ? qualifiedIdentifierNode.qualifier.evaluate(context, this) : null;
        AttributeListNode attributeListNode2 = attributeListNode = qualifiedIdentifierNode.qualifier instanceof AttributeListNode ? (AttributeListNode)qualifiedIdentifierNode.qualifier : null;
        if (attributeListNode != null && attributeListNode.items != null && attributeListNode.items.size() == 1) {
            Slot slot2;
            ReferenceValue referenceValue3;
            value = attributeListNode.items.at(0).evaluate(context, this);
            ReferenceValue referenceValue4 = referenceValue3 = value instanceof ReferenceValue ? (ReferenceValue)value : null;
            if (referenceValue3 != null && (slot2 = referenceValue3.getSlot(context)) != null && slot2.getObjectValue() != null && slot2.getObjectValue().isConfigNS()) {
                ReferenceValue referenceValue5 = new ReferenceValue(context, null, qualifiedIdentifierNode.name, slot2.getObjectValue());
                referenceValue5.setPosition(qualifiedIdentifierNode.qualifier.getPosition());
                referenceValue2 = referenceValue5;
            }
        } else if (value instanceof ReferenceValue && (slot = (referenceValue = (ReferenceValue)value).getSlot(context)) != null && slot.getObjectValue() != null && slot.getObjectValue().isConfigNS()) {
            ReferenceValue referenceValue6 = new ReferenceValue(context, null, qualifiedIdentifierNode.name, slot.getObjectValue());
            referenceValue6.setPosition(qualifiedIdentifierNode.getPosition());
            referenceValue2 = referenceValue6;
        }
        return referenceValue2;
    }

    public Value evaluate(Context context, QualifiedExpressionNode qualifiedExpressionNode) {
        return null;
    }

    public Value evaluate(Context context, LiteralBooleanNode literalBooleanNode) {
        return this.getBooleanObjectValue(context, literalBooleanNode.value);
    }

    public Value evaluate(Context context, LiteralNumberNode literalNumberNode) {
        TypeValue[] typeValueArray = new TypeValue[1];
        literalNumberNode.numericValue = context.getEmitter().getValueOfNumberLiteral(literalNumberNode.value, typeValueArray);
        literalNumberNode.type = typeValueArray[0];
        return new ObjectValue(literalNumberNode.value, literalNumberNode.type);
    }

    public Value evaluate(Context context, LiteralStringNode literalStringNode) {
        return new ObjectValue(literalStringNode.value, context.stringType());
    }

    public Value evaluate(Context context, LiteralNullNode literalNullNode) {
        return null;
    }

    public Value evaluate(Context context, LiteralRegExpNode literalRegExpNode) {
        return null;
    }

    public Value evaluate(Context context, LiteralXMLNode literalXMLNode) {
        return null;
    }

    public Value evaluate(Context context, FunctionCommonNode functionCommonNode) {
        functionCommonNode.signature.evaluate(context, this);
        ConfigurationBuilder configurationBuilder = new ConfigurationBuilder();
        ObjectValue objectValue = new ObjectValue(context, configurationBuilder, null);
        context.pushScope(objectValue);
        functionCommonNode.body.evaluate(context, this);
        context.popScope();
        return null;
    }

    public Value evaluate(Context context, ParenExpressionNode parenExpressionNode) {
        parenExpressionNode.expr = this.evalAndFold(context, parenExpressionNode.expr);
        return null;
    }

    public Value evaluate(Context context, ParenListExpressionNode parenListExpressionNode) {
        parenListExpressionNode.expr = this.evalAndFold(context, parenListExpressionNode.expr);
        return null;
    }

    private void evalArrayOrObjectArgList(Context context, ArgumentListNode argumentListNode) {
        if (argumentListNode != null) {
            for (int i = argumentListNode.size() - 1; i > 0; --i) {
                Value value;
                ListNode listNode;
                Node node = argumentListNode.items.at(i);
                ListNode listNode2 = listNode = node instanceof ListNode ? (ListNode)node : null;
                if (listNode == null || listNode.size() != 2 || !listNode.items.at(0).isConfigurationName() || (value = listNode.items.at(0).evaluate(context, this)) == null || !value.isReference() || !((ReferenceValue)value).isConfigRef()) continue;
                ReferenceValue referenceValue = (ReferenceValue)value;
                Value value2 = value.getValue(context);
                if (value2 == null) {
                    context.error(referenceValue.getPosition(), 1120, referenceValue.name);
                    continue;
                }
                Boolean bl = this.toBoolean(context, (ObjectValue)referenceValue.getValue(context));
                if (bl != null && bl.booleanValue()) {
                    argumentListNode.items.set(i, listNode.items.at(1));
                    continue;
                }
                argumentListNode.items.remove(i);
            }
        }
    }

    public Value evaluate(Context context, LiteralObjectNode literalObjectNode) {
        if (literalObjectNode.fieldlist != null) {
            this.evalArrayOrObjectArgList(context, literalObjectNode.fieldlist);
            literalObjectNode.fieldlist.evaluate(context, this);
        }
        return null;
    }

    public Value evaluate(Context context, LiteralFieldNode literalFieldNode) {
        literalFieldNode.name = this.evalAndFold(context, literalFieldNode.name);
        literalFieldNode.value = this.evalAndFold(context, literalFieldNode.value);
        return null;
    }

    public Value evaluate(Context context, LiteralArrayNode literalArrayNode) {
        if (literalArrayNode.elementlist != null) {
            this.evalArrayOrObjectArgList(context, literalArrayNode.elementlist);
            literalArrayNode.elementlist.evaluate(context, this);
        }
        return null;
    }

    public Value evaluate(Context context, SuperExpressionNode superExpressionNode) {
        superExpressionNode.expr = this.evalAndFold(context, superExpressionNode.expr);
        return null;
    }

    public Value evaluate(Context context, SuperStatementNode superStatementNode) {
        superStatementNode.call.evaluate(context, this);
        return null;
    }

    public Value evaluate(Context context, MemberExpressionNode memberExpressionNode) {
        if (memberExpressionNode.base != null) {
            memberExpressionNode.base = this.evalAndFold(context, memberExpressionNode.base);
        }
        Value value = memberExpressionNode.selector.evaluate(context, this);
        return value;
    }

    public Value evaluate(Context context, CallExpressionNode callExpressionNode) {
        if (callExpressionNode.args != null) {
            callExpressionNode.args.evaluate(context, this);
        }
        return null;
    }

    public Value evaluate(Context context, GetExpressionNode getExpressionNode) {
        Value value = getExpressionNode.expr.evaluate(context, this);
        return value;
    }

    public Value evaluate(Context context, SetExpressionNode setExpressionNode) {
        setExpressionNode.args.evaluate(context, this);
        return null;
    }

    private Boolean toBoolean(Context context, ObjectValue objectValue) {
        TypeValue typeValue;
        Boolean bl = null;
        TypeInfo typeInfo = objectValue.getType(context);
        TypeValue typeValue2 = typeValue = typeInfo != null ? typeInfo.getTypeValue() : null;
        if (typeValue != null) {
            if (typeValue == context.booleanType()) {
                bl = objectValue.booleanValue() ? Boolean.TRUE : Boolean.FALSE;
            } else if (typeValue == context.stringType()) {
                String string = objectValue.getValue();
                bl = string == null || "".equals(string) ? Boolean.FALSE : Boolean.TRUE;
            } else if (this.isNumericType(context, typeValue)) {
                TypeValue[] typeValueArray = new TypeValue[1];
                double d = context.getEmitter().getValueOfNumberLiteral(objectValue.getValue(), typeValueArray);
                bl = Double.isNaN(d) || d == 0.0 ? Boolean.FALSE : Boolean.TRUE;
            }
        }
        return bl;
    }

    private String toString(Context context, ObjectValue objectValue) {
        TypeValue typeValue;
        String string = null;
        TypeInfo typeInfo = objectValue.getType(context);
        TypeValue typeValue2 = typeValue = typeInfo != null ? typeInfo.getTypeValue() : null;
        if (typeValue != null) {
            if (typeValue == context.booleanType()) {
                string = objectValue.booleanValue() ? TRUE : FALSE;
            } else if (typeValue == context.stringType()) {
                string = objectValue.getValue();
            } else if (this.isNumericType(context, typeValue)) {
                TypeValue[] typeValueArray = new TypeValue[1];
                double d = context.getEmitter().getValueOfNumberLiteral(objectValue.getValue(), typeValueArray);
                string = Double.isNaN(d) ? "NaN" : String.valueOf(d);
            }
        }
        return string;
    }

    private Double toNumber(Context context, ObjectValue objectValue) {
        TypeValue typeValue;
        Double d = null;
        TypeInfo typeInfo = objectValue.getType(context);
        TypeValue typeValue2 = typeValue = typeInfo != null ? typeInfo.getTypeValue() : null;
        if (typeValue != null) {
            if (typeValue == context.booleanType()) {
                d = new Double(objectValue.booleanValue() ? 1.0 : 0.0);
            } else if (typeValue == context.stringType() || this.isNumericType(context, typeValue)) {
                TypeValue[] typeValueArray = new TypeValue[1];
                try {
                    d = Boxing.valueOf(context.getEmitter().getValueOfNumberLiteral(objectValue.getValue(), typeValueArray));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return d;
    }

    private Integer toInt(Context context, ObjectValue objectValue) {
        Integer n = null;
        Double d = this.toNumber(context, objectValue);
        if (d != null) {
            n = d.isInfinite() || d.isNaN() || d == 0.0 ? IntegerPool.getNumber(0) : IntegerPool.getNumber((int)d.doubleValue());
        }
        return n;
    }

    private Long toUInt(Context context, ObjectValue objectValue) {
        Long l = null;
        Double d = this.toNumber(context, objectValue);
        if (d != null) {
            l = d.isInfinite() || d.isNaN() || d == 0.0 ? new Long(0L) : new Long((long)d.doubleValue());
        }
        return l;
    }

    public Value evaluate(Context context, UnaryExpressionNode unaryExpressionNode) {
        ObjectValue objectValue = null;
        if (this.fold_expressions) {
            Value value = unaryExpressionNode.expr.evaluate(context, this);
            Node node = this.foldRefValue(context, value);
            if (node != null) {
                unaryExpressionNode.expr = node;
                value = unaryExpressionNode.expr.evaluate(context, this);
            }
            if (value != null && value.hasValue()) {
                ObjectValue objectValue2 = (ObjectValue)value;
                switch (unaryExpressionNode.op) {
                    case -4: {
                        Boolean bl = this.toBoolean(context, objectValue2);
                        if (bl == null) break;
                        objectValue = this.getBooleanObjectValue(context, bl == false);
                    }
                }
            }
        } else {
            unaryExpressionNode.expr = this.evalAndFold(context, unaryExpressionNode.expr);
        }
        return objectValue;
    }

    public Value evaluate(Context context, BinaryExpressionNode binaryExpressionNode) {
        ObjectValue objectValue = null;
        if (this.fold_expressions) {
            Value value = binaryExpressionNode.lhs.evaluate(context, this);
            Value value2 = binaryExpressionNode.rhs.evaluate(context, this);
            Node node = this.foldRefValue(context, value);
            Node node2 = this.foldRefValue(context, value2);
            if (node != null) {
                binaryExpressionNode.lhs = node;
                value = binaryExpressionNode.lhs.evaluate(context, this);
            }
            if (node2 != null) {
                binaryExpressionNode.rhs = node2;
                value2 = binaryExpressionNode.rhs.evaluate(context, this);
            }
            if (value != null && value2 != null && value.hasValue() && value2.hasValue()) {
                ObjectValue objectValue2 = (ObjectValue)value;
                ObjectValue objectValue3 = (ObjectValue)value2;
                TypeValue typeValue = objectValue2.getType(context).getTypeValue();
                TypeValue typeValue2 = objectValue3.getType(context).getTypeValue();
                switch (binaryExpressionNode.op) {
                    case -41: {
                        if (this.isNumericType(context, typeValue) && this.isNumericType(context, typeValue2)) {
                            TypeValue[] typeValueArray = new TypeValue[1];
                            double d = context.getEmitter().getValueOfNumberLiteral(objectValue2.getValue(), typeValueArray);
                            double d2 = context.getEmitter().getValueOfNumberLiteral(objectValue3.getValue(), typeValueArray);
                            double d3 = Double.NaN;
                            d3 = d + d2;
                            objectValue = new ObjectValue(Double.toString(d3), context.numberType());
                            break;
                        }
                        if (typeValue != context.stringType() && typeValue2 != context.stringType()) break;
                        String string = this.toString(context, objectValue2);
                        String string2 = this.toString(context, objectValue3);
                        objectValue = new ObjectValue(string + string2, context.stringType());
                        break;
                    }
                    case -21: 
                    case -15: 
                    case -7: 
                    case -2: {
                        if (this.isNumericType(context, typeValue) && this.isNumericType(context, typeValue2)) {
                            TypeValue[] typeValueArray = new TypeValue[1];
                            double d = context.getEmitter().getValueOfNumberLiteral(objectValue2.getValue(), typeValueArray);
                            double d4 = context.getEmitter().getValueOfNumberLiteral(objectValue3.getValue(), typeValueArray);
                            double d5 = Double.NaN;
                            switch (binaryExpressionNode.op) {
                                case -2: {
                                    d5 = d - d4;
                                    break;
                                }
                                case -15: {
                                    d5 = d * d4;
                                    break;
                                }
                                case -21: {
                                    d5 = d / d4;
                                    break;
                                }
                                case -7: {
                                    d5 = d % d4;
                                }
                            }
                            objectValue = new ObjectValue(Double.toString(d5), context.numberType());
                            break;
                        }
                    }
                    case -36: {
                        Boolean bl = this.toBoolean(context, objectValue2);
                        Boolean bl2 = this.toBoolean(context, objectValue3);
                        if (bl == null || bl2 == null) break;
                        objectValue = this.getBooleanObjectValue(context, bl != false || bl2 != false);
                        break;
                    }
                    case -10: {
                        Boolean bl = this.toBoolean(context, objectValue2);
                        Boolean bl3 = this.toBoolean(context, objectValue3);
                        if (bl == null || bl3 == null) break;
                        objectValue = this.getBooleanObjectValue(context, bl != false && bl3 != false);
                        break;
                    }
                    case -50: 
                    case -5: {
                        Boolean bl = this.compare(context, objectValue2, objectValue3);
                        if (bl == null) break;
                        if (binaryExpressionNode.op == -5) {
                            objectValue = this.getBooleanObjectValue(context, bl == false);
                            break;
                        }
                        objectValue = this.getBooleanObjectValue(context, bl);
                        break;
                    }
                    case -53: 
                    case -44: {
                        String string = this.lessthan(context, objectValue2, objectValue3);
                        Boolean bl = null;
                        bl = binaryExpressionNode.op == -44 ? (string == UNDEFINED || string == FALSE ? Boolean.FALSE : Boolean.TRUE) : (string == UNDEFINED || string == TRUE ? Boolean.FALSE : Boolean.TRUE);
                        if (bl == null) break;
                        objectValue = this.getBooleanObjectValue(context, bl);
                        break;
                    }
                    case -52: 
                    case -47: {
                        String string = this.lessthan(context, objectValue3, objectValue2);
                        Boolean bl = null;
                        bl = binaryExpressionNode.op == -47 ? (string == UNDEFINED || string == TRUE ? Boolean.FALSE : Boolean.TRUE) : (string == UNDEFINED || string == FALSE ? Boolean.FALSE : Boolean.TRUE);
                        if (bl == null) break;
                        objectValue = this.getBooleanObjectValue(context, bl);
                        break;
                    }
                    case -54: 
                    case -45: {
                        Integer n = this.toInt(context, objectValue2);
                        Integer n2 = this.toInt(context, objectValue3);
                        if (n == null || n2 == null) break;
                        n2 = Boxing.valueOf(n2 & 0x1F);
                        if (binaryExpressionNode.op == -45) {
                            objectValue = new ObjectValue(String.valueOf(n << n2), context.intType());
                            break;
                        }
                        objectValue = new ObjectValue(String.valueOf(n >> n2), context.intType());
                        break;
                    }
                    case -56: {
                        Long l = this.toUInt(context, objectValue2);
                        Long l2 = this.toUInt(context, objectValue3);
                        if (l == null || l2 == null) break;
                        l2 = l2 & 0x1FL;
                        objectValue = new ObjectValue(String.valueOf(l >>> (int)l2.longValue()), context.intType());
                        break;
                    }
                    case -35: 
                    case -30: 
                    case -9: {
                        Integer n = this.toInt(context, objectValue2);
                        Integer n3 = this.toInt(context, objectValue3);
                        if (n == null || n3 == null) break;
                        int n4 = 0;
                        switch (binaryExpressionNode.op) {
                            case -9: {
                                n4 = n & n3;
                                break;
                            }
                            case -35: {
                                n4 = n | n3;
                                break;
                            }
                            case -30: {
                                n4 = n ^ n3;
                            }
                        }
                        objectValue = new ObjectValue(String.valueOf(n4), context.intType());
                    }
                }
            }
        } else {
            binaryExpressionNode.lhs = this.evalAndFold(context, binaryExpressionNode.lhs);
            binaryExpressionNode.rhs = this.evalAndFold(context, binaryExpressionNode.rhs);
        }
        return objectValue;
    }

    private String lessthan(Context context, ObjectValue objectValue, ObjectValue objectValue2) {
        Double d = this.toNumber(context, objectValue);
        Double d2 = this.toNumber(context, objectValue2);
        if (d != null && d2 != null) {
            if (d.isNaN() || d2.isNaN()) {
                return UNDEFINED;
            }
            if (d.doubleValue() == d2.doubleValue()) {
                return FALSE;
            }
            if (d.isInfinite()) {
                if (d > 0.0) {
                    return FALSE;
                }
                return TRUE;
            }
            if (d2.isInfinite()) {
                if (d2 < 0.0) {
                    return FALSE;
                }
                return TRUE;
            }
            if (d < d2) {
                return TRUE;
            }
            return FALSE;
        }
        return null;
    }

    private Boolean compare(Context context, ObjectValue objectValue, ObjectValue objectValue2) {
        if (objectValue != null && objectValue.hasValue() && objectValue2 != null && objectValue2.hasValue()) {
            if (objectValue == objectValue2) {
                return Boolean.TRUE;
            }
            TypeValue typeValue = objectValue2.getType(context).getTypeValue();
            TypeValue typeValue2 = objectValue.getType(context).getTypeValue();
            if (typeValue2 == typeValue) {
                if (typeValue2 == context.stringType()) {
                    return objectValue.getValue().equals(this.toString(context, objectValue2));
                }
                if (typeValue2 == context.booleanType()) {
                    Boolean bl = this.toBoolean(context, objectValue);
                    Boolean bl2 = this.toBoolean(context, objectValue2);
                    if (bl.booleanValue() == bl2.booleanValue()) {
                        return Boolean.TRUE;
                    }
                    return Boolean.FALSE;
                }
                if (this.isNumericType(context, typeValue2)) {
                    Double d = this.toNumber(context, objectValue);
                    Double d2 = this.toNumber(context, objectValue2);
                    if (d.doubleValue() == d2.doubleValue()) {
                        return Boolean.TRUE;
                    }
                    return Boolean.FALSE;
                }
            } else if (this.isNumericType(context, typeValue2) && this.isNumericType(context, typeValue) || this.isNumericType(context, typeValue2) && typeValue == context.stringType() || typeValue2 == context.stringType() && this.isNumericType(context, typeValue) || typeValue2 == context.booleanType() || typeValue == context.booleanType()) {
                Double d = this.toNumber(context, objectValue);
                Double d3 = this.toNumber(context, objectValue2);
                if (d != null && d3 != null && d.doubleValue() == d3.doubleValue()) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        }
        return Boolean.FALSE;
    }

    private ObjectValue numberObjVal(Context context, double d) {
        return new ObjectValue(String.valueOf(d), context.numberType());
    }

    private boolean isNumericType(Context context, TypeValue typeValue) {
        return typeValue == context.numberType() || typeValue == context.intType() || typeValue == context.uintType();
    }

    public Value evaluate(Context context, ConditionalExpressionNode conditionalExpressionNode) {
        conditionalExpressionNode.condition = this.evalAndFold(context, conditionalExpressionNode.condition);
        conditionalExpressionNode.thenexpr = this.evalAndFold(context, conditionalExpressionNode.thenexpr);
        conditionalExpressionNode.elseexpr = this.evalAndFold(context, conditionalExpressionNode.elseexpr);
        return null;
    }

    public Value evaluate(Context context, ArgumentListNode argumentListNode) {
        int n = argumentListNode.items.size();
        for (int i = 0; i < n; ++i) {
            Node node = (Node)argumentListNode.items.get(i);
            Node node2 = null;
            if (node == null || (node2 = this.evalAndFold(context, node)) == node) continue;
            argumentListNode.items.set(i, node2);
        }
        return null;
    }

    public Value evaluate(Context context, ListNode listNode) {
        Value value = null;
        int n = listNode.items.size();
        for (int i = 0; i < n; ++i) {
            Node node = listNode.items.at(i);
            value = node.evaluate(context, this);
            Node node2 = this.foldRefValue(context, value);
            if (node2 == null) continue;
            listNode.items.set(i, node2);
            value = node2.evaluate(context, this);
        }
        return value;
    }

    public Value evaluate(Context context, StatementListNode statementListNode) {
        NodeFactory nodeFactory = context.getNodeFactory();
        if (statementListNode.config_attrs != null) {
            statementListNode.config_attrs.evaluate(context, this);
            if (!statementListNode.config_attrs.compileDefinition) {
                statementListNode.items.clear();
            }
            statementListNode.config_attrs = null;
        }
        int n = statementListNode.items.size();
        for (int i = 0; i < n; ++i) {
            Node node;
            Node node2 = statementListNode.items.at(i);
            if (node2 != null && node2.isDefinition()) {
                DefinitionNode definitionNode = (DefinitionNode)node2;
                if (definitionNode.attrs != null) {
                    definitionNode.attrs.evaluate(context, this);
                    if (!definitionNode.attrs.compileDefinition) {
                        statementListNode.items.set(i, nodeFactory.emptyStatement());
                        this.removeMetaData(context, definitionNode, statementListNode, i);
                        continue;
                    }
                }
                boolean bl = this.top_level;
                if (!(definitionNode instanceof ConfigNamespaceDefinitionNode) && !(definitionNode instanceof VariableDefinitionNode)) {
                    this.top_level = false;
                }
                definitionNode.evaluate(context, this);
                this.top_level = bl;
                if (!(definitionNode instanceof VariableDefinitionNode)) continue;
                VariableDefinitionNode variableDefinitionNode = (VariableDefinitionNode)definitionNode;
                if (variableDefinitionNode.list.items.size() != 0) continue;
                this.removeMetaData(context, variableDefinitionNode, statementListNode, i);
                statementListNode.items.set(i, nodeFactory.emptyStatement());
                continue;
            }
            boolean bl = this.top_level;
            if (!(node2 instanceof StatementListNode)) {
                this.top_level = false;
            }
            if ((node = this.evalAndFold(context, node2)) != node2) {
                statementListNode.items.set(i, node);
            }
            if (node2 instanceof StatementListNode) continue;
            this.top_level = bl;
        }
        return null;
    }

    private void removeMetaData(Context context, DefinitionNode definitionNode, StatementListNode statementListNode, int n) {
        if (definitionNode.metaData != null) {
            NodeFactory nodeFactory = context.getNodeFactory();
            for (int i = n - 1; i >= 0; --i) {
                MetaDataNode metaDataNode;
                Node node = statementListNode.items.at(i);
                MetaDataNode metaDataNode2 = metaDataNode = node instanceof MetaDataNode ? (MetaDataNode)node : null;
                if (metaDataNode != null && metaDataNode.def == definitionNode) {
                    statementListNode.items.set(i, nodeFactory.emptyStatement());
                    metaDataNode.def = null;
                    continue;
                }
                if (!(node instanceof IncludeDirectiveNode)) break;
            }
            definitionNode.metaData = null;
        }
    }

    private Node evalAndFold(Context context, Node node) {
        Value value;
        Node node2 = node;
        if (node != null && (node2 = this.foldRefValue(context, value = node.evaluate(context, this))) == null) {
            node2 = node;
        }
        return node2;
    }

    private Node foldRefValue(Context context, Value value) {
        ReferenceValue referenceValue;
        Node node = null;
        ReferenceValue referenceValue2 = referenceValue = value instanceof ReferenceValue ? (ReferenceValue)value : null;
        if (referenceValue != null && referenceValue.isConfigRef()) {
            Value value2 = referenceValue.getValue(context);
            if (value2 == null) {
                context.error(referenceValue.getPosition(), 1120, referenceValue.name);
            } else {
                node = this.literalFromValue(context, referenceValue.getValue(context));
            }
            if (node != null) {
                node.evaluate(context, this);
            }
        }
        return node;
    }

    private Node literalFromValue(Context context, Value value) {
        LiteralStringNode literalStringNode = null;
        if (value instanceof ObjectValue) {
            ObjectValue objectValue;
            ObjectValue objectValue2 = objectValue = value instanceof ObjectValue ? (ObjectValue)value : null;
            if (objectValue != null) {
                Node node = null;
                switch (objectValue.getType(context).getTypeId()) {
                    case 4: {
                        node = context.getNodeFactory().literalString(objectValue.getValue());
                        break;
                    }
                    case 1: {
                        node = context.getNodeFactory().literalBoolean(objectValue.booleanValue());
                        break;
                    }
                    case 2: 
                    case 256: 
                    case 512: {
                        node = context.getNodeFactory().literalNumber(objectValue.getValue());
                    }
                }
                literalStringNode = node;
            }
        }
        return literalStringNode;
    }

    public Value evaluate(Context context, EmptyElementNode emptyElementNode) {
        return null;
    }

    public Value evaluate(Context context, EmptyStatementNode emptyStatementNode) {
        return null;
    }

    public Value evaluate(Context context, ExpressionStatementNode expressionStatementNode) {
        Value value = expressionStatementNode.expr.evaluate(context, this);
        Node node = this.foldRefValue(context, value);
        if (node != null) {
            expressionStatementNode.expr = node;
            value = node.evaluate(context, this);
        }
        return value;
    }

    public Value evaluate(Context context, LabeledStatementNode labeledStatementNode) {
        labeledStatementNode.label = this.evalAndFold(context, labeledStatementNode.label);
        labeledStatementNode.statement = this.evalAndFold(context, labeledStatementNode.statement);
        return null;
    }

    public Value evaluate(Context context, IfStatementNode ifStatementNode) {
        ifStatementNode.condition = this.evalAndFold(context, ifStatementNode.condition);
        ifStatementNode.thenactions = this.evalAndFold(context, ifStatementNode.thenactions);
        ifStatementNode.elseactions = this.evalAndFold(context, ifStatementNode.elseactions);
        return null;
    }

    public Value evaluate(Context context, SwitchStatementNode switchStatementNode) {
        switchStatementNode.expr = this.evalAndFold(context, switchStatementNode.expr);
        switchStatementNode.statements.evaluate(context, this);
        return null;
    }

    public Value evaluate(Context context, CaseLabelNode caseLabelNode) {
        caseLabelNode.label = this.evalAndFold(context, caseLabelNode.label);
        return null;
    }

    public Value evaluate(Context context, DoStatementNode doStatementNode) {
        doStatementNode.expr = this.evalAndFold(context, doStatementNode.expr);
        doStatementNode.statements = this.evalAndFold(context, doStatementNode.statements);
        return null;
    }

    public Value evaluate(Context context, WhileStatementNode whileStatementNode) {
        whileStatementNode.expr = this.evalAndFold(context, whileStatementNode.expr);
        whileStatementNode.statement = this.evalAndFold(context, whileStatementNode.statement);
        return null;
    }

    public Value evaluate(Context context, ForStatementNode forStatementNode) {
        forStatementNode.initialize = this.evalAndFold(context, forStatementNode.initialize);
        forStatementNode.test = this.evalAndFold(context, forStatementNode.test);
        forStatementNode.increment = this.evalAndFold(context, forStatementNode.increment);
        forStatementNode.statement = this.evalAndFold(context, forStatementNode.statement);
        return null;
    }

    public Value evaluate(Context context, WithStatementNode withStatementNode) {
        withStatementNode.expr = this.evalAndFold(context, withStatementNode.expr);
        withStatementNode.statement = this.evalAndFold(context, withStatementNode.statement);
        return null;
    }

    public Value evaluate(Context context, ContinueStatementNode continueStatementNode) {
        return null;
    }

    public Value evaluate(Context context, BreakStatementNode breakStatementNode) {
        return null;
    }

    public Value evaluate(Context context, ReturnStatementNode returnStatementNode) {
        returnStatementNode.expr = this.evalAndFold(context, returnStatementNode.expr);
        return null;
    }

    public Value evaluate(Context context, ThrowStatementNode throwStatementNode) {
        throwStatementNode.expr = this.evalAndFold(context, throwStatementNode.expr);
        return null;
    }

    public Value evaluate(Context context, TryStatementNode tryStatementNode) {
        if (tryStatementNode.tryblock != null) {
            tryStatementNode.tryblock.evaluate(context, this);
        }
        if (tryStatementNode.catchlist != null) {
            tryStatementNode.catchlist.evaluate(context, this);
        }
        if (tryStatementNode.finallyblock != null) {
            tryStatementNode.finallyblock.evaluate(context, this);
        }
        return null;
    }

    public Value evaluate(Context context, CatchClauseNode catchClauseNode) {
        if (catchClauseNode.parameter != null) {
            catchClauseNode.parameter = this.evalAndFold(context, catchClauseNode.parameter);
        }
        if (catchClauseNode.statements != null) {
            catchClauseNode.statements.evaluate(context, this);
        }
        return null;
    }

    public Value evaluate(Context context, FinallyClauseNode finallyClauseNode) {
        if (finallyClauseNode.default_catch != null) {
            finallyClauseNode.default_catch.evaluate(context, this);
        }
        if (finallyClauseNode.statements != null) {
            finallyClauseNode.statements.evaluate(context, this);
        }
        return null;
    }

    public Value evaluate(Context context, UseDirectiveNode useDirectiveNode) {
        return null;
    }

    public Value evaluate(Context context, IncludeDirectiveNode includeDirectiveNode) {
        return null;
    }

    public Value evaluate(Context context, ImportNode importNode) {
        return null;
    }

    public Value evaluate(Context context, MetaDataNode metaDataNode) {
        return null;
    }

    public Value evaluate(Context context, DocCommentNode docCommentNode) {
        return null;
    }

    public Value evaluate(Context context, ImportDirectiveNode importDirectiveNode) {
        return null;
    }

    public Value evaluate(Context context, AttributeListNode attributeListNode) {
        ObjectValue objectValue = null;
        int n = attributeListNode.items.size();
        for (int i = 0; i < n; ++i) {
            Node node = attributeListNode.items.at(i);
            Value value = node.evaluate(context, this);
            ObjectValue objectValue2 = objectValue = value instanceof ObjectValue ? (ObjectValue)value : null;
            if (objectValue == null || i != n - 1 || objectValue.getType(context).getTypeValue() != context.booleanType()) continue;
            attributeListNode.compileDefinition = objectValue.booleanValue();
            attributeListNode.items.removeLast();
        }
        return null;
    }

    public Value evaluate(Context context, VariableDefinitionNode variableDefinitionNode) {
        variableDefinitionNode.list.evaluate(context, this);
        for (int i = variableDefinitionNode.list.items.size() - 1; i >= 0; --i) {
            Node node = variableDefinitionNode.list.items.at(i);
            if (!(node instanceof VariableBindingNode)) continue;
            VariableBindingNode variableBindingNode = (VariableBindingNode)node;
            if (variableBindingNode.ref == null || !variableBindingNode.ref.isConfigRef()) continue;
            variableDefinitionNode.list.items.removeLast();
        }
        return null;
    }

    public Value evaluate(Context context, VariableBindingNode variableBindingNode) {
        ReferenceValue referenceValue;
        Value value = variableBindingNode.variable.identifier.evaluate(context, this);
        ReferenceValue referenceValue2 = referenceValue = value instanceof ReferenceValue ? (ReferenceValue)value : null;
        if (referenceValue != null && referenceValue.isConfigRef()) {
            if (!this.isTopLevel()) {
                context.error(variableBindingNode.pos() - 1, 1210);
                return null;
            }
            ObjectValue objectValue = context.scope();
            Builder builder = objectValue.builder;
            Namespaces namespaces = objectValue.hasNames(context, -78, referenceValue.name, referenceValue.namespaces);
            if (namespaces == null) {
                int n = builder.Variable(context, objectValue);
                int n2 = builder.ExplicitVar(context, objectValue, referenceValue.name, referenceValue.namespaces, context.noType(), -1, -1, n);
                Slot slot = objectValue.getSlot(context, n2);
                if (variableBindingNode.kind != -64) {
                    context.error(variableBindingNode.attrs.pos() - 1, 1209);
                }
                slot.setConst(true);
                if (variableBindingNode.initializer == null) {
                    context.error(variableBindingNode.pos() - 1, 1208);
                } else {
                    boolean bl = this.fold_expressions;
                    this.fold_expressions = true;
                    Value value2 = variableBindingNode.initializer.evaluate(context, this);
                    this.fold_expressions = bl;
                    if (value2 == null || !value2.hasValue()) {
                        context.error(variableBindingNode.initializer.pos() - 1, 1208);
                    }
                    slot.setValue(value2);
                }
                variableBindingNode.ref = referenceValue;
            } else {
                context.error(variableBindingNode.variable.identifier.pos() - 1, 1151, referenceValue.name, ((ObjectValue)referenceValue.namespaces.at((int)0)).name);
            }
        } else {
            variableBindingNode.initializer = this.evalAndFold(context, variableBindingNode.initializer);
        }
        return null;
    }

    public Value evaluate(Context context, UntypedVariableBindingNode untypedVariableBindingNode) {
        return null;
    }

    public Value evaluate(Context context, TypedIdentifierNode typedIdentifierNode) {
        return typedIdentifierNode.identifier.evaluate(context, this);
    }

    public Value evaluate(Context context, TypeExpressionNode typeExpressionNode) {
        return null;
    }

    public Value evaluate(Context context, FunctionDefinitionNode functionDefinitionNode) {
        functionDefinitionNode.fexpr.evaluate(context, this);
        return null;
    }

    public Value evaluate(Context context, BinaryFunctionDefinitionNode binaryFunctionDefinitionNode) {
        return null;
    }

    public Value evaluate(Context context, FunctionNameNode functionNameNode) {
        return null;
    }

    public Value evaluate(Context context, FunctionSignatureNode functionSignatureNode) {
        if (functionSignatureNode.parameter != null) {
            functionSignatureNode.parameter.evaluate(context, this);
        }
        if (functionSignatureNode.result != null) {
            functionSignatureNode.result.evaluate(context, this);
        }
        return null;
    }

    public Value evaluate(Context context, ParameterNode parameterNode) {
        parameterNode.init = this.evalAndFold(context, parameterNode.init);
        return null;
    }

    public Value evaluate(Context context, ParameterListNode parameterListNode) {
        int n = parameterListNode.items.size();
        for (int i = 0; i < n; ++i) {
            ParameterNode parameterNode = parameterListNode.items.at(i);
            parameterNode.evaluate(context, this);
        }
        return null;
    }

    public Value evaluate(Context context, RestExpressionNode restExpressionNode) {
        return null;
    }

    public Value evaluate(Context context, RestParameterNode restParameterNode) {
        return null;
    }

    public Value evaluate(Context context, InterfaceDefinitionNode interfaceDefinitionNode) {
        return this.evaluate(context, (ClassDefinitionNode)interfaceDefinitionNode);
    }

    public Value evaluate(Context context, ClassDefinitionNode classDefinitionNode) {
        ConfigurationBuilder configurationBuilder = new ConfigurationBuilder();
        ObjectValue objectValue = new ObjectValue(context, configurationBuilder, null);
        context.pushScope(objectValue);
        if (classDefinitionNode.statements != null) {
            classDefinitionNode.statements.evaluate(context, this);
        }
        context.popScope();
        return null;
    }

    public Value evaluate(Context context, BinaryClassDefNode binaryClassDefNode) {
        return null;
    }

    public Value evaluate(Context context, BinaryInterfaceDefinitionNode binaryInterfaceDefinitionNode) {
        return null;
    }

    public Value evaluate(Context context, ClassNameNode classNameNode) {
        return null;
    }

    public Value evaluate(Context context, InheritanceNode inheritanceNode) {
        return null;
    }

    private boolean isTopLevel() {
        return this.top_level;
    }

    public Value evaluate(Context context, ConfigNamespaceDefinitionNode configNamespaceDefinitionNode) {
        if (!this.isTopLevel()) {
            context.error(configNamespaceDefinitionNode.pos() - 1, 1210);
            return null;
        }
        Namespaces namespaces = new Namespaces();
        ObjectList<String> objectList = new ObjectList<String>();
        namespaces.push_back(context.publicNamespace());
        ObjectValue objectValue = context.scope();
        Builder builder = objectValue.builder;
        int n = -1;
        Namespaces namespaces2 = objectValue.hasNames(context, -78, configNamespaceDefinitionNode.name.name, namespaces);
        if (namespaces2 == null) {
            int n2 = builder.Variable(context, objectValue);
            n = builder.ExplicitVar(context, objectValue, configNamespaceDefinitionNode.name.name, namespaces, context.noType(), -1, -1, n2);
            Slot slot = objectValue.getSlot(context, n);
            String string = context.debugName("", configNamespaceDefinitionNode.name.name, objectList, -132);
            ObjectValue objectValue2 = context.getNamespace(string.intern(), (byte)1);
            if (objectValue2 instanceof NamespaceValue) {
                ((NamespaceValue)objectValue2).config_ns = true;
            }
            slot.setObjectValue(objectValue2);
            slot.setConst(true);
            this.config_namespaces.add(configNamespaceDefinitionNode.name.name);
        }
        return null;
    }

    public Value evaluate(Context context, NamespaceDefinitionNode namespaceDefinitionNode) {
        if (this.config_namespaces.contains(namespaceDefinitionNode.name.name)) {
            context.error(namespaceDefinitionNode.pos(), 1211, namespaceDefinitionNode.name.name);
        }
        return null;
    }

    public Value evaluate(Context context, PackageDefinitionNode packageDefinitionNode) {
        return null;
    }

    public Value evaluate(Context context, PackageIdentifiersNode packageIdentifiersNode) {
        return null;
    }

    public Value evaluate(Context context, PackageNameNode packageNameNode) {
        return null;
    }

    public Value evaluate(Context context, ProgramNode programNode) {
        ConfigurationBuilder configurationBuilder = new ConfigurationBuilder();
        ObjectValue objectValue = new ObjectValue(context, configurationBuilder, null);
        context.pushScope(objectValue);
        this.top_level = true;
        programNode.statements.evaluate(context, this);
        this.top_level = false;
        context.popScope();
        return null;
    }

    public Value evaluate(Context context, BinaryProgramNode binaryProgramNode) {
        return null;
    }

    public Value evaluate(Context context, ErrorNode errorNode) {
        return null;
    }

    public Value evaluate(Context context, ToObjectNode toObjectNode) {
        toObjectNode.expr = this.evalAndFold(context, toObjectNode.expr);
        return null;
    }

    public Value evaluate(Context context, LoadRegisterNode loadRegisterNode) {
        return null;
    }

    public Value evaluate(Context context, StoreRegisterNode storeRegisterNode) {
        return null;
    }

    public Value evaluate(Context context, RegisterNode registerNode) {
        return null;
    }

    public Value evaluate(Context context, HasNextNode hasNextNode) {
        return null;
    }

    public Value evaluate(Context context, BoxNode boxNode) {
        boxNode.expr = this.evalAndFold(context, boxNode.expr);
        return null;
    }

    public Value evaluate(Context context, CoerceNode coerceNode) {
        coerceNode.expr = this.evalAndFold(context, coerceNode.expr);
        return null;
    }

    public Value evaluate(Context context, PragmaNode pragmaNode) {
        pragmaNode.list.evaluate(context, this);
        return null;
    }

    public Value evaluate(Context context, PragmaExpressionNode pragmaExpressionNode) {
        return null;
    }

    public Value evaluate(Context context, DefaultXMLNamespaceNode defaultXMLNamespaceNode) {
        return null;
    }
}

