/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.embedding;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import macromedia.asc.embedding.Compiler;
import macromedia.asc.embedding.CompilerPlug;
import macromedia.asc.embedding.ConfigVar;
import macromedia.asc.embedding.IncludeInfo;
import macromedia.asc.embedding.SanityCompilerHandler;
import macromedia.asc.embedding.avmplus.Features;
import macromedia.asc.util.Context;
import macromedia.asc.util.ContextStatics;
import macromedia.asc.util.ObjectList;

public class Main {
    static boolean show_parsetrees = false;
    static boolean show_instructions = false;
    static boolean show_linenums = false;
    static boolean show_bytes = false;
    static boolean show_machinecode = false;
    static boolean show_flow = false;
    static boolean emit_debug_info = false;
    static boolean emit_doc_info = false;
    static boolean do_test = false;
    static boolean do_help = false;
    static boolean filespecFound = false;
    static boolean make_movieclip = false;
    static boolean lint_mode = false;
    static boolean use_static_semantics = false;
    static boolean sanity_mode = false;
    static boolean emit_metadata = false;
    static boolean log = false;
    static PrintStream stderr = System.err;
    static int earliest_dialect = 7;
    static int latest_dialect = 11;
    static int default_dialect;
    static int dialect;
    static boolean optimize;
    static ObjectList<String> include_filespecs;
    static ObjectList<String> import_filespecs;
    static String swf_options;
    static String language;
    static String avmplus_exe;
    static ObjectList<ConfigVar> config_vars;

    public static void main(String[] stringArray) throws Exception {
        String string = "";
        String string2 = "";
        if (stringArray.length == 0) {
            do_help = true;
        } else {
            block22: for (int i = 0; i < stringArray.length; ++i) {
                String string3 = stringArray[i];
                if (string3.charAt(0) == '-') {
                    if (string3.length() < 2) {
                        do_help = true;
                        continue;
                    }
                    switch (string3.charAt(1)) {
                        case '!': {
                            use_static_semantics = true;
                            break;
                        }
                        case 'b': {
                            show_bytes = true;
                            break;
                        }
                        case 'f': {
                            show_flow = true;
                            break;
                        }
                        case 'p': {
                            show_parsetrees = true;
                            break;
                        }
                        case 'i': {
                            if (string3.length() == 3 && string3.charAt(2) == 'n') {
                                include_filespecs.add(stringArray[++i]);
                                break;
                            }
                            if (string3.length() == 7 && "-import".equals(string3)) {
                                import_filespecs.add(stringArray[++i].trim());
                                break;
                            }
                            show_instructions = true;
                            break;
                        }
                        case 'm': {
                            if (string3.length() == 10 && "-movieclip".equals(string3)) {
                                make_movieclip = true;
                                break;
                            }
                            if (string3.length() == 3 && "-md".equals(string3)) {
                                emit_metadata = true;
                                break;
                            }
                            show_instructions = true;
                            show_machinecode = true;
                            break;
                        }
                        case 'a': {
                            if (string3.length() != 10 || !"-abcfuture".equals(string3)) continue block22;
                            Features.FUTURE_ABC = true;
                            break;
                        }
                        case 'c': {
                            String string4;
                            ConfigVar configVar;
                            if (string3.length() == 6 && "-coach".equals(string3)) {
                                lint_mode = true;
                                break;
                            }
                            if (string3.length() != 7 || !"-config".equals(string3)) continue block22;
                            if ((configVar = Main.parseConfigVar(string4 = stringArray[++i])) != null) {
                                config_vars.push_back(configVar);
                                break;
                            }
                            do_help = true;
                            break;
                        }
                        case 'w': {
                            if (string3.length() != 9 || !"-warnings".equals(string3)) continue block22;
                            lint_mode = true;
                            break;
                        }
                        case 's': {
                            if (string3.length() == 7) {
                                if ("-strict".equals(string3)) {
                                    use_static_semantics = true;
                                    break;
                                }
                                if (!"-sanity".equals(string3)) continue block22;
                                sanity_mode = true;
                                break;
                            }
                            if (string3.length() != 4 || !"-swf".equals(string3) || (swf_options = stringArray[++i]).indexOf("-g") <= -1) continue block22;
                            emit_debug_info = true;
                            break;
                        }
                        case 'e': {
                            if (string3.length() != 4 || !"-exe".equals(string3)) continue block22;
                            avmplus_exe = stringArray[++i];
                            break;
                        }
                        case 'd': {
                            if (string3.length() == 4 && "-doc".equals(string3)) {
                                emit_doc_info = true;
                                break;
                            }
                            emit_debug_info = true;
                            break;
                        }
                        case 'l': {
                            if (string3.length() == 4 && "-log".equals(string3)) {
                                log = true;
                                break;
                            }
                            if (string3.length() == 9 && "-language".equals(string3)) {
                                language = stringArray[++i];
                                break;
                            }
                            show_linenums = true;
                            break;
                        }
                        case 't': {
                            do_test = true;
                            break;
                        }
                        case 'h': {
                            do_help = true;
                            break;
                        }
                        case 'o': {
                            optimize = true;
                            break;
                        }
                        case 'A': {
                            if (string3.length() != 4 || !"-AS3".equalsIgnoreCase(string3)) continue block22;
                            dialect = 10;
                            break;
                        }
                        case 'E': {
                            if (string3.length() == 3 && "-ES".equalsIgnoreCase(string3)) {
                                dialect = 9;
                                break;
                            }
                            if (string3.length() != 4 || !"-ES4".equalsIgnoreCase(string3)) continue block22;
                            dialect = 11;
                            break;
                        }
                        default: {
                            try {
                                if (string3.length() <= 1 || (dialect = -1 * Integer.parseInt(string3)) == 0 || dialect >= earliest_dialect && dialect <= latest_dialect) continue block22;
                                do_help = true;
                            }
                            catch (NumberFormatException numberFormatException) {
                                do_help = true;
                            }
                            break;
                        }
                    }
                    continue;
                }
                string = new String(stringArray[i].trim());
                string2 = string.endsWith(".as") ? ".as" : (string.endsWith(".es") ? ".es" : (string.endsWith(".js") ? ".js" : ""));
                filespecFound = true;
                Main.handleFile(string, string2);
            }
        }
        if (!do_help && !filespecFound) {
            Context context = new Context(new ContextStatics());
            System.err.println(context.errorString(1147));
            System.exit(1);
        } else if (do_help) {
            Main.handleFile("", "");
        }
    }

    private static void handleFile(String string, String string2) throws IOException, FileNotFoundException, Exception {
        if (do_help) {
            System.out.println("ActionScript 3.0 for AVM+");
            System.out.println("version 1.0 build 124 3980a8a98674");
            System.out.println("Copyright (c) 2003-2004 Macromedia, Inc.");
            System.out.println("Copyright (c) 1998-2003 Mountain View Compiler Company");
            System.out.println("All rights reserved\n");
            System.out.println("Usage:");
            System.out.println("  asc {-AS3|-ES|-d|-f|-h|-i|-import <filename>|-in <filename>|-m|-p}* filespec");
            System.out.println("  -AS3 = use the AS3 class based object model for greater performance and better error reporting");
            System.out.println("  -ES = use the ECMAScript edition 3 prototype based object model to allow dynamic overriding of prototype properties");
            System.out.println("  -d = emit debug info into the bytecode");
            System.out.println("  -f = print the flow graph to standard out");
            System.out.println("  -h = print this message");
            System.out.println("  -i = write intermediate code to the .il file");
            System.out.println("  -import <filename> = make the packages in the");
            System.out.println("       specified file available for import");
            System.out.println("  -in <filename> = include the specified filename");
            System.out.println("       (multiple -in arguments allowed)");
            System.out.println("  -m = write the avm+ assembly code to the .il file");
            System.out.println("  -p = write parse tree to the .p file");
            System.out.println("  -md = emit metadata information into the bytecode");
            System.out.println("  -warnings = warn on common actionscript mistakes");
            System.out.println("  -strict = treat undeclared variable and method access as errors");
            System.out.println("  -sanity = system-independent error/warning output -- appropriate for sanity testing");
            System.out.println("  -log = redirect all error output to a logfile");
            System.out.println("  -exe <avmplus path> = emit an EXE file (projector)");
            System.out.println("  -swf classname,width,height[,fps] = emit a SWF file");
            System.out.println("  -language = set the language for output strings {EN|FR|DE|IT|ES|JP|KR|CN|TW}");
            System.out.println("  -optimize = produced an optimized abc file");
            System.out.println("  -config ns::name=value = define a configuration value in the namespace ns");
            System.out.println("");
            System.exit(1);
        }
        if (!do_test) {
            Object object;
            String string3;
            File file = new File(string.trim());
            if (!file.exists()) {
                Context context = new Context(new ContextStatics());
                StringBuffer stringBuffer = new StringBuffer();
                Context.replaceStringArg(stringBuffer, context.errorString(1063), 0, string);
                System.err.println(stringBuffer.toString());
                return;
            }
            try {
                string3 = new File(file.getCanonicalPath()).getParent();
            }
            catch (IOException iOException) {
                string3 = new File(file.getAbsolutePath()).getParent();
            }
            String string4 = file.getName().substring(0, file.getName().length() - string2.length());
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            CompilerPlug compilerPlug = new CompilerPlug();
            compilerPlug.in = bufferedInputStream;
            compilerPlug.pathspec = string3;
            compilerPlug.filename = file.getPath();
            compilerPlug.scriptname = string4;
            compilerPlug.emit_debug_info = emit_debug_info;
            compilerPlug.emit_doc_info = emit_doc_info;
            compilerPlug.make_movieclip = make_movieclip;
            compilerPlug.import_filespecs = import_filespecs;
            compilerPlug.lint_mode = lint_mode;
            compilerPlug.use_static_semantics = use_static_semantics;
            compilerPlug.emit_metadata = emit_metadata;
            compilerPlug.swf_options = swf_options;
            compilerPlug.avmplus_exe = avmplus_exe;
            compilerPlug.language = language;
            compilerPlug.dialect = dialect;
            compilerPlug.optimize = optimize;
            compilerPlug.configs = config_vars;
            if (sanity_mode) {
                ContextStatics.useSanityStyleErrors = true;
                compilerPlug.handler = new SanityCompilerHandler();
            }
            if (log) {
                object = string.substring(0, string.length() - string2.length()) + ".log";
                System.setErr(stderr);
                System.err.println("Logging to " + (String)object);
                System.setErr(new PrintStream(new FileOutputStream(new File((String)object))));
            }
            if (include_filespecs.size() > 0) {
                compilerPlug.includes = new ObjectList();
                for (int i = 0; i < include_filespecs.size(); ++i) {
                    String string5 = (String)include_filespecs.get(i);
                    file = new File(string5);
                    if (!file.exists()) {
                        System.err.println("File not found");
                        return;
                    }
                    string5 = file.getPath();
                    string3 = new File(file.getCanonicalPath()).getParent();
                    string = file.getAbsolutePath();
                    string4 = file.getName().substring(0, file.getName().length() - string2.length());
                    bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                    IncludeInfo includeInfo = new IncludeInfo();
                    includeInfo.script = bufferedInputStream;
                    includeInfo.name = make_movieclip ? "frame" + i : string5;
                    compilerPlug.includes.push_back(includeInfo);
                }
            }
            object = new ObjectList<CompilerPlug>();
            Compiler.doCompile(compilerPlug, object, show_instructions, show_machinecode, show_linenums, show_parsetrees, show_bytes, show_flow);
        }
    }

    public static ConfigVar parseConfigVar(String string) {
        int n;
        ConfigVar configVar = null;
        if (string != null && (n = string.indexOf("::")) != -1) {
            String string2 = string.substring(0, n);
            int n2 = string.indexOf("=", n);
            if (n2 != -1) {
                String string3 = string.substring(n + 2, n2);
                String string4 = string.substring(n2 + 1, string.length());
                configVar = new ConfigVar(string2, string3, string4);
            }
        }
        return configVar;
    }

    static {
        dialect = default_dialect = 9;
        optimize = false;
        include_filespecs = new ObjectList();
        import_filespecs = new ObjectList();
        swf_options = "";
        language = "EN";
        avmplus_exe = null;
        config_vars = new ObjectList();
    }
}

