/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.agl.util;

import com.adobe.agl.impl.ICUResourceBundle;
import com.adobe.agl.util.MeasureUnit;
import com.adobe.agl.util.ULocale;
import com.adobe.agl.util.UResourceBundle;
import java.io.Serializable;
import java.text.ChoiceFormat;
import java.text.ParsePosition;
import java.util.Locale;
import java.util.MissingResourceException;

public class Currency
extends MeasureUnit
implements Serializable {
    private String isoCode;
    public static final int SYMBOL_NAME = 0;
    public static final int LONG_NAME = 1;
    private static ServiceShim shim;
    private static final int[] LAST_RESORT_DATA;
    private static final int[] POW10;
    private ULocale validLocale;
    private ULocale actualLocale;

    private static ServiceShim getShim() {
        if (shim == null) {
            try {
                Class<?> cls = Class.forName("com.adobe.agl.util.CurrencyServiceShim");
                shim = (ServiceShim)cls.newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e.getMessage());
            }
        }
        return shim;
    }

    public static Currency getInstance(Locale locale) {
        return Currency.getInstance(ULocale.forLocale(locale));
    }

    public static Currency getInstance(ULocale locale) {
        String currency = locale.getKeywordValue("currency");
        if (currency != null) {
            return Currency.getInstance(currency);
        }
        if (shim == null) {
            return Currency.createCurrency(locale);
        }
        return shim.createInstance(locale);
    }

    static Currency createCurrency(ULocale loc) {
        String country = loc.getCountry();
        String variant = loc.getVariant();
        if (variant.equals("PREEURO") || variant.equals("EURO")) {
            country = country + '_' + variant;
        }
        ICUResourceBundle bundle = ICUResourceBundle.createBundle("com/adobe/agl/impl/data/icudt32b", "CurrencyData", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
        ICUResourceBundle cm = bundle.get("CurrencyMap");
        String curriso = null;
        try {
            curriso = cm.getString(country);
            if (curriso != null) {
                return new Currency(curriso);
            }
        }
        catch (MissingResourceException ex) {
            // empty catch block
        }
        return null;
    }

    public static Currency getInstance(String theISOCode) {
        return new Currency(theISOCode);
    }

    public static Object registerInstance(Currency currency, ULocale locale) {
        return Currency.getShim().registerInstance(currency, locale);
    }

    public static boolean unregister(Object registryKey) {
        if (registryKey == null) {
            throw new IllegalArgumentException("registryKey must not be null");
        }
        if (shim == null) {
            return false;
        }
        return shim.unregister(registryKey);
    }

    public static Locale[] getAvailableLocales() {
        if (shim == null) {
            return ICUResourceBundle.getAvailableLocales("com/adobe/agl/impl/data/icudt32b");
        }
        return shim.getAvailableLocales();
    }

    public static ULocale[] getAvailableULocales() {
        if (shim == null) {
            return ICUResourceBundle.getAvailableULocales("com/adobe/agl/impl/data/icudt32b");
        }
        return shim.getAvailableULocales();
    }

    public int hashCode() {
        return this.isoCode.hashCode();
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        if (rhs == this) {
            return true;
        }
        try {
            Currency c = (Currency)rhs;
            return this.isoCode.equals(c.isoCode);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public String getCurrencyCode() {
        return this.isoCode;
    }

    public String getName(Locale locale, int nameStyle, boolean[] isChoiceFormat) {
        return this.getName(ULocale.forLocale(locale), nameStyle, isChoiceFormat);
    }

    public String getName(ULocale locale, int nameStyle, boolean[] isChoiceFormat) {
        if (nameStyle < 0 || nameStyle > 1) {
            throw new IllegalArgumentException();
        }
        String s = null;
        while (locale != null) {
            ICUResourceBundle rb = (ICUResourceBundle)UResourceBundle.getBundleInstance("com/adobe/agl/impl/data/icudt32b", locale);
            try {
                ICUResourceBundle currencies = rb.get("Currencies");
                s = currencies.get(this.isoCode).getString(nameStyle);
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
            if (s != null) break;
            locale = locale.getFallback();
        }
        isChoiceFormat[0] = false;
        if (s != null) {
            int i;
            for (i = 0; i < s.length() && s.charAt(i) == '=' && i < 2; ++i) {
            }
            boolean bl = isChoiceFormat[0] = i == 1;
            if (i != 0) {
                s = s.substring(1);
            }
            return s;
        }
        return this.isoCode;
    }

    public static String parse(ULocale locale, String text, ParsePosition pos) {
        int start = pos.getIndex();
        String fragment = text.substring(start);
        String iso = null;
        int max = 0;
        while (locale != null) {
            ICUResourceBundle rb = (ICUResourceBundle)UResourceBundle.getBundleInstance("com/adobe/agl/impl/data/icudt32b", locale);
            try {
                ICUResourceBundle currencies = rb.get("Currencies");
                for (int i = 0; i < currencies.getSize(); ++i) {
                    ICUResourceBundle item = currencies.get(i);
                    String name = item.getString(0);
                    if (name.length() < 1) continue;
                    if (name.charAt(0) == '=' && (name = name.substring(1)).length() > 0 && name.charAt(0) != '=') {
                        ChoiceFormat choice = new ChoiceFormat(name);
                        choice.parse(text, pos);
                        int len = pos.getIndex() - start;
                        if (len > max) {
                            iso = item.getKey();
                            max = len;
                        }
                        pos.setIndex(start);
                        continue;
                    }
                    if (name.length() <= max || !fragment.startsWith(name)) continue;
                    iso = item.getKey();
                    max = name.length();
                }
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
            locale = locale.getFallback();
        }
        if (max < 3 && text.length() - start >= 3) {
            boolean valid = true;
            for (int k = 0; k < 3; ++k) {
                char ch = text.charAt(start + k);
                if (ch >= 'A' && ch <= 'Z') continue;
                valid = false;
                break;
            }
            if (valid) {
                iso = text.substring(start, start + 3);
                max = 3;
            }
        }
        pos.setIndex(start + max);
        return iso;
    }

    public int getDefaultFractionDigits() {
        return this.findData()[0];
    }

    public double getRoundingIncrement() {
        int[] data = this.findData();
        int data1 = data[1];
        if (data1 == 0) {
            return 0.0;
        }
        int data0 = data[0];
        if (data0 < 0 || data0 >= POW10.length) {
            return 0.0;
        }
        return (double)data1 / (double)POW10[data0];
    }

    public String toString() {
        return this.isoCode;
    }

    private Currency(String theISOCode) {
        this.isoCode = theISOCode;
    }

    private int[] findData() {
        try {
            ICUResourceBundle root = ICUResourceBundle.createBundle("com/adobe/agl/impl/data/icudt32b", "CurrencyData", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
            ICUResourceBundle currencyMeta = root.get("CurrencyMeta");
            int[] i = currencyMeta.get(this.isoCode).getIntVector();
            if (i == null) {
                i = currencyMeta.get("DEFAULT").getIntVector();
            }
            if (i != null && i.length >= 2) {
                return i;
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return LAST_RESORT_DATA;
    }

    public final ULocale getLocale(ULocale.Type type) {
        return ULocale.ROOT;
    }

    final void setLocale(ULocale valid, ULocale actual) {
        if (valid == null != (actual == null)) {
            throw new IllegalArgumentException();
        }
        this.validLocale = valid;
        this.actualLocale = actual;
    }

    static {
        LAST_RESORT_DATA = new int[]{2, 0};
        POW10 = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};
    }

    static abstract class ServiceShim {
        ServiceShim() {
        }

        abstract ULocale[] getAvailableULocales();

        abstract Locale[] getAvailableLocales();

        abstract Currency createInstance(ULocale var1);

        abstract Object registerInstance(Currency var1, ULocale var2);

        abstract boolean unregister(Object var1);
    }
}

