/*
 * Decompiled with CFR 0.152.
 */
package macromedia.abc;

import macromedia.abc.BytecodeBuffer;
import macromedia.abc.DecoderException;

public final class Scanner {
    public static int scanMinorVersion(BytecodeBuffer bytecodeBuffer) {
        int n = bytecodeBuffer.pos();
        bytecodeBuffer.skip(2L);
        return n;
    }

    public static int scanMajorVersion(BytecodeBuffer bytecodeBuffer) {
        int n = bytecodeBuffer.pos();
        bytecodeBuffer.skip(2L);
        return n;
    }

    public static int[] scanIntConstants(BytecodeBuffer bytecodeBuffer) {
        int n = bytecodeBuffer.readU32();
        int[] nArray = new int[n];
        for (int i = 1; i < n; ++i) {
            nArray[i] = bytecodeBuffer.pos();
            bytecodeBuffer.readU32();
        }
        return nArray;
    }

    public static int[] scanUIntConstants(BytecodeBuffer bytecodeBuffer) {
        int n = bytecodeBuffer.readU32();
        int[] nArray = new int[n];
        for (int i = 1; i < n; ++i) {
            nArray[i] = bytecodeBuffer.pos();
            bytecodeBuffer.readU32();
        }
        return nArray;
    }

    public static int[] scanDoubleConstants(BytecodeBuffer bytecodeBuffer) {
        int n = bytecodeBuffer.readU32();
        int[] nArray = new int[n];
        for (int i = 1; i < n; ++i) {
            nArray[i] = bytecodeBuffer.pos();
            bytecodeBuffer.readDouble();
        }
        return nArray;
    }

    public static int[] scanStrConstants(BytecodeBuffer bytecodeBuffer) {
        int n = bytecodeBuffer.readU32();
        int[] nArray = new int[n];
        for (int i = 1; i < n; ++i) {
            nArray[i] = bytecodeBuffer.pos();
            long l = bytecodeBuffer.readU32();
            bytecodeBuffer.skip(l);
        }
        return nArray;
    }

    public static int[] scanNsConstants(BytecodeBuffer bytecodeBuffer) {
        int n = bytecodeBuffer.readU32();
        int[] nArray = new int[n];
        for (int i = 1; i < n; ++i) {
            nArray[i] = bytecodeBuffer.pos();
            bytecodeBuffer.readU8();
            bytecodeBuffer.readU32();
        }
        return nArray;
    }

    public static int[] scanNsSetConstants(BytecodeBuffer bytecodeBuffer) {
        int n = bytecodeBuffer.readU32();
        int[] nArray = new int[n];
        for (int i = 1; i < n; ++i) {
            nArray[i] = bytecodeBuffer.pos();
            long l = bytecodeBuffer.readU32();
            bytecodeBuffer.skipEntries(l);
        }
        return nArray;
    }

    public static int[] scanMultinameConstants(BytecodeBuffer bytecodeBuffer) throws DecoderException {
        int n = bytecodeBuffer.readU32();
        int[] nArray = new int[n];
        block7: for (int i = 1; i < n; ++i) {
            nArray[i] = bytecodeBuffer.pos();
            int n2 = bytecodeBuffer.readU8();
            switch (n2) {
                case 7: 
                case 13: {
                    bytecodeBuffer.readU32();
                    bytecodeBuffer.readU32();
                    continue block7;
                }
                case 15: 
                case 16: {
                    bytecodeBuffer.readU32();
                    continue block7;
                }
                case 9: 
                case 14: {
                    bytecodeBuffer.readU32();
                    bytecodeBuffer.readU32();
                    continue block7;
                }
                case 17: 
                case 18: {
                    continue block7;
                }
                case 27: 
                case 28: {
                    bytecodeBuffer.readU32();
                    continue block7;
                }
                default: {
                    throw new DecoderException("Invalid constant type: " + n2);
                }
            }
        }
        return nArray;
    }

    public static int[] scanMethods(BytecodeBuffer bytecodeBuffer) {
        int n = bytecodeBuffer.readU32();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            long l;
            nArray[i] = bytecodeBuffer.pos();
            long l2 = bytecodeBuffer.readU32();
            bytecodeBuffer.readU32();
            bytecodeBuffer.skipEntries(l2);
            bytecodeBuffer.readU32();
            int n2 = bytecodeBuffer.readU8();
            long l3 = (n2 & 8) != 0 ? (long)bytecodeBuffer.readU32() : 0L;
            for (l = 0L; l < l3; ++l) {
                bytecodeBuffer.readU32();
                bytecodeBuffer.readU8();
            }
            l = (n2 & 0x80) != 0 ? l2 : 0L;
            for (long j = 0L; j < l; ++j) {
                bytecodeBuffer.readU32();
            }
        }
        return nArray;
    }

    public static int[] scanMetadata(BytecodeBuffer bytecodeBuffer) {
        int n = bytecodeBuffer.readU32();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = bytecodeBuffer.pos();
            bytecodeBuffer.readU32();
            long l = bytecodeBuffer.readU32();
            bytecodeBuffer.skipEntries(l * 2L);
        }
        return nArray;
    }

    public static int[] scanInstances(BytecodeBuffer bytecodeBuffer, int n) {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = bytecodeBuffer.pos();
            bytecodeBuffer.skipEntries(2L);
            int n2 = bytecodeBuffer.readU8();
            if ((n2 & 8) != 0) {
                bytecodeBuffer.readU32();
            }
            long l = bytecodeBuffer.readU32();
            bytecodeBuffer.skipEntries(l);
            bytecodeBuffer.readU32();
            Scanner.scanTraits(bytecodeBuffer);
        }
        return nArray;
    }

    public static int[] scanClasses(BytecodeBuffer bytecodeBuffer, int n) {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = bytecodeBuffer.pos();
            bytecodeBuffer.readU32();
            Scanner.scanTraits(bytecodeBuffer);
        }
        return nArray;
    }

    public static int[] scanScripts(BytecodeBuffer bytecodeBuffer) {
        int n = bytecodeBuffer.readU32();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = bytecodeBuffer.pos();
            bytecodeBuffer.readU32();
            Scanner.scanTraits(bytecodeBuffer);
        }
        return nArray;
    }

    public static int[] scanMethodBodies(BytecodeBuffer bytecodeBuffer) {
        int n = bytecodeBuffer.readU32();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = bytecodeBuffer.pos();
            bytecodeBuffer.skipEntries(5L);
            long l = bytecodeBuffer.readU32();
            bytecodeBuffer.skip((int)l);
            Scanner.scanExceptions(bytecodeBuffer);
            Scanner.scanTraits(bytecodeBuffer);
        }
        return nArray;
    }

    private static void scanExceptions(BytecodeBuffer bytecodeBuffer) {
        long l = bytecodeBuffer.readU32();
        if (bytecodeBuffer.minorVersion() == 15) {
            bytecodeBuffer.skipEntries(l * 4L);
        } else {
            bytecodeBuffer.skipEntries(l * 5L);
        }
    }

    private static void scanTraits(BytecodeBuffer bytecodeBuffer) {
        long l = bytecodeBuffer.readU32();
        for (long i = 0L; i < l; ++i) {
            bytecodeBuffer.readU32();
            int n = bytecodeBuffer.readU8();
            int n2 = n & 0xF;
            switch (n2) {
                case 0: 
                case 6: {
                    bytecodeBuffer.skipEntries(2L);
                    int n3 = bytecodeBuffer.readU32();
                    if (n3 <= 0) break;
                    bytecodeBuffer.readU8();
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    bytecodeBuffer.skipEntries(2L);
                    break;
                }
                case 4: 
                case 5: {
                    bytecodeBuffer.skipEntries(2L);
                    break;
                }
                default: {
                    System.err.println("invalid trait type: " + n2);
                }
            }
            if ((n >> 4 & 4) == 0) continue;
            long l2 = bytecodeBuffer.readU32();
            bytecodeBuffer.skipEntries(l2);
        }
    }
}

