/*
 * Decompiled with CFR 0.152.
 */
package flex.webtier.util;

import flex.webtier.util.OrderedProperties;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Stack;

public class PropertiesUtil {
    public static final String BEGIN_VARIABLE_MARKER = "{";
    public static final String END_VARIABLE_MARKER = "}";
    public static final String SYSTEM_PROPERTY_KEY = "System.";
    protected static Hashtable sdfCache = new Hashtable();
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static OrderedProperties trimParent(Properties props, String parentKey) {
        return PropertiesUtil.trimParent2(props, parentKey);
    }

    public static OrderedProperties trimParent(OrderedProperties props, String parentKey) {
        return PropertiesUtil.trimParent2(props, parentKey);
    }

    private static OrderedProperties trimParent2(Object props, String parentKey) {
        if (parentKey == null || parentKey.length() == 0 || props == null) {
            if (props instanceof Properties) {
                OrderedProperties op = new OrderedProperties();
                Properties p = (Properties)props;
                Enumeration<Object> e = p.keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    op.put(key, p.getProperty(key));
                }
                return op;
            }
            return (OrderedProperties)props;
        }
        OrderedProperties newProps = new OrderedProperties();
        parentKey = parentKey + ".";
        int keyLen = parentKey.length();
        Enumeration e = null;
        Properties pSource = null;
        OrderedProperties opSource = null;
        if (props instanceof Properties) {
            pSource = (Properties)props;
            e = pSource.keys();
        } else {
            opSource = (OrderedProperties)props;
            e = opSource.keys();
        }
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (key.indexOf(".") < 0) continue;
            String value = pSource != null ? pSource.getProperty(key) : opSource.getProperty(key);
            if (key.startsWith(parentKey)) {
                newProps.put(key.substring(keyLen), value);
                continue;
            }
            newProps.put(key, value);
        }
        return newProps;
    }

    public static OrderedProperties getChildren(Properties props, String parentKey) {
        return PropertiesUtil.getChildren2(props, parentKey);
    }

    public static OrderedProperties getChildren(OrderedProperties props, String parentKey) {
        return PropertiesUtil.getChildren2(props, parentKey);
    }

    private static OrderedProperties getChildren2(Object props, String parentKey) {
        if (parentKey == null || parentKey.length() == 0 || props == null) {
            if (props instanceof Properties) {
                OrderedProperties op = new OrderedProperties();
                Properties p = (Properties)props;
                Enumeration<Object> e = p.keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    op.put(key, p.getProperty(key));
                }
                return op;
            }
            return (OrderedProperties)props;
        }
        OrderedProperties newProps = new OrderedProperties();
        parentKey = parentKey + ".";
        int keyLen = parentKey.length();
        Enumeration e = null;
        Properties pSource = null;
        OrderedProperties opSource = null;
        if (props instanceof Properties) {
            pSource = (Properties)props;
            e = pSource.keys();
        } else {
            opSource = (OrderedProperties)props;
            e = opSource.keys();
        }
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith(parentKey)) continue;
            String value = pSource != null ? pSource.getProperty(key) : opSource.getProperty(key);
            newProps.put(key.substring(keyLen), value);
        }
        return newProps;
    }

    public static boolean isTrue(String value) {
        boolean rc = false;
        if (value != null && value.equals("true")) {
            rc = true;
        }
        return rc;
    }

    public static String expandDynamicVariables(String value, Date date, Properties variableProps) {
        if (value == null) {
            return null;
        }
        String lastValue = "";
        while (!value.equals(lastValue)) {
            int endPos;
            lastValue = value;
            int beginPos = value.indexOf(BEGIN_VARIABLE_MARKER);
            while (beginPos >= 0 && (endPos = value.indexOf(END_VARIABLE_MARKER, beginPos)) >= 0) {
                Properties sysProps;
                String varName = value.substring(beginPos + 1, endPos);
                String varValue = null;
                if (variableProps != null) {
                    varValue = variableProps.getProperty(varName);
                }
                if (varValue == null) {
                    varValue = PropertiesUtil.getVariableValue(varName, date);
                }
                if (varValue == null && varName.startsWith(SYSTEM_PROPERTY_KEY) && (sysProps = System.getProperties()) != null) {
                    varValue = sysProps.getProperty(varName.substring(SYSTEM_PROPERTY_KEY.length()));
                }
                if (varValue != null && varValue.indexOf(BEGIN_VARIABLE_MARKER + varName + END_VARIABLE_MARKER) >= 0) {
                    varValue = null;
                }
                if (varValue != null) {
                    StringBuffer sb = new StringBuffer();
                    if (beginPos > 0) {
                        sb.append(value.substring(0, beginPos));
                    }
                    sb.append(varValue);
                    if (endPos < value.length()) {
                        sb.append(value.substring(endPos + 1));
                    }
                    value = sb.toString();
                }
                beginPos = value.indexOf(BEGIN_VARIABLE_MARKER, beginPos + 1);
            }
        }
        return value;
    }

    protected static SimpleDateFormat getPooledSDF(String format) {
        SimpleDateFormat sdf = null;
        Stack stack = (Stack)sdfCache.get(format);
        if (stack != null) {
            try {
                sdf = (SimpleDateFormat)stack.pop();
            }
            catch (EmptyStackException emptyStackException) {
                // empty catch block
            }
        }
        if (sdf == null) {
            sdf = new SimpleDateFormat(format);
        }
        return sdf;
    }

    protected static void returnPooledSDF(SimpleDateFormat sdf) {
        String format = sdf.toPattern();
        Stack<SimpleDateFormat> stack = (Stack<SimpleDateFormat>)sdfCache.get(format);
        if (stack == null) {
            stack = new Stack<SimpleDateFormat>();
            sdfCache.put(format, stack);
        }
        stack.push(sdf);
    }

    public static String getVariableValue(String var, Date date) {
        if (var == null || date == null) {
            return null;
        }
        String s = null;
        if (var.equals("date")) {
            SimpleDateFormat format = PropertiesUtil.getPooledSDF("yyyyMMdd");
            s = format.format(date);
            PropertiesUtil.returnPooledSDF(format);
        } else if (var.startsWith("date ")) {
            SimpleDateFormat format = PropertiesUtil.getPooledSDF(var.substring(5));
            s = format.format(date);
            PropertiesUtil.returnPooledSDF(format);
        } else if (var.equals("day")) {
            SimpleDateFormat format = PropertiesUtil.getPooledSDF("dd");
            s = format.format(date);
            PropertiesUtil.returnPooledSDF(format);
        } else if (var.equals("month")) {
            SimpleDateFormat format = PropertiesUtil.getPooledSDF("MM");
            s = format.format(date);
            PropertiesUtil.returnPooledSDF(format);
        } else if (var.equals("year")) {
            SimpleDateFormat format = PropertiesUtil.getPooledSDF("yyyy");
            s = format.format(date);
            PropertiesUtil.returnPooledSDF(format);
        } else if (var.equals("hour")) {
            SimpleDateFormat format = PropertiesUtil.getPooledSDF("HH");
            s = format.format(date);
            PropertiesUtil.returnPooledSDF(format);
        } else if (var.equals("julian")) {
            s = "" + date.getTime() / 86400000L;
        } else if (var.equals("thread.name")) {
            s = Thread.currentThread().getName();
        } else if (var.equals("thread.hashcode")) {
            s = "" + Thread.currentThread().hashCode();
        } else if (var.equals("thread.id")) {
            s = PropertiesUtil.toHex(Thread.currentThread().hashCode());
        }
        return s;
    }

    public static String toHex(int n, int bytes) {
        if (bytes < 1 || bytes > 4) {
            bytes = 4;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = bytes - 1; i >= 0; --i) {
            sb.append(hexDigit[n >> i * 8 + 4 & 0xF]);
            sb.append(hexDigit[n >> i * 8 & 0xF]);
        }
        return sb.toString();
    }

    public static String toHex(int n) {
        return PropertiesUtil.toHex(n, 4);
    }
}

