/*
 * Decompiled with CFR 0.152.
 */
package flex.webtier.services.license;

import flex.license.common.LicenseLoader;
import flex.webtier.services.license.InvalidLicenseException;
import flex.webtier.services.license.LicenseService;
import flex.webtier.services.license.StandardLicense;
import java.io.File;
import java.io.FileNotFoundException;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public final class LicenseServiceImpl
implements LicenseService {
    private StandardLicense license;
    private String licenseKey = null;
    File hiddenFile = null;
    private boolean betaRelease = false;
    private int betaPeriodDays = 106;
    private int betaStartsYear = 2007;
    private int betaStartsMonth = 3;
    private int betaStartsDay = 1;
    LicenseLoader loader;

    public LicenseServiceImpl(LicenseLoader loader) {
        this.loader = loader;
    }

    private void load() {
        try {
            Properties props = this.loader.loadProperties();
            this.licenseKey = props.getProperty("flexbuilder3");
            if (this.licenseKey != null) {
                this.licenseKey = this.licenseKey.trim();
            }
            if (this.licenseKey == null || this.licenseKey == "") {
                this.licenseKey = null;
            }
        }
        catch (FileNotFoundException ex) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean validateLicense() {
        this.license = new StandardLicense(this.licenseKey, this.betaRelease);
        if (this.licenseKey != null && this.licenseKey.length() > 0 && !this.license.isValid()) {
            InvalidLicenseException ile = new InvalidLicenseException();
            ile.setMessage("An invalid flexbuilder3 license key was entered.  To enable a trial, which does not required a license, please remove the invalid flexbuilder3 license key from license.properties.");
            throw ile;
        }
        return this.license.isValid();
    }

    public void init() {
        this.license = null;
        this.load();
        this.validateLicense();
        if (this.isBetaExpired()) {
            InvalidLicenseException ile = new InvalidLicenseException();
            ile.setMessage(this.expiredMessage());
            throw ile;
        }
    }

    public Map getLicenseMap() {
        HashMap<String, String> licenseMap = new HashMap<String, String>();
        if (this.licenseKey == null) {
            licenseMap.put("flexbuilder3", "");
        } else {
            licenseMap.put("flexbuilder3", this.licenseKey);
        }
        return licenseMap;
    }

    public boolean isMxmlCompileEnabled() {
        return true;
    }

    public boolean isValid() {
        return this.license.isValid();
    }

    public String getBetaRemainingMessage() {
        String message = null;
        if (this.betaRelease) {
            Calendar c = this.betaExpires();
            message = " (beta period ends " + DateFormat.getDateInstance().format(c.getTime()) + ")";
        }
        return message;
    }

    private Calendar betaExpires() {
        if (!this.betaRelease) {
            return null;
        }
        Calendar expires = Calendar.getInstance();
        expires.clear();
        expires.set(11, 0);
        expires.set(12, 0);
        expires.set(13, 0);
        expires.set(1, this.betaStartsYear);
        expires.set(2, this.betaStartsMonth - 1);
        expires.set(5, this.betaStartsDay);
        expires.add(5, this.betaPeriodDays);
        return expires;
    }

    public boolean isBetaExpired() {
        if (!this.betaRelease) {
            return false;
        }
        Calendar now = Calendar.getInstance();
        Calendar expires = this.betaExpires();
        return now.after(expires);
    }

    public String expiredMessage() {
        String message = null;
        if (this.isBetaExpired()) {
            message = "Adobe Flex Web Tier Compiler: beta license expired!";
        }
        return message;
    }
}

