/*
 * Decompiled with CFR 0.152.
 */
package flex.webtier.server.j2ee;

import flex.webtier.server.j2ee.FileNameGenerator;
import flex.webtier.server.j2ee.URLHelper;
import flex.webtier.server.j2ee.cache.CacheKeyUtils;
import flex.webtier.services.ServiceFactory;
import flex.webtier.services.extensions.ExtensionManager;
import flex.webtier.util.J2EEUtil;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

public class RequestContext {
    private String dependencyKey;
    private String sourceFileName;
    private String swfUri;
    private String objectUri;
    private String objectQuery;

    public RequestContext(ServletContext context, HttpServletRequest request) {
        String requestFileName = J2EEUtil.getRealPath((String)request.getServletPath(), (ServletContext)context);
        ExtensionManager extensionManager = ServiceFactory.getExtensionManager();
        String mxmlSwfExt = extensionManager.getMxmlSwfExt();
        String mxmlSwdExt = extensionManager.getMxmlSwdExt();
        String swfExt = extensionManager.getSwfExt();
        String swdExt = extensionManager.getSwdExt();
        String asSwfExt = extensionManager.getAsSwfExt();
        if (requestFileName.lastIndexOf(mxmlSwfExt) != -1 || requestFileName.lastIndexOf(mxmlSwdExt) != -1 || requestFileName.lastIndexOf(asSwfExt) != -1) {
            this.setupSwfRequest(context, request);
        } else if (requestFileName.lastIndexOf(swfExt) != -1 || requestFileName.lastIndexOf(swdExt) != -1) {
            this.setupPrecompileRequest(request);
        } else {
            this.setupMxmlRequest(context, request);
        }
    }

    private void setupPrecompileRequest(HttpServletRequest request) {
        this.dependencyKey = CacheKeyUtils.generateGenericCacheKey(request, null);
    }

    private void setupSwfRequest(ServletContext context, HttpServletRequest request) {
        String requestPath = request.getServletPath();
        this.sourceFileName = J2EEUtil.getRealPath((String)FileNameGenerator.sourceFileName(requestPath), (ServletContext)context);
        this.dependencyKey = CacheKeyUtils.generateSwfCacheKey(request, null);
    }

    private void setupMxmlRequest(ServletContext context, HttpServletRequest request) {
        String requestFileName;
        String query = this.getSwfQueryString(request);
        String requestPath = request.getServletPath();
        this.sourceFileName = requestFileName = J2EEUtil.getRealPath((String)requestPath, (ServletContext)context);
        this.dependencyKey = CacheKeyUtils.generateSwfCacheKey(request, null);
        this.swfUri = FileNameGenerator.swfFileName(requestPath);
        if (query != null) {
            this.swfUri = this.swfUri + "?" + query;
        }
        this.objectUri = FileNameGenerator.sourceFileName(requestPath);
        this.objectQuery = this.getObjectQueryString(request);
    }

    public String getDependencyKey() {
        return this.dependencyKey;
    }

    public String getSourceFileName() {
        return this.sourceFileName;
    }

    public String getSwfUri() {
        return this.swfUri;
    }

    public String getObjectUri() {
        String uri = this.objectUri;
        if (this.objectQuery != null) {
            uri = uri + "?" + this.objectQuery;
        }
        return uri;
    }

    public String getObjectQueryString(HttpServletRequest request) {
        Iterator iterator;
        Set keySet;
        TreeMap<String, String> queries = new TreeMap<String, String>();
        String query = null;
        Map parameterMap = request.getParameterMap();
        if (parameterMap != null && (keySet = parameterMap.keySet()) != null && (iterator = keySet.iterator()) != null) {
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                String value = request.getParameter(key);
                if (value == null) continue;
                queries.put(key, value);
            }
        }
        if (queries.size() > 0) {
            query = URLHelper.encode(queries);
        }
        return query;
    }

    public String getSwfQueryString(HttpServletRequest request) {
        Iterator iterator;
        Set keySet;
        TreeMap<String, String> directives = new TreeMap<String, String>();
        String query = null;
        Map parameterMap = request.getParameterMap();
        if (parameterMap != null && (keySet = parameterMap.keySet()) != null && (iterator = keySet.iterator()) != null) {
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                String value = request.getParameter(key);
                if (!CacheKeyUtils.isCompilerDirective(key) || value == null) continue;
                directives.put(key, value);
            }
        }
        if (directives.size() > 0) {
            query = URLHelper.encode(directives);
        }
        return query;
    }
}

