/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.util;

import flash.localization.LocalizationManager;
import flex2.compiler.ILocalizableMessage;
import flex2.compiler.Logger;
import flex2.compiler.io.FileUtil;
import flex2.compiler.util.AbstractLogger;
import flex2.compiler.util.ThreadLocalToolkit;
import java.io.IOException;

public class Console
extends AbstractLogger
implements Logger {
    private static final String lineSeparator;
    private boolean isInfoEnabled;
    private boolean isDebugEnabled;
    private boolean isWarningEnabled;
    private boolean isErrorEnabled;
    private int errorCount;
    private int warningCount;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Console() {
        this(true, true, true, true);
    }

    public Console(boolean isInfoEnabled, boolean isDebugEnabled, boolean isWarningEnabled, boolean isErrorEnabled) {
        this.isInfoEnabled = isInfoEnabled;
        this.isDebugEnabled = isDebugEnabled;
        this.isWarningEnabled = isWarningEnabled;
        this.isErrorEnabled = isErrorEnabled;
        this.init(ThreadLocalToolkit.getLocalizationManager());
    }

    public int errorCount() {
        return this.errorCount;
    }

    public int warningCount() {
        return this.warningCount;
    }

    public void logInfo(String info) {
        if (!this.isInfoEnabled) {
            return;
        }
        this.printOut(info, false);
    }

    public void logDebug(String debug) {
        if (!this.isDebugEnabled) {
            return;
        }
        this.printOut(debug, false);
    }

    public void logWarning(String warning) {
        if (!this.isWarningEnabled) {
            return;
        }
        this.printWarning(this.WARNING + ": " + warning);
    }

    public void logError(String error) {
        if (!this.isErrorEnabled) {
            return;
        }
        this.printError(this.ERROR + ": " + error);
    }

    public void logInfo(String path, String info) {
        if (!this.isInfoEnabled) {
            return;
        }
        this.printOut(path + lineSeparator + lineSeparator + info);
    }

    public void logDebug(String path, String debug) {
        if (!this.isDebugEnabled) {
            return;
        }
        this.printOut(path + lineSeparator + lineSeparator + debug);
    }

    public void logWarning(String path, String warning) {
        if (!this.isWarningEnabled) {
            return;
        }
        this.printWarning(path + lineSeparator + lineSeparator + this.WARNING + ": " + warning);
    }

    public void logWarning(String path, String warning, int errorCode) {
        this.logWarning(path, warning);
    }

    public void logError(String path, String error) {
        if (!this.isErrorEnabled) {
            return;
        }
        this.printError(path + lineSeparator + lineSeparator + this.ERROR + ": " + error);
    }

    public void logError(String path, String error, int errorCode) {
        this.logError(path, error);
    }

    public void logInfo(String path, int line, String info) {
        if (!this.isInfoEnabled) {
            return;
        }
        this.printOut(path + "(" + line + "):" + " " + info);
    }

    public void logDebug(String path, int line, String debug) {
        if (!this.isDebugEnabled) {
            return;
        }
        this.printOut(path + "(" + line + "):" + " " + debug);
    }

    public void logWarning(String path, int line, String warning) {
        if (!this.isWarningEnabled) {
            return;
        }
        this.printWarning(path + "(" + line + "):" + " " + this.WARNING + ": " + warning + lineSeparator + lineSeparator + this.getLineText(path, line));
    }

    public void logWarning(String path, int line, String warning, int errorCode) {
        this.logWarning(path, line, warning);
    }

    public void logError(String path, int line, String error) {
        if (!this.isErrorEnabled) {
            return;
        }
        this.printError(path + "(" + line + "): " + " " + this.ERROR + ": " + error + lineSeparator + lineSeparator + this.getLineText(path, line));
    }

    public void logError(String path, int line, String error, int errorCode) {
        this.logError(path, line, error);
    }

    public void logInfo(String path, int line, int col, String info) {
        if (!this.isInfoEnabled) {
            return;
        }
        this.printOut(path + "(" + line + "): " + this.COL + ": " + col + " " + info);
    }

    public void logDebug(String path, int line, int col, String debug) {
        if (!this.isDebugEnabled) {
            return;
        }
        this.printOut(path + "(" + line + "): " + this.COL + ": " + col + " " + debug);
    }

    public void logWarning(String path, int line, int col, String warning) {
        if (!this.isWarningEnabled) {
            return;
        }
        String lineText = this.getLineText(path, line);
        this.printWarning(path + "(" + line + "): " + this.COL + ": " + col + " " + this.WARNING + ": " + warning + lineSeparator + lineSeparator + lineText + lineSeparator + this.getLinePointer(col, lineText));
    }

    public void log(ILocalizableMessage m) {
        this.log(m, null);
    }

    public void log(ILocalizableMessage m, String source) {
        if (m.getLevel() == "error" ? !this.isErrorEnabled : (m.getLevel() == "warning" ? !this.isWarningEnabled : !this.isInfoEnabled)) {
            return;
        }
        String prefix = this.formatPrefix(this.getLocalizationManager(), m);
        boolean found = true;
        LocalizationManager loc = this.getLocalizationManager();
        String text = loc.getLocalizedTextString((Object)m);
        if (text == null) {
            text = m.getClass().getName();
            found = false;
        }
        String exText = this.formatExceptionDetail(m, loc);
        if (m.getPath() != null && m.getLine() != -1) {
            exText = exText + lineSeparator + lineSeparator + (source == null ? this.getLineText(m.getPath(), m.getLine()) : source);
        }
        if (m.getColumn() != -1) {
            exText = exText + lineSeparator + this.getLinePointer(m.getColumn(), source);
        }
        if (m.getLevel() == "info") {
            this.printOut(prefix + text + exText, false);
        } else if (m.getLevel() == "warning") {
            this.printWarning(prefix + text + exText);
        } else {
            this.printError(prefix + text + exText);
        }
        if (!$assertionsDisabled && !found) {
            throw new AssertionError((Object)("Localized text missing for " + m.getClass().getName()));
        }
    }

    public void logError(String path, int line, int col, String error) {
        if (!this.isErrorEnabled) {
            return;
        }
        String lineText = this.getLineText(path, line);
        this.printError(path + "(" + line + "): " + this.COL + ": " + col + " " + this.ERROR + ": " + error + lineSeparator + lineSeparator + lineText + lineSeparator + this.getLinePointer(col, lineText));
    }

    public void logWarning(String path, int line, int col, String warning, String source) {
        if (!this.isWarningEnabled) {
            return;
        }
        this.printWarning(path + "(" + line + "): " + this.COL + ": " + col + " " + this.WARNING + ": " + warning + lineSeparator + lineSeparator + source + lineSeparator + this.getLinePointer(col, source));
    }

    public void logWarning(String path, int line, int col, String warning, String source, int errorCode) {
        this.logWarning(path, line, col, warning, source);
    }

    public void logError(String path, int line, int col, String error, String source) {
        if (!this.isErrorEnabled) {
            return;
        }
        this.printError(path + "(" + line + "): " + this.COL + ": " + col + " " + this.ERROR + ": " + error + lineSeparator + lineSeparator + source + lineSeparator + this.getLinePointer(col, source));
    }

    public void logError(String path, int line, int col, String error, String source, int errorCode) {
        this.logError(path, line, col, error, source);
    }

    public void needsCompilation(String path, String reason) {
        this.printOut(this.RECOMPILE + ": " + path, false);
        this.printOut(this.REASON + ": " + reason, false);
    }

    public void includedFileUpdated(String path) {
        this.printOut(this.INCLUDEUPDATED + ": " + path, false);
    }

    public void includedFileAffected(String path) {
        this.printOut(this.INCLUDEAFFECTED + ": " + path, false);
    }

    private void printOut(String message) {
        this.printOut(message, true);
    }

    private void printOut(String message, boolean extraLineBreak) {
        System.out.println(message + (extraLineBreak ? lineSeparator : ""));
    }

    private void printWarning(String message) {
        ++this.warningCount;
        System.err.println(message + lineSeparator);
        if (message == null) {
            Thread.dumpStack();
        }
    }

    private void printWarning(String message, byte[] more) {
        ++this.warningCount;
        System.err.print(message);
        try {
            System.err.write(more);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.err.println(lineSeparator);
    }

    private void printError(String message) {
        ++this.errorCount;
        System.err.println(message + lineSeparator);
        if (message == null) {
            Thread.dumpStack();
        }
    }

    private void printError(String message, byte[] more) {
        ++this.errorCount;
        System.err.print(message);
        try {
            System.err.write(more);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.err.println(lineSeparator);
    }

    private String getLineText(String path, int line) {
        String text = FileUtil.readLine(path, line);
        return text == null ? "" : text;
    }

    private byte[] getLineBytes(String path, int line) {
        return FileUtil.readBytes(path, line);
    }

    private String getLinePointer(int col, String source) {
        if (col <= 0) {
            return "^";
        }
        StringBuffer b = new StringBuffer(col);
        for (int i = 0; i < col - 1; ++i) {
            if (source != null && i < source.length() && source.charAt(i) == '\t') {
                b.append('\t');
                continue;
            }
            b.append(' ');
        }
        b.append('^');
        return b.toString();
    }

    static {
        $assertionsDisabled = !Console.class.desiredAssertionStatus();
        lineSeparator = System.getProperty("line.separator");
    }
}

