/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.css;

import flash.css.Descriptor;
import flash.css.Rule;
import flash.css.StyleDeclaration;
import flex2.compiler.Source;
import flex2.compiler.css.Import;
import flex2.compiler.css.StyleProperty;
import flex2.compiler.mxml.lang.FrameworkDefs;
import flex2.compiler.mxml.reflect.Type;
import flex2.compiler.mxml.rep.AtEmbed;
import flex2.compiler.mxml.rep.MxmlDocument;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.ThreadLocalToolkit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class StyleDef {
    private String name;
    private boolean isTypeSelector;
    private Map atEmbeds = new HashMap();
    private Set imports = new HashSet();
    private Map styles = new HashMap();
    private List effectStyles = new ArrayList();
    private MxmlDocument mxmlDocument;
    private Source source;
    private int lineNumber;
    private Object perCompileData;
    private static final String CLASS_REFERENCE = "ClassReference(";
    private static final String EMBED = "Embed(";

    StyleDef(String name, boolean isTypeSelector, MxmlDocument mxmlDocument, Source source, int lineNumber, Object perCompileData) {
        this.name = name;
        this.isTypeSelector = isTypeSelector;
        this.mxmlDocument = mxmlDocument;
        this.source = source;
        this.lineNumber = lineNumber;
        this.perCompileData = perCompileData;
    }

    StyleDef(String name, boolean isTypeSelector, Source source, int lineNumber, Object perCompileData) {
        this.name = name;
        this.isTypeSelector = isTypeSelector;
        this.source = source;
        this.lineNumber = lineNumber;
        this.perCompileData = perCompileData;
    }

    void addRule(Rule rule) {
        StyleDeclaration declaration = rule.getStyle();
        Iterator propertyIterator = declaration.iterator();
        while (propertyIterator.hasNext()) {
            String descriptorName = (String)propertyIterator.next();
            Descriptor descriptor = declaration.getPropertyValue(descriptorName);
            String propertyName = StyleDef.dehyphenize(descriptor.getName());
            try {
                if (propertyName.equals("fontFamily")) {
                    this.processFontFamily(descriptor);
                    continue;
                }
                this.processStyle(descriptor, propertyName);
            }
            catch (CompilerMessage.CompilerError compilerError) {
                compilerError.setPath(descriptor.getPath());
                compilerError.setLine(descriptor.getLineNumber());
                ThreadLocalToolkit.log(compilerError);
            }
        }
    }

    public boolean isTypeSelector() {
        return this.isTypeSelector;
    }

    public static String dehyphenize(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int start = 0;
        int end = string.indexOf(45);
        while (end >= 0) {
            stringBuffer.append(string.substring(start, end));
            stringBuffer.append(Character.toUpperCase(string.charAt(end + 1)));
            start = end + 2;
            end = string.indexOf(45, start);
        }
        stringBuffer.append(string.substring(start));
        return stringBuffer.toString();
    }

    private boolean addAtEmbed(AtEmbed atEmbed) {
        if (this.mxmlDocument != null) {
            this.mxmlDocument.addAtEmbed(atEmbed);
        } else if (!this.atEmbeds.containsKey(atEmbed.getPropName())) {
            this.atEmbeds.put(atEmbed.getPropName(), atEmbed);
        }
        return true;
    }

    public Collection getAtEmbeds() {
        return this.atEmbeds.values();
    }

    public List getEffectStyles() {
        return this.effectStyles;
    }

    public Set getImports() {
        return this.imports;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getName() {
        return this.name;
    }

    public Collection getStyles() {
        return this.styles.values();
    }

    public String getTypeName() {
        return StyleDef.dehyphenize(this.name);
    }

    private String processEmbed(String value, String styleSheetPath, int line) {
        String result = null;
        AtEmbed atEmbed = AtEmbed.create(this.perCompileData, this.source, value, styleSheetPath, line, "_embed_css_");
        if (atEmbed != null) {
            this.addAtEmbed(atEmbed);
            result = atEmbed.getPropName();
        }
        return result;
    }

    private String processClassReference(String value, String styleSheetPath, int line) {
        String result = null;
        String parameter = value.substring(CLASS_REFERENCE.length(), value.length() - 1).trim();
        if (parameter.charAt(0) == '\"' && parameter.indexOf(34, 1) == parameter.length() - 1) {
            result = parameter.substring(1, parameter.length() - 1);
            this.imports.add(new Import(result, line));
        } else if (parameter.equals("null")) {
            result = parameter;
        } else {
            InvalidClassReference invalidClassReference = new InvalidClassReference();
            invalidClassReference.path = styleSheetPath;
            invalidClassReference.line = line;
            ThreadLocalToolkit.log(invalidClassReference);
        }
        return result;
    }

    private void processFontFamily(Descriptor descriptor) {
        String fontFamily = descriptor.getIdentAsString();
        StyleProperty stylesProperty = new StyleProperty("fontFamily", "\"" + fontFamily + "\"", descriptor.getLineNumber());
        this.styles.put(stylesProperty.getName(), stylesProperty);
    }

    private void processStyle(Descriptor descriptor, String propertyName) throws CompilerMessage.CompilerError {
        String value;
        if (propertyName.endsWith("Effect")) {
            this.effectStyles.add(propertyName);
        }
        if ((value = this.processStyle(descriptor)) != null) {
            StyleProperty styleProperty = new StyleProperty(propertyName, value, descriptor.getLineNumber());
            this.styles.put(styleProperty.getName(), styleProperty);
        }
    }

    private String processStyle(Descriptor descriptor) throws CompilerMessage.CompilerError {
        String value = descriptor.getValueAsString();
        if (value.startsWith(EMBED)) {
            value = this.processEmbed(value, descriptor.getPath(), descriptor.getLineNumber());
        } else if (value.startsWith(CLASS_REFERENCE)) {
            value = this.processClassReference(value, descriptor.getPath(), descriptor.getLineNumber());
        }
        if (!(this.mxmlDocument == null || descriptor.getValue().getLexicalUnitType() != 35 || value == null || value.length() <= 2 || value.charAt(0) != '\'' && value.charAt(0) != '\"' || value.charAt(value.length() - 1) != '\'' && value.charAt(value.length() - 1) != '\"')) {
            String potentialProperty = value.substring(1, value.length() - 1);
            Type type = this.mxmlDocument.getRoot().getType();
            if (type != null && type.getProperty(potentialProperty) != null) {
                value = potentialProperty;
            }
            if (FrameworkDefs.isBuiltinEffectName(potentialProperty)) {
                this.mxmlDocument.addTypeRef("mx.effects." + potentialProperty, descriptor.getLineNumber());
            }
        }
        return value;
    }

    public static class InvalidClassReference
    extends CompilerMessage.CompilerError {
    }
}

