/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.type1;

import com.adobe.fontengine.font.FontInputStream;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.postscript.SubArrays;
import com.adobe.fontengine.font.type1.AFM;
import com.adobe.fontengine.font.type1.MetricFile;
import com.adobe.fontengine.font.type1.PFM;
import com.adobe.fontengine.font.type1.Type1Font;
import java.io.IOException;
import java.net.URL;

public final class FontFactory {
    private static final byte[] kType1PFAStart1 = new byte[]{37, 33, 80, 83, 45, 65, 100, 111, 98, 101, 70, 111, 110, 116};
    private static final byte[] kType1PFAStart2 = new byte[]{37, 33, 70, 111, 110, 116, 84, 121, 112, 101, 49};
    private static final byte[] kType1PFAStart3 = new byte[]{37, 33, 70, 111, 110, 116, 84, 121, 112, 101, 32, 49};
    private static final byte[] kAFMStart = new byte[]{83, 116, 97, 114, 116, 70, 111, 110, 116, 77, 101, 116, 114, 105, 99, 115};
    private static final byte[] kType1PFBStart = new byte[]{-128, 1};
    private static final int maxT1BytesNeeded = 6 + kType1PFAStart1.length;

    public static int getNumBytesNeededToIdentify() {
        return maxT1BytesNeeded;
    }

    private static boolean startsWithType1(byte[] byArray, int n) {
        return SubArrays.arrayCompare(kType1PFAStart1, 0, byArray, n, kType1PFAStart1.length) || SubArrays.arrayCompare(kType1PFAStart2, 0, byArray, n, kType1PFAStart2.length) || SubArrays.arrayCompare(kType1PFAStart3, 0, byArray, n, kType1PFAStart3.length);
    }

    private static boolean isPFA(byte[] byArray) {
        return FontFactory.startsWithType1(byArray, 0);
    }

    private static boolean isPFB(byte[] byArray) {
        if (SubArrays.arrayCompare(kType1PFBStart, 0, byArray, 0, kType1PFBStart.length)) {
            return FontFactory.startsWithType1(byArray, 6);
        }
        return false;
    }

    public static boolean isType1(byte[] byArray) {
        return FontFactory.isPFB(byArray) || FontFactory.isPFA(byArray);
    }

    public static int getNumBytesNeededToIdentifyAFM() {
        return kAFMStart.length;
    }

    public static boolean isAFM(byte[] byArray) {
        if (byArray.length < FontFactory.getNumBytesNeededToIdentifyAFM()) {
            return false;
        }
        return SubArrays.arrayCompare(byArray, 0, kAFMStart, 0, kAFMStart.length);
    }

    public static int getNumBytesNeededToIdentifyPFM() {
        return 68;
    }

    public static boolean isPFM(byte[] byArray) {
        if (byArray.length < FontFactory.getNumBytesNeededToIdentifyPFM()) {
            return false;
        }
        return byArray[0] == 0 && byArray[1] == 1 && (byArray[66] & 0xFF) == 129 && byArray[67] == 0 && ((byArray[3] & 0xFF) << 8 | byArray[2] & 0xFF) >= FontFactory.getNumBytesNeededToIdentify();
    }

    public static Type1Font[] load(FontInputStream fontInputStream, URL uRL) throws IOException, InvalidFontException, UnsupportedFontException {
        Type1Font type1Font = new Type1Font(fontInputStream, uRL);
        Type1Font[] type1FontArray = new Type1Font[]{type1Font};
        return type1FontArray;
    }

    public static MetricFile loadAFM(FontInputStream fontInputStream, URL uRL) throws IOException, InvalidFontException {
        return AFM.createAFM(fontInputStream, uRL);
    }

    public static MetricFile loadPFM(FontInputStream fontInputStream, URL uRL) throws IOException, InvalidFontException {
        return PFM.createPFM(fontInputStream, uRL);
    }
}

