/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.fontmanagement;

import com.adobe.fontengine.font.FontData;
import com.adobe.fontengine.font.FontImpl;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.type1.MetricFile;
import com.adobe.fontengine.font.type1.Type1Font;
import com.adobe.fontengine.fontmanagement.FontLoader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.ref.SoftReference;
import java.net.URL;

class URLFont
extends FontImpl {
    static final long serialVersionUID = 1L;
    protected final URL outlineFileURL;
    protected URL metricFileURL;
    protected final int index;
    protected transient SoftReference fontRef;

    URLFont(URL uRL, int n) {
        this.outlineFileURL = uRL;
        this.index = n;
        this.fontRef = new SoftReference<Object>(null);
    }

    URLFont(URL uRL, int n, FontData fontData) throws UnsupportedFontException {
        this.outlineFileURL = uRL;
        this.index = n;
        this.fontRef = new SoftReference<FontData>(fontData);
    }

    void setMetricURL(URL uRL, MetricFile metricFile) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        FontData fontData = this.retrieveFontData();
        if (!(fontData instanceof Type1Font)) {
            return;
        }
        if (((Type1Font)fontData).setMetricFile(metricFile)) {
            this.metricFileURL = uRL;
        }
    }

    protected synchronized FontData retrieveFontData() throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        FontData fontData = null;
        fontData = (FontData)this.fontRef.get();
        if (fontData == null) {
            FontData[] fontDataArray;
            try {
                fontDataArray = FontLoader.fromURL(this.outlineFileURL, this.metricFileURL);
            }
            catch (IOException iOException) {
                throw new FontLoadingException(iOException);
            }
            fontData = fontDataArray[this.index];
            this.fontRef = new SoftReference<FontData>(fontData);
        }
        return fontData;
    }

    public int hashCode() {
        int n = this.index;
        n ^= this.outlineFileURL.hashCode();
        if (this.metricFileURL != null) {
            n ^= this.metricFileURL.hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object != null) {
            if (this == object) {
                return true;
            }
            if (object instanceof URLFont && this.index == ((URLFont)object).index) {
                if (!this.outlineFileURL.equals(((URLFont)object).outlineFileURL)) {
                    return false;
                }
                if (this.metricFileURL == null && ((URLFont)object).metricFileURL == null) {
                    return true;
                }
                return this.metricFileURL != null && ((URLFont)object).metricFileURL != null && this.metricFileURL.equals(((URLFont)object).metricFileURL);
            }
        }
        return false;
    }

    public String toString() {
        return this.outlineFileURL.toString();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.fontRef = new SoftReference<Object>(null);
    }
}

