/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.util;

import com.adobe.internal.util.Stack;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.Iterator;
import java.util.ListIterator;

public class ArrayListStack
implements Stack,
Serializable {
    private static final long serialVersionUID = 1L;
    private ArrayList m_Items;

    public ArrayListStack() {
        this.m_Items = new ArrayList(1000);
    }

    public ArrayListStack(ArrayList list) {
        this.m_Items = list;
    }

    public ArrayList getArrayList() {
        return this.m_Items;
    }

    public Object push(Object x) {
        this.m_Items.add(x);
        return x;
    }

    public Object pop() throws EmptyStackException {
        int len = this.size();
        Object obj = this.peek();
        this.m_Items.remove(len - 1);
        return obj;
    }

    public Object peek() throws EmptyStackException {
        int len = this.size();
        if (len == 0) {
            throw new EmptyStackException();
        }
        return this.m_Items.get(len - 1);
    }

    public boolean empty() {
        return this.size() == 0;
    }

    public int size() {
        return this.m_Items.size();
    }

    public void clear() {
        this.m_Items.clear();
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        for (int i = this.size() - 1; i >= 0; --i) {
            result.append(this.m_Items.get(i));
            result.append("\n");
        }
        return result.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArrayListStack)) {
            return false;
        }
        ArrayListStack oStack = (ArrayListStack)o;
        if (this.m_Items.size() != oStack.size()) {
            return false;
        }
        ListIterator e1 = this.m_Items.listIterator();
        ListIterator e2 = oStack.getArrayList().listIterator();
        while (e1.hasNext() && e2.hasNext()) {
            Object o1 = e1.next();
            Object o2 = e2.next();
            if (o1 != null ? o1.equals(o2) : o2 == null) continue;
            return false;
        }
        return !e1.hasNext() && !e2.hasNext();
    }

    public int hashCode() {
        int hashCode = 1;
        Iterator i = this.m_Items.iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            hashCode = 31 * hashCode + (obj == null ? 0 : obj.hashCode());
        }
        return hashCode;
    }

    public int search(Object o) {
        int i = this.m_Items.lastIndexOf(o);
        if (i >= 0) {
            return this.size() - i;
        }
        return -1;
    }
}

