/*
 * Decompiled with CFR 0.152.
 */
package flex2.tools;

import flex2.compiler.API;
import flex2.compiler.CompilationUnit;
import flex2.compiler.CompilerSwcContext;
import flex2.compiler.FileSpec;
import flex2.compiler.ResourceBundlePath;
import flex2.compiler.ResourceContainer;
import flex2.compiler.Source;
import flex2.compiler.SourceList;
import flex2.compiler.SourcePath;
import flex2.compiler.SymbolTable;
import flex2.compiler.common.Configuration;
import flex2.compiler.i18n.I18nUtils;
import flex2.compiler.io.TextFile;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.swc.SwcException;
import flex2.compiler.util.MimeMappings;
import flex2.compiler.util.MultiName;
import flex2.compiler.util.NameFormatter;
import flex2.compiler.util.QName;
import flex2.compiler.util.ThreadLocalToolkit;
import flex2.tools.CompcConfiguration;
import flex2.tools.PreLink;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class CompcPreLink
implements flex2.compiler.PreLink {
    private Map rbFiles;
    private List defaults;

    public CompcPreLink(Map rbFiles, List defaults) {
        this.rbFiles = rbFiles;
        this.defaults = defaults;
    }

    public void run(List sources, List units, FileSpec fileSpec, SourceList sourceList, SourcePath sourcePath, ResourceBundlePath bundlePath, ResourceContainer resources, SymbolTable symbolTable, CompilerSwcContext swcContext, Configuration configuration) {
        this.postGenerateExtraSwcCode(sources, units, symbolTable, sourceList, sourcePath, bundlePath, resources, swcContext, configuration);
        this.processResourceBundles(this.rbFiles, configuration, sources, this.defaults, symbolTable, bundlePath, swcContext);
    }

    private void postGenerateExtraSwcCode(List sources, List units, SymbolTable symbolTable, SourceList sourceList, SourcePath sourcePath, ResourceBundlePath bundlePath, ResourceContainer resources, CompilerSwcContext swcContext, Configuration configuration) {
        int size;
        LinkedList fonts = new LinkedList();
        boolean isAccessible = configuration.getCompilerConfiguration().accessible();
        HashSet accessibilityList = new HashSet();
        Set externs = configuration.getExterns();
        int n = size = units == null ? 0 : units.size();
        for (int i = 0; i < size; ++i) {
            List fontList;
            Set unitAccessibilityList;
            CompilationUnit u = (CompilationUnit)units.get(i);
            if (u == null || PreLink.isCompilationUnitExternal(u, externs) || u.getSource().isInternal()) continue;
            if (isAccessible && (unitAccessibilityList = u.getAccessibilityClasses()) != null) {
                accessibilityList.addAll(unitAccessibilityList);
            }
            if ((fontList = u.getAssets().getFonts()) == null || fontList.isEmpty()) continue;
            fonts.addAll(fontList);
        }
        if (accessibilityList.size() > 0) {
            Iterator it = accessibilityList.iterator();
            while (it.hasNext()) {
                String className = (String)it.next();
                MultiName mName = new MultiName(NameFormatter.retrievePackageName(className), NameFormatter.retrieveClassName(className));
                API.resolveMultiName(mName, sources, sourceList, sourcePath, resources, swcContext, symbolTable);
            }
        }
        this.codegenRootClass(sources, units, swcContext, configuration, fonts);
    }

    private void processResourceBundles(Map rbFiles, Configuration configuration, List sources, List defaults, SymbolTable symbolTable, ResourceBundlePath bundlePath, CompilerSwcContext swcContext) {
        if (rbFiles != null && !configuration.generateRBList()) {
            int i;
            String[] locales = configuration.getCompilerConfiguration().getLocales();
            TreeSet s = new TreeSet();
            Set externs = configuration.getExterns();
            int size = sources.size();
            for (i = 0; i < size; ++i) {
                CompilationUnit unit;
                Source src = (Source)sources.get(i);
                CompilationUnit compilationUnit = unit = src == null ? null : src.getCompilationUnit();
                if (unit == null || PreLink.isCompilationUnitExternal(unit, externs) || src.isInternal()) continue;
                s.addAll(unit.resourceBundleHistory);
            }
            int n = size = defaults == null ? 0 : defaults.size();
            for (i = 0; i < size; ++i) {
                s.add(defaults.get(i));
            }
            Iterator i2 = s.iterator();
            while (i2.hasNext()) {
                int size2;
                QName precompiledQName;
                Source source;
                String rbName = NameFormatter.toColon((String)i2.next());
                QName qName = new QName(rbName);
                VirtualFile[] files = bundlePath.findVirtualFiles(rbName);
                if (files == null) {
                    files = swcContext.getVirtualFiles(locales, qName.getNamespace(), qName.getLocalPart());
                }
                if (files == null && (source = swcContext.getSource((precompiledQName = new QName(rbName + I18nUtils.CLASS_SUFFIX)).getNamespace(), precompiledQName.getLocalPart())) != null) {
                    externs.add(qName);
                    continue;
                }
                if (files == null && locales.length > 0) {
                    ThreadLocalToolkit.log(new SwcException.NoResourceBundleSource(rbName));
                }
                int n2 = size2 = files == null ? 0 : files.length;
                for (int j = 0; j < size2; ++j) {
                    if (files[j] == null) continue;
                    String ext = MimeMappings.getExtension(files[j].getMimeType());
                    String key = "locale/" + locales[j] + "/" + rbName.replace(':', '.').replace('.', '/') + ext;
                    rbFiles.put(key, files[j]);
                }
                if (files == null) continue;
                QName[] qNames = API.resolveResourceBundleName(rbName, sources, null, bundlePath, null, swcContext, symbolTable, locales);
                configuration.addExterns(qNames);
            }
        }
    }

    private void codegenRootClass(List sources, List units, CompilerSwcContext swcContext, Configuration configuration, List fonts) {
        if (fonts.size() == 0) {
            return;
        }
        if (configuration instanceof CompcConfiguration) {
            String className = this.getSwcClassName(((CompcConfiguration)configuration).getOutput());
            String rootClassName = "_" + className + "_" + "mx_core_FlexModuleFactory";
            String sourceText = PreLink.codegenModuleFactory("flash.display.Sprite", rootClassName, null, null, null, null, null, fonts, null, null, null, null, configuration, swcContext);
            String generatedLoaderFile = rootClassName + ".as";
            Source s = new Source((VirtualFile)new TextFile(sourceText, generatedLoaderFile, null, MimeMappings.getMimeType(generatedLoaderFile)), "", rootClassName, null, false, false, false);
            s.setPathResolver(null);
            sources.add(s);
            configuration.setRootClassName(rootClassName);
            if (configuration.getCompilerConfiguration().keepGeneratedActionScript()) {
                PreLink.saveGenerated(generatedLoaderFile, sourceText, configuration.getCompilerConfiguration().getGeneratedDirectory());
            }
        }
    }

    private String getSwcClassName(String pathName) {
        File file = new File(pathName);
        String fileName = file.getName();
        int ext = fileName.lastIndexOf(".");
        if (ext != -1) {
            fileName = fileName.substring(0, ext);
        }
        fileName = fileName.replaceAll("[\\W]", "_");
        return fileName;
    }
}

