/*
 * Decompiled with CFR 0.152.
 */
package flex2.linker;

import flash.localization.LocalizationManager;
import flash.swf.Movie;
import flex2.compiler.io.FileUtil;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.ThreadLocalToolkit;
import flex2.linker.Configuration;
import flex2.linker.ConsoleApplication;
import flex2.linker.FlexMovie;
import flex2.linker.LinkerException;
import flex2.linker.PostLink;
import flex2.linker.SimpleMovie;
import java.util.List;

public final class API {
    public static Movie link(List units, PostLink postLink, flex2.compiler.common.Configuration configuration) throws LinkerException {
        LocalizationManager l10n;
        FlexMovie movie = new FlexMovie(configuration);
        movie.topLevelClass = FlexMovie.formatSymbolClassName(configuration.getRootClassName());
        movie.generate(units);
        if (ThreadLocalToolkit.getBenchmark() != null) {
            l10n = ThreadLocalToolkit.getLocalizationManager();
            ThreadLocalToolkit.getBenchmark().benchmark(l10n.getLocalizedTextString((Object)new Linking()));
        }
        API.generateReports(configuration, movie);
        if (postLink != null) {
            postLink.run(movie);
            if (ThreadLocalToolkit.getBenchmark() != null) {
                l10n = ThreadLocalToolkit.getLocalizationManager();
                ThreadLocalToolkit.getBenchmark().benchmark(l10n.getLocalizedTextString((Object)new Optimizing()));
            }
        }
        return movie;
    }

    private static void generateReports(Configuration configuration, SimpleMovie movie) {
        String fileName;
        if (configuration.generateLinkReport() && configuration.getLinkReportFileName() != null) {
            fileName = configuration.getLinkReportFileName();
            try {
                FileUtil.writeFile(fileName, movie.getLinkReport());
            }
            catch (Exception ex) {
                ThreadLocalToolkit.log(new LinkerException.UnableToWriteLinkReport(fileName));
            }
        }
        if (configuration.generateRBList() && configuration.getRBListFileName() != null) {
            fileName = configuration.getRBListFileName();
            try {
                FileUtil.writeFile(configuration.getRBListFileName(), movie.getRBList());
            }
            catch (Exception ex) {
                ThreadLocalToolkit.log(new LinkerException.UnableToWriteResourceBundleList(fileName));
            }
        }
    }

    public static ConsoleApplication linkConsole(List units, PostLink postLink, flex2.compiler.common.Configuration configuration) throws LinkerException {
        LocalizationManager l10n;
        ConsoleApplication app = new ConsoleApplication(configuration);
        app.generate(units);
        if (ThreadLocalToolkit.getBenchmark() != null) {
            l10n = ThreadLocalToolkit.getLocalizationManager();
            ThreadLocalToolkit.getBenchmark().benchmark(l10n.getLocalizedTextString((Object)new Linking()));
        }
        if (postLink != null) {
            postLink.run(app);
            if (ThreadLocalToolkit.getBenchmark() != null) {
                l10n = ThreadLocalToolkit.getLocalizationManager();
                ThreadLocalToolkit.getBenchmark().benchmark(l10n.getLocalizedTextString((Object)new Optimizing()));
            }
        }
        return app;
    }

    public static class Optimizing
    extends CompilerMessage.CompilerInfo {
    }

    public static class Linking
    extends CompilerMessage.CompilerInfo {
    }
}

